import sys, os, os.path, urllib, urllib2, gtk
from threading import Thread, Semaphore
from ifacebgworker import IFaceBgWorker
from yclient import YClient
from ystorage import YStorage
from yconf import YCfg

class GuiBgWorker(Thread, IFaceBgWorker):    
    def __init__(self, gui):
        Thread.__init__(self)
        self.gui = gui
        self.mustExit = False
        self.mustCancel = False
        self.waitCmd = Semaphore(0)
        self.doneCmd = Semaphore(1)
        self.requestCrt = []
        self.requestLast = None
        self.urlThumb = None
    
    def run(self):
        #dummy = YStorage() #init here some variables
        #TODO:self.gui.setDetails(None) #do some work after the startup in background
        while not self.mustExit:
            self.waitCmd.acquire()
            print "bgworker got a job "
            if len(self.requestCrt) == 0:
                continue #do nothing
            elif self.requestCrt == None:
                print "bg worker fired as well"
                return
            else:
                try:
                    self.work()
                except:
                    YCfg.log(sys.exc_info()[1])
                #cleanup working request
                self.requestLast = self.requestCrt
                self.requestCrt = []
                self.doneCmd.release()
    def work(self):
        gui = self.gui
        
        requestType = self.requestCrt[0]
        searchString = self.requestCrt[1]
        startIdx = self.requestCrt[2]
        maxResuls = self.requestCrt[3]
        date = self.requestCrt[4]
        #bug here. thread !safe thingy ?
        #gui.liststore.clear()
        videos = list()

        cli = YClient(date)
        #create entries fast
        if requestType == self.TYPE_SEARCH:
            if (searchString.startswith("http://www.youtube.com/watch") or searchString.startswith("http://youtube.com/watch")):
                vid = searchString.split("=")[1].split("&")[0]
                print "searching by id = " + vid
                receivedVideos = cli.search_video_by_id(vid);
            else:
                print "searching some string"
                receivedVideos = cli.search_video(urllib.quote(searchString), startIdx, maxResuls);            
        elif requestType == self.TYPE_TOPRATED:
            print "searching top rated"
            receivedVideos = cli.get_toprated(startIdx, maxResuls);
        elif requestType == self.TYPE_MOSTVIEWED:
            print "searching most viewed"
            receivedVideos = cli.get_mostviewed(startIdx, maxResuls);
        elif requestType == self.TYPE_FEATURED:
            print "searching featured"
            receivedVideos = cli.get_recentlyfeatured(startIdx, maxResuls);
        elif requestType == self.TYPE_DIRECT_FEED:
            print "searching direct feed"
            receivedVideos = cli.search_direct_feed(searchString, startIdx, maxResuls); #search string is used to carry the feed url
        elif requestType == self.TYPE_BY_AUTHOR:
            print "searching by author"
            receivedVideos = cli.videos_upload_by(searchString, startIdx, maxResuls);
        elif requestType == self.TYPE_BY_CAT:
            print "searching category"
            receivedVideos = cli.get_by_category(searchString, startIdx, maxResuls);
        elif requestType == self.TYPE_LOCAL:
            print "searching local"
            receivedVideo = self.work_get_local(startIdx, maxResuls)
            return
    
        else:
            print "unknown search"
            return
        
        for video in receivedVideos:
            yentry = YStorage.loadFromVideo(video, cli)
            videos.append(yentry)
            gui.liststore.append([yentry])
        
        #start adding images
        for idx in range(len(videos)):
            if self.mustCancel:
                break
            video = videos[idx]
            thumb_url = video.thumburl
            print "bgworker -> %s" %thumb_url
            self.urlThumb = urllib2.urlopen(thumb_url)
            data = self.urlThumb.read()
            #TODO: move this in some settings/env class
            #TODO: this wastes MMC/SD cards
            for tmpdir in ["c:\\", "/home/user/", "/tmp/"]:
                if os.path.isdir(tmpdir):                 
                    file_tmpname = tmpdir+"mtube-%s" % (os.path.basename(thumb_url))
            thumb_pixbuf_file = open(file_tmpname, "wb")
            thumb_pixbuf_file.write(data)
            thumb_pixbuf_file.close()
            thumb_pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(file_tmpname, 80, 80)
            os.remove(file_tmpname)
            video.setThumbPix(thumb_pixbuf)
            gui.updateEntry(idx, video)
        return
    
    def work_get_local(self, startIdx, maxResults):
        if not os.path.exists(YCfg.STORE_PATH):
            return
        index = 0
        for fentry in os.listdir(YCfg.STORE_PATH):
            index += 1
            if index >= startIdx and index < startIdx+maxResults:
                pass #create entries
            else:
                continue
            yentry = YStorage.loadEntry(fentry)
            self.gui.liststore.append([yentry])
        return
    
    def isBusy(self):
        if self.requestCrt != None and len(self.requestCrt) > 0:
            return True
        return False
    
    def addRequest(self, requestInfo):
        if self.isBusy():
            print "worker is busy, cancel current request"
            self.cancelCrtRequest()
            #return False
        print "worker adding request"
        self.doneCmd.acquire()
        #self.gui.treeColumn.set_title("videos ["+str(requestInfo[2])+"-"+str(requestInfo[2]+requestInfo[3])+"]")
        self.gui.window.set_title("("+str(requestInfo[2])+"-"+str(requestInfo[2]+requestInfo[3])+")")
        self.gui.liststore.clear()
        self.mustCancel = self.mustExit = False
        self.requestCrt = requestInfo
        self.waitCmd.release()
        
        return True
    
    def addRequestNext(self, maxResults):
        if (self.requestLast == None):
            print "make a request first"
            return
        requestNext = self.requestLast
        requestNext[2] += requestNext[3]
        requestNext[3] = maxResults
        self.addRequest(requestNext)
        
    def addRequestPrev(self, maxResults):
        if (self.requestLast == None):
            print "make a request first"
            return
        requestPrev = self.requestLast
        requestPrev[2] = max(requestPrev[2] - requestPrev[3], 1)
        requestPrev[3] = maxResults
        self.addRequest(requestPrev)
   
    def cancelCrtRequest(self):
        self.mustCancel = True
        self.urlThumb.close()

    #TODO: make a request to cancel the previous one
    def repeatRequest(self, date):
        if (self.requestLast == None):
            print "make a request first"
            return
        self.requestLast[4] = date
        self.addRequest(self.requestLast)
    
    def terminate(self):
        self.mustExit = True
        self.waitCmd.release()
        self.join(1000)
        print "bgworker terminated"
