#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import datetime
import time
import uuid
import commands
import sqlite3
import pango

DB_FORMAT = '%Y-%m-%d'
FRAMEWORK_VERSION = '0.2.1' 
DB_PATH = '/home/user/.mPIM/mtasks.db'

class Database:
        def __init__(self,path=None):
          self.db = None
          self.cursor = None
          if path != None:
            self.path = path
          else:
            self.path = '/home/user/.mPIM/mtasks.db'
          try:
            self.db = sqlite3.connect(self.path)
            self.cursor = self.db.cursor()
            self._update()
          except:
            print 'Database doesn t exist'
            self._create()

        def _create(self):
          #Try to create the folder in case of
          commands.getoutput("mkdir /home/user/.mPIM/")
          self.db = sqlite3.connect(self.path)
          self.cursor = self.db.cursor()
          self.cursor.execute('CREATE TABLE tasks (uuid TEXT PRIMARY KEY, due_datetime DATETIME, description TEXT, priority INTEGER, status INTEGER)')
          self.db.commit()
          self.cursor.execute('CREATE TABLE db_struct (version TEXT);')
          self.db.commit()
          self.cursor.execute('INSERT INTO db_struct (version) VALUES ("'+FRAMEWORK_VERSION+'");')
          self.db.commit()

        def _update(self):
          self.cursor.execute('SELECT version From db_struct;')
          for version in self.cursor.fetchall():
            v = version

          if version < '0.2':
            self._create()

        def close(self):
          self.db.close()

class Task:
        """This class represents one task"""

        def __init__(self,suuid='',default_due_datetime=None):

            self.due_datetime = default_due_datetime
            self.description = ''
            self.priority = 1
            self.status = 0

            if suuid=='':
              self.uuid = uuid.uuid4().__str__()
              self.new = True
            else:
              self.uuid = suuid
              self.load_from_db(self.uuid)
              self.new = False

        def load_from_db(self,suuid):
            db = Database(DB_PATH)
            db.cursor.execute('SELECT due_datetime, description, priority,status FROM tasks where uuid="'+suuid+'"')
            for task in db.cursor.fetchall():
              if task[0]!=None:
                self.due_datetime = datetime.datetime.strptime(task[0],DB_FORMAT)
              self.description = task[1]
              self.priority = int(task[2])
              self.status = int(task[3])
              self.new = False
            db.close()

        def save_to_db(self):
            db = Database(DB_PATH)
            if self.due_datetime == None:
              due_datetime = None
            else:
              due_datetime = datetime.datetime.strftime(self.due_datetime,DB_FORMAT)

            if self.new==True:
              db.cursor.execute('INSERT INTO tasks (uuid , due_datetime, description, priority, status ) VALUES(?,?,?,?,?);',[self.uuid,due_datetime,self.description, str(self.priority) ,self.status])
              db.db.commit()
            else:
              db.cursor.execute('UPDATE tasks SET due_datetime=?, description=?, priority=?, status=? WHERE uuid=?;',[due_datetime,self.description, str(self.priority),str(self.status),self.uuid])
              db.db.commit()
            db.close()

        def get_bg_color(self):
          return '#FFFFFF'

        def get_fg_color(self):
          if self.priority == 0:
            return "#FF0000"
          elif self.priority == 1:
            return "#000000"
          else:
            return "#666666"
        def get_style(self):
          if self.status==0:
            return pango.STYLE_NORMAL
          else:
            return pango.STYLE_ITALIC

        def delete_from_db(self):
            db = Database(DB_PATH)
            db.cursor.execute('DELETE FROM tasks WHERE uuid ="'+self.uuid + '";')
            db.db.commit()
            db.close()

class TasksList:
        def __init__(self):
            self.tasks_list = []

        def clear(self):
            self.tasks_list = []

        def get_all_tasks(self):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM tasks  '
            where = ''
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              task = Task(uuid[0])
              if task.due_datetime == None:
                due_datetime = datetime.datetime(9999,9,9)
              else:
                due_datetime = task.due_datetime 
              self.tasks_list.append((task.status,due_datetime,task.priority,task.uuid))
            db.close()

            return self.tasks_list

        def get_done_tasks(self):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM tasks  '
            where = ' WHERE status="1"'
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              task = Task(uuid[0])
              self.tasks_list.append((task.status,task.due_datetime,task.priority,task.uuid))
            db.close()

            return self.tasks_list

        def get_undone_tasks(self):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM tasks  '
            where = ' WHERE status="0"'
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              task = Task(uuid[0])
              self.tasks_list.append((task.status,task.due_datetime,task.priority,task.uuid))
            db.close()

            return self.tasks_list