#!/usr/bin/env python2.5

from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)

import os
import dbus
import gobject

try:
    import gnome.gconf as gconf
except ImportError:
    import gconf

# Adapted from http://www.le-web.org/2008/10/30/python-allow-only-one-instance-of-your-application/
class ApplicationInstance: 
    #specify the file used to save the application instance pid
    def __init__( self, pid_file ):
        self.pid_file = pid_file
        self.check()
        file = open( self.pid_file, 'wt' )
        file.write( str( os.getpid() ) )
        file.close()
 
    def check( self ):
        if not os.path.isfile( self.pid_file ):
            return
        pid = 0
        try:
            file = open( self.pid_file, 'rt' )
            data = file.read()
            file.close()
            pid = int( data )
        except:
            pass
        if 0 == pid:
            return
        try:
            os.kill( pid, 0 )
        except:
            return
        exit(0) #exit raise an exception so don't put it in a try/except block
  
    def exitApplication( self ):
        try:
            os.remove( self.pid_file )
        except:
            pass

def handler(sender=None):
    global cgclnt
    cgclnt.set_string('/apps/maemo/minigpsd/screen', sender )

def handler2(sender=None):
    global cgclnt
    cgclnt.set_string('/apps/maemo/minigpsd/inactivity', str( sender ) )
 
if __name__ == '__main__':
    #create application instance
    appInstance = ApplicationInstance( '/tmp/dbus2gconf.pid' )
 
    cgclnt = gconf.client_get_default()
    dbus_loop = gobject.MainLoop()
    bus = dbus.SystemBus()

    obj = bus.get_object('com.nokia.mce', '/com/nokia/mce/signal')
    
    iface1 = dbus.Interface(obj, 'com.nokia.mce.signal')
    iface1.connect_to_signal("display_status_ind", handler)

    iface2 = dbus.Interface(obj, 'com.nokia.mce.signal')
    iface2.connect_to_signal("system_inactivity_ind", handler2)

    dbus_loop.run()

    #remove pid file
    appInstance.exitApplication()
