/*
 * Copyright: (C) 2008 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */
#ifndef DATA_TAB_H
#define DATA_TAB_H

#define DATA_DISPLAY_NOITEM 0
#define DATA_DISPLAY_MILEAGE 1
#define DATA_DISPLAY_ACTIVITY 2
#define DATA_DISPLAY_ALERTS 3
#define DATA_DISPLAY_TRIPS 4

#define DATA_DATE_ROW   0
#define DATA_ODO_ROW    1
#define DATA_FUEL_ROW   2
#define DATA_MPG_ROW    3
#define DATA_COST_ROW   4
#define DATA_EXTRA1_ROW 5
#define DATA_EXTRA2_ROW 6


#include <gtk/gtk.h>

extern void data_tab_layout(GtkWidget *window);
extern void data_tab_load_car(char *);
extern void data_tab_update_car_combo_box(int);
extern void data_tab_load_data(char *);
extern void data_tab_update_columns(
   char *date,
   char *odo,
   char *fuel,
   char *mpg,
   char *cost,
   char *extra1,
   char *extra2);
extern GtkListStore * data_tab_get_store();
extern GtkWidget *data_tab_get_car_selector();
extern int  data_tab_get_car_inserted();
extern int  data_tab_get_display_selector();


#endif
