#!/usr/bin/env python

"""
mgedcom.py
version 0.74

This is a simple PyGTK GUI application intended to display -- and
optional edit -- genealogical data files in the GEDCOM format.

More information about the GEDCOM standard is available at:

http://en.wikipedia.org/wiki/GEDCOM

Copyright (C) 2009 Darren Enns <dmenns1@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
USA.
"""

import pygtk
pygtk.require('2.0')
import gtk
from gedcom import *
import os
import sys
import datetime
import pango
import string
import gobject
import codecs
try:
        import hildon
        hildon_flag = True
except ImportError:
        hildon_flag = False
        print "not on maemo platform"
try:
	import xdot
        xdot_flag = True
except ImportError:
        xdot_flag = False
        print "xdot not present"

NAME = 'MGedcom'
VERSION = '0.74'
AUTHORS = ['Darren Enns <dmenns1@gmail.com>']

window_in_fullscreen = False
relation_style = "ParentChild"
individual_show_flag = True
family_show_flag = False
family_show_flag = True
note_show_flag = True
submitter_show_flag = True
repository_show_flag = True
source_show_flag = True
object_show_flag = True
submission_show_flag = True
custom_show_flag = True
font_size = 10

def starter(widget, window, button):
        button.destroy()
        show_nice_gedcom("clicked", window)

        return

class MyDotWindow(xdot.DotWindow):

    def __init__(self):
        xdot.DotWindow.__init__(self)
        self.widget.connect('clicked', self.on_url_clicked)

    def on_url_clicked(self, widget, url, event):
        dialog = gtk.MessageDialog(
                parent = self,
                buttons = gtk.BUTTONS_OK,
                message_format="%s clicked" % url)
        dialog.connect('response', lambda dialog, response: dialog.destroy())
        dialog.run()
        return True

class show_nice_gedcom:
	if hildon_flag == True:
		menu_element = 'popup'
	else:
		menu_element = 'menubar'

	ui = '''<ui>
	<%(menu_element)s name="MenuBar">
	<menu action="File">
	<menuitem action="Open Gedcom"/>
	<menuitem action="Save Gedcom"/>
	<menuitem action="Quit"/>
	<menuitem action="Refresh"/>
	</menu>
	<menu action="Edit">
	<menuitem action="Add Individual"/>
	<menuitem action="Add Spouse"/>
	<menuitem action="Add Child"/>
	<menuitem action="Add Father"/>
	<menuitem action="Add Mother"/>
	<menuitem action="Add Family"/>
	<menuitem action="Add Note"/>
	<menuitem action="Delete Individual"/>
	<menuitem action="Delete Family"/>
	</menu>
	<menu action="View">
	<menuitem action="Individuals"/>
	<menuitem action="Families"/>
	<menuitem action="Notes"/>
	<menuitem action="Submitters"/>
	<menuitem action="Repositories"/>
	<menuitem action="Sources"/>
	<menuitem action="Objects"/>
	<menuitem action="Submissions"/>
	<menuitem action="Custom"/>
	</menu>
	<menu action="Expansion">
	<menuitem action="ParentChild"/>
	<menuitem action="ChildParent"/>
	</menu>
	<menu action="DotGraphs">
	<menuitem action="Generate Children Dot Graph"/>
	<menuitem action="Generate Parents Dot Graph"/>
	<menuitem action="View Dot Graph with xdot"/>
	<menuitem action="Convert Dot Graph to PDF"/>
	<menuitem action="Convert Dot Graph to PNG"/>
	<menuitem action="Convert Dot Graph to SVG"/>
	</menu>
	<menu action="Reports">
	<menuitem action="Last Name Frequency"/>
	</menu>
	<menu action="Help">
	<menuitem action="Readme"/>
	<menuitem action="License"/>
	<menuitem action="Tag List"/>
	<menuitem action="About"/>
	</menu>
	</%(menu_element)s>
	</ui>''' % { 'menu_element': menu_element }

    	# close the window and quit
    	def delete_event(self, widget, event, data=None):
        	gtk.main_quit()
        	return False

	def __init__(self, widget, window):
		global g
		global font_size
		global individual_show_flag
		global family_show_flag
		global note_show_flag
		global submitter_show_flag
		global repository_show_flag
		global source_show_flag
		global object_show_flag
		global submission_show_flag
		global custom_show_flag

		self.valid_tags = {
		"ABBR":"A short name of a title, description, or name.",
		"ADDR":"The contemporary place, usually required for postal purposes, of an individual, a submitter of information, a repository, a business, a school, or a company.",
		"ADR1":"The first line of an address.",
		"ADR2":"The second line of an address.",
		"ADOP":"Pertaining to creation of a child-parent relationship that does not exist biologically.",
		"AFN":"Ancestral File Nummer, a unique permanent record file number of an individual record stored in Ancestral File.",
		"AGE":"The age of the individual at the time an event occurred, or the age listed in the document.",
		"AGNC":"The institution or individual having authority and/or responsibility to manage or govern.",
		"ALIA":"An indicator to link different record descriptions of a person who may be the same person.",
		"ANCE":"Pertaining to forbearers of an individual.",
		"ANCI":"Indicates an interest in additional research for ancestors of this individual. (See also DESI)",
		"ANUL":"Declaring a marriage void from the beginning (never existed).",
		"ASSO":"An indicator to link friends, neighbors, relatives, or associates of an individual.",
		"AUTH":"The name of the individual who created or compiled information.",
		"BAPL":"The event of baptism performed at age eight or later by priesthood authority of the LDS Church. (See also BAPM)",
		"BAPM":"The event of baptism (not LDS), performed in infancy or later. (See also BAPL and CHR)",
		"BARM":"The ceremonial event held when a Jewish boy reaches age 13.",
		"BASM":"The ceremonial event held when a Jewish girl reaches age 13, also known as 'Bat Mitzvah.'",
		"BIRT":"The event of entering into life.",
		"BLES":"A religious event of bestowing divine care or intercession. Sometimes given in connection with a naming ceremony.",
		"BLOB":"A grouping of data used as input to a multimedia system that processes binary data to represent images, sound, and video.  deleted in Gedcom 5.5.1",
		"BURI":"The event of the proper disposing of the mortal remains of a deceased person.",
		"CALN":"The number used by a repository to identify the specific items in its collections.",
		"CAST":"The name of an individual's rank or status in society, based on racial or religious differences, or differences in wealth, inherited rank, profession, occupation, etc.",
		"CAUS":"A description of the cause of the associated event or fact, such as the cause of death.",
		"CENS":"The event of the periodic count of the population for a designated locality, such as a national or state Census.",
		"CHAN":"Indicates a change, correction, or modification. Typically used in connection with a DATE to specify when a change in information occurred.",
		"CHAR":"An indicator of the character set used in writing this automated information.",
		"CHIL":"The natural, adopted, or sealed (LDS) child of a father and a mother.",
		"CHR":"The religious event (not LDS) of baptizing and/or naming a child.",
		"CHRA":"The religious event (not LDS) of baptizing and/or naming an adult person.",
		"CITY":"A lower level jurisdictional unit. Normally an incorporated municipal unit.",
		"CONC":"An indicator that additional data belongs to the superior value. The information from the CONC value is to be connected to the value of the superior preceding line without a space and without a carriage return and/or new line character. Values that are split for a CONC tag must always be split at a non-space. If the value is split on a space the space will be lost when concatenation takes place. This is because of the treatment that spaces get as a GEDCOM delimiter, many GEDCOM values are trimmed of trailing spaces and some systems look for the first non-space starting after the tag to determine the beginning of the value.",
		"CONF":"The religious event (not LDS) of conferring the gift of the Holy Ghost and, among protestants, full church membership.",
		"CONL":"The religious event by which a person receives membership in the LDS Church.",
		"CONT":"An indicator that additional data belongs to the superior value. The information from the CONT value is to be connected to the value of the superior preceding line with a carriage return and/or new line character. Leading spaces could be important to the formatting of the resultant text. When importing values from CONT lines the reader should assume only one delimiter character following the CONT tag. Assume that the rest of the leading spaces are to be a part of the value.",
		"COPR":"A statement that accompanies data to protect it from unlawful duplication and distribution.",
		"CORP":"A name of an institution, agency, corporation, or company.",
		"CREM":"Disposal of the remains of a person's body by fire.",
		"CTRY":"The name or code of the country.",
		"DATA":"Pertaining to stored automated information.",
		"DATE":"The time of an event in a calendar format.",
		"DEAT":"The event when mortal life terminates.",
		"DESC":"Pertaining to offspring of an individual.",
		"DESI":"Indicates an interest in research to identify additional descendants of this individual. (See also ANCI)",
		"DEST":"A system receiving data.",
		"DIV":"An event of dissolving a marriage through civil action.",
		"DIVF":"An event of filing for a divorce by a spouse.",
		"DSCR":"The physical characteristics of a person, place, or thing.",
		"EDUC":"Indicator of a level of education attained.",
		"EMAIL":"An electronic address that can be used for contact such as an email address...  new in Gedcom 5.5.1",
		"EMIG":"An event of leaving one's homeland with the intent of residing elsewhere.",
		"ENDL":"A religious event where an endowment ordinance for an individual was performed by priesthood authority in an LDS temple.",
		"ENGA":"An event of recording or announcing an agreement between two people to become married.",
		"EVEN":"A noteworthy happening related to an individual, a group, or an organization.",
		"FACT":"Pertaining to a noteworthy attribute or fact concerning an individual, a group, or an organization. A, FACT structure is usually qualified or classified by a subordinate use of the TYPE tag. new in Gedcom 5.5.1",
		"FAM":"Identifies a legal, common law, or other customary relationship of man and woman and their children, if any, or a family created by virtue of the birth of a child to its biological father and mother.",
		"FAMC":"Identifies the family in which an individual appears as a child.",
		"FAMF":"Pertaining to, or the name of, a family file. Names stored in a file that are assigned to a family for doing temple ordinance work.",
		"FAMS":"Identifies the family in which an individual appears as a spouse.",
		"FAX":"A FAX telephone number appropriate for sending data facsimiles.  new in Gedcom 5.5.1",
		"FCOM":"A religious rite, the first act of sharing in the Lord's supper as part of church worship.",
		"FILE":"An information storage place that is ordered and arranged for preservation and reference.",
		"FONE":"A phonetic variation of a superior text string.  new in Gedcom 5.5.1",
		"FORM":"An assigned name given to a consistent format in which information can be conveyed.",
		"GEDC":"Information about the use of GEDCOM in a transmission.",
		"GIVN":"A given or earned name used for official identification of a person.",
		"GRAD":"An event of awarding educational diplomas or degrees to individuals.",
		"HEAD":"Identifies information pertaining to an entire GEDCOM transmission.",
		"HUSB":"An individual in the family role of a married man or father.",
		"IDNO":"A number assigned to identify a person within some significant external system.",
		"IMMI":"An event of entering into a new locality with the intent of residing there.",
		"INDI":"A person.",
		"LANG":"The name of the language used in a communication or transmission of information.",
		"LATI":"A value indicating a coordinate position on a line, plane, or space.  new in Gedcom 5.5.1",
		"LEGA":"A role of an individual acting as a person receiving a bequest or legal devise.",
		"LONG":"A value indicating a coordinate position on a line, plane, or space.  new in Gedcom 5.5.1",
		"MAP":"Pertains to a representation of measurements usually presented in a graphical form.  new in Gedcom 5.5.1",
		"MARB":"An event of an official public notice given that two people intend to marry.",
		"MARC":"An event of recording a formal agreement of marriage, including the prenuptial agreement in which marriage partners reach agreement about the property rights of one or both, securing property to their children.",
		"MARL":"An event of obtaining a legal license to marry.",
		"MARR":"A legal, common-law, or customary event of creating a family unit of a man and a woman as husband and wife.",
		"MARS":"An event of creating an agreement between two people contemplating marriage, at which time they agree to release or modify property rights that would otherwise arise from the marriage.",
		"MEDI":"Identifies information about the media or having to do with the medium in which information is stored.",
		"NAME":"A word or combination of words used to help identify an individual, title, or other item. More than one NAME line should be used for people who were known by multiple names.",
		"NATI":"The national heritage of an individual.",
		"NATU":"The event of obtaining citizenship.",
		"NCHI":"The number of children that this person is known to be the parent of (all marriages) when subordinate to an individual, or that belong to this family when subordinate to a FAM_RECORD.",
		"NICK":"A descriptive or familiar that is used instead of, or in addition to, one's proper name.",
		"NMR":"The number of times this person has participated in a family as a spouse or parent.",
		"NOTE":"Additional information provided by the submitter for understanding the enclosing data.",
		"NPFX":"Text which appears on a name line before the given and surname parts of a name. i.e. ( Lt. Cmndr. ) Joseph /Allen/ jr. In this example Lt. Cmndr. is considered as the name prefix portion.",
		"NSFX":"Text which appears on a name line after or behind the given and surname parts of a name. i.e. Lt. Cmndr. Joseph /Allen/ ( jr. ) In this example jr. is considered as the name suffix portion.",
		"OBJE":"Pertaining to a grouping of attributes used in describing something. Usually referring to the data required to represent a multimedia object, such an audio recording, a photograph of a person, or an image of a document.",
		"OCCU":"The type of work or profession of an individual.",
		"ORDI":"Pertaining to a religious ordinance in general.",
		"ORDN":"A religious event of receiving authority to act in religious matters.",
		"PAGE":"A number or description to identify where information can be found in a referenced work.",
		"PEDI":"Information pertaining to an individual to parent lineage chart.",
		"PHON":"A unique number assigned to access a specific telephone.",
		"PLAC":"A jurisdictional name to identify the place or location of an event.",
		"POST":"A code used by a postal service to identify an area to facilitate mail handling.",
		"PROB":"An event of judicial determination of the validity of a will. May indicate several related court activities over several dates.",
		"PROP":"Pertaining to possessions such as real estate or other property of interest.",
		"PUBL":"Refers to when and/or were a work was published or created.",
		"QUAY":"An assessment of the certainty of the evidence to support the conclusion drawn from evidence.",
		"REFN":"A description or number used to identify an item for filing, storage, or other reference purposes.",
		"RELA":"A relationship value between the indicated contexts.",
		"RELI":"A religious denomination to which a person is affiliated or for which a record applies.",
		"REPO":"An institution or person that has the specified item as part of their collection(s).",
		"RESI":"The act of dwelling at an address for a period of time.",
		"RESN":"A processing indicator signifying access to information has been denied or otherwise restricted.",
		"RETI":"An event of exiting an occupational relationship with an employer after a qualifying time period.",
		"RFN":"A permanent number assigned to a record that uniquely identifies it within a known file.",
		"RIN":"A number assigned to a record by an originating automated system that can be used by a receiving system to report results pertaining to that record.",
		"ROLE":"A name given to a role played by an individual in connection with an event.",
		"ROMN":"A romanized variation of a superior text string.  new in Gedcom 5.5.1",
		"SEX":"Indicates the sex of an individual--male or female.",
		"SLGC":"A religious event pertaining to the sealing of a child to his or her parents in an LDS temple ceremony.",
		"SLGS":"A religious event pertaining to the sealing of a husband and wife in an LDS temple ceremony.",
		"SOUR":"The initial or original material from which information was obtained.",
		"SPFX":"A name piece used as a non-indexing pre-part of a surname.",
		"SSN":"A number assigned by the United States Social Security Administration. Used for tax identification purposes.",
		"STAE":"A geographical division of a larger jurisdictional area, such as a State within the United States of America.",
		"STAT":"An assessment of the state or condition of something.",
		"SUBM":"An individual or organization who contributes genealogical data to a file or transfers it to someone else.",
		"SUBN":"Pertains to a collection of data issued for processing.",
		"SURN":"A family name passed on or used by members of a family.",
		"TEMP":"The name or code that represents the name a temple of the LDS Church.",
		"TEXT":"The exact wording found in an original source document.",
		"TIME":"A time value in a 24-hour clock format, including hours, minutes, and optional seconds, separated by a colon (:). Fractions of seconds are shown in decimal notation.",
		"TITL":"A description of a specific writing or other work, such as the title of a book when used in a source context, or a formal designation used by an individual in connection with positions of royalty or other social status, such as Grand Duke.",
		"TRLR":"At level 0, specifies the end of a GEDCOM transmission.",
		"TYPE":"A further qualification to the meaning of the associated superior tag. The value does not have any computer processing reliability. It is more in the form of a short one or two word note that should be displayed any time the associated data is displayed.",
		"VERS":"Indicates which version of a product, item, or publication is being used or referenced.",
		"WIFE":"An individual in the role as a mother and/or married woman.",
		"WWW":"World Wide Web home page.  new in Gedcom 5.5.1",
		"WILL":"A legal document treated as an event, by which a person disposes of his or her estate, to take effect after death. The event date is the date the will was signed while the person was alive. (See also PROBate)"
		}

		self.window = window

		# Create a new window
                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		self.window.set_title("MGedcom Main Display")

		self.next_individual_pointer_number = 0
		self.next_family_pointer_number = 0
		self.next_note_pointer_number = 0

		# create empty dictionaries for lookup

		self.family_dict = {}
		self.individual_dict = {}
		self.note_dict = {}
		self.submitter_dict = {}
		self.repository_dict = {}
		self.source_dict = {}
		self.object_dict = {}
		self.submission_dict = {}
		self.custom_dict = {}

		# start pointer counters
		self.get_next_individual_pointer()
		self.get_next_family_pointer()
		self.get_next_note_pointer()

		# create a individual TreeStore
		self.individual_treestore = gtk.TreeStore(str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, str)

		# create a family TreeStore
		self.family_treestore = gtk.TreeStore(str, str, str, str, str, str, str, str, str, str, str, str, str, str)

		# create a note TreeStore
		self.note_treestore = gtk.TreeStore(str, str, str, str)

		# create a submitters TreeStore
		self.submitter_treestore = gtk.TreeStore(str, str, str, str)

		# create a repository TreeStore
		self.repository_treestore = gtk.TreeStore(str, str, str, str)

		# create a source TreeStore
		self.source_treestore = gtk.TreeStore(str, str, str, str)

		# create an object  TreeStore
		self.object_treestore = gtk.TreeStore(str, str, str)

		# create a submission TreeStore
		self.submission_treestore = gtk.TreeStore(str, str, str)

		# create a custom TreeStore
		self.custom_treestore = gtk.TreeStore(str, str, str)

		# create the individual TreeView using individual treestore
		self.individual_treeview = gtk.TreeView(self.individual_treestore)
		self.individual_treeview.set_headers_visible(True)		# needed for Maemo
		self.individual_selection = self.individual_treeview.get_selection()
		self.individual_selection.set_mode(gtk.SELECTION_SINGLE)
		self.individual_treeview.connect('test-expand-row', self.individual_on_row_expanded)
		self.individual_treeview.connect('cursor-changed', self.individual_cursor_changed)
		self.individual_treeview.set_property("show-expanders", True)	# needed for Maemo
		#self.individual_treeview.set_property("enable-grid-lines", True)
		self.individual_treeview.set_property("enable-tree-lines", True)

		# create the family TreeView using family treestore
		self.family_treeview = gtk.TreeView(self.family_treestore)
		self.family_treeview.set_headers_visible(True)		# needed for Maemo
		self.family_selection = self.family_treeview.get_selection()
		self.family_selection.set_mode(gtk.SELECTION_SINGLE)
		self.family_treeview.connect('cursor-changed', self.family_cursor_changed)

		# create the note TreeView using note treestore
		self.note_treeview = gtk.TreeView(self.note_treestore)
		self.note_treeview.set_headers_visible(True)		# needed for Maemo
		self.note_selection = self.note_treeview.get_selection()
		self.note_selection.set_mode(gtk.SELECTION_SINGLE)
		self.note_treeview.connect('cursor-changed', self.note_cursor_changed)

		# create the submitter TreeView using submitter treestore
		self.submitter_treeview = gtk.TreeView(self.submitter_treestore)
		self.submitter_treeview.set_headers_visible(True)		# needed for Maemo
		self.submitter_selection = self.submitter_treeview.get_selection()
		self.submitter_selection.set_mode(gtk.SELECTION_SINGLE)
		self.submitter_treeview.connect('cursor-changed', self.submitter_cursor_changed)

		# create the repository TreeView using repository treestore
		self.repository_treeview = gtk.TreeView(self.repository_treestore)
		self.repository_treeview.set_headers_visible(True)		# needed for Maemo
		self.repository_selection = self.repository_treeview.get_selection()
		self.repository_selection.set_mode(gtk.SELECTION_SINGLE)
		self.repository_treeview.connect('cursor-changed', self.repository_cursor_changed)

		# create the source TreeView using source treestore
		self.source_treeview = gtk.TreeView(self.source_treestore)
		self.source_treeview.set_headers_visible(True)		# needed for Maemo
		self.source_selection = self.source_treeview.get_selection()
		self.source_selection.set_mode(gtk.SELECTION_SINGLE)
		self.source_treeview.connect('cursor-changed', self.source_cursor_changed)

		# create the object TreeView using object treestore
		self.object_treeview = gtk.TreeView(self.object_treestore)
		self.object_treeview.set_headers_visible(True)		# needed for Maemo
		self.object_selection = self.object_treeview.get_selection()
		self.object_selection.set_mode(gtk.SELECTION_SINGLE)
		self.object_treeview.connect('cursor-changed', self.object_cursor_changed)

		# create the submission TreeView using submission treestore
		self.submission_treeview = gtk.TreeView(self.submission_treestore)
		self.submission_treeview.set_headers_visible(True)		# needed for Maemo
		self.submission_selection = self.submission_treeview.get_selection()
		self.submission_selection.set_mode(gtk.SELECTION_SINGLE)
		self.submission_treeview.connect('cursor-changed', self.submission_cursor_changed)

		# create the custom TreeView using custom treestore
		self.custom_treeview = gtk.TreeView(self.custom_treestore)
		self.custom_treeview.set_headers_visible(True)		# needed for Maemo
		self.custom_selection = self.custom_treeview.get_selection()
		self.custom_selection.set_mode(gtk.SELECTION_SINGLE)
		self.custom_treeview.connect('cursor-changed', self.custom_cursor_changed)

		# create the individual TreeViewColumns to display the data
		self.individual_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.individual_raw_gedcom_column.set_resizable(True)
		self.individual_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.individual_type_column)
		self.individual_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.individual_pointer_column)
		self.individual_given_names_column = gtk.TreeViewColumn('Given\nNames')
		self.set_column_style(self.individual_given_names_column)
		self.individual_last_name_column = gtk.TreeViewColumn('Last\nName')
		self.set_column_style(self.individual_last_name_column)
		self.individual_sex_column = gtk.TreeViewColumn('Sex')
		self.set_column_style(self.individual_sex_column)
		self.individual_birth_date_column = gtk.TreeViewColumn('Birth\nDate')
		self.set_column_style(self.individual_birth_date_column)
		self.individual_birth_year_column = gtk.TreeViewColumn('Birth\nYear')
		self.set_column_style(self.individual_birth_year_column)
		self.individual_birth_month_column = gtk.TreeViewColumn('Birth\nMonth')
		self.set_column_style(self.individual_birth_month_column)
		self.individual_birth_day_column = gtk.TreeViewColumn('Birth\nDay')
		self.set_column_style(self.individual_birth_day_column)
		self.individual_death_date_column = gtk.TreeViewColumn('Death\nDate')
		self.set_column_style(self.individual_death_date_column)
		self.individual_death_year_column = gtk.TreeViewColumn('Death\nYear')
		self.set_column_style(self.individual_death_year_column)
		self.individual_death_month_column = gtk.TreeViewColumn('Death\nMonth')
		self.set_column_style(self.individual_death_month_column)
		self.individual_death_day_column = gtk.TreeViewColumn('Death\nDay')
		self.set_column_style(self.individual_death_day_column)
		self.individual_family_pointers_column = gtk.TreeViewColumn('Spouse\nFamily\nPointer')
		self.set_column_style(self.individual_family_pointers_column)
		self.individual_parent_pointers_column = gtk.TreeViewColumn('Parent\nFamily\nPointer')
		self.set_column_style(self.individual_parent_pointers_column)

		# create the family TreeViewColumns to display the data
		self.family_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.family_raw_gedcom_column)
		self.family_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.family_type_column)
		self.family_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.family_pointer_column)
		self.family_husband_pointer_column = gtk.TreeViewColumn('Husband\nPointer')
		self.set_column_style(self.family_husband_pointer_column)
		self.family_husband_given_names_column = gtk.TreeViewColumn('Husband\nGiven\nNames')
		self.set_column_style(self.family_husband_given_names_column)
		self.family_husband_last_name_column = gtk.TreeViewColumn('Husband\nLast\nName')
		self.set_column_style(self.family_husband_last_name_column)
		self.family_wife_pointer_column = gtk.TreeViewColumn('Wife\nPointer')
		self.set_column_style(self.family_wife_pointer_column)
		self.family_wife_given_names_column = gtk.TreeViewColumn('Wife\nGiven\nNames')
		self.set_column_style(self.family_wife_given_names_column)
		self.family_wife_last_name_column = gtk.TreeViewColumn('Wife\nLast\nName')
		self.set_column_style(self.family_wife_last_name_column)
		self.family_marriage_date_column = gtk.TreeViewColumn('Marriage\nDate')
		self.set_column_style(self.family_marriage_date_column)
		self.family_marriage_year_column = gtk.TreeViewColumn('Marriage\nYear')
		self.set_column_style(self.family_marriage_year_column)
		self.family_marriage_month_column = gtk.TreeViewColumn('Marriage\nMonth')
		self.set_column_style(self.family_marriage_month_column)
		self.family_marriage_day_column = gtk.TreeViewColumn('Marriage\nDay')
		self.set_column_style(self.family_marriage_day_column)
		self.family_children_pointers_column = gtk.TreeViewColumn('Children\nPointers')
		self.set_column_style(self.family_children_pointers_column)

		# create the note TreeViewColumns to display the data
		self.note_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.note_raw_gedcom_column)
		self.note_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.note_type_column)
		self.note_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.note_pointer_column)
		self.note_text_column = gtk.TreeViewColumn('Text')
		self.set_column_style(self.note_text_column)

		# create the submitter TreeViewColumns to display the data
		self.submitter_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.submitter_raw_gedcom_column)
		self.submitter_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.submitter_type_column)
		self.submitter_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.submitter_pointer_column)
		self.submitter_name_column = gtk.TreeViewColumn('Name')
		self.set_column_style(self.submitter_name_column)

		# create the repository TreeViewColumns to display the data
		self.repository_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.repository_raw_gedcom_column)
		self.repository_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.repository_type_column)
		self.repository_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.repository_pointer_column)
		self.repository_name_column = gtk.TreeViewColumn('Name')
		self.set_column_style(self.repository_name_column)

		# create the source TreeViewColumns to display the data
		self.source_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.source_raw_gedcom_column)
		self.source_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.source_type_column)
		self.source_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.source_pointer_column)
		self.source_abbreviation_column = gtk.TreeViewColumn('Short\nTitle')
		self.set_column_style(self.source_abbreviation_column)

		# create the object TreeViewColumns to display the data
		self.object_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.object_raw_gedcom_column)
		self.object_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.object_type_column)
		self.object_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.object_pointer_column)

		# create the submission TreeViewColumns to display the data
		self.submission_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.submission_raw_gedcom_column)
		self.submission_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.submission_type_column)
		self.submission_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.submission_pointer_column)

		# create the custom TreeViewColumns to display the data
		self.custom_raw_gedcom_column = gtk.TreeViewColumn('Raw Text')
		self.set_column_style(self.custom_raw_gedcom_column)
		self.custom_type_column = gtk.TreeViewColumn('Type')
		self.set_column_style(self.custom_type_column)
		self.custom_pointer_column = gtk.TreeViewColumn('Pointer')
		self.set_column_style(self.custom_pointer_column)

		# set some individual treeview columns invisible
		self.individual_raw_gedcom_column.set_visible(False)
		self.individual_pointer_column.set_visible(False)
		self.individual_birth_date_column.set_visible(False)
		self.individual_death_date_column.set_visible(False)
		self.individual_family_pointers_column.set_visible(False)
		self.individual_parent_pointers_column.set_visible(False)

		# set some family treeview columns invisible
		self.family_raw_gedcom_column.set_visible(False)
		self.family_pointer_column.set_visible(False)
		self.family_husband_pointer_column.set_visible(False)
		self.family_wife_pointer_column.set_visible(False)
		self.family_marriage_date_column.set_visible(False)
		self.family_children_pointers_column.set_visible(False)

		# set some note treeview columns invisible
		self.note_raw_gedcom_column.set_visible(False)
		self.note_pointer_column.set_visible(False)

		# set some submitter treeview columns invisible
		self.submitter_raw_gedcom_column.set_visible(False)
		self.submitter_pointer_column.set_visible(False)

		# set some repository treeview columns invisible
		self.repository_raw_gedcom_column.set_visible(False)
		self.repository_pointer_column.set_visible(False)

		# set some source treeview columns invisible
		self.source_raw_gedcom_column.set_visible(False)
		self.source_pointer_column.set_visible(False)

		# set some object treeview columns invisible
		self.object_raw_gedcom_column.set_visible(False)

		# set some submission treeview columns invisible
		self.submission_raw_gedcom_column.set_visible(False)

		# set some custom treeview columns invisible
		self.custom_raw_gedcom_column.set_visible(False)

		# add columns to individual treeview
		self.individual_treeview.append_column(self.individual_raw_gedcom_column)
		self.individual_treeview.append_column(self.individual_type_column)
		self.individual_treeview.append_column(self.individual_pointer_column)
		self.individual_treeview.append_column(self.individual_given_names_column)
		self.individual_treeview.append_column(self.individual_last_name_column)
		self.individual_treeview.append_column(self.individual_sex_column)
		self.individual_treeview.append_column(self.individual_birth_date_column)
		self.individual_treeview.append_column(self.individual_birth_year_column)
		self.individual_treeview.append_column(self.individual_birth_month_column)
		self.individual_treeview.append_column(self.individual_birth_day_column)
		self.individual_treeview.append_column(self.individual_death_date_column)
		self.individual_treeview.append_column(self.individual_death_year_column)
		self.individual_treeview.append_column(self.individual_death_month_column)
		self.individual_treeview.append_column(self.individual_death_day_column)
		#self.individual_treeview.append_column(self.individual_delete_column)
		self.individual_treeview.append_column(self.individual_family_pointers_column)
		self.individual_treeview.append_column(self.individual_parent_pointers_column)

		# add columns to family treeview
		self.family_treeview.append_column(self.family_raw_gedcom_column)
		self.family_treeview.append_column(self.family_type_column)
		self.family_treeview.append_column(self.family_pointer_column)
		self.family_treeview.append_column(self.family_husband_pointer_column)
		self.family_treeview.append_column(self.family_husband_given_names_column)
		self.family_treeview.append_column(self.family_husband_last_name_column)
		self.family_treeview.append_column(self.family_wife_pointer_column)
		self.family_treeview.append_column(self.family_wife_given_names_column)
		self.family_treeview.append_column(self.family_wife_last_name_column)
		self.family_treeview.append_column(self.family_marriage_date_column)
		self.family_treeview.append_column(self.family_marriage_year_column)
		self.family_treeview.append_column(self.family_marriage_month_column)
		self.family_treeview.append_column(self.family_marriage_day_column)
		self.family_treeview.append_column(self.family_children_pointers_column)

		# add columns to note treeview
		self.note_treeview.append_column(self.note_raw_gedcom_column)
		self.note_treeview.append_column(self.note_type_column)
		self.note_treeview.append_column(self.note_pointer_column)
		self.note_treeview.append_column(self.note_text_column)

		# add columns to submitter treeview
		self.submitter_treeview.append_column(self.submitter_raw_gedcom_column)
		self.submitter_treeview.append_column(self.submitter_type_column)
		self.submitter_treeview.append_column(self.submitter_pointer_column)
		self.submitter_treeview.append_column(self.submitter_name_column)

		# add columns to repository treeview
		self.repository_treeview.append_column(self.repository_raw_gedcom_column)
		self.repository_treeview.append_column(self.repository_type_column)
		self.repository_treeview.append_column(self.repository_pointer_column)
		self.repository_treeview.append_column(self.repository_name_column)

		# add columns to source treeview
		self.source_treeview.append_column(self.source_raw_gedcom_column)
		self.source_treeview.append_column(self.source_type_column)
		self.source_treeview.append_column(self.source_pointer_column)
		self.source_treeview.append_column(self.source_abbreviation_column)

		# add columns to object treeview
		self.object_treeview.append_column(self.object_raw_gedcom_column)
		self.object_treeview.append_column(self.object_type_column)
		self.object_treeview.append_column(self.object_pointer_column)

		# add columns to submission treeview
		self.submission_treeview.append_column(self.submission_raw_gedcom_column)
		self.submission_treeview.append_column(self.submission_type_column)
		self.submission_treeview.append_column(self.submission_pointer_column)

		# add columns to custom treeview
		self.custom_treeview.append_column(self.custom_raw_gedcom_column)
		self.custom_treeview.append_column(self.custom_type_column)
		self.custom_treeview.append_column(self.custom_pointer_column)

		# create individual CellRendererText to render the data
		#self.individual_raw_gedcom_cell.set_property('editable', True)
		#self.individual_raw_gedcom_cell.connect('edited', self.values_edited_cb2, self.individual_treestore)
		self.individual_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_type_cell)
		self.individual_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_pointer_cell)
		self.individual_given_names_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_given_names_cell)
		self.individual_last_name_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_last_name_cell)
		self.individual_sex_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_sex_cell)
		self.individual_birth_date_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_birth_date_cell)
		self.individual_birth_year_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_birth_year_cell)
		self.individual_birth_month_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_birth_month_cell)
		self.individual_birth_day_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_birth_day_cell)
		self.individual_death_date_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_death_date_cell)
		self.individual_death_year_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_death_year_cell)
		self.individual_death_month_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_death_month_cell)
		self.individual_death_day_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_death_day_cell)
		self.individual_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_raw_gedcom_cell)
		self.individual_family_pointers_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_family_pointers_cell)
		self.individual_parent_pointers_cell = gtk.CellRendererText()
		self.set_cell_style(self.individual_parent_pointers_cell)

		# create family CellRendererText to render the data
		self.family_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_raw_gedcom_cell)
		self.family_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_type_cell)
		self.family_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_pointer_cell)
		self.family_husband_given_names_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_husband_given_names_cell)
		self.family_husband_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_husband_pointer_cell)
		self.family_husband_last_name_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_husband_last_name_cell)
		self.family_wife_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_wife_pointer_cell)
		self.family_wife_given_names_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_wife_given_names_cell)
		self.family_wife_last_name_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_wife_last_name_cell)
		self.family_marriage_date_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_marriage_date_cell)
		self.family_marriage_year_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_marriage_year_cell)
		self.family_marriage_month_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_marriage_month_cell)
		self.family_marriage_day_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_marriage_day_cell)
		self.family_children_pointers_cell = gtk.CellRendererText()
		self.set_cell_style(self.family_children_pointers_cell)

		# create note CellRendererText to render the data
		self.note_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.note_raw_gedcom_cell)
		self.note_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.note_type_cell)
		self.note_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.note_pointer_cell)
		self.note_text_cell = gtk.CellRendererText()
		self.set_cell_style(self.note_text_cell)

		# create submitter CellRendererText to render the data
		self.submitter_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.submitter_raw_gedcom_cell)
		self.submitter_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.submitter_type_cell)
		self.submitter_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.submitter_pointer_cell)
		self.submitter_name_cell = gtk.CellRendererText()
		self.set_cell_style(self.submitter_name_cell)

		# create repository CellRendererText to render the data
		self.repository_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.repository_raw_gedcom_cell)
		self.repository_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.repository_type_cell)
		self.repository_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.repository_pointer_cell)
		self.repository_name_cell = gtk.CellRendererText()
		self.set_cell_style(self.repository_name_cell)

		# create source CellRendererText to render the data
		self.source_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.source_raw_gedcom_cell)
		self.source_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.source_type_cell)
		self.source_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.source_pointer_cell)
		self.source_abbreviation_cell = gtk.CellRendererText()
		self.set_cell_style(self.source_abbreviation_cell)

		# create object CellRendererText to render the data
		self.object_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.object_raw_gedcom_cell)
		self.object_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.object_type_cell)
		self.object_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.object_pointer_cell)

		# create submission CellRendererText to render the data
		self.submission_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.submission_raw_gedcom_cell)
		self.submission_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.submission_type_cell)
		self.submission_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.submission_pointer_cell)

		# create custom CellRendererText to render the data
		self.custom_raw_gedcom_cell = gtk.CellRendererText()
		self.set_cell_style(self.custom_raw_gedcom_cell)
		self.custom_type_cell = gtk.CellRendererText()
		self.set_cell_style(self.custom_type_cell)
		self.custom_pointer_cell = gtk.CellRendererText()
		self.set_cell_style(self.custom_pointer_cell)

		# add the individual cells to the individual columns and allow them to expand
		self.individual_raw_gedcom_column.pack_start(self.individual_raw_gedcom_cell, True)
		self.individual_type_column.pack_start(self.individual_type_cell, True)
		self.individual_pointer_column.pack_start(self.individual_pointer_cell, True)
		self.individual_given_names_column.pack_start(self.individual_given_names_cell, True)
		self.individual_sex_column.pack_start(self.individual_sex_cell, True)
		self.individual_last_name_column.pack_start(self.individual_last_name_cell, True)
		self.individual_birth_date_column.pack_start(self.individual_birth_date_cell, True)
		self.individual_birth_year_column.pack_start(self.individual_birth_year_cell, True)
		self.individual_birth_month_column.pack_start(self.individual_birth_month_cell, True)
		self.individual_birth_day_column.pack_start(self.individual_birth_day_cell, True)
		self.individual_death_date_column.pack_start(self.individual_death_date_cell, True)
		self.individual_death_year_column.pack_start(self.individual_death_year_cell, True)
		self.individual_death_month_column.pack_start(self.individual_death_month_cell, True)
		self.individual_death_day_column.pack_start(self.individual_death_day_cell, True)
		self.individual_family_pointers_column.pack_start(self.individual_family_pointers_cell, True)
		self.individual_parent_pointers_column.pack_start(self.individual_parent_pointers_cell, True)

		# add the family cells to the family columns and allow them to expand
		self.family_raw_gedcom_column.pack_start(self.family_raw_gedcom_cell, True)
		self.family_type_column.pack_start(self.family_type_cell, True)
		self.family_pointer_column.pack_start(self.family_pointer_cell, True)
		self.family_husband_pointer_column.pack_start(self.family_husband_pointer_cell, True)
		self.family_husband_given_names_column.pack_start(self.family_husband_given_names_cell, True)
		self.family_husband_last_name_column.pack_start(self.family_husband_last_name_cell, True)
		self.family_wife_pointer_column.pack_start(self.family_wife_pointer_cell, True)
		self.family_wife_given_names_column.pack_start(self.family_wife_given_names_cell, True)
		self.family_wife_last_name_column.pack_start(self.family_wife_last_name_cell, True)
		self.family_marriage_date_column.pack_start(self.family_marriage_date_cell, True)
		self.family_marriage_year_column.pack_start(self.family_marriage_year_cell, True)
		self.family_marriage_month_column.pack_start(self.family_marriage_month_cell, True)
		self.family_marriage_day_column.pack_start(self.family_marriage_day_cell, True)
		self.family_children_pointers_column.pack_start(self.family_children_pointers_cell, True)

		# add the note cells to the note columns and allow them to expand
		self.note_raw_gedcom_column.pack_start(self.note_raw_gedcom_cell, True)
		self.note_type_column.pack_start(self.note_type_cell, True)
		self.note_pointer_column.pack_start(self.note_pointer_cell, True)
		self.note_text_column.pack_start(self.note_text_cell, True)

		# add the submitter cells to the submitter columns and allow them to expand
		self.submitter_raw_gedcom_column.pack_start(self.submitter_raw_gedcom_cell, True)
		self.submitter_type_column.pack_start(self.submitter_type_cell, True)
		self.submitter_pointer_column.pack_start(self.submitter_pointer_cell, True)
		self.submitter_name_column.pack_start(self.submitter_name_cell, True)

		# add the repository cells to the repository columns and allow them to expand
		self.repository_raw_gedcom_column.pack_start(self.repository_raw_gedcom_cell, True)
		self.repository_type_column.pack_start(self.repository_type_cell, True)
		self.repository_pointer_column.pack_start(self.repository_pointer_cell, True)
		self.repository_name_column.pack_start(self.repository_name_cell, True)

		# add the source cells to the source columns and allow them to expand
		self.source_raw_gedcom_column.pack_start(self.source_raw_gedcom_cell, True)
		self.source_type_column.pack_start(self.source_type_cell, True)
		self.source_pointer_column.pack_start(self.source_pointer_cell, True)
		self.source_abbreviation_column.pack_start(self.source_abbreviation_cell, True)

		# add the object cells to the object columns and allow them to expand
		self.object_raw_gedcom_column.pack_start(self.object_raw_gedcom_cell, True)
		self.object_type_column.pack_start(self.object_type_cell, True)
		self.object_pointer_column.pack_start(self.object_pointer_cell, True)

		# add the submission cells to the submission columns and allow them to expand
		self.submission_raw_gedcom_column.pack_start(self.submission_raw_gedcom_cell, True)
		self.submission_type_column.pack_start(self.submission_type_cell, True)
		self.submission_pointer_column.pack_start(self.submission_pointer_cell, True)

		# add the custom cells to the custom columns and allow them to expand
		self.custom_raw_gedcom_column.pack_start(self.custom_raw_gedcom_cell, True)
		self.custom_type_column.pack_start(self.custom_type_cell, True)
		self.custom_pointer_column.pack_start(self.custom_pointer_cell, True)

		# set the individual cells "text" attribute to matching column - retrieve text from that column in individual treestore
		column = 0
		self.individual_raw_gedcom_posn = column
		self.individual_raw_gedcom_column.add_attribute(self.individual_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.individual_type_posn = column
		self.generic_type_posn = column
		self.individual_type_column.add_attribute(self.individual_type_cell, 'text', column)
		column = column + 1
		self.individual_pointer_posn = column
		self.individual_pointer_column.add_attribute(self.individual_pointer_cell, 'text', column)
		column = column + 1
		self.individual_given_names_posn = column
		self.individual_given_names_column.add_attribute(self.individual_given_names_cell, 'text', column)
		column = column + 1
		self.individual_last_name_posn = column
		self.individual_last_name_column.add_attribute(self.individual_last_name_cell, 'text', column)
		column = column + 1
		self.individual_sex_posn = column
		self.individual_sex_column.add_attribute(self.individual_sex_cell, 'text', column)
		column = column + 1
		self.individual_birth_date_posn = column
		self.individual_birth_date_column.add_attribute(self.individual_birth_date_cell, 'text', column)
		column = column + 1
		self.individual_birth_year_posn = column
		self.individual_birth_year_column.add_attribute(self.individual_birth_year_cell, 'text', column)
		column = column + 1
		self.individual_birth_month_posn = column
		self.individual_birth_month_column.add_attribute(self.individual_birth_month_cell, 'text', column)
		column = column + 1
		self.individual_birth_day_posn = column
		self.individual_birth_day_column.add_attribute(self.individual_birth_day_cell, 'text', column)
		column = column + 1
		self.individual_death_date_posn = column
		self.individual_death_date_column.add_attribute(self.individual_death_date_cell, 'text', column)
		column = column + 1
		self.individual_death_year_posn = column
		self.individual_death_year_column.add_attribute(self.individual_death_year_cell, 'text', column)
		column = column + 1
		self.individual_death_month_posn = column
		self.individual_death_month_column.add_attribute(self.individual_death_month_cell, 'text', column)
		column = column + 1
		self.individual_death_day_posn = column
		self.individual_death_day_column.add_attribute(self.individual_death_day_cell, 'text', column)
		column = column + 1
		self.individual_family_pointers_posn = column
		self.individual_family_pointers_column.add_attribute(self.individual_family_pointers_cell, 'text', column)
		column = column + 1
		self.individual_parent_pointers_posn = column
		self.individual_parent_pointers_column.add_attribute(self.individual_parent_pointers_cell, 'text', column)
		self.individual_last_posn = column

		# set the family cells "text" attribute to matching column - retrieve text from that column in family treestore
		column = 0
		self.family_raw_gedcom_posn = column
		self.family_raw_gedcom_column.add_attribute(self.family_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.family_type_posn = column
		self.family_type_column.add_attribute(self.family_type_cell, 'text', column)
		column = column + 1
		self.family_pointer_posn = column
		self.family_pointer_column.add_attribute(self.family_pointer_cell, 'text', column)
		column = column + 1
		self.family_husband_pointer_posn = column
		self.family_husband_pointer_column.add_attribute(self.family_husband_pointer_cell, 'text', column)
		column = column + 1
		self.family_husband_given_names_posn = column
		self.family_husband_given_names_column.add_attribute(self.family_husband_given_names_cell, 'text', column)
		column = column + 1
		self.family_husband_last_name_posn = column
		self.family_husband_last_name_column.add_attribute(self.family_husband_last_name_cell, 'text', column)
		column = column + 1
		self.family_wife_pointer_posn = column
		self.family_wife_pointer_column.add_attribute(self.family_wife_pointer_cell, 'text', column)
		column = column + 1
		self.family_wife_given_names_posn = column
		self.family_wife_given_names_column.add_attribute(self.family_wife_given_names_cell, 'text', column)
		column = column + 1
		self.family_wife_last_name_posn = column
		self.family_wife_last_name_column.add_attribute(self.family_wife_last_name_cell, 'text', column)
		column = column + 1
		self.family_marriage_date_posn = column
		self.family_marriage_date_column.add_attribute(self.family_marriage_date_cell, 'text', column)
		column = column + 1
		self.family_marriage_year_posn = column
		self.family_marriage_year_column.add_attribute(self.family_marriage_year_cell, 'text', column)
		column = column + 1
		self.family_marriage_month_posn = column
		self.family_marriage_month_column.add_attribute(self.family_marriage_month_cell, 'text', column)
		column = column + 1
		self.family_marriage_day_posn = column
		self.family_marriage_day_column.add_attribute(self.family_marriage_day_cell, 'text', column)
		column = column + 1
		self.family_children_pointers_posn = column
		self.family_children_pointers_column.add_attribute(self.family_children_pointers_cell, 'text', column)
		self.family_last_posn = column

		# set the note cells "text" attribute to matching column - retrieve text from that column in note treestore
		column = 0
		self.note_raw_gedcom_posn = column
		self.generic_raw_gedcom_posn = column
		self.note_raw_gedcom_column.add_attribute(self.note_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.note_type_posn = column
		self.note_type_column.add_attribute(self.note_type_cell, 'text', column)
		self.note_type_cell.set_property('yalign', 0.0)
		column = column + 1
		self.note_pointer_posn = column
		self.generic_pointer_posn = column
		self.note_pointer_column.add_attribute(self.note_pointer_cell, 'text', column)
		self.note_pointer_cell.set_property('yalign', 0.0)
		column = column + 1
		self.note_text_posn = column
		self.generic_tag_posn = column
		self.note_text_column.add_attribute(self.note_text_cell, 'text', column)
		column = column + 1
		self.generic_values_posn = column

		# set the submitter cells "text" attribute to matching column - retrieve text from that column in submitter treestore
		column = 0
		self.submitter_raw_gedcom_posn = column
		self.submitter_raw_gedcom_column.add_attribute(self.submitter_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.submitter_type_posn = column
		self.submitter_type_column.add_attribute(self.submitter_type_cell, 'text', column)
		column = column + 1
		self.submitter_pointer_posn = column
		self.submitter_pointer_column.add_attribute(self.submitter_pointer_cell, 'text', column)
		column = column + 1
		self.submitter_name_posn = column
		self.submitter_name_column.add_attribute(self.submitter_name_cell, 'text', column)

		# set the repository cells "text" attribute to matching column - retrieve text from that column in repository treestore
		column = 0
		self.repository_raw_gedcom_posn = column
		self.repository_raw_gedcom_column.add_attribute(self.repository_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.repository_type_posn = column
		self.repository_type_column.add_attribute(self.repository_type_cell, 'text', column)
		column = column + 1
		self.repository_pointer_posn = column
		self.repository_pointer_column.add_attribute(self.repository_pointer_cell, 'text', column)
		column = column + 1
		self.repository_name_posn = column
		self.repository_name_column.add_attribute(self.repository_name_cell, 'text', column)

		# set the source cells "text" attribute to matching column - retrieve text from that column in source treestore
		column = 0
		self.source_raw_gedcom_posn = column
		self.source_raw_gedcom_column.add_attribute(self.source_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.source_type_posn = column
		self.source_type_column.add_attribute(self.source_type_cell, 'text', column)
		column = column + 1
		self.source_pointer_posn = column
		self.source_pointer_column.add_attribute(self.source_pointer_cell, 'text', column)
		column = column + 1
		self.source_abbreviation_posn = column
		self.source_abbreviation_column.add_attribute(self.source_abbreviation_cell, 'text', column)

		# set the object cells "text" attribute to matching column - retrieve text from that column in object treestore
		column = 0
		self.object_raw_gedcom_posn = column
		self.object_raw_gedcom_column.add_attribute(self.object_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.object_type_posn = column
		self.object_type_column.add_attribute(self.object_type_cell, 'text', column)
		column = column + 1
		self.object_pointer_posn = column
		self.object_pointer_column.add_attribute(self.object_pointer_cell, 'text', column)

		# set the submission cells "text" attribute to matching column - retrieve text from that column in submission treestore
		column = 0
		self.submission_raw_gedcom_posn = column
		self.submission_raw_gedcom_column.add_attribute(self.submission_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.submission_type_posn = column
		self.submission_type_column.add_attribute(self.submission_type_cell, 'text', column)
		column = column + 1
		self.submission_pointer_posn = column
		self.submission_pointer_column.add_attribute(self.submission_pointer_cell, 'text', column)

		# set the custom cells "text" attribute to matching column - retrieve text from that column in custom treestore
		column = 0
		self.custom_raw_gedcom_posn = column
		self.custom_raw_gedcom_column.add_attribute(self.custom_raw_gedcom_cell, 'text', column)
		column = column + 1
		self.custom_type_posn = column
		self.custom_type_column.add_attribute(self.custom_type_cell, 'text', column)
		column = column + 1
		self.custom_pointer_posn = column
		self.custom_pointer_column.add_attribute(self.custom_pointer_cell, 'text', column)

		# make it searchable
		#self.individual_treeview.set_search_column(0)

		# Allow sorting on the individual columns
		column = 0
		self.individual_death_day_column.set_sort_column_id(column)
		column = column + 1
		self.individual_type_column.set_sort_column_id(column)
		column = column + 1
		self.individual_pointer_column.set_sort_column_id(column)
		column = column + 1
		self.individual_given_names_column.set_sort_column_id(column)
		column = column + 1
		self.individual_last_name_column.set_sort_column_id(column)
		column = column + 1
		self.individual_sex_column.set_sort_column_id(column)
		column = column + 1
		self.individual_birth_date_column.set_sort_column_id(column)
		column = column + 1
		self.individual_birth_year_column.set_sort_column_id(column)
		column = column + 1
		self.individual_birth_month_column.set_sort_column_id(column)
		column = column + 1
		self.individual_birth_day_column.set_sort_column_id(column)
		column = column + 1
		self.individual_death_date_column.set_sort_column_id(column)
		column = column + 1
		self.individual_death_year_column.set_sort_column_id(column)
		column = column + 1
		self.individual_death_month_column.set_sort_column_id(column)

		# Allow sorting on the column
		column = 0
		self.family_marriage_day_column.set_sort_column_id(column)
		column = column + 1
		self.family_type_column.set_sort_column_id(column)
		column = column + 1
		self.family_pointer_column.set_sort_column_id(column)
		column = column + 1
		self.family_husband_pointer_column.set_sort_column_id(column)
		column = column + 1
		self.family_husband_given_names_column.set_sort_column_id(column)
		column = column + 1
		self.family_husband_last_name_column.set_sort_column_id(column)
		column = column + 1
		self.family_wife_pointer_column.set_sort_column_id(column)
		column = column + 1
		self.family_wife_given_names_column.set_sort_column_id(column)
		column = column + 1
		self.family_wife_last_name_column.set_sort_column_id(column)
		column = column + 1
		self.family_marriage_date_column.set_sort_column_id(column)
		column = column + 1
		self.family_marriage_year_column.set_sort_column_id(column)
		column = column + 1
		self.family_marriage_month_column.set_sort_column_id(column)

		# Allow sorting on the column
		column = 0
		self.note_type_column.set_sort_column_id(column)
		column = column + 1
		self.note_pointer_column.set_sort_column_id(column)
		column = column + 1
		self.note_text_column.set_sort_column_id(column)
		column = column + 1

		# Allow sorting on the column
		column = 0
		self.submitter_type_column.set_sort_column_id(column)
		column = column + 1
		self.submitter_pointer_column.set_sort_column_id(column)
		column = column + 1
		self.submitter_name_column.set_sort_column_id(column)
		column = column + 1

		# Allow sorting on the column
		column = 0
		self.repository_type_column.set_sort_column_id(column)
		column = column + 1
		self.repository_pointer_column.set_sort_column_id(column)
		column = column + 1
		self.repository_name_column.set_sort_column_id(column)
		column = column + 1

		# Allow sorting on the column
		column = 0
		self.source_type_column.set_sort_column_id(column)
		column = column + 1
		self.source_pointer_column.set_sort_column_id(column)
		column = column + 1

		# Allow sorting on the column
		column = 0
		self.object_type_column.set_sort_column_id(column)
		column = column + 1
		self.object_pointer_column.set_sort_column_id(column)
		column = column + 1

		# Allow sorting on the column
		column = 0
		self.submission_type_column.set_sort_column_id(column)
		column = column + 1
		self.submission_pointer_column.set_sort_column_id(column)
		column = column + 1

		# Allow sorting on the column
		column = 0
		self.custom_type_column.set_sort_column_id(column)
		column = column + 1
		self.custom_pointer_column.set_sort_column_id(column)
		column = column + 1

		# Allow drag and drop reordering of rows
		#self.individual_treeview.set_reorderable(True)
		#self.family_treeview.set_reorderable(True)

		# make ui layout
		self.vbox = gtk.VBox()

		# Create a UIManager instance
		uimanager = gtk.UIManager()

		# Add the accelerator group to the toplevel window
		accelgroup = uimanager.get_accel_group()
		window.add_accel_group(accelgroup)

		# Create an ActionGroup
		actiongroup = gtk.ActionGroup('UIManagerExample')
		self.actiongroup = actiongroup

		# Create actions
		actiongroup.add_actions([('Open Gedcom', gtk.STOCK_OPEN, '_Open GEDCOM...', None, None, self.open_gedcom),
					 ('Save Gedcom', gtk.STOCK_SAVE, '_Save GEDCOM...', None, None, self.save_gedcom),
					 ('Quit', gtk.STOCK_QUIT, '_Quit!', None,
					  'Quit the Program', self.quit_cb),
					 ('File', None, '_File'),
					 ('Edit', None, '_Edit'),
					 ('View', None, '_View'),
					 ('Expansion', None, '_Expansion'),
					 ('Reports', None, '_Reports'),
					 ('DotGraphs', None, '_DotGraphs'),
					 ('Help', None, '_Help')])

		actiongroup.add_actions([('Add Individual', None, 'Add _Individual', '<Control>i', None, self.add_individual),
					('Add Spouse', None, 'Add S_pouse', '<Control>p', None, self.add_spouse),
					('Add Child', None, 'Add _Child', '<Control>c', None, self.add_child),
					('Add Father', None, 'Add _Father', None, None, self.add_father),
					('Add Mother', None, 'Add _Mother', None, None, self.add_mother),
					('Add Family', None, 'Add _Family', '<Control>f', None, self.add_family),
					('Add Note', None, 'Add _Note', '<Control>n', None, self.add_note),
					('Delete Individual', None, 'Delete Individual', None, None, self.delete_individual),
					('Delete Family', None, 'Delete Family', None, None, self.delete_family)])

		actiongroup.add_actions([('Refresh', None, '_Refresh', '<Control>r', None, self.refresh_view)])

     		actiongroup.add_actions([('Readme', gtk.STOCK_HELP, '_Readme', None, None, self.show_help),
                   			('License', gtk.STOCK_HELP, '_License', None, None, self.show_license),
                   			('Tag List', gtk.STOCK_HELP, '_Tag List', None, None, self.show_valid_tags),
                   			('About', gtk.STOCK_ABOUT, '_About', None, None, self.show_about)])

		actiongroup.get_action('Quit').set_property('short-label', '_Quit')

        	actiongroup.add_toggle_actions([('Individuals', None, 'Individuals', None, '',
                                        	self.individual_show_toggle, True),
                                       		('Families', None, 'Families', None, '',
                                        	self.family_show_toggle, False),
                                       		('Notes', None, 'Notes', None, '',
                                        	self.note_show_toggle, False),
                                       		('Submitters', None, 'Submitters', None, '',
                                        	self.submitter_show_toggle, False),
                                       		('Repositories', None, 'Repositories', None, '',
                                        	self.repository_show_toggle, False),
                                       		('Sources', None, 'Sources', None, '',
                                        	self.source_show_toggle, False),
                                       		('Objects', None, 'Objects', None, '',
                                        	self.object_show_toggle, False),
                                       		('Submissions', None, 'Submissions', None, '',
                                        	self.submission_show_toggle, False),
                                       		('Custom', None, 'Custom', None, '',
                                        	self.custom_show_toggle, False)])

		actiongroup.add_radio_actions([('ParentChild', None, '_ParentChild', '<Control>p', 'Parent->Child', 0),
						('ChildParent', None, '_ChildParent', '<Control>c', 'Child->Parent', 1),
					       ], 0, self.gedcom_direction_cb)

		actiongroup.add_actions([('Generate Children Dot Graph', None, 'Generate _Children Dot Graph...', None, None, self.save_children_dot_graph),
					 ('Generate Parents Dot Graph', None, 'Generate _Parents Dot Graph...', None, None, self.save_parents_dot_graph),
					 ('View Dot Graph with xdot', None, '_View Dot Graph with xdot...', None, None, self.open_dot_graph),
					 ('Convert Dot Graph to PDF', None, 'Convert Dot Graph to _PDF...', None, None, self.convert_dot_graph_to_pdf),
					 ('Convert Dot Graph to PNG', None, 'Convert Dot Graph to P_NG...', None, None, self.convert_dot_graph_to_png),
					 ('Convert Dot Graph to SVG', None, 'Convert Dot Graph to _SVG...', None, None, self.convert_dot_graph_to_svg)])

		actiongroup.add_actions([('Last Name Frequency', None, '_Last Name Frequency...', None, None, self.last_name_frequency_report)])

		# Add the actiongroup to the uimanager
		uimanager.insert_action_group(actiongroup, 0)

		# Add a UI description
		uimanager.add_ui_from_string(self.ui)

		# Create a MenuBar
		menubar = uimanager.get_widget('/MenuBar')
		if hildon_flag == True:
            		self.window.set_menu(menubar)
		else:
			self.vbox.pack_start(menubar, False)

		self.individual_scrolledwindow = gtk.ScrolledWindow()
		self.family_scrolledwindow = gtk.ScrolledWindow()
		self.note_scrolledwindow = gtk.ScrolledWindow()
		self.submitter_scrolledwindow = gtk.ScrolledWindow()
		self.repository_scrolledwindow = gtk.ScrolledWindow()
		self.source_scrolledwindow = gtk.ScrolledWindow()
		self.object_scrolledwindow = gtk.ScrolledWindow()
		self.submission_scrolledwindow = gtk.ScrolledWindow()
		self.custom_scrolledwindow = gtk.ScrolledWindow()

		self.individual_scrolledwindow.add(self.individual_treeview)
		self.family_scrolledwindow.add(self.family_treeview)
		self.note_scrolledwindow.add(self.note_treeview)
		self.submitter_scrolledwindow.add(self.submitter_treeview)
		self.repository_scrolledwindow.add(self.repository_treeview)
		self.source_scrolledwindow.add(self.source_treeview)
		self.object_scrolledwindow.add(self.object_treeview)
		self.submission_scrolledwindow.add(self.submission_treeview)
		self.custom_scrolledwindow.add(self.custom_treeview)

		if individual_show_flag == True:
			self.vbox.pack_start(self.individual_scrolledwindow)
		if family_show_flag == True:
			self.vbox.pack_start(self.family_scrolledwindow)
		if note_show_flag == True:
			self.vbox.pack_start(self.note_scrolledwindow)
		if submitter_show_flag == True:
			self.vbox.pack_start(self.submitter_scrolledwindow)
		if repository_show_flag == True:
			self.vbox.pack_start(self.repository_scrolledwindow)
		if source_show_flag == True:
			self.vbox.pack_start(self.source_scrolledwindow)
		if object_show_flag == True:
			self.vbox.pack_start(self.object_scrolledwindow)
		if submission_show_flag == True:
			self.vbox.pack_start(self.submission_scrolledwindow)
		if custom_show_flag == True:
			self.vbox.pack_start(self.custom_scrolledwindow)

		self.window.add(self.vbox)

               	window.unfullscreen()

		if hildon_flag == True:
		    	settings = self.window.get_settings()
		    	settings.set_property("gtk-button-images", False)
		    	settings.set_property("gtk-menu-images", False)

		self.window.show_all()

		self.vbox.remove(self.family_scrolledwindow)
		self.vbox.remove(self.note_scrolledwindow)
		self.vbox.remove(self.submitter_scrolledwindow)
		self.vbox.remove(self.repository_scrolledwindow)
		self.vbox.remove(self.source_scrolledwindow)
		self.vbox.remove(self.object_scrolledwindow)
		self.vbox.remove(self.submission_scrolledwindow)
		self.vbox.remove(self.custom_scrolledwindow)

	def set_font_size_raw_gedcom(self):
		global raw_gedcom_treeview

		column_number = 0
		for column in raw_gedcom_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
	def set_font_size_nice_gedcom(self):
		column_number = 0
		for column in self.individual_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.family_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.note_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.submitter_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.repository_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.source_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.object_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.submission_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
		column_number = 0
		for column in self.custom_treeview.get_columns():
			cell = gtk.CellRendererText()
			self.set_column_style(column)
			self.set_cell_style(cell)
			column.clear()
			column.pack_start(cell, True)
			column.add_attribute(cell, 'text', column_number)
			column_number = column_number + 1
			
	def set_column_style(self, column):
                label = gtk.Label(column.get_title())
                label.modify_font(pango.FontDescription("sans " + str(font_size)))
                label.show()
		column.set_resizable(True)
                column.set_widget(label)

	def set_cell_style(self, cell):
		font = pango.FontDescription('sans ' + str(font_size))
		cell.set_property('font-desc', font)

	def individual_delete_cb(self, cell, path, model):
		model[path][self.individual_delete_posn] = not model[path][self.individual_delete_posn]
		iter = model.get_iter(path)
		result = model.remove(iter)

		return

	def raw_gedcom_delete_cb(self, cell, path, raw_gedcom_treestore, input_treestore, input_iter):
		raw_gedcom_treestore[path][self.raw_gedcom_delete_posn] = not raw_gedcom_treestore[path][self.raw_gedcom_delete_posn]
		raw_gedcom_iter = raw_gedcom_treestore.get_iter(path)
		result = raw_gedcom_treestore.remove(raw_gedcom_iter)

		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		return

  	def individual_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
     		model,iter = treeview.get_selection().get_selected()
		if colname == "Type":
			self.generic_on_selection_changed(self.individual_selection)

  	def family_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
     		model,iter = treeview.get_selection().get_selected()
		if colname == "Type":
			self.generic_on_selection_changed(self.family_selection)
		if colname in ("Husband\nGiven\nNames", "Husband\nLast\nName"):
			family_husband_pointer = model.get_value(iter, self.family_husband_pointer_posn)
			if family_husband_pointer:
				self.set_cursor(family_husband_pointer, self.individual_treeview)
		if colname in ("Wife\nGiven\nNames", "Wife\nLast\nName"):
			family_wife_pointer = model.get_value(iter, self.family_wife_pointer_posn)
			if family_wife_pointer:
				self.set_cursor(family_wife_pointer, self.individual_treeview)

  	def note_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
		if colname == "Type":
			self.generic_on_selection_changed(self.note_selection)

  	def submitter_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
		if colname == "Type":
			self.generic_on_selection_changed(self.submitter_selection)

  	def repository_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
		if colname == "Type":
			self.generic_on_selection_changed(self.repository_selection)

  	def source_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
		if colname == "Type":
			self.generic_on_selection_changed(self.source_selection)

  	def object_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
		if colname == "Type":
			self.generic_on_selection_changed(self.object_selection)

  	def submission_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
		if colname == "Type":
			self.generic_on_selection_changed(self.submission_selection)

  	def custom_cursor_changed(self, treeview):
     		path, column = treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
		if colname == "Type":
			self.generic_on_selection_changed(self.custom_selection)

	def find_individual(self, pointer, treeview):
		model = treeview.get_model()
		self.generic_iter = model.get_iter_root()
		self.generic_path = model.get_path(self.generic_iter)
		while self.generic_iter:
			self.temp_individual_pointer = model.get_value(self.generic_iter, self.generic_pointer_posn)
			if self.temp_individual_pointer == pointer:
				self.temp_individual_pointer = self.individual_treestore.get_value(self.generic_iter, self.individual_pointer_posn)
				self.temp_individual_raw_gedcom = self.individual_treestore.get_value(self.generic_iter, self.individual_raw_gedcom_posn)
				self.temp_individual_given_names = self.individual_treestore.get_value(self.generic_iter, self.individual_given_names_posn)
				self.temp_individual_last_name = self.individual_treestore.get_value(self.generic_iter, self.individual_last_name_posn)
				self.temp_individual_sex = self.individual_treestore.get_value(self.generic_iter, self.individual_sex_posn)
				self.temp_individual_birth_date = self.individual_treestore.get_value(self.generic_iter, self.individual_birth_date_posn)
				self.temp_individual_birth_year = self.individual_treestore.get_value(self.generic_iter, self.individual_birth_year_posn)
				self.temp_individual_birth_month = self.individual_treestore.get_value(self.generic_iter, self.individual_birth_month_posn)
				self.temp_individual_birth_day = self.individual_treestore.get_value(self.generic_iter, self.individual_birth_day_posn)
				self.temp_individual_death_date = self.individual_treestore.get_value(self.generic_iter, self.individual_death_date_posn)
				self.temp_individual_death_year = self.individual_treestore.get_value(self.generic_iter, self.individual_death_year_posn)
				self.temp_individual_death_month = self.individual_treestore.get_value(self.generic_iter, self.individual_death_month_posn)
				self.temp_individual_death_day = self.individual_treestore.get_value(self.generic_iter, self.individual_death_day_posn)
				self.temp_individual_family_pointers = self.individual_treestore.get_value(self.generic_iter, self.individual_family_pointers_posn)
				self.temp_individual_parent_pointers = self.individual_treestore.get_value(self.generic_iter, self.individual_parent_pointers_posn)
				return
			else:
				self.generic_iter = model.iter_next(self.generic_iter)
				self.generic_path = model.get_path(self.generic_iter)

		return

	def find_family(self, pointer, treeview):
		model = treeview.get_model()
		self.generic_iter = model.get_iter_root()
		self.generic_path = model.get_path(self.generic_iter)
		while self.generic_iter:
			self.temp_family_pointer = model.get_value(self.generic_iter, self.generic_pointer_posn)
			if self.temp_family_pointer == pointer:
				self.temp_family_raw_gedcom = model.get_value(self.generic_iter, self.family_raw_gedcom_posn)
				self.temp_family_husband_pointer = model.get_value(self.generic_iter, self.family_husband_pointer_posn)
				self.temp_family_husband_given_names = model.get_value(self.generic_iter, self.family_husband_given_names_posn)
				self.temp_family_husband_last_name = model.get_value(self.generic_iter, self.family_husband_last_name_posn)
				self.temp_family_wife_pointer = model.get_value(self.generic_iter, self.family_wife_pointer_posn)
				self.temp_family_wife_given_names = model.get_value(self.generic_iter, self.family_wife_given_names_posn)
				self.temp_family_wife_last_name = model.get_value(self.generic_iter, self.family_wife_last_name_posn)
				self.temp_family_children_pointers = model.get_value(self.generic_iter, self.family_children_pointers_posn)
				self.temp_family_marriage_date = model.get_value(self.generic_iter, self.family_marriage_date_posn)
				return
			else:
				self.generic_iter = model.iter_next(self.generic_iter)
				self.generic_path = model.get_path(self.generic_iter)

		return

	def set_cursor(self, pointer, treeview):
		model = treeview.get_model()
		self.generic_iter = model.get_iter_root()
		self.generic_path = model.get_path(self.generic_iter)
		while self.generic_iter:
			val = model.get_value(self.generic_iter, self.generic_pointer_posn)
			if val == pointer:
				#treeview.set_cursor(self.generic_path)
				#treeview.scroll_to_cell(self.generic_path, treeview.get_column(3))
				treeview.set_cursor(self.generic_path, focus_column=treeview.get_column(3))
				#treeview.set_cursor_on_cell(self.generic_path, focus_column=treeview.get_column(3))
				self.generic_iter = None	
			else:
				self.generic_iter = model.iter_next(self.generic_iter)
				self.generic_path = model.get_path(self.generic_iter)

	def save_gedcom(self, action):

		#if hildon_flag == True:	
		#	file_save = hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_SAVE)
		#else:	
		#	file_save = gtk.FileChooserDialog(title="Save GEDCOM File"
		#			, action=gtk.FILE_CHOOSER_ACTION_SAVE
		#			, buttons=(gtk.STOCK_CANCEL
		#						, gtk.RESPONSE_CANCEL
		#						, gtk.STOCK_SAVE
		#						, gtk.RESPONSE_OK))

		file_save = gtk.FileChooserDialog(title="Save GEDCOM File"
				, action=gtk.FILE_CHOOSER_ACTION_SAVE
				, buttons=(gtk.STOCK_CANCEL
							, gtk.RESPONSE_CANCEL
							, gtk.STOCK_SAVE
							, gtk.RESPONSE_OK))

                path = os.path.expanduser("~") + "/.mgedcom/"
		file_save.set_show_hidden(True)
		file_save.set_current_folder(os.path.dirname(path))

		"""Create and add the Images filter"""		
		filter = gtk.FileFilter()
		filter.set_name("Gedcoms")
		filter.add_pattern("*.ged")
		filter.add_pattern("*.GED")
		file_save.add_filter(filter)
		"""Create and add the 'all files' filter"""
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		file_save.add_filter(filter)
		
		file_save.set_do_overwrite_confirmation(True)
		file_save.set_default_response(gtk.RESPONSE_OK)
		res = file_save.run()
		file_name = file_save.get_filename()
		file_save.destroy()
		if res != gtk.RESPONSE_OK: 
       	 		self.on_show_note(self.window, "ERROR: GEDOM save failed!", "OK")
			return

		print "NOTE: Saving GEDCOM file " + file_name + " in " + self.unicode_type + " format..."
		if self.unicode_type.startswith("utf"):
			file = codecs.open(file_name, "w", self.unicode_type)
		else:
			file = open(file_name, "w")

       	 	self.on_show_note(self.window, "NOTE: GEDOM save (in " + self.unicode_type + " format) proceeding to " + file_name, "OK")

		if self.unicode_type == "utf-16-be":
			file.write(u'\ufeff')
			#file.write(codecs.BOM_UTF16_BE)
			print "now writing UTF-16-BE BOM..."
			gedcom_char = "UNICODE"

		if self.unicode_type == "utf-16-le":
			file.write(u'\ufeff')	# reverse from proper since it will be reversed on write
			#file.write(codecs.BOM_UTF16_LE)
			print "now writing UTF-16-LE BOM..."
			gedcom_char = "UNICODE"

		if self.unicode_type == "utf-8":
			gedcom_char = "UTF-8"

		head = "0 HEAD" + "\n"
		head = head + "1 SOUR mgedcom" + "\n"
		head = head + "2 VERS " + str(VERSION) + "\n"
		head = head + "2 NAME MGedcom" + "\n"
		head = head + "1 DATE " + datetime.datetime.now().strftime("%d %b %Y") + "\n"
		head = head + "2 TIME " + datetime.datetime.now().strftime("%H:%M") + "\n"
		head = head + "1 CHAR " + gedcom_char + "\n"
		head = head + "1 FILE " + file_name + "\n"
		head = head + "1 GEDC" + "\n"
		head = head + "2 VERS 5.5" + "\n"
		head = head + "2 FORM LINEAGE-LINKED" + "\n"

		file.write(head)
		for row in self.head_comments:
		    	file.write(row + "\n")
		for row in self.individual_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.family_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.note_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.submitter_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.repository_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.source_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.object_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.submission_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		for row in self.custom_treestore:
		    	file.write(row[self.generic_raw_gedcom_posn] + "\n")
		file.write("0 TRLR" + "\n")
		file.close()

	def open_gedcom(self, action):
		global relation_style

		#if hildon_flag == True:	
		#	file_open = hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_OPEN)
		#else:	
		#	file_open = gtk.FileChooserDialog(title="Select GEDCOM File"
		#			, action=gtk.FILE_CHOOSER_ACTION_OPEN
		#			, buttons=(gtk.STOCK_CANCEL
		#						, gtk.RESPONSE_CANCEL
		#						, gtk.STOCK_OPEN
		#						, gtk.RESPONSE_OK))

		file_open = gtk.FileChooserDialog(title="Select GEDCOM File"
				, action=gtk.FILE_CHOOSER_ACTION_OPEN
				, buttons=(gtk.STOCK_CANCEL
							, gtk.RESPONSE_CANCEL
							, gtk.STOCK_OPEN
							, gtk.RESPONSE_OK))

                path = os.path.expanduser("~") + "/.mgedcom/"
		file_open.set_show_hidden(True)
		file_open.set_current_folder(os.path.dirname(path))
		print "path=", path

		"""Create and add the Gedcoms filter"""		
		filter = gtk.FileFilter()
		filter.set_name("Gedcoms")
		filter.add_pattern("*.ged")
		filter.add_pattern("*.GED")
		file_open.add_filter(filter)
		"""Create and add the 'all files' filter"""
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		file_open.add_filter(filter)
		
		"""Init the return value"""
		file_name = ""
		if file_open.run() == gtk.RESPONSE_OK:
			file_name = file_open.get_filename()
			file_open.destroy()
		else:
			file_open.destroy()
			return

		if file_name:	
			self.window.set_title("MGedcom Main Display: " + file_name)

			g = Gedcom(file_name)

			self.unicode_type = g.unicode_type()
			print "NOTE: GEDCOM file " + file_name + " detected/read in " + self.unicode_type + " format..."

			self.individual_treestore.clear()
			self.family_treestore.clear()
			self.note_treestore.clear()
			self.submitter_treestore.clear()
			self.repository_treestore.clear()
			self.source_treestore.clear()
			self.object_treestore.clear()
			self.submission_treestore.clear()
			self.custom_treestore.clear()

			self.head_comments = []

			for e in g.element_list():
				if e.level() == 0 and e.tag() in ("HEAD"):
					for f in e.children():
						if f.tag() == "NOTE":
							#print f.get_individual()
							self.head_comments.append(f.get_individual())

			self.family_dict = {}

			for e in g.element_list():
				if e.tag() == "FAM":
					marriage = ""
					husband = ""
					wife = ""
					date = ""
					place = ""
					children = []
					raw_gedcom = ""
					for h in e.children():
						raw_gedcom = raw_gedcom + str(h) + "\n"
						if h.tag() == "HUSB":
							husband = h.value()
						if h.tag() == "WIFE":
							wife = h.value()
						if h.tag() == "CHIL":
							children.append(h.value())
						if h.tag() == "MARR":
							for i in h.children():
								if i.tag() == "DATE":
									date = i.value()
								if i.tag() == "PLAC":
									place = i.value()
					if len(raw_gedcom) > 0 and raw_gedcom[-1] == "\n":
						raw_gedcom = raw_gedcom[:-1]
					self.family_dict[e.pointer()] = (husband, wife, [date, place], children, e.get_individual())

			self.individual_dict = {}

			for e in g.element_list():
				if e.individual():
					family = []
					parents = []
					sex = ""
					for h in e.children():
						if h.tag() == "FAMC":
							parents = h.value()
						if h.tag() == "SEX":
							sex = h.value()
					for f in e.families():
						family.append(f.pointer())
					self.individual_dict[e.pointer()] = (e.name(), sex, e.birth(), e.death(), family, parents, e.get_individual())

			self.note_dict = {}

			for e in g.element_list():
				if e.level() == 0 and e.tag() in ("NOTE"):
					self.note_dict[e.pointer()] = (e.get_individual())
				
			self.submitter_dict = {}

			for e in g.element_list():
				if e.level() == 0 and e.tag() in ("SUBM"):
					self.submitter_dict[e.pointer()] = (e.get_individual())
				
			self.repository_dict = {}

			for e in g.element_list():
				if e.level() == 0 and e.tag() in ("REPO"):
					self.repository_dict[e.pointer()] = (e.get_individual())
				
			self.source_dict = {}

			for e in g.element_list():
				if e.level() == 0 and e.tag() in ("SOUR"):
					self.source_dict[e.pointer()] = (e.get_individual())
				
			self.object_dict = {}

			for e in g.element_list():
				if e.level() == 0 and e.tag() in ("OBJE"):
					self.object_dict[e.pointer()] = (e.get_individual())
				
			self.submission_dict = {}

			for e in g.element_list():
				if e.level() == 0 and e.tag() in ("SUBN"):
					self.submission_dict[e.pointer()] = (e.get_individual())
				
			self.custom_dict = {}

			for e in g.element_list():
				if e.level() == 0 and e.tag() not in ("INDI", "FAM", "HEAD", "TRLR", "NOTE", "SUBM", "REPO", "SOUR", "OBJE", "SUBN"):
					self.custom_dict[e.pointer()] = (e.get_individual())
				
			pd = self.individual_dict.keys()
			pd.sort()

			for p in pd:
				self.get_individual_info(p)

				piter = self.individual_treestore.append(None, [self.individual_raw_gedcom, "INDIVIDUAL", p, self.individual_given_names, self.individual_last_name, self.individual_sex, self.individual_birth_date, self.individual_birth_year, self.individual_birth_month, self.individual_birth_day, self.individual_death_date, self.individual_death_year, self.individual_death_month, self.individual_death_day, self.individual_family_pointers, self.individual_parent_pointers])

				if relation_style == "ParentChild":					
					if self.individual_family_pointers:
						self.individual_treestore.append(piter)

				if relation_style == "ChildParent":					
					#if len(self.individual_parent_pointers) > 0:
					if self.individual_parent_pointers:
						self.individual_treestore.append(piter)

			fd = self.family_dict.keys()
			fd.sort()

			for f in fd:
				self.get_family_info(f)

				piter = self.family_treestore.append(None, [self.family_raw_gedcom, "FAMILY", f, self.family_husband_pointer, self.family_husband_given_names, self.family_husband_last_name, self.family_wife_pointer, self.family_wife_given_names, self.family_wife_last_name, self.family_marriage_date, self.family_marriage_year, self.family_marriage_month, self.family_marriage_day, self.family_children_pointers])

			nd = self.note_dict.keys()
			nd.sort()

			for n in nd:
				self.note_raw_gedcom = self.note_dict[n]
				notes = " "
				for raw_gedcom_line in self.note_raw_gedcom.split("\n"):
					line_element = raw_gedcom_line.split(" ", 2)
					#line_element = re.split(" ", raw_gedcom_line, 2)
					level = line_element[0]
					if len(line_element) == 2:
						pointer =  " "
						tag = line_element[1]
						values = " "
					if len(line_element) == 3:
						if line_element[1][:1] == "@":
							pointer = line_element[1]
							tag = line_element[2]
							if len(line_element[2].split(" ")) > 1:
								values = line_element[2].split(" ", 1)[1]
							else:
								values = " "
						else:
							pointer = " "
							tag = line_element[1]
							values = line_element[2]
					if int(level) == 0 and values != " ":
						notes = notes + values
						print "WARNING: Found start of note text on NOTE line: '" + raw_gedcom_line + "'"
					if int(level) == 1 and tag == "CONC":
						notes = notes + values
					if int(level) == 1 and tag == "CONT":
						notes = notes + "\n" + values
				piter = self.note_treestore.append(None, [self.note_raw_gedcom, "NOTE", n, notes])

			sd = self.submitter_dict.keys()
			sd.sort()

			for s in sd:
				self.submitter_raw_gedcom = self.submitter_dict[s]
				name = " "
				for raw_gedcom_line in self.submitter_raw_gedcom.split("\n"):
					line_element = raw_gedcom_line.split(" ", 2)
					level = line_element[0]
					if len(line_element) == 2:
						pointer =  " "
						tag = line_element[1]
						values = " "
					if len(line_element) == 3:
						if line_element[1][:1] == "@":
							pointer = line_element[1]
							tag = line_element[2]
							values = " "
						else:
							pointer = " "
							tag = line_element[1]
							values = line_element[2]
					if int(level) == 1 and tag == "NAME":
						name = name + values
				piter = self.submitter_treestore.append(None, [self.submitter_raw_gedcom, "SUBMITTER", s, name])

			rd = self.repository_dict.keys()
			rd.sort()

			for r in rd:
				self.repository_raw_gedcom = self.repository_dict[r]
				name = " "
				for raw_gedcom_line in self.repository_raw_gedcom.split("\n"):
					line_element = raw_gedcom_line.split(" ", 2)
					level = line_element[0]
					if len(line_element) == 2:
						pointer =  " "
						tag = line_element[1]
						values = " "
					if len(line_element) == 3:
						if line_element[1][:1] == "@":
							pointer = line_element[1]
							tag = line_element[2]
							values = " "
						else:
							pointer = " "
							tag = line_element[1]
							values = line_element[2]
					if int(level) == 1 and tag == "NAME":
						name = name + values
				piter = self.repository_treestore.append(None, [self.repository_raw_gedcom, "REPOSITORY", r, name])

			srd = self.source_dict.keys()
			srd.sort()

			for sr in srd:
				self.source_raw_gedcom = self.source_dict[sr]
				abbrev = " "
				for raw_gedcom_line in self.source_raw_gedcom.split("\n"):
					line_element = raw_gedcom_line.split(" ", 2)
					level = line_element[0]
					if len(line_element) == 2:
						pointer =  " "
						tag = line_element[1]
						values = " "
					if len(line_element) == 3:
						if line_element[1][:1] == "@":
							pointer = line_element[1]
							tag = line_element[2]
							values = " "
						else:
							pointer = " "
							tag = line_element[1]
							values = line_element[2]
					if int(level) == 1 and tag == "ABBR":
						abbrev = abbrev + values
				piter = self.source_treestore.append(None, [self.source_raw_gedcom, "SOURCE", sr, abbrev])

			od = self.object_dict.keys()
			od.sort()

			for o in od:
				self.object_raw_gedcom = self.object_dict[o]
				piter = self.object_treestore.append(None, [self.object_raw_gedcom, "OBJECT", o])

			snd = self.submission_dict.keys()
			snd.sort()

			for sn in snd:
				self.submission_raw_gedcom = self.submission_dict[sn]
				piter = self.submission_treestore.append(None, [self.submission_raw_gedcom, "SUBMISSION", sn])

			md = self.custom_dict.keys()
			md.sort()

			for m in md:
				self.custom_raw_gedcom = self.custom_dict[m]
				piter = self.custom_treestore.append(None, [self.custom_raw_gedcom, "CUSTOM", m])

			self.total_individual_count = len(self.individual_dict)
			self.total_family_count = len(self.family_dict)
			self.total_note_count = len(self.note_dict)
			self.total_submitter_count = len(self.submitter_dict)
			self.total_repository_count = len(self.repository_dict)
			self.total_source_count = len(self.source_dict)
			self.total_object_count = len(self.object_dict)
			self.total_submission_count = len(self.submission_dict)
			self.total_custom_count = len(self.custom_dict)

			self.on_show_note(self.window, "%4.0f" % self.total_individual_count +": Individuals\n" + "%4.0f" % self.total_family_count + ": Families\n" + "%4.0f" % self.total_note_count + " : Notes\n" + "%4.0f" % self.total_submitter_count + ": Submitters\n" + "%4.0f" % self.total_repository_count + ": Respositories\n" + "%4.0f" % self.total_source_count + ": Sources\n" + "%4.0f" % self.total_object_count + ": Objects\n" + "%4.0f" % self.total_submission_count + ": Submissions\n" + "%4.0f" % self.total_custom_count + ": Custom","OK")

			self.next_individual_pointer_number = 0
			self.get_next_individual_pointer()
			self.next_family_pointer_number = 0
			self.get_next_family_pointer()
			self.get_next_note_pointer()

		return file_name

	def convert_dot_graph_to_pdf(self, action):
		self.convert_dot_graph('pdf')

	def convert_dot_graph_to_png(self, type):
		self.convert_dot_graph('png')

	def convert_dot_graph_to_svg(self, type):
		self.convert_dot_graph('svg')

	def convert_dot_graph(self, type):
		#if hildon_flag == True:	
		#	file_open = hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_OPEN)
		#else:	
		#	file_open = gtk.FileChooserDialog(title="Select Dot File"
		#			, action=gtk.FILE_CHOOSER_ACTION_OPEN
		#			, buttons=(gtk.STOCK_CANCEL
		#						, gtk.RESPONSE_CANCEL
		#						, gtk.STOCK_OPEN
		#						, gtk.RESPONSE_OK))

		file_open = gtk.FileChooserDialog(title="Select Dot File"
				, action=gtk.FILE_CHOOSER_ACTION_OPEN
				, buttons=(gtk.STOCK_CANCEL
							, gtk.RESPONSE_CANCEL
							, gtk.STOCK_OPEN
							, gtk.RESPONSE_OK))

                path = os.path.expanduser("~") + "/.mgedcom/"
		file_open.set_show_hidden(True)
		file_open.set_current_folder(os.path.dirname(path))

		"""Create and add the Dotfiles filter"""		
		filter = gtk.FileFilter()
		filter.set_name("Dotfiles")
		filter.add_pattern("*.dot")
		file_open.add_filter(filter)
		"""Create and add the 'all files' filter"""
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		file_open.add_filter(filter)
		
		"""Init the return value"""
		file_name = ""
		if file_open.run() == gtk.RESPONSE_OK:
			file_name = file_open.get_filename()

		file_open.destroy()

		convert_name = file_name.split('.dot')[0] + '.' + type

		os.system('/usr/bin/dot -Tpdf -o ' + convert_name + ' ' + file_name)

     		self.on_show_note(self.window, "Dot file " + file_name + " successfully converted into " + string.upper(type) + ' at ' + convert_name, "OK")

		return file_name

	def open_dot_graph(self, action):
		#if hildon_flag == True:	
		#	file_open = hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_OPEN)
		#else:	
		#	file_open = gtk.FileChooserDialog(title="Select Dot File"
		#			, action=gtk.FILE_CHOOSER_ACTION_OPEN
		#			, buttons=(gtk.STOCK_CANCEL
		#						, gtk.RESPONSE_CANCEL
		#						, gtk.STOCK_OPEN
		#						, gtk.RESPONSE_OK))

		file_open = gtk.FileChooserDialog(title="Select Dot File"
				, action=gtk.FILE_CHOOSER_ACTION_OPEN
				, buttons=(gtk.STOCK_CANCEL
							, gtk.RESPONSE_CANCEL
							, gtk.STOCK_OPEN
							, gtk.RESPONSE_OK))

                path = os.path.expanduser("~") + "/.mgedcom/"
		file_open.set_show_hidden(True)
		file_open.set_current_folder(os.path.dirname(path))

		"""Create and add the Dotfiles filter"""		
		filter = gtk.FileFilter()
		filter.set_name("Dotfiles")
		filter.add_pattern("*.dot")
		file_open.add_filter(filter)
		"""Create and add the 'all files' filter"""
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		file_open.add_filter(filter)
		
		"""Init the return value"""
		file_name = ""
		if file_open.run() == gtk.RESPONSE_OK:
			file_name = file_open.get_filename()

		file_open.destroy()

		f = open(file_name)
		dotfile = ""
		for line in f.readlines():
			dotfile = dotfile + line	

		window = MyDotWindow()
		window.set_dotcode(dotfile)

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		return file_name

	def save_children_dot_graph(self, action):
     		individual_model, individual_iter = self.individual_treeview.get_selection().get_selected()
		if not individual_iter:
       	 		self.on_show_note(self.window, "ERROR: Must select individual to generate children DOT graph for!", "OK")
			return

		pointer = self.individual_treestore.get_value(individual_iter, self.individual_pointer_posn)

		#if hildon_flag == True:	
		#	hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_SAVE)
		#else:	
		#	file_save = gtk.FileChooserDialog(title="Save Children DOT File"
		#			, action=gtk.FILE_CHOOSER_ACTION_SAVE
		#			, buttons=(gtk.STOCK_CANCEL
		#						, gtk.RESPONSE_CANCEL
		#						, gtk.STOCK_SAVE
		#						, gtk.RESPONSE_OK))

		file_save = gtk.FileChooserDialog(title="Save Children DOT File"
				, action=gtk.FILE_CHOOSER_ACTION_SAVE
				, buttons=(gtk.STOCK_CANCEL
							, gtk.RESPONSE_CANCEL
							, gtk.STOCK_SAVE
							, gtk.RESPONSE_OK))

                path = os.path.expanduser("~") + "/.mgedcom/"
		file_save.set_show_hidden(True)
		file_save.set_current_folder(os.path.dirname(path))

		"""Create and add the Images filter"""		
		filter = gtk.FileFilter()
		filter.set_name("Dotfiles")
		filter.add_pattern("*.dot")
		file_save.add_filter(filter)
		"""Create and add the 'all files' filter"""
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		file_save.add_filter(filter)
		
		file_save.set_do_overwrite_confirmation(True)
		file_save.set_default_response(gtk.RESPONSE_OK)
		res = file_save.run()
		file_name = file_save.get_filename()
		file_save.destroy()
		if res != gtk.RESPONSE_OK: 
			return

		self.dot_file = open(file_name, "w")

		head = "# Graphviz 'dot' file" + "\n"
		head = head + "# Generated by MGedcom " + str(VERSION) + "\n"
		head = head + "# " + datetime.datetime.now().strftime("%d %b %Y") + "\n"
		head = head + "digraph tree {" + "\n"
		head = head + "rankdir = LR" + "\n"
		head = head + "bgcolor=white" + "\n"
		head = head + "node [color=green, style=filled, fontname=verdana, fontsize=9];" + "\n"
		head = head + "edge [color=black,dir=none];" + "\n"
		self.dot_file.write(head)

		self.traverse_level = 1
		self.traverse_children(pointer)

		tail = "}" + "\n"
		self.dot_file.write(tail)
	
		self.dot_file.close()

     		self.on_show_note(self.window, "Dot file successfully generated for children and spouses of " + pointer, "OK")

	def save_parents_dot_graph(self, action):
     		individual_model, individual_iter = self.individual_treeview.get_selection().get_selected()
		if not individual_iter:
       	 		self.on_show_note(self.window, "ERROR: Must select individual to generate parent DOT graph for!", "OK")
			return

		pointer = self.individual_treestore.get_value(individual_iter, self.individual_pointer_posn)

		if hildon_flag == True:	
			hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_SAVE)
		else:	
			file_save = gtk.FileChooserDialog(title="Save Children DOT File"
					, action=gtk.FILE_CHOOSER_ACTION_SAVE
					, buttons=(gtk.STOCK_CANCEL
								, gtk.RESPONSE_CANCEL
								, gtk.STOCK_SAVE
								, gtk.RESPONSE_OK))

                path = os.path.expanduser("~") + "/.mgedcom/"
		file_save.set_show_hidden(True)
		file_save.set_current_folder(os.path.dirname(path))

		"""Create and add the Images filter"""		
		filter = gtk.FileFilter()
		filter.set_name("Dotfiles")
		filter.add_pattern("*.dot")
		file_save.add_filter(filter)
		"""Create and add the 'all files' filter"""
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		file_save.add_filter(filter)
		
		file_save.set_do_overwrite_confirmation(True)
		file_save.set_default_response(gtk.RESPONSE_OK)
		res = file_save.run()
		file_name = file_save.get_filename()
		file_save.destroy()
		if res != gtk.RESPONSE_OK: 
			return

		self.dot_file = open(file_name, "w")

		head = "# Graphviz 'dot' file" + "\n"
		head = head + "# Generated by MGedcom " + str(VERSION) + "\n"
		head = head + "# " + datetime.datetime.now().strftime("%d %b %Y") + "\n"
		head = head + "digraph tree {" + "\n"
		head = head + "rankdir = LR" + "\n"
		head = head + "bgcolor=white" + "\n"
		head = head + "node [color=green, style=filled, fontname=verdana, fontsize=9];" + "\n"
		head = head + "edge [color=black,dir=none];" + "\n"
		self.dot_file.write(head)

		self.parent_hit = {}

		self.traverse_level = 1
		self.traverse_parents(pointer)

		tail = "}" + "\n"
		self.dot_file.write(tail)
	
		self.dot_file.close()

     		self.on_show_note(self.window, "Dot file successfully generated for parents of " + pointer, "OK")

	def traverse_children(self, individual_pointer):
		self.find_individual(individual_pointer, self.individual_treeview)
		if self.temp_individual_sex == "M":
			individual = individual_pointer.split("@")[1] + ' [label="' + self.temp_individual_given_names + ' ' + self.temp_individual_last_name + '\\n' + 'B: ' + self.temp_individual_birth_date + '\\n' + 'D: ' + self.temp_individual_death_date + '",color=lightblue ]' + '\n'
		else:
			individual = individual_pointer.split("@")[1] + ' [label="' + self.temp_individual_given_names + ' ' + self.temp_individual_last_name + '\\n' + 'B: ' + self.temp_individual_birth_date + '\\n' + 'D: ' + self.temp_individual_death_date + '",color=lightpink ]' + '\n'
		self.dot_file.write(individual)
		#print ' ' * 2 * self.traverse_level, self.traverse_level, self.temp_individual_given_names, self.temp_individual_last_name
		individual_family_pointers = string.split(self.temp_individual_family_pointers, ",")
		for f in individual_family_pointers:
			if f:
				self.find_family(f, self.family_treeview)
				family = self.temp_family_pointer.split("@")[1] + ' [ shape=box, ranksep=0.1, orientation=270.0, label="' + 'M: ' + self.temp_family_marriage_date + '", color=tan ]' + '\n'
				self.dot_file.write(family)
				family_link = individual_pointer.split("@")[1] + " -> " + self.temp_family_pointer.split("@")[1] + " [ weight=10]" + "\n"
				self.dot_file.write(family_link)
				if self.temp_individual_sex == "M":
					if self.temp_family_wife_pointer:
						self.find_individual(self.temp_family_wife_pointer, self.individual_treeview)
						individual = self.temp_individual_pointer.split("@")[1] + ' [label="' + self.temp_individual_given_names + ' ' + self.temp_individual_last_name + '\\n' + 'B: ' + self.temp_individual_birth_date + '\\n' + 'D: ' + self.temp_individual_death_date + '",color=lightpink ]' + '\n'
						self.dot_file.write(individual)
						family_link = self.temp_family_wife_pointer.split("@")[1] + " -> " + self.temp_family_pointer.split("@")[1] + " [ weight=10]" + "\n"
						self.dot_file.write(family_link)
						#print ' ' * 2 * self.traverse_level, self.traverse_level, "[", self.temp_family_wife_given_names, self.temp_family_wife_last_name, self.temp_individual_birth_date, "]"
				else:
					if self.temp_family_husband_pointer:
						self.find_individual(self.temp_family_husband_pointer, self.individual_treeview)
						individual = self.temp_individual_pointer.split("@")[1] + ' [label="' + self.temp_individual_given_names + ' ' + self.temp_individual_last_name + '\\n' + 'B: ' + self.temp_individual_birth_date + '\\n' + 'D: ' + self.temp_individual_death_date + '",color=lightblue ]' + '\n'
						self.dot_file.write(individual)
						family_link = self.temp_family_husband_pointer.split("@")[1] + " -> " + self.temp_family_pointer.split("@")[1] + " [ weight=10]" + "\n"
						self.dot_file.write(family_link)
						#print ' ' * 2 * self.traverse_level, self.traverse_level, "[", self.temp_family_husband_given_names, self.temp_family_husband_last_name, self.temp_individual_birth_date, "]"
				family_children_pointers = string.split(self.temp_family_children_pointers, ",")
				if len(family_children_pointers) > 1:
					child_list = ""
					prev_j = ""
					child_arrow = ""
					for j in family_children_pointers:
						child_list = child_list + j.split("@")[1] + ";"
						if prev_j:
							child_arrow = child_arrow + prev_j.split("@")[1] + " -> " + j.split("@")[1] + " [ style=invis ]" + "\n"
						prev_j = j
					child_joins = "{" + "\n"
					child_joins = child_joins + "rank=same; ordering=out; " + child_list + "\n"
					self.dot_file.write(child_joins) 				
					self.dot_file.write(child_arrow) 				
					child_joins = "}" + "\n"
					self.dot_file.write(child_joins) 				
				for c in family_children_pointers:
					if c:
						child_link = f.split("@")[1] + " -> " + c.split("@")[1] + "\n"
						self.dot_file.write(child_link)
						self.traverse_level += 1
						self.traverse_children(c)
						self.traverse_level -= 1
			
		return
	
	def traverse_parents(self, individual_pointer):
		self.find_individual(individual_pointer, self.individual_treeview)

		if not self.parent_hit.has_key(individual_pointer):
			if self.temp_individual_sex == "M":
				individual = individual_pointer.split("@")[1] + ' [label="' + self.temp_individual_given_names + ' ' + self.temp_individual_last_name + '\\n' + 'B: ' + self.temp_individual_birth_date + '\\n' + 'D: ' + self.temp_individual_death_date + '",color=lightblue ]' + '\n'
				self.dot_file.write(individual)
			else:
				individual = individual_pointer.split("@")[1] + ' [label="' + self.temp_individual_given_names + ' ' + self.temp_individual_last_name + '\\n' + 'B: ' + self.temp_individual_birth_date + '\\n' + 'D: ' + self.temp_individual_death_date + '",color=lightpink ]' + '\n'
				self.dot_file.write(individual)
		self.parent_hit[individual_pointer] = "hit!"

		#print ' ' * 2 * self.traverse_level, self.traverse_level, self.temp_individual_given_names, self.temp_individual_last_name
		individual_parent_pointers = string.split(self.temp_individual_parent_pointers, ",")
		for p in individual_parent_pointers:
			if self.family_dict.has_key(p):
				self.find_family(p, self.family_treeview)
				if not self.parent_hit.has_key(p):
					family = self.temp_family_pointer.split("@")[1] + ' [ shape=box, ranksep=0.1, orientation=270.0, label="' + 'M: ' + self.temp_family_marriage_date + '", color=tan ]' + '\n'
					self.dot_file.write(family)
					self.parent_hit[p] = "hit!"
				family_link = individual_pointer.split("@")[1] + " -> " + self.temp_family_pointer.split("@")[1] + " [ weight=10]" + "\n"
				self.dot_file.write(family_link)
				father_pointer = self.temp_family_husband_pointer
				mother_pointer = self.temp_family_wife_pointer
				#print ' ' * 2 * self.traverse_level, self.traverse_level, "[", self.temp_family_husband_given_names, self.temp_family_husband_last_name, self.temp_family_wife_given_names, self.temp_family_wife_last_name, "]"
				if father_pointer:
					if not self.parent_hit.has_key(father_pointer):
						self.traverse_level += 1
						father_link = p.split("@")[1] + " -> " + father_pointer.split("@")[1] + "\n"
						self.dot_file.write(father_link)
						self.traverse_parents(father_pointer)
						self.traverse_level -= 1
				if mother_pointer:
					if not self.parent_hit.has_key(mother_pointer):
						self.traverse_level += 1
						mother_link = p.split("@")[1] + " -> " + mother_pointer.split("@")[1] + "\n"
						self.dot_file.write(mother_link)
						self.traverse_parents(mother_pointer)
						self.traverse_level -= 1
			
		return
	
	def get_next_individual_pointer(self):
		self.next_individual_pointer_number = self.next_individual_pointer_number + 1
		self.next_individual_pointer = "@I" + str(self.next_individual_pointer_number).zfill(4) + "@"
		while self.individual_dict.has_key(self.next_individual_pointer):
			self.next_individual_pointer_number = self.next_individual_pointer_number + 1
			self.next_individual_pointer = "@I" + str(self.next_individual_pointer_number).zfill(4) + "@"
		
	def get_next_family_pointer(self):
		self.next_family_pointer_number = self.next_family_pointer_number + 1
		self.next_family_pointer = "@F" + str(self.next_family_pointer_number).zfill(4) + "@"
		while self.family_dict.has_key(self.next_family_pointer):
			self.next_family_pointer_number = self.next_family_pointer_number + 1
			self.next_family_pointer = "@F" + str(self.next_family_pointer_number).zfill(4) + "@"
		
	def get_next_note_pointer(self):
		self.next_note_pointer_number = self.next_note_pointer_number + 1
		self.next_note_pointer = "@N" + str(self.next_note_pointer_number).zfill(4) + "@"
		while self.note_dict.has_key(self.next_note_pointer):
			self.next_note_pointer_number = self.next_note_pointer_number + 1
			self.next_note_pointer = "@N" + str(self.next_note_pointer_number).zfill(4) + "@"
		
	def individual_show_toggle(self, action, data=None):
		global individual_show_flag
		individual_show_flag = action.get_active()
		if individual_show_flag == True:
			self.vbox.pack_start(self.individual_scrolledwindow)
		else:
			self.vbox.remove(self.individual_scrolledwindow)

	def family_show_toggle(self, action, data=None):
		global family_show_flag 
		family_show_flag = action.get_active()
		if family_show_flag == True:
			self.vbox.pack_start(self.family_scrolledwindow)
		else:
			self.vbox.remove(self.family_scrolledwindow)

	def note_show_toggle(self, action, data=None):
		global note_show_flag 
		note_show_flag = action.get_active()
		if note_show_flag == True:
			self.vbox.pack_start(self.note_scrolledwindow)
		else:
			self.vbox.remove(self.note_scrolledwindow)

	def submitter_show_toggle(self, action, data=None):
		global submitter_show_flag 
		submitter_show_flag = action.get_active()
		if submitter_show_flag == True:
			self.vbox.pack_start(self.submitter_scrolledwindow)
		else:
			self.vbox.remove(self.submitter_scrolledwindow)

	def repository_show_toggle(self, action, data=None):
		global repository_show_flag 
		repository_show_flag = action.get_active()
		if repository_show_flag == True:
			self.vbox.pack_start(self.repository_scrolledwindow)
		else:
			self.vbox.remove(self.repository_scrolledwindow)

	def source_show_toggle(self, action, data=None):
		global source_show_flag 
		source_show_flag = action.get_active()
		if source_show_flag == True:
			self.vbox.pack_start(self.source_scrolledwindow)
		else:
			self.vbox.remove(self.source_scrolledwindow)

	def object_show_toggle(self, action, data=None):
		global object_show_flag 
		object_show_flag = action.get_active()
		if object_show_flag == True:
			self.vbox.pack_start(self.object_scrolledwindow)
		else:
			self.vbox.remove(self.object_scrolledwindow)

	def submission_show_toggle(self, action, data=None):
		global _show_flag 
		submission_show_flag = action.get_active()
		if submission_show_flag == True:
			self.vbox.pack_start(self.submission_scrolledwindow)
		else:
			self.vbox.remove(self.submission_scrolledwindow)

	def custom_show_toggle(self, action, data=None):
		global custom_show_flag 
		custom_show_flag = action.get_active()
		if custom_show_flag == True:
			self.vbox.pack_start(self.custom_scrolledwindow)
		else:
			self.vbox.remove(self.custom_scrolledwindow)

	def gedcom_direction_cb(self, action, current):
		global relation_style
		text = ('ParentChild', 'ChildParent')[action.get_current_value()]
		relation_style = text

		self.new_individual_treestore = gtk.TreeStore(str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, str)

		for row in self.individual_treestore:
			values = []
			for i in range(0, self.individual_last_posn+1):
				values.append(row[i])
			piter = self.new_individual_treestore.append(None, values)

		self.individual_treestore.clear()
		
		for row in self.new_individual_treestore:
			values = []
			for i in range(0, self.individual_last_posn+1):
				values.append(row[i])
			piter = self.individual_treestore.append(None, values)

			self.individual_family_pointers = row[self.individual_family_pointers_posn]
			if relation_style == "ParentChild":					
				#if len(self.individual_family_pointers) > 0:
				if self.individual_family_pointers:
					self.individual_treestore.append(piter)

			self.individual_parent_pointers = row[self.individual_parent_pointers_posn]
			if relation_style == "ChildParent":					
				#if len(self.individual_parent_pointers) > 0:
				if self.individual_parent_pointers:
					self.individual_treestore.append(piter)

		return

	def refresh_view(self, widget):
		global font_size
		global individual_show_flag
		global family_show_flag
		global note_show_flag
		global submitter_show_flag
		global repository_show_flag
		global source_show_flag
		global object_show_flag
		global submission_show_flag
		global custom_show_flag
		self.new_individual_treestore = gtk.TreeStore(str, str, str, str, str, str, str, str, str, str, str, str, str, str, str, str)

		for row in self.individual_treestore:
			values = []
			for i in range(0, self.individual_last_posn+1):
				values.append(row[i])
			piter = self.new_individual_treestore.append(None, values)

		self.individual_treestore.clear()
	
		for row in self.new_individual_treestore:
			values = []
			for i in range(0, self.individual_last_posn+1):
				values.append(row[i])
			piter = self.individual_treestore.append(None, values)

			self.individual_family_pointers = row[self.individual_family_pointers_posn]
			if relation_style == "ParentChild":					
				if self.individual_family_pointers:
					self.individual_treestore.append(piter)

			self.individual_parent_pointers = row[self.individual_parent_pointers_posn]
			if relation_style == "ChildParent":					
				if self.individual_parent_pointers:
					self.individual_treestore.append(piter)

		self.new_family_treestore = gtk.TreeStore(str, str, str, str, str, str, str, str, str, str, str, str, str, str)

		for row in self.family_treestore:
			values = []
			for i in range(0, self.family_last_posn+1):
				values.append(row[i])
			piter = self.new_family_treestore.append(None, values)

		self.family_treestore.clear()
		
		for row in self.new_family_treestore:
			values = []
			for i in range(0, self.family_last_posn+1):
				values.append(row[i])
			piter = self.family_treestore.append(None, values)

		return

	def show_help(self, widget):
		self.show_text_file('README')

	def show_license(self, widget):
		self.show_text_file('COPYING')

	def show_text_file(self, file_name):
		global font_size

		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Viewing " + file_name)
		window.set_size_request(800, 480)

		box1 = gtk.VBox(False, 0)
		window.add(box1)
		box1.show()

		box2 = gtk.VBox(False, 10)
		box2.set_border_width(10)
		box1.pack_start(box2, True, True, 0)
		box2.show()

		sw = gtk.ScrolledWindow()
		sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		textview = gtk.TextView()
		textview.modify_font(pango.FontDescription('Courier bold ' + str(font_size)))

		textbuffer = textview.get_buffer()
		sw.add(textview)
		sw.show()
		textview.show()
		box2.pack_start(sw)

		# Load the file into the text window
                path = os.path.dirname(os.path.abspath(sys.argv[0]))
                file_name = os.path.join(path, file_name)
		infile = open(file_name, "r")

		if infile:
		    	string = infile.read()
		    	infile.close()
		    	textbuffer.set_text(string)

		hbox = gtk.HButtonBox()
		box2.pack_start(hbox, False, False, 0)
		hbox.show()

                if window_in_fullscreen == True:
                        window.fullscreen()

		window.show_all()

	def show_valid_tags(self, widget):
		global font_size

		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Valid Tag List")
		window.set_size_request(800, 480)

		box1 = gtk.VBox(False, 0)
		window.add(box1)
		box1.show()

		box2 = gtk.VBox(False, 10)
		box2.set_border_width(10)
		box1.pack_start(box2, True, True, 0)
		box2.show()

		sw = gtk.ScrolledWindow()
		sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		textview = gtk.TextView()
		textview.modify_font(pango.FontDescription('Courier bold ' + str(font_size)))

		textbuffer = textview.get_buffer()
		sw.add(textview)
		sw.show()
		textview.show()
		box2.pack_start(sw)

		vt = self.valid_tags.keys()
		vt.sort()

		out_string = ""
		for tag in vt:
			out_string = out_string + string.ljust(tag, 4) + " : " + self.valid_tags[tag] + "\n"
		out_string = out_string[:-1]
		textbuffer.set_text(out_string)

		hbox = gtk.HButtonBox()
		box2.pack_start(hbox, False, False, 0)
		hbox.show()

                if window_in_fullscreen == True:
                        window.fullscreen()

		window.show_all()

	def last_name_frequency_report(self, widget):
		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Last Name Frequency Report")
		window.set_size_request(800, 480)

		last_name_frequency_treestore = gtk.TreeStore(str, int)

		last_names = []	
		for row in self.individual_treestore:
			last_names.append(row[self.individual_last_name_posn])

		freq = [(a, last_names.count(a)) for a in set(last_names)]
		sort_freq = sorted(freq, key=lambda freq: -freq[1])

		for count in sort_freq:
			last_name_frequency_iter = last_name_frequency_treestore.append(None, [count[0], count[1]])

		# create the TreeView using treestore
		last_name_frequency_treeview = gtk.TreeView(last_name_frequency_treestore)
		last_name_frequency_treeview.set_headers_visible(True)		# needed for Maemo
		last_name_frequency_treeview.expand_all()

		# create a CellRendererText to render the data
		last_name_cell = gtk.CellRendererText()
		self.set_cell_style(last_name_cell)
		frequency_cell = gtk.CellRendererText()
		self.set_cell_style(frequency_cell)

		# create the TreeViewColumn to display the data
		last_name_column = gtk.TreeViewColumn('Last Name', last_name_cell, text=0)
		self.set_column_style(last_name_column)
		frequency_column = gtk.TreeViewColumn('Frequency', frequency_cell, text=1)
		self.set_column_style(frequency_column)

		# Allow sorting on the individual columns
		column = 0
		last_name_column.set_sort_column_id(column)
		column = column + 1
		frequency_column.set_sort_column_id(column)

		# add level_column to treeview
		last_name_frequency_treeview.append_column(last_name_column)
		last_name_frequency_treeview.append_column(frequency_column)

		# add the cell to the column and allow it to expand
		#last_name_column.pack_start(last_name_cell, True)
		#frequency_column.pack_start(frequency_cell, True)

		# set the cell "text" attribute to column 0 - retrieve text from that column in treestore
		column = 0
		last_name_posn = column
		last_name_column.add_attribute(last_name_cell, 'text', 0)
		column = column + 1
		frequency_posn = column
		frequency_column.add_attribute(frequency_cell, 'text', 1)

		# make ui layout
		vbox = gtk.VBox()

		# add scrolled window
		scrolledwindow = gtk.ScrolledWindow()
		bbox = gtk.HButtonBox()
		vbox.pack_start(scrolledwindow)
		vbox.pack_start(bbox, False)

		scrolledwindow.add(last_name_frequency_treeview)

                if window_in_fullscreen == True:
                        window.fullscreen()

		window.add(vbox)
		window.show_all()

	def quit_cb(self, b):
		gtk.main_quit()

	def individual_on_row_expanded(self, store, iter, path):
		global relation_style
		
	     	store = store.get_model()
	     	child = store.iter_children(iter)

	     	if store.get_value(child, 0) is None:
		 	# append actual rows at iter
			result = store.remove(child)
			individual_pointer = store.get_value(iter, self.individual_pointer_posn)
			if relation_style == "ParentChild":					
				if not self.individual_dict.has_key(individual_pointer):
					print "ERROR: individual pointer does NOT exist in GEDCOM file!", individual_pointer
				else:
					individual_family_pointers = string.split(store.get_value(iter, self.individual_family_pointers_posn), ",")
					for f in individual_family_pointers:
						if self.family_dict.has_key(f):
							self.find_family(f, self.family_treeview)
							husband_pointer = self.temp_family_husband_pointer
							wife_pointer = self.temp_family_wife_pointer
							if individual_pointer == husband_pointer:
								store.set_value(iter, self.generic_type_posn, "HUSBAND")
								w = wife_pointer
								if w:
									self.find_individual(w, self.individual_treeview)
									piter = self.individual_treestore.append(iter, [self.temp_individual_raw_gedcom, "WIFE", w, self.temp_individual_given_names, self.temp_individual_last_name, self.temp_individual_sex, self.temp_individual_birth_date, self.temp_individual_birth_year, self.temp_individual_birth_month, self.temp_individual_birth_day, self.temp_individual_death_date, self.temp_individual_death_year, self.temp_individual_death_month, self.temp_individual_death_day, self.temp_individual_family_pointers, self.temp_individual_parent_pointers])
									family_children_pointers = string.split(self.temp_family_children_pointers, ",")
									for c in family_children_pointers:
										if self.individual_dict.has_key(c):
											self.find_individual(c, self.individual_treeview)
											citer = self.individual_treestore.append(piter, [self.temp_individual_raw_gedcom, "CHILD", c, self.temp_individual_given_names, self.temp_individual_last_name, self.temp_individual_sex, self.temp_individual_birth_date, self.temp_individual_birth_year, self.temp_individual_birth_month, self.temp_individual_birth_day, self.temp_individual_death_date, self.temp_individual_death_year, self.temp_individual_death_month, self.temp_individual_death_day, self.temp_individual_family_pointers, self.temp_individual_parent_pointers])
											if self.individual_family_pointers:
												self.individual_treestore.append(citer)
								else:
									print "ERROR: No wife pointer in GEDCOM family record!"

							if individual_pointer == wife_pointer:
								store.set_value(iter, self.generic_type_posn, "WIFE")
								h = husband_pointer
								if h:
									self.find_individual(h, self.individual_treeview)
									piter = self.individual_treestore.append(iter, [self.temp_individual_raw_gedcom, "HUSBAND", h, self.temp_individual_given_names, self.temp_individual_last_name, self.temp_individual_sex, self.temp_individual_birth_date, self.temp_individual_birth_year, self.temp_individual_birth_month, self.temp_individual_birth_day, self.temp_individual_death_date, self.temp_individual_death_year, self.temp_individual_death_month, self.temp_individual_death_day, self.temp_individual_family_pointers, self.temp_individual_parent_pointers])
									family_children_pointers = string.split(self.temp_family_children_pointers, ",")
									for c in family_children_pointers:
										if self.individual_dict.has_key(c):
											self.find_individual(c, self.individual_treeview)
											citer = self.individual_treestore.append(piter, [self.temp_individual_raw_gedcom, "CHILD", c, self.temp_individual_given_names, self.temp_individual_last_name, self.temp_individual_sex, self.temp_individual_birth_date, self.temp_individual_birth_year, self.temp_individual_birth_month, self.temp_individual_birth_day, self.temp_individual_death_date, self.temp_individual_death_year, self.temp_individual_death_month, self.temp_individual_death_day, self.temp_individual_family_pointers, self.temp_individual_parent_pointers])
											if self.individual_family_pointers:
												self.individual_treestore.append(citer)
								else:
									print "ERROR: No husband pointer in GEDCOM family record!"

			if relation_style == "ChildParent":
				if not self.individual_dict.has_key(individual_pointer):
					print "ERROR: individual pointer does NOT exist in GEDCOM file!", individual_pointer
				else:
					individual_parent_pointers = string.split(store.get_value(iter, self.individual_parent_pointers_posn), ",")[0]
					if self.family_dict.has_key(individual_parent_pointers):
						self.find_family(individual_parent_pointers, self.family_treeview)
						f = self.temp_family_husband_pointer
						m = self.temp_family_wife_pointer
						if f:
							self.find_individual(f, self.individual_treeview)
							piter = self.individual_treestore.append(iter, [self.temp_individual_raw_gedcom, "FATHER", f, self.temp_individual_given_names, self.temp_individual_last_name, self.temp_individual_sex, self.temp_individual_birth_date, self.temp_individual_birth_year, self.temp_individual_birth_month, self.temp_individual_birth_day, self.temp_individual_death_date, self.temp_individual_death_year, self.temp_individual_death_month, self.temp_individual_death_day, self.temp_individual_family_pointers, self.temp_individual_parent_pointers])
							if self.temp_individual_parent_pointers:
								self.individual_treestore.append(piter)
						if m:
							self.find_individual(m, self.individual_treeview)
							piter = self.individual_treestore.append(iter, [self.temp_individual_raw_gedcom, "MOTHER", m, self.temp_individual_given_names, self.temp_individual_last_name, self.temp_individual_sex, self.temp_individual_birth_date, self.temp_individual_birth_year, self.temp_individual_birth_month, self.temp_individual_birth_day, self.temp_individual_death_date, self.temp_individual_death_year, self.temp_individual_death_month, self.temp_individual_death_day, self.temp_individual_family_pointers, self.temp_individual_parent_pointers])
							if self.temp_individual_parent_pointers:
								self.individual_treestore.append(piter)

        def get_individual_info(self, individual_pointer):
		if not self.individual_dict.has_key(individual_pointer):
			print "ERROR: individual pointer does NOT exist in GEDCOM file!", individual_pointer
			return
                self.individual_given_names = self.individual_dict[individual_pointer][0][0]
                self.individual_last_name = self.individual_dict[individual_pointer][0][1]
                self.individual_sex = self.individual_dict[individual_pointer][1]
                self.individual_birth_date = self.individual_dict[individual_pointer][2][0]
                self.individual_birth_place = self.individual_dict[individual_pointer][2][1]
                self.individual_death_date = self.individual_dict[individual_pointer][3][0]
                self.individual_death_place = self.individual_dict[individual_pointer][3][1]
                #self.individual_family_pointers = self.individual_dict[individual_pointer][4]
                ifp = self.individual_dict[individual_pointer][4]
		self.individual_family_pointers = ""
		for x in ifp:
			self.individual_family_pointers = self.individual_family_pointers + x + ","
		if self.individual_family_pointers and self.individual_family_pointers[-1] == ",":
			self.individual_family_pointers = self.individual_family_pointers[:-1]
                self.individual_parent_pointers = self.individual_dict[individual_pointer][5]
		if self.individual_parent_pointers:
			self.get_family_info(self.individual_parent_pointers)
			if self.family_husband_pointer:
				self.individual_father_pointer = self.family_husband_pointer		
			if self.family_wife_pointer:
				self.individual_mother_pointer = self.family_wife_pointer		
		else:
			self.individual_father_pointer = None
			self.individual_mother_pointer = None
                self.individual_raw_gedcom = self.individual_dict[individual_pointer][6]

                self.individual_birth_year = ""
                self.individual_birth_month = ""
                self.individual_birth_day = ""
                individual_birth_date_parts = self.individual_birth_date.split(" ")
                if len(individual_birth_date_parts) == 1:
			if len(individual_birth_date_parts[0]) == 4:
				self.individual_birth_year = individual_birth_date_parts[0]
			if len(individual_birth_date_parts[0]) == 3:
				self.individual_birth_month = individual_birth_date_parts[0]
			if len(individual_birth_date_parts[0]) <= 2:
				self.individual_birth_day = individual_birth_date_parts[0]
                if len(individual_birth_date_parts) == 2: 
			if len(individual_birth_date_parts[0]) <= 2:
				self.individual_birth_day = individual_birth_date_parts[0]
			if len(individual_birth_date_parts[0]) == 3:
				self.individual_birth_month = individual_birth_date_parts[0]
			if len(individual_birth_date_parts[1]) == 3:
				self.individual_birth_month = individual_birth_date_parts[1]
			if len(individual_birth_date_parts[1]) == 4:
				self.individual_birth_year = individual_birth_date_parts[1]
                if len(individual_birth_date_parts) == 3: 
                        self.individual_birth_year = individual_birth_date_parts[2]
                        self.individual_birth_month = individual_birth_date_parts[1]
                        self.individual_birth_day = individual_birth_date_parts[0]

                self.individual_death_year = ""
                self.individual_death_month = ""
                self.individual_death_day = ""
                individual_death_date_parts = self.individual_death_date.split(" ")

                if len(individual_death_date_parts) == 1:
                        if len(individual_death_date_parts[0]) == 4:
                                self.individual_death_year = individual_death_date_parts[0]
                        if len(individual_death_date_parts[0]) == 3:
                                self.individual_death_month = individual_death_date_parts[0]
                        if len(individual_death_date_parts[0]) <= 2:
                                self.individual_death_day = individual_death_date_parts[0]
                if len(individual_death_date_parts) == 2:
                        if len(individual_death_date_parts[0]) <= 2:
                                self.individual_death_day = individual_death_date_parts[0]
                        if len(individual_death_date_parts[0]) == 3:
                                self.individual_death_month = individual_death_date_parts[0]
                        if len(individual_death_date_parts[1]) == 3:
                                self.individual_death_month = individual_death_date_parts[1]
                        if len(individual_death_date_parts[1]) == 4:
                                self.individual_death_year = individual_death_date_parts[1]
                if len(individual_death_date_parts) == 3:
                        self.individual_death_year = individual_death_date_parts[2]
                        self.individual_death_month = individual_death_date_parts[1]
                        self.individual_death_day = individual_death_date_parts[0]

                return  

        def get_family_info(self, family_pointer):
		self.family_husband_pointer = None
		self.family_wife_pointer = None
		if not self.family_dict.has_key(family_pointer):
			print "ERROR: family pointer does NOT exist in GEDCOM file!", family_pointer
			return
		self.family_husband_given_names = ""
		self.family_husband_last_name = ""
		self.family_husband_pointer = self.family_dict.get(family_pointer)[0]
		if self.individual_dict.has_key(self.family_husband_pointer):
			self.family_husband_given_names = self.individual_dict[self.family_husband_pointer][0][0]
			self.family_husband_last_name = self.individual_dict[self.family_husband_pointer][0][1]
		self.family_wife_given_names = ""
		self.family_wife_last_name = ""
		self.family_wife_pointer = self.family_dict.get(family_pointer)[1]
		if self.individual_dict.has_key(self.family_wife_pointer):
			self.family_wife_pointer = self.family_dict[family_pointer][1]
			self.family_wife_given_names = self.individual_dict[self.family_wife_pointer][0][0]
			self.family_wife_last_name = self.individual_dict[self.family_wife_pointer][0][1]
		self.family_marriage_date = self.family_dict[family_pointer][2][0]
		self.family_marriage_place = self.family_dict[family_pointer][2][1]
                fcp = self.family_dict[family_pointer][3]
		self.family_children_pointers = ""
		for x in fcp:
			self.family_children_pointers = self.family_children_pointers + x + ","
		if self.family_children_pointers and self.family_children_pointers[-1] == ",":
			self.family_children_pointers = self.family_children_pointers[:-1]
		self.family_raw_gedcom = self.family_dict[family_pointer][4]

		self.family_marriage_year = ""
		self.family_marriage_month = ""
		self.family_marriage_day = ""
		family_marriage_date_parts = self.family_marriage_date.split(" ")

                if len(family_marriage_date_parts) == 1:
                        if len(family_marriage_date_parts[0]) == 4:
                                self.family_marriage_year = family_marriage_date_parts[0]
                        if len(family_marriage_date_parts[0]) == 3:
                                self.family_marriage_month = family_marriage_date_parts[0]
                        if len(family_marriage_date_parts[0]) <= 2:
                                self.family_marriage_day = family_marriage_date_parts[0]
                if len(family_marriage_date_parts) == 2:
                        if len(family_marriage_date_parts[0]) <= 2:
                                self.family_marriage_day = family_marriage_date_parts[0]
                        if len(family_marriage_date_parts[0]) == 3:
                                self.family_marriage_month = family_marriage_date_parts[0]
                        if len(family_marriage_date_parts[1]) == 3:
                                self.family_marriage_month = family_marriage_date_parts[1]
                        if len(family_marriage_date_parts[1]) == 4:
                                self.family_marriage_year = family_marriage_date_parts[1]

                                #self.family_marriage_year = family_marriage_date_parts[1]
                                #self.family_marriage_month = family_marriage_date_parts[0]
                                #self.family_marriage_day = ""
                if len(family_marriage_date_parts) == 3:
                        self.family_marriage_year = family_marriage_date_parts[2]
                        self.family_marriage_month = family_marriage_date_parts[1]
                        self.family_marriage_day = family_marriage_date_parts[0]


		return

	def add_child(self, widget): 
		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Add New Child Individual")
		window.set_size_request(800, 480)

     		individual_treestore,  individual_iter = self.individual_treeview.get_selection().get_selected()

		individual_pointer = individual_treestore.get_value(individual_iter, self.individual_pointer_posn)

		prev_individual_iter = individual_treestore.iter_parent(individual_iter)
		if prev_individual_iter:
			type = individual_treestore.get_value(prev_individual_iter, self.individual_type_posn)
			prev_individual_pointer = individual_treestore.get_value(prev_individual_iter, self.individual_pointer_posn)
			if type not in ("HUSBAND", "WIFE", "NEWHUSBAND", "NEWWIFE"):
				print "ERROR: Not positioned on proper parent row for new child!"
       	 			self.on_show_note(self.window, "ERROR: Not positioned on proper parent row!\n" + individual_pointer, "OK")
				return
		else:
			print "ERROR: Not positioned on proper parent row for new child!"
       	 		self.on_show_note(self.window, "ERROR: Not positioned on proper parent row!\n" + individual_pointer, "OK")
			return

		# dare, now does family pointers get updated?
		fp = individual_treestore.get_value(individual_iter, self.individual_family_pointers_posn)
		if not fp:
			print "No family to attach child too!"
       	 		self.on_show_note(self.window, "ERROR: family pointer does NOT exist in GEDCOM file!\n" + fp, "OK")
			return

		individual_family_pointers = string.split(individual_treestore.get_value(individual_iter, self.individual_family_pointers_posn), ",")
		for family_pointer in individual_family_pointers:
			if self.family_dict.has_key(family_pointer):
				self.find_family(family_pointer, self.family_treeview)
				if (self.temp_family_husband_pointer == individual_pointer) and (self.temp_family_wife_pointer == prev_individual_pointer):
					print "correct family 1!", family_pointer
				elif (self.temp_family_wife_pointer == individual_pointer) and (self.temp_family_husband_pointer == prev_individual_pointer):
					print "correct family 2!", family_pointer
				else:
					self.on_show_note(self.window, "ERROR: family pointer does NOT exist in GEDCOM file!\n" + family_pointer, "OK")
					return

		individual_family_pointers = family_pointer

		if self.family_dict.has_key(individual_family_pointers):
			self.find_family(individual_family_pointers, self.family_treeview)
			raw_gedcom = self.family_treestore.get_value(self.generic_iter, self.generic_raw_gedcom_posn)
			new_raw_gedcom = raw_gedcom + "\n" + "1 CHIL " + self.next_individual_pointer 
			self.family_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, new_raw_gedcom)
			new_children_pointers = self.family_treestore.get_value(self.generic_iter, self.family_children_pointers_posn)
			new_children_pointers = new_children_pointers + "," + self.next_individual_pointer
			self.family_treestore.set_value(self.generic_iter, self.family_children_pointers_posn, new_children_pointers)
		else:
			print "No family to attach child too!"
       	 		self.on_show_note(self.window, "ERROR: family pointer does NOT exist in GEDCOM file!\n" + individual_pointer, "OK")
			return

		raw_gedcom_treestore = gtk.TreeStore(str, str, str, str)

		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["0", self.next_individual_pointer, "INDI", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NAME", "GivenNames /Lastname/"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "SEX", "M or F"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "BIRT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "DEAT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMC", individual_family_pointers])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMS", "@Fnnnn@"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NOTE", "@Nnnnn@"])

		# dare, beware that you are adding a child as a new person -- not one that might already have his own info/relationships

		new_child_iter = self.individual_treestore.insert_after(individual_iter, None, ["", "NEWCHILD", self.next_individual_pointer, "GivenNames", "LastName", "Sex", "BirthDate", "BirthYear", "BirthMonth", "BirthDay", "DeathDate", "DeathYear", "DeathMonth", "DeathDay", "", individual_family_pointers])

		new_individual_iter = self.individual_treestore.insert_after(None, None, ["", "NEWINDIVIDUAL", self.next_individual_pointer, "GivenNames", "LastName", "Sex", "BirthDate", "BirthYear", "BirthMonth", "BirthDay", "DeathDate", "DeathYear", "DeathMonth", "DeathDay", "", individual_family_pointers])
		
		self.save_raw_gedcom(raw_gedcom_treestore, self.individual_treestore, new_child_iter)

		raw_gedcom_treeview = self.raw_gedcom_edit(raw_gedcom_treestore, self.individual_treestore, new_child_iter, window)

		self.individual_treestore.set_value(new_child_iter, self.individual_parent_pointers_posn, individual_family_pointers)

		self.copy_individual(new_individual_iter, new_child_iter)

		self.individual_dict[self.next_individual_pointer] = ()

		self.get_next_individual_pointer()

		return

	def match_func(self, model, iter, data):
		column, key = data
		value = model.get_value(iter, column)
		return value == key

        def treerow_search_and_delete(self, model, iter, func, data):
		bad_iters = []
                while iter:
                        if func(model, iter, data):
                                if model == self.individual_treestore:
					bad_iters.append(iter)
                                        #result = model.remove(iter)
                        result = self.treerow_search_and_delete(model, model.iter_children(iter), func, data)
                        if result:
                                if model == self.individual_treestore:
					bad_iters.append(iter)
                                        #result = model.remove(iter)
                        iter = model.iter_next(iter)
		for iter in bad_iters:
                	result = model.remove(iter)

                return None

	def treerow_search_and_copy(self, model, iter, func, data):
		while iter:
			if func(model, iter, data):
				if model == self.individual_treestore:
					self.individual_treestore.set_value(iter, self.individual_raw_gedcom_posn, self.temp_individual_raw_gedcom)
					self.individual_treestore.set_value(iter, self.individual_given_names_posn, self.temp_individual_given_names)
					self.individual_treestore.set_value(iter, self.individual_last_name_posn, self.temp_individual_last_name)
					self.individual_treestore.set_value(iter, self.individual_sex_posn, self.temp_individual_sex)
					self.individual_treestore.set_value(iter, self.individual_birth_date_posn, self.temp_individual_birth_date)
					self.individual_treestore.set_value(iter, self.individual_birth_year_posn, self.temp_individual_birth_year)
					self.individual_treestore.set_value(iter, self.individual_birth_month_posn, self.temp_individual_birth_month)
					self.individual_treestore.set_value(iter, self.individual_birth_day_posn, self.temp_individual_birth_day)
					self.individual_treestore.set_value(iter, self.individual_death_date_posn, self.temp_individual_death_date)
					self.individual_treestore.set_value(iter, self.individual_death_year_posn, self.temp_individual_death_year)
					self.individual_treestore.set_value(iter, self.individual_death_month_posn, self.temp_individual_death_month)
					self.individual_treestore.set_value(iter, self.individual_death_day_posn, self.temp_individual_death_day)
					self.individual_treestore.set_value(iter, self.individual_family_pointers_posn, self.temp_individual_family_pointers)
					self.individual_treestore.set_value(iter, self.individual_parent_pointers_posn, self.temp_individual_parent_pointers)
			result = self.treerow_search_and_copy(model, model.iter_children(iter), func, data)
			if result: 
				if model == self.individual_treestore:
					self.individual_treestore.set_value(iter, self.individual_raw_gedcom_posn, self.temp_individual_raw_gedcom)
					self.individual_treestore.set_value(iter, self.individual_given_names_posn, self.temp_individual_given_names)
					self.individual_treestore.set_value(iter, self.individual_last_name_posn, self.temp_individual_last_name)
					self.individual_treestore.set_value(iter, self.individual_sex_posn, self.temp_individual_sex)
					self.individual_treestore.set_value(iter, self.individual_birth_date_posn, self.temp_individual_birth_date)
					self.individual_treestore.set_value(iter, self.individual_birth_year_posn, self.temp_individual_birth_year)
					self.individual_treestore.set_value(iter, self.individual_birth_month_posn, self.temp_individual_birth_month)
					self.individual_treestore.set_value(iter, self.individual_birth_day_posn, self.temp_individual_birth_day)
					self.individual_treestore.set_value(iter, self.individual_death_date_posn, self.temp_individual_death_date)
					self.individual_treestore.set_value(iter, self.individual_death_year_posn, self.temp_individual_death_year)
					self.individual_treestore.set_value(iter, self.individual_death_month_posn, self.temp_individual_death_month)
					self.individual_treestore.set_value(iter, self.individual_death_day_posn, self.temp_individual_death_day)
					self.individual_treestore.set_value(iter, self.individual_family_pointers_posn, self.temp_individual_family_pointers)
					self.individual_treestore.set_value(iter, self.individual_parent_pointers_posn, self.temp_individual_parent_pointers)
			iter = model.iter_next(iter)

		return None

	def add_note(self, widget): 
		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Add New Note")
		window.set_size_request(800, 480)

		raw_gedcom_treestore = gtk.TreeStore(str, str, str, str)

		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["0", self.next_note_pointer, "NOTE", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "CONC", "Comment line starts here..."])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "CONC", "and continues on next line with no breaks."])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "CONT", "Fresh comment line starts here..."])

		new_note_iter = self.note_treestore.prepend(None, ["", "NEWNOTE", self.next_note_pointer, "Comment line starts here...and continues on next line with no breaks.\nFresh comment line starts here..."])
		
		raw_gedcom_treeview = self.raw_gedcom_edit(raw_gedcom_treestore, self.note_treestore, new_note_iter, window)

		self.save_raw_gedcom(raw_gedcom_treestore, self.note_treestore, new_note_iter)

		self.note_dict[self.next_note_pointer] = ()

		self.get_next_note_pointer()

		return

	def add_individual(self, widget): 
		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Add New Individual")
		window.set_size_request(800, 480)

		raw_gedcom_treestore = gtk.TreeStore(str, str, str, str)

		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["0", self.next_individual_pointer, "INDI", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NAME", "GivenNames /Lastname/"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "SEX", "M or F"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "BIRT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "DEAT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMC", "@Fnnnn@"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMS", "@Fnnnn@"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NOTE", "@Nnnnn@"])

		new_individual_iter = self.individual_treestore.prepend(None, ["", "NEWINDIVIDUAL", self.next_individual_pointer, "GivenNames", "LastName", "Sex", "BirthDate", "BirthYear", "BirthMonth", "BirthDay", "DeathDate", "DeathYear", "DeathMonth", "DeathDay", "", ""])
		
		raw_gedcom_treeview = self.raw_gedcom_edit(raw_gedcom_treestore, self.individual_treestore, new_individual_iter, window)

		self.save_raw_gedcom(raw_gedcom_treestore, self.individual_treestore, new_individual_iter)

		self.individual_dict[self.next_individual_pointer] = ()

		self.get_next_individual_pointer()

		return

	def save_raw_gedcom(self, raw_gedcom_treestore, input_treestore, input_iter):
		new_values = ""
		for row in raw_gedcom_treestore:
			if row[1] == " ":
				new_values = new_values + row[0] + " " + row[2] + " " + row[3] + "\n"
			else:
				if row[0] != None:
					new_values = new_values + row[0] + " " + row[1] + " " + row[2] + " " + row[3] + "\n"
				else:
					print "not a valid row!"
		if new_values[-1] == '\n': 
			new_values = new_values[:-1]
		input_treestore.set_value(input_iter, self.generic_raw_gedcom_posn, new_values)

		return

	def add_father(self, widget):
		self.add_parent('Father')
		
		return

	def add_mother(self, widget):
		self.add_parent('Mother')
		
		return

	def add_parent(self, parent_type): 
		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Add New Parent Individual")
		window.set_size_request(800, 480)

     		individual_treestore,  individual_iter = self.individual_treeview.get_selection().get_selected()

		individual_pointer = individual_treestore.get_value(individual_iter, self.individual_pointer_posn)
		individual_parent_pointers = individual_treestore.get_value(individual_iter, self.individual_parent_pointers_posn)

		raw_gedcom_treestore = gtk.TreeStore(str, str, str, str)

		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["0", self.next_individual_pointer, "INDI", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NAME", "GivenNames /Lastname/"])
		if parent_type == "Father":
			raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "SEX", "M"])
		else:
			raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "SEX", "F"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "BIRT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "DEAT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMC", "@Fnnnn@"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMS", self.next_family_pointer])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NOTE", "@Nnnnn@"])

		raw_gedcom = self.individual_treestore.get_value(individual_iter, self.generic_raw_gedcom_posn)
		new_raw_gedcom = raw_gedcom + "\n" + "1 FAMS " + self.next_family_pointer 
		self.individual_treestore.set_value(individual_iter, self.individual_raw_gedcom_posn, new_raw_gedcom)

		families = self.individual_treestore.get_value(individual_iter, self.individual_family_pointers_posn)
		if families:
			new_families = families + "," + self.next_family_pointer
		else:
			new_families = self.next_family_pointer

		self.individual_treestore.set_value(individual_iter, self.individual_family_pointers_posn, new_families)

		new_parent_iter = self.individual_treestore.insert_before(None, None, ["", "NEWPARENT", self.next_individual_pointer, "GivenNames", "LastName", "Sex", "BirthDate", "BirthYear", "BirthMonth", "BirthDay", "DeathDate", "DeathYear", "DeathMonth", "DeathDay", self.next_family_pointer, ""])

		raw_gedcom_treeview = self.raw_gedcom_edit(raw_gedcom_treestore, self.individual_treestore, new_parent_iter, window)

		self.individual_dict[self.next_individual_pointer] = ()

		self.individual_dict[self.next_individual_pointer] = ()

		family_raw_gedcom = "0 " + self.next_family_pointer + " FAM"
		if parent_type == "Father":
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 HUSB " + self.next_individual_pointer
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 WIFE @Ixxxx@"
		else:
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 HUSB @Ixxxx@" 
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 WIFE " + self.next_individual_pointer
		family_raw_gedcom = family_raw_gedcom + "\n" + "1 MARR"
		family_raw_gedcom = family_raw_gedcom + "\n" + "2 DATE dd Mmm yyyy"
		family_raw_gedcom = family_raw_gedcom + "\n" + "2 PLAC dd Mmm yyyy"
		family_raw_gedcom = family_raw_gedcom + "\n" + "1 CHIL " + individual_pointer

		add_spouse_iter = self.family_treestore.prepend(None, [family_raw_gedcom, "NEWFAMILY", self.next_family_pointer, "", "HusbandGivenNames", "HusbandLastName", "", "WifeGivenNames", "WifeLastName", "MarriageDate", "MarriageYear", "MarriageMonth", "MarriageDay", ""])

		self.save_raw_gedcom(raw_gedcom_treestore, self.individual_treestore, new_parent_iter)

		self.family_dict[self.next_family_pointer] = ()

		self.get_next_individual_pointer()
		self.get_next_family_pointer()

		return

	def delete_individual(self, widget): 
		# have to remove spouse from family and child from family and remove from dict
     		individual_treestore,  individual_iter = self.individual_treeview.get_selection().get_selected()
		individual_pointer = individual_treestore.get_value(individual_iter, self.individual_pointer_posn)
		individual_family_pointers = individual_treestore.get_value(individual_iter, self.individual_family_pointers_posn)

		# if deleted individual is a husband/wife, remove HUSB/WIFE tag from each family raw gedcom and also set individual's name/pointer to empty in each family
		if individual_family_pointers:
			family_pointers = string.split(individual_family_pointers, ",")
			for family in family_pointers:
				if self.family_dict.has_key(family):
					self.find_family(family, self.family_treeview)
					self.delete_raw_gedcom_line(self.temp_family_raw_gedcom, ["HUSB", "WIFE"], individual_pointer)
					self.family_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
					if self.temp_family_husband_pointer == individual_pointer:
						self.family_treestore.set_value(self.generic_iter, self.family_husband_pointer_posn, "")
						self.family_treestore.set_value(self.generic_iter, self.family_husband_given_names_posn, "")
						self.family_treestore.set_value(self.generic_iter, self.family_husband_last_name_posn, "")
					else:
						self.family_treestore.set_value(self.generic_iter, self.family_wife_pointer_posn, "")
						self.family_treestore.set_value(self.generic_iter, self.family_wife_given_names_posn, "")
						self.family_treestore.set_value(self.generic_iter, self.family_wife_last_name_posn, "")
				else:
					print "No marriage family to clean up!"

		individual_parent_pointers = individual_treestore.get_value(individual_iter, self.individual_parent_pointers_posn)

		# if deleted individual is a child in a family, remove CHIL tag in family raw gedcom and also remove child pointer from family children pointer list
		if self.family_dict.has_key(individual_parent_pointers):
			self.find_family(individual_parent_pointers, self.family_treeview)
			self.delete_raw_gedcom_line(self.temp_family_raw_gedcom, "CHIL", individual_pointer)
			self.family_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
			self.delete_pointer_list(self.temp_family_children_pointers, individual_pointer)
			self.family_treestore.set_value(self.generic_iter, self.family_children_pointers_posn, self.new_pointer_list)
		else:
			print "No child family to clean up!"

		self.temp_individual_pointer = individual_pointer
		result = self.treerow_search_and_delete(self.individual_treestore, self.individual_treestore.iter_children(None), self.match_func, (self.individual_pointer_posn, self.temp_individual_pointer))

		del self.individual_dict[individual_pointer]

		return

	def delete_family(self, widget): 
     		family_treestore,  family_iter = self.family_treeview.get_selection().get_selected()

		family_pointer = family_treestore.get_value(family_iter, self.family_pointer_posn)
		family_husband_pointer = family_treestore.get_value(family_iter, self.family_husband_pointer_posn)
		family_wife_pointer = family_treestore.get_value(family_iter, self.family_wife_pointer_posn)
		family_children_pointers = family_treestore.get_value(family_iter, self.family_children_pointers_posn)

		# if family has husband, remove FAMS tag for husband from individual raw gedcom and also remove family pointer from husband family pointer list
		#if family_husband_pointer != "":
		if family_husband_pointer:
			self.find_individual(family_husband_pointer, self.individual_treeview)
			self.delete_raw_gedcom_line(self.temp_individual_raw_gedcom, "FAMS", family_pointer)
			self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
			self.delete_pointer_list(self.temp_individual_family_pointers, family_pointer)
			self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, self.new_pointer_list)

			#family_pointers = string.split(self.temp_individual_family_pointers, ",")
			#new_individual_family_pointers = ""
			#for family in family_pointers:
			#	if family == family_pointer:
			#		print "found family to delete!", family
			#	else:
			#		new_individual_family_pointers = new_individual_family_pointers + family + ","
			#if new_individual_family_pointers:
			#	if new_individual_family_pointers[-1] == ',': 
			#		new_individual_family_pointers = new_individual_family_pointers[:-1]
			#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, new_individual_family_pointers)

		# if family has wife, remove FAMS tag for wife from individual raw gedcom and also remove family pointer from wife family pointer list
		#if family_wife_pointer != "":
		if family_wife_pointer:
			self.find_individual(family_wife_pointer, self.individual_treeview)
			self.delete_raw_gedcom_line(self.temp_individual_raw_gedcom, "FAMS", family_pointer)
			self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
			self.delete_pointer_list(self.temp_individual_family_pointers, family_pointer)
			self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, self.new_pointer_list)

			#family_pointers = string.split(self.temp_individual_family_pointers, ",")
			#new_individual_family_pointers = ""
			#for family in family_pointers:
			#	if family == family_pointer:
			#		print "found family to delete!", family
			#	else:
			#		new_individual_family_pointers = new_individual_family_pointers + family + ","
			#if new_individual_family_pointers:
			#	if new_individual_family_pointers[-1] == ',': 
			#		new_individual_family_pointers = new_individual_family_pointers[:-1]
			#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, new_individual_family_pointers)

		# if family has children, remove FAMC tag for each child from individual raw gedcom and also remove family pointer from each child parent pointer list
		#if family_children_pointers != "":
		if family_children_pointers:
			child_pointers = string.split(family_children_pointers, ",")
			for child in child_pointers:
				self.find_individual(child, self.individual_treeview)
				self.delete_raw_gedcom_line(self.temp_individual_raw_gedcom, "FAMC", family_pointer)
				self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
				self.delete_pointer_list(self.temp_individual_parent_pointers, family_pointer)
				self.individual_treestore.set_value(self.generic_iter, self.individual_parent_pointers_posn, self.new_pointer_list)

				#parent_pointers = string.split(self.temp_individual_parent_pointers, ",")
				#new_individual_parent_pointers = ""
				#for family in parent_pointers:
				#	if family == family_pointer:
				#		print "found family to delete!", family
				#	else:
				#		new_individual_parent_pointers = new_individual_parent_pointers + family + ","
				#if new_individual_parent_pointers:
				#	if new_individual_parent_pointers[-1] == ',': 
				#		new_individual_parent_pointers = new_individual_parent_pointers[:-1]
				#self.individual_treestore.set_value(self.generic_iter, self.individual_parent_pointers_posn, new_individual_parent_pointers)

		result = family_treestore.remove(family_iter)

		del self.family_dict[family_pointer]

		return

	def delete_raw_gedcom_line(self, input_gedcom, check_tag, check_value):
		raw_gedcom = input_gedcom
		self.new_raw_gedcom = ""
		for raw_gedcom_line in raw_gedcom.split("\n"):
			line_element = raw_gedcom_line.split(" ", 2)
			level = line_element[0]
			if len(line_element) == 2:
				pointer =  " "
				tag = line_element[1]
				values = " "
			if len(line_element) == 3:
				if line_element[1][:1] == "@":
					pointer = line_element[1]
					tag = line_element[2]
					values = " "
				else:
					pointer = " "
					tag = line_element[1]
					values = line_element[2]
			if tag in check_tag and values == check_value:
				print "found family line!"
			else:
				if pointer == " ":
					self.new_raw_gedcom = self.new_raw_gedcom + level + " " + tag + " " + values + "\n"
				else:
					self.new_raw_gedcom = self.new_raw_gedcom + level + " " + pointer + " " + tag + " " + values + "\n"
		if self.new_raw_gedcom[-1] == '\n': 
			self.new_raw_gedcom = self.new_raw_gedcom[:-1]

		return
 
	def replace_raw_gedcom_line(self, input_gedcom, input_value, check_tag, check_value):
		raw_gedcom = input_gedcom
		self.new_raw_gedcom = ""
		for raw_gedcom_line in raw_gedcom.split("\n"):
			line_element = raw_gedcom_line.split(" ", 2)
			level = line_element[0]
			if len(line_element) == 2:
				pointer =  " "
				tag = line_element[1]
				values = " "
			if len(line_element) == 3:
				if line_element[1][:1] == "@":
					pointer = line_element[1]
					tag = line_element[2]
					values = " "
				else:
					pointer = " "
					tag = line_element[1]
					values = line_element[2]
			#print "tag, check_tag, values=", tag, check_tag, values
			#if tag in check_tag and values == check_value:
			if tag in check_tag: 
				if (values == check_value) or (check_value == None):
					print "found tag to be replaced!"
					values = input_value
			if pointer == " ":
				self.new_raw_gedcom = self.new_raw_gedcom + level + " " + tag + " " + values + "\n"
			else:
				self.new_raw_gedcom = self.new_raw_gedcom + level + " " + pointer + " " + tag + " " + values + "\n"
		if self.new_raw_gedcom[-1] == '\n': 
			self.new_raw_gedcom = self.new_raw_gedcom[:-1]

		return
 
	def add_family(self, widget): 
		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Add New Family")
		window.set_size_request(800, 480)

		raw_gedcom_treestore = gtk.TreeStore(str, str, str, str)

		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["0",self. next_family_pointer, "FAM", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "HUSB", "@Innnn@"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "WIFE", "@Innnn@"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "MARR", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NOTE", "@Nnnnn@"])

		family_treestore_iter = self.family_treestore.prepend(None, ["", "FAMILY", self.next_family_pointer, "", "HusbandGivenNames", "HusbandLastName", "", "WifeGivenNames", "WifeLastName", "MarriageDate", "MarriageYear", "MarriageMonth", "MarriageDay", ""])
		
		raw_gedcom_treeview = self.raw_gedcom_edit(raw_gedcom_treestore, self.family_treestore, family_treestore_iter, window)

		self.save_raw_gedcom(raw_gedcom_treestore, self.family_treestore, family_treestore_iter)

		self.family_dict[self.next_family_pointer] = ()

		self.get_next_family_pointer()

		return

	def add_spouse(self, widget): 
		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_nice_gedcom, window)

		window.set_title("Add New Spouse")
		window.set_size_request(800, 480)

     		individual_treestore,  individual_iter = self.individual_treeview.get_selection().get_selected()

		if not individual_iter:
       	 		self.on_show_note(self.window, "ERROR: Must select spouse to attach to!", "OK")
			return

		individual_pointer = individual_treestore.get_value(individual_iter, self.individual_pointer_posn)
		individual_given_names = individual_treestore.get_value(individual_iter, self.individual_given_names_posn)
		individual_last_name = individual_treestore.get_value(individual_iter, self.individual_last_name_posn)
		individual_sex = individual_treestore.get_value(individual_iter, self.individual_sex_posn)

		raw_gedcom_treestore = gtk.TreeStore(str, str, str, str)

		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["0", self.next_individual_pointer, "INDI", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NAME", "GivenNames /Lastname/"])
		if individual_sex == "M":
			raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "SEX", "F"])
		else:
			raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "SEX", "M"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "BIRT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "DEAT", ""])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "DATE", "dd Mmm yyyy"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["2", " ", "PLAC", "location"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMC", "@Fnnnn@"])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "FAMS", self.next_family_pointer])
		raw_gedcom_iter = raw_gedcom_treestore.append(None, ["1", " ", "NOTE", "@Nnnnn@"])

		raw_gedcom = self.individual_treestore.get_value(individual_iter, self.generic_raw_gedcom_posn)
		new_raw_gedcom = raw_gedcom + "\n" + "1 FAMS " + self.next_family_pointer 
		self.individual_treestore.set_value(individual_iter, self.individual_raw_gedcom_posn, new_raw_gedcom)

		families = self.individual_treestore.get_value(individual_iter, self.individual_family_pointers_posn)
		if families:
			new_families = families + "," + self.next_family_pointer
		else:
			new_families = self.next_family_pointer

		self.individual_treestore.set_value(individual_iter, self.individual_family_pointers_posn, new_families)

		new_individual_iter = self.individual_treestore.insert_after(None, None, ["", "NEWINDIVIDUAL", self.next_individual_pointer, "GivenNames", "LastName", "F", "BirthDate", "BirthYear", "BirthMonth", "BirthDay", "DeathDate", "DeathYear", "DeathMonth", "DeathDay", self.next_family_pointer, ""])

		self.save_raw_gedcom(raw_gedcom_treestore, self.individual_treestore, new_individual_iter)

		if individual_sex == "M":
			self.individual_treestore.set_value(individual_iter, self.individual_type_posn, "HUSBAND")
			new_spouse_iter = self.individual_treestore.insert_after(individual_iter, None, ["", "NEWWIFE", self.next_individual_pointer, "GivenNames", "LastName", "F", "BirthDate", "BirthYear", "BirthMonth", "BirthDay", "DeathDate", "DeathYear", "DeathMonth", "DeathDay", self.next_family_pointer, ""])
		else:
			self.individual_treestore.set_value(individual_iter, self.individual_type_posn, "WIFE")
			new_spouse_iter = self.individual_treestore.insert_after(individual_iter, None, ["", "NEWHUSBAND", self.next_individual_pointer, "GivenNames", "LastName", "M", "BirthDate", "BirthYear", "BirthMonth", "BirthDay", "DeathDate", "DeathYear", "DeathMonth", "DeathDay", self.next_family_pointer, ""])

		raw_gedcom_treeview = self.raw_gedcom_edit(raw_gedcom_treestore, self.individual_treestore, new_spouse_iter, window)

		self.individual_dict[self.next_individual_pointer] = ()

		family_raw_gedcom = "0 " + self.next_family_pointer + " FAM"
		if individual_sex == "M":
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 HUSB " + individual_pointer
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 WIFE " + self.next_individual_pointer
		else:
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 HUSB " + self.next_individual_pointer
			family_raw_gedcom = family_raw_gedcom + "\n" + "1 WIFE " + individual_pointer
		family_raw_gedcom = family_raw_gedcom + "\n" + "1 MARR"
		family_raw_gedcom = family_raw_gedcom + "\n" + "2 DATE dd Mmm yyyy"
		family_raw_gedcom = family_raw_gedcom + "\n" + "2 PLAC dd Mmm yyyy"

		new_family_iter = self.family_treestore.prepend(None, [family_raw_gedcom, "NEWFAMILY", self.next_family_pointer, "", "HusbandGivenNames", "HusbandLastName", "", "WifeGivenNames", "WifeLastName", "MarriageDate", "MarriageYear", "MarriageMonth", "MarriageDay", ""])

		# dare is this needed? YES!
		self.save_raw_gedcom(raw_gedcom_treestore, self.individual_treestore, new_spouse_iter)

		if individual_sex == "M":
			self.family_treestore.set_value(new_family_iter, self.family_husband_given_names_posn, individual_given_names)
			self.family_treestore.set_value(new_family_iter, self.family_husband_last_name_posn, individual_last_name)
			self.family_treestore.set_value(new_family_iter, self.family_husband_pointer_posn, individual_pointer) 
			self.family_treestore.set_value(new_family_iter, self.family_wife_pointer_posn, self.next_individual_pointer)
		else:
			self.family_treestore.set_value(new_family_iter, self.family_wife_given_names_posn, individual_given_names)
			self.family_treestore.set_value(new_family_iter, self.family_wife_last_name_posn, individual_last_name)
			self.family_treestore.set_value(new_family_iter, self.family_wife_pointer_posn, individual_pointer) 
			self.family_treestore.set_value(new_family_iter, self.family_husband_pointer_posn, self.next_individual_pointer)

		self.family_dict[self.next_family_pointer] = ()

		self.get_next_individual_pointer()
		self.get_next_family_pointer()

		return

	def copy_individual(self, output_iter, input_iter):

                temp_individual_pointer = self.individual_treestore.get_value(input_iter, self.individual_pointer_posn)
                temp_individual_raw_gedcom = self.individual_treestore.get_value(input_iter, self.individual_raw_gedcom_posn)
                temp_individual_given_names = self.individual_treestore.get_value(input_iter, self.individual_given_names_posn)
                temp_individual_last_name = self.individual_treestore.get_value(input_iter, self.individual_last_name_posn)
                temp_individual_sex = self.individual_treestore.get_value(input_iter, self.individual_sex_posn)
                temp_individual_birth_date = self.individual_treestore.get_value(input_iter, self.individual_birth_date_posn)
                temp_individual_birth_year = self.individual_treestore.get_value(input_iter, self.individual_birth_year_posn)
                temp_individual_birth_month = self.individual_treestore.get_value(input_iter, self.individual_birth_month_posn)
                temp_individual_birth_day = self.individual_treestore.get_value(input_iter, self.individual_birth_day_posn)
                temp_individual_death_date = self.individual_treestore.get_value(input_iter, self.individual_death_date_posn)
                temp_individual_death_year = self.individual_treestore.get_value(input_iter, self.individual_death_year_posn)
                temp_individual_death_month = self.individual_treestore.get_value(input_iter, self.individual_death_month_posn)
                temp_individual_death_day = self.individual_treestore.get_value(input_iter, self.individual_death_day_posn)
                temp_individual_family_pointers = self.individual_treestore.get_value(input_iter, self.individual_family_pointers_posn)
                temp_individual_parent_pointers = self.individual_treestore.get_value(input_iter, self.individual_parent_pointers_posn)

                self.individual_treestore.set_value(output_iter, self.individual_raw_gedcom_posn, temp_individual_raw_gedcom)
                self.individual_treestore.set_value(output_iter, self.individual_given_names_posn, temp_individual_given_names)
                self.individual_treestore.set_value(output_iter, self.individual_last_name_posn, temp_individual_last_name)
                self.individual_treestore.set_value(output_iter, self.individual_sex_posn, temp_individual_sex)
                self.individual_treestore.set_value(output_iter, self.individual_birth_date_posn, temp_individual_birth_date)
                self.individual_treestore.set_value(output_iter, self.individual_birth_year_posn, temp_individual_birth_year)
                self.individual_treestore.set_value(output_iter, self.individual_birth_month_posn, temp_individual_birth_month)
                self.individual_treestore.set_value(output_iter, self.individual_birth_day_posn, temp_individual_birth_day)
                self.individual_treestore.set_value(output_iter, self.individual_death_date_posn, temp_individual_death_date)
                self.individual_treestore.set_value(output_iter, self.individual_death_year_posn, temp_individual_death_year)
                self.individual_treestore.set_value(output_iter, self.individual_death_month_posn, temp_individual_death_month)
                self.individual_treestore.set_value(output_iter, self.individual_death_day_posn, temp_individual_death_day)
                self.individual_treestore.set_value(output_iter, self.individual_family_pointers_posn, temp_individual_family_pointers)
                self.individual_treestore.set_value(output_iter, self.individual_parent_pointers_posn, temp_individual_parent_pointers)

		return

	def generic_on_selection_changed(self, selection): 
		global raw_gedcom_treeview

		# Create a new window
                if hildon_flag == 1:
                        window = hildon.Window()
                else:
			window = gtk.Window()

                window.connect("window-state-event", on_window_state_change, window)
                window.connect("key-press-event", self.on_key_press_raw_gedcom, window)

		window.set_title("New Raw Gedcom")
		window.set_size_request(800, 480)

		raw_gedcom_treestore = gtk.TreeStore(str, str, str, str)

		input_treestore, input_iter = selection.get_selected()

		if input_iter:
			raw_gedcom = input_treestore.get_value(input_iter, self.generic_raw_gedcom_posn)
			for raw_gedcom_line in raw_gedcom.split("\n"):
				line_element = raw_gedcom_line.split(" ", 2)
				level = line_element[0]
				if len(line_element) == 2:
					pointer =  " "
					tag = line_element[1]
					values = " "
				if len(line_element) == 3:
					if line_element[1][:1] == "@":
						pointer = line_element[1]
						tag = line_element[2]
						values = " "
					else:
						pointer = " "
						tag = line_element[1]
						values = line_element[2]
				raw_gedcom_iter = raw_gedcom_treestore.append(None, [level, pointer, tag, values])
				#raw_gedcom_iter = raw_gedcom_treestore.append(None, [level, pointer, tag, values, None])
				#if int(level) > int(prev_level):
				#	raw_gedcom_iter = raw_gedcom_treestore.append(prev_raw_gedcom_piter, [level, pointer, tag, values, None])
				#else:
				#	if int(level) == 0:
				#		new_raw_gedcom_piter = None
				#	if int(level) == 1:
				#		new_raw_gedcom_piter = level_0_raw_gedcom_piter
				#	if int(level) == 2:
				#		new_raw_gedcom_piter = level_1_raw_gedcom_piter
				#	if int(level) == 3:
				#		new_raw_gedcom_piter = level_2_raw_gedcom_piter
				#	raw_gedcom_iter = raw_gedcom_treestore.append(new_raw_gedcom_piter, [level, pointer, tag, values, None])
				#if int(level) == 0:
				#	level_0_raw_gedcom_piter = raw_gedcom_iter
				#if int(level) == 1:
				#	level_1_raw_gedcom_piter = raw_gedcom_iter
				#if int(level) == 2:
				#	level_2_raw_gedcom_piter = raw_gedcom_iter
				#if int(level) == 3:
				#	level_3_raw_gedcom_piter = raw_gedcom_iter
				#prev_level = level
				#prev_raw_gedcom_piter = raw_gedcom_iter

		treeview = self.raw_gedcom_edit(raw_gedcom_treestore, input_treestore, input_iter, window)

		return

	def raw_gedcom_edit(self, raw_gedcom_treestore, input_treestore, input_iter, window):
		global raw_gedcom_treeview

		if hildon_flag == True:
			menu_element = 'popup'
		else:
			menu_element = 'menubar'

		ui2 = '''<ui>
		<%(menu_element)s name="MenuBar">
		<menu action="Edit">
		<menuitem action="Insert Raw Gedcom Row Before"/>
		<menuitem action="Insert Raw Gedcom Row After"/>
		<menuitem action="Delete Raw Gedcom Row"/>
		</menu>
		</%(menu_element)s>
		</ui>''' % { 'menu_element': menu_element }

		# create the TreeView using treestore
		raw_gedcom_treeview = gtk.TreeView(raw_gedcom_treestore)
		raw_gedcom_treeview.set_headers_visible(True)		# needed for Maemo
		raw_gedcom_treeview.expand_all()

		# create a CellRendererText to render the data
		level_cell = gtk.CellRendererText()
		level_cell.set_property('editable', True)
		self.set_cell_style(level_cell)
		level_cell.connect('edited', self.raw_gedcom_level_edited_cb, raw_gedcom_treestore, input_treestore, input_iter)
		pointer_cell = gtk.CellRendererText()
		pointer_cell.set_property('editable', True)
		self.set_cell_style(pointer_cell)
		pointer_cell.connect('edited', self.raw_gedcom_pointer_edited_cb, raw_gedcom_treestore, input_treestore, input_iter)
		tag_cell = gtk.CellRendererText()
		tag_cell.set_property('editable', True)
		self.set_cell_style(tag_cell)
		tag_cell.connect('edited', self.raw_gedcom_tag_edited_cb, raw_gedcom_treestore, input_treestore, input_iter)
		values_cell = gtk.CellRendererText()
		values_cell.set_property('editable', True)
		self.set_cell_style(values_cell)
		values_cell.connect('edited', self.raw_gedcom_values_edited_cb, raw_gedcom_treestore, input_treestore, input_iter)
		raw_gedcom_treeview.connect('cursor-changed', self.raw_gedcom_cursor_changed_cb)

		# create the TreeViewColumn to display the data
		level_column = gtk.TreeViewColumn('Level', level_cell, text=0)
		self.set_column_style(level_column)
		pointer_column = gtk.TreeViewColumn('Pointer', pointer_cell, text=1)
		self.set_column_style(pointer_column)
		tag_column = gtk.TreeViewColumn('Tag', tag_cell, text=2)
		self.set_column_style(tag_column)
		values_column = gtk.TreeViewColumn('Values', values_cell, text=3)
		self.set_column_style(values_column)

		# add level_column to treeview
		raw_gedcom_treeview.append_column(level_column)
		raw_gedcom_treeview.append_column(pointer_column)
		raw_gedcom_treeview.append_column(tag_column)
		raw_gedcom_treeview.append_column(values_column)

		# add the cell to the level_column and allow it to expand
		#level_column.pack_start(level_cell, True)
		#pointer_column.pack_start(pointer_cell, True)
		#tag_column.pack_start(tag_cell, True)
		#values_column.pack_start(values_cell, True)

		# set the cell "text" attribute to column 0 - retrieve text
		# from that column in treestore
		column = 0
		self.raw_gedcom_level_posn = column
		level_column.add_attribute(level_cell, 'text', 0)
		column = column + 1
		self.raw_gedcom_pointer_posn = column
		pointer_column.add_attribute(pointer_cell, 'text', 1)
		column = column + 1
		self.raw_gedcom_tag_posn = column
		tag_column.add_attribute(tag_cell, 'text', 2)
		column = column + 1
		self.raw_gedcom_values_posn = column
		#values_column.add_attribute(values_cell, 'text', 3)

		# make ui layout
		vbox = gtk.VBox()

		# Create a UIManager instance
		uimanager2 = gtk.UIManager()

		# Add the accelerator group to the toplevel window
		accelgroup2 = uimanager2.get_accel_group()
		window.add_accel_group(accelgroup2)

		# Create an ActionGroup
		actiongroup2 = gtk.ActionGroup('UIManagerExample')
		self.actiongroup2 = actiongroup2

		# Create actions
		actiongroup2.add_actions([('Edit', None, '_Edit')])

		# hey, the first letters of the commands are shortcuts, but are they correct and work?
		actiongroup2.add_actions([('Insert Raw Gedcom Row Before', None, '_Insert Raw Gedcom Row Before', None, None, self.raw_gedcom_row_insert_before),
					('Insert Raw Gedcom Row After', None, '_Insert Raw Gedcom Row After', None, None, self.raw_gedcom_row_insert_after),
					('Delete Raw Gedcom Row', None, '_Delete Raw Gedcom Row', None, None, self.raw_gedcom_row_delete)], 
					[raw_gedcom_treeview, input_treestore, input_iter])

		# Add the actiongroup to the uimanager
		uimanager2.insert_action_group(actiongroup2, 0)

		# Add a UI description
		#uimanager2.add_ui_from_string(self.ui2)
		uimanager2.add_ui_from_string(ui2)

		# Create a MenuBar
		menubar2 = uimanager2.get_widget('/MenuBar')
		if hildon_flag == True:
            		window.set_menu(menubar2)
		else:
			vbox.pack_start(menubar2, False)

		# add scrolled window
		scrolledwindow = gtk.ScrolledWindow()
		bbox = gtk.HButtonBox()
		vbox.pack_start(scrolledwindow)
		vbox.pack_start(bbox, False)

		scrolledwindow.add(raw_gedcom_treeview)

                if window_in_fullscreen == True:
                        window.fullscreen()

		window.add(vbox)
		window.show_all()

		return

	def raw_gedcom_row_insert_before(self, widget, params): 
		raw_gedcom_treeview = params[0]
		input_treestore = params[1]
		input_iter = params[2]
     		raw_gedcom_treestore,  raw_gedcom_iter = raw_gedcom_treeview.get_selection().get_selected()
		new_raw_gedcom_iter = raw_gedcom_treestore.insert_before(None, raw_gedcom_iter, [" "," "," "," "])
		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		path = raw_gedcom_treestore.get_path(new_raw_gedcom_iter)
		raw_gedcom_treeview.set_cursor(path)

		return

	def raw_gedcom_row_insert_after(self, widget, params): 
		raw_gedcom_treeview = params[0]
		input_treestore = params[1]
		input_iter = params[2]
     		raw_gedcom_treestore,  raw_gedcom_iter = raw_gedcom_treeview.get_selection().get_selected()
		new_raw_gedcom_iter = raw_gedcom_treestore.insert_after(None, raw_gedcom_iter, [" "," "," "," "])
		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		path = raw_gedcom_treestore.get_path(new_raw_gedcom_iter)
		raw_gedcom_treeview.set_cursor(path)

		return

	def raw_gedcom_row_delete(self, widget, params): 
		raw_gedcom_treeview = params[0]
		input_treestore = params[1]
		input_iter = params[2]
     		raw_gedcom_treestore,  raw_gedcom_iter = raw_gedcom_treeview.get_selection().get_selected()
		level = raw_gedcom_treestore.get_value(raw_gedcom_iter, self.raw_gedcom_level_posn)
		pointer = raw_gedcom_treestore.get_value(raw_gedcom_iter, self.raw_gedcom_pointer_posn)
		tag = raw_gedcom_treestore.get_value(raw_gedcom_iter, self.raw_gedcom_tag_posn)
		values = raw_gedcom_treestore.get_value(raw_gedcom_iter, self.raw_gedcom_values_posn)

		result = raw_gedcom_treestore.remove(raw_gedcom_iter)
		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		return

  	def raw_gedcom_cursor_changed_cb(self, raw_gedcom_treeview):
     		path, column = raw_gedcom_treeview.get_cursor()
     		if not column: 
			return
     		colname = column.get_title()
     		raw_gedcom_treestore, raw_gedcom_iter = raw_gedcom_treeview.get_selection().get_selected()
		tag = raw_gedcom_treestore.get_value(raw_gedcom_iter, self.raw_gedcom_tag_posn)
		value = raw_gedcom_treestore.get_value(raw_gedcom_iter, self.raw_gedcom_values_posn)
		if colname in ("Values") and value[:1] == "@":
			if tag in ("INDI", "HUSB", "WIFE", "CHIL"):
				individual_pointer = value
				if self.individual_dict.has_key(individual_pointer):
					self.set_cursor(individual_pointer, self.individual_treeview)
			if tag[:3] == "FAM":
				family_pointer = value
				if self.family_dict.has_key(family_pointer):
					self.set_cursor(family_pointer, self.family_treeview)
			if tag == "NOTE":
				note_pointer = value
				if self.note_dict.has_key(note_pointer):
					self.set_cursor(note_pointer, self.note_treeview)
			if tag == "SUBM":
				submitter_pointer = value
				if self.submitter_dict.has_key(submitter_pointer):
					self.set_cursor(submitter_pointer, self.submitter_treeview)
			if tag == "SOUR":
				source_pointer = value
				if self.source_dict.has_key(source_pointer):
					self.set_cursor(source_pointer, self.source_treeview)
			if tag == "REPO":
				respository_pointer = value
				if self.repository_dict.has_key(repository_pointer):
					self.set_cursor(repository_pointer, self.repository_treeview)
			if tag == "OBJE":
				object_pointer = value
				if self.object_dict.has_key(object_pointer):
					self.set_cursor(object_pointer, self.object_treeview)
			if tag == "SUBN":
				submission_pointer = value
				if self.submission_dict.has_key(submission_pointer):
					self.set_cursor(submission_pointer, self.submission_treeview)

	def raw_gedcom_level_edited_cb(self, cell, path, new_text, raw_gedcom_treestore, input_treestore, input_iter):
		raw_gedcom_treestore[path][self.raw_gedcom_level_posn] = new_text
		level = raw_gedcom_treestore[path][self.raw_gedcom_level_posn]
		pointer = raw_gedcom_treestore[path][self.raw_gedcom_pointer_posn]

		try:
    			stripped = str(int(level))
		except:
       	 		self.on_show_note(self.window, "ERROR: level value must be numeric integer", "OK")
			return

		if int(level) != 0 and pointer != " ":
			self.on_show_note(self.window, "ERROR: Pointer value only valid for level 0!\n" + pointer, "OK")
			return

		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		return

	def raw_gedcom_pointer_edited_cb(self, cell, path, new_text, raw_gedcom_treestore, input_treestore, input_iter):
		raw_gedcom_treestore[path][self.raw_gedcom_pointer_posn] = string.upper(new_text)
		pointer = raw_gedcom_treestore[path][self.raw_gedcom_pointer_posn]
		level = raw_gedcom_treestore[path][self.raw_gedcom_level_posn]

		if int(level) != 0:	
			self.on_show_note(self.window, "ERROR: Pointer value only valid for level 0!\n" + pointer, "OK")
			return

		if input_treestore == self.individual_treestore:	
			if not self.individual_dict.has_key(pointer) and pointer != "":
				print "ERROR: individual pointer does NOT exist in GEDCOM file!", pointer
				self.on_show_note(self.window, "ERROR: individual pointer does NOT exist in GEDCOM file!\n" + pointer, "OK")
				return

		if input_treestore == self.family_treestore:	
			if not self.family_dict.has_key(pointer) and pointer != "":
				print "ERROR: family pointer does NOT exist in GEDCOM file!", pointer
				self.on_show_note(self.window, "ERROR: family pointer does NOT exist in GEDCOM file!\n" + pointer, "OK")
				return

		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		return

	def raw_gedcom_tag_edited_cb(self, cell, path, new_text, raw_gedcom_treestore, input_treestore, input_iter):
		raw_gedcom_treestore[path][self.raw_gedcom_tag_posn] = string.upper(new_text)
		tag = raw_gedcom_treestore[path][self.raw_gedcom_tag_posn]
	
		if not self.valid_tags.has_key(tag):
       	 		self.on_show_note(self.window, "ERROR: TAG value is not valid", "OK")
			return
	
		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		return

	def raw_gedcom_values_edited_cb(self, cell, path, new_text, raw_gedcom_treestore, input_treestore, input_iter):
		"""
		Called when a text cell is edited.  It puts the new text
		in the model so that it is displayed properly.
		"""
		tag = raw_gedcom_treestore[path][self.raw_gedcom_tag_posn]
		old_values = raw_gedcom_treestore[path][self.raw_gedcom_values_posn]
		raw_gedcom_treestore[path][self.raw_gedcom_values_posn] = new_text

		if input_treestore == self.individual_treestore:
			print "raw edit on indi treestore"
			individual_pointer = input_treestore.get_value(input_iter, self.individual_pointer_posn)
		if input_treestore == self.family_treestore:
			print "raw edit on family treestore"
			family_pointer = input_treestore.get_value(input_iter, self.family_pointer_posn)
			
		if tag == "NAME":
		    	name = string.split(new_text, '/')
			if len(name) < 2:
       	 			self.on_show_note(self.window, "ERROR: NAME tag requires /lastname/", "OK")
				return
			else:
				first = string.strip(name[0])
				last = string.strip(name[1])
				input_treestore.set_value(input_iter, self.individual_given_names_posn, first)
				input_treestore.set_value(input_iter, self.individual_last_name_posn, last)

				individual_pointer = input_treestore.get_value(input_iter, self.individual_pointer_posn)
				individual_sex = input_treestore.get_value(input_iter, self.individual_sex_posn)
				individual_family_pointers = string.split(input_treestore.get_value(input_iter, self.individual_family_pointers_posn), ",")
				# dare, now does family pointers get updated?
				for family_pointer in individual_family_pointers:
					if self.family_dict.has_key(family_pointer):
						#self.find_individual(family_pointer, self.family_treeview)
						self.find_family(family_pointer, self.family_treeview)
						if individual_sex == "M":
							self.family_treestore.set_value(self.generic_iter, self.family_husband_given_names_posn, first)
							self.family_treestore.set_value(self.generic_iter, self.family_husband_last_name_posn, last)
						else:
							self.family_treestore.set_value(self.generic_iter, self.family_wife_given_names_posn, first)
							self.family_treestore.set_value(self.generic_iter, self.family_wife_last_name_posn, last)

		if tag == "SEX":
			sex = string.upper(new_text[:1])
			if sex not in ('M', 'F'):
       	 			self.on_show_note(self.window, "ERROR: SEX tag must be either 'M' or 'F'", "OK")
				return
			else:
				input_treestore.set_value(input_iter, self.individual_sex_posn, sex)
				raw_gedcom_treestore[path][3] = sex
		if tag == "DATE":
			date_parts = new_text.split(" ")
			year = ""
			month = ""
			day = ""
			if len(date_parts) == 1:
				if len(date_parts[0]) == 4:
					year = date_parts[0]
				if len(date_parts[0]) == 3:
					month = date_parts[0]
				if len(date_parts[0]) <= 2:
					day = date_parts[0]
			if len(date_parts) == 2:
				if len(date_parts[0]) <= 2:
					day = date_parts[0]
				if len(date_parts[0]) == 3:
					month = date_parts[0]
				if len(date_parts[1]) == 3:
					month = date_parts[1]
				if len(date_parts[1]) == 4:
					year = date_parts[1]
			if len(date_parts) == 3:
				year = date_parts[2]
				month = date_parts[1]
				day = date_parts[0]

			old_level =  raw_gedcom_treestore[int(path)][0]
			for line in range(int(path), 0, -1):
				new_level =  raw_gedcom_treestore[line][0]
				new_tag =  raw_gedcom_treestore[line][2]
				if old_level != new_level:	
					if new_tag == "BIRT":
						input_treestore.set_value(input_iter, self.individual_birth_year_posn, year)
						input_treestore.set_value(input_iter, self.individual_birth_month_posn, month)
						input_treestore.set_value(input_iter, self.individual_birth_day_posn, day)
					if new_tag == "DEAT":
						input_treestore.set_value(input_iter, self.individual_death_year_posn, year)
						input_treestore.set_value(input_iter, self.individual_death_month_posn, month)
						input_treestore.set_value(input_iter, self.individual_death_day_posn, day)
					if new_tag == "MARR":
						input_treestore.set_value(input_iter, self.family_marriage_year_posn, year)
						input_treestore.set_value(input_iter, self.family_marriage_month_posn, month)
						input_treestore.set_value(input_iter, self.family_marriage_day_posn, day)
					break
		#if tag in ("INDI", "HUSB", "WIFE", "CHIL"):
		if tag == "HUSB":
			pointer = new_text
			if not self.individual_dict.has_key(pointer) and pointer != "":
				print "ERROR: individual pointer does NOT exist in GEDCOM file!", pointer
       	 			self.on_show_note(self.window, "ERROR: individual pointer does NOT exist in GEDCOM file!\n" + pointer, "OK")
				return
			else:
				input_treestore.set_value(input_iter, self.family_husband_pointer_posn, new_text)
				self.find_individual(new_text, self.individual_treeview)
				input_treestore.set_value(input_iter, self.family_husband_given_names_posn, self.temp_individual_given_names)
				input_treestore.set_value(input_iter, self.family_husband_last_name_posn, self.temp_individual_last_name)

				#dare, do you REPLACE existing indi family info, or APPEND new stuff to it? and what about the original spouse?
				self.find_individual(old_values, self.individual_treeview)
				self.delete_pointer_list(self.temp_individual_family_pointers, family_pointer)
				#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, "")
				self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, self.new_pointer_list)
				self.delete_raw_gedcom_line(self.temp_individual_raw_gedcom, "FAMS", family_pointer)
				self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)

				self.find_individual(new_text, self.individual_treeview)
				self.append_pointer_list(self.temp_individual_family_pointers, family_pointer)
				#new_husband_family_pointers = self.temp_individual_family_pointers + "," + family_pointer
				#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, family_pointer)
				#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, new_husband_family_pointers)
				self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, self.new_pointer_list)
				#self.replace_raw_gedcom_line(self.temp_individual_raw_gedcom, family_pointer, "FAMS", None)
				new_husband_raw_gedcom = self.temp_individual_raw_gedcom + "\n" + "1 FAMS " + family_pointer
				#self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
				self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, new_husband_raw_gedcom)
		if tag == "WIFE":
			pointer = new_text
			if not self.individual_dict.has_key(pointer) and pointer != "":
				print "ERROR: individual pointer does NOT exist in GEDCOM file!", pointer
       	 			self.on_show_note(self.window, "ERROR: individual pointer does NOT exist in GEDCOM file!\n" + pointer, "OK")
				return
			else:
				# set family wife pointer, wife given names, and wife last name
				input_treestore.set_value(input_iter, self.family_wife_pointer_posn, new_text)
				self.find_individual(new_text, self.individual_treeview)
				input_treestore.set_value(input_iter, self.family_wife_pointer_posn, new_text)
				input_treestore.set_value(input_iter, self.family_wife_given_names_posn, self.temp_individual_given_names)
				input_treestore.set_value(input_iter, self.family_wife_last_name_posn, self.temp_individual_last_name)

				#dare, do you REPLACE existing indi family info, or APPEND new stuff to it?
				# set remove family pointer from original wife individual family pointer list and also remove FAMS entry from raw gedcom
				self.find_individual(old_values, self.individual_treeview)
				self.delete_pointer_list(self.temp_individual_family_pointers, family_pointer)
				#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, "")
				self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, self.new_pointer_list)
				self.delete_raw_gedcom_line(self.temp_individual_raw_gedcom, "FAMS", family_pointer)
				self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)

				# append current family to family pointer of new wife individual and also append FAMS entry to raw gedcom
				self.find_individual(new_text, self.individual_treeview)
				self.append_pointer_list(self.temp_individual_family_pointers, family_pointer)
				#new_wife_family_pointers = self.temp_individual_family_pointers + "," + family_pointer
				#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, family_pointer)
				#self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, new_wife_family_pointers)
				self.individual_treestore.set_value(self.generic_iter, self.individual_family_pointers_posn, self.new_pointer_list)
				#self.replace_raw_gedcom_line(self.temp_individual_raw_gedcom, family_pointer, "FAMS", None)
				new_wife_raw_gedcom = self.temp_individual_raw_gedcom + "\n" + "1 FAMS " + family_pointer
				#self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
				self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, new_wife_raw_gedcom)
		if tag == "CHIL":
			pointer = new_text
			if not self.individual_dict.has_key(pointer) and pointer != "":
				print "ERROR: individual pointer does NOT exist in GEDCOM file!", pointer
       	 			self.on_show_note(self.window, "ERROR: individual pointer does NOT exist in GEDCOM file!\n" + pointer, "OK")
				return
			else:
				new_children_pointers = input_treestore.get_value(input_iter, self.family_children_pointers_posn)
				new_children_pointers = new_children_pointers + "," + new_text
				input_treestore.set_value(input_iter, self.family_children_pointers_posn, new_children_pointers)
				self.find_individual(new_text, self.individual_treeview)
				self.individual_treestore.set_value(self.generic_iter, self.individual_parent_pointers_posn, family_pointer)
				self.replace_raw_gedcom_line(self.temp_individual_raw_gedcom, family_pointer, "FAMC", None)
				self.individual_treestore.set_value(self.generic_iter, self.generic_raw_gedcom_posn, self.new_raw_gedcom)
		if tag[:3] == "FAM":
			pointer = new_text
			if not self.family_dict.has_key(pointer) and pointer != "":
				print "ERROR: family pointer does NOT exist in GEDCOM file!", pointer
       	 			self.on_show_note(self.window, "ERROR: family pointer does NOT exist in GEDCOM file!\n" + pointer, "OK")
				return
		if tag == "NOTE":
			pointer = new_text
			if not self.note_dict.has_key(pointer) and pointer != "":
				print "ERROR: note pointer does NOT exist in GEDCOM file!", pointer
       	 			self.on_show_note(self.window, "ERROR: note pointer does NOT exist in GEDCOM file!\n" + pointer, "OK")
				return
		if tag in ["CONC", "CONT"]:
			notes = " "
			for raw_gedcom_line in raw_gedcom_treestore:
				level = raw_gedcom_line[0]
				pointer = raw_gedcom_line[1]
				tag = raw_gedcom_line[2]
				values = raw_gedcom_line[3]
				if int(level) == 1 and tag == "CONC":
					notes = notes + values
				if int(level) == 1 and tag == "CONT":
					notes = notes + "\n" + values
			self.note_treestore.set_value(input_iter, self.note_text_posn, notes)

		self.save_raw_gedcom(raw_gedcom_treestore, input_treestore, input_iter)

		if input_treestore == self.individual_treestore:
			self.temp_individual_pointer = input_treestore.get_value(input_iter, self.individual_pointer_posn)
			self.temp_individual_raw_gedcom = input_treestore.get_value(input_iter, self.individual_raw_gedcom_posn)
			self.temp_individual_given_names = input_treestore.get_value(input_iter, self.individual_given_names_posn)
			self.temp_individual_last_name = input_treestore.get_value(input_iter, self.individual_last_name_posn)
			self.temp_individual_sex = input_treestore.get_value(input_iter, self.individual_sex_posn)
			self.temp_individual_birth_date = input_treestore.get_value(input_iter, self.individual_birth_date_posn)
			self.temp_individual_birth_year = input_treestore.get_value(input_iter, self.individual_birth_year_posn)
			self.temp_individual_birth_month = input_treestore.get_value(input_iter, self.individual_birth_month_posn)
			self.temp_individual_birth_day = input_treestore.get_value(input_iter, self.individual_birth_day_posn)
			self.temp_individual_death_date = input_treestore.get_value(input_iter, self.individual_death_date_posn)
			self.temp_individual_death_year = input_treestore.get_value(input_iter, self.individual_death_year_posn)
			self.temp_individual_death_month = input_treestore.get_value(input_iter, self.individual_death_month_posn)
			self.temp_individual_death_day = input_treestore.get_value(input_iter, self.individual_death_day_posn)
			self.temp_individual_family_pointers = input_treestore.get_value(input_iter, self.individual_family_pointers_posn)
			self.temp_individual_parent_pointers = input_treestore.get_value(input_iter, self.individual_parent_pointers_posn)

			match_iter = self.treerow_search_and_copy(self.individual_treestore, self.individual_treestore.iter_children(None), self.match_func, (self.individual_pointer_posn, self.temp_individual_pointer))

		return 

	def replace_pointer_list(self, pointer_list, input_pointer):
		self.new_pointer_list = ""
		pointers = string.split(pointer_list, ",")
		for p in pointers:
			if p == input_pointer:
				pointer = input_pointer
			self.new_pointer_list = self.new_pointer_list + p + ","
		if self.new_pointer_list and self.new_pointer_list[-1] == ',': 
			self.new_pointer_list = self.new_pointer_list[:-1]

		return

	def append_pointer_list(self, pointer_list, input_pointer):
		if pointer_list:
			self.new_pointer_list = pointer_list + "," + input_pointer
		else:
			self.new_pointer_list = input_pointer

		return

	def delete_pointer_list(self, pointer_list, input_pointer):
		self.new_pointer_list = ""
		pointers = string.split(pointer_list, ",")
		for p in pointers:
			if p == input_pointer:
				print "found pointer to remove!", p
			else:
				self.new_pointer_list = self.new_pointer_list + p + ","
		if self.new_pointer_list and self.new_pointer_list[-1] == ',': 
			self.new_pointer_list = self.new_pointer_list[:-1]

		return

	def gedcom_family(self, id):
	    family = ''
	    for e in g.element_list():
		if e.individual():
		    if e.pointer() == id:
			for f in e.families():
			    family += f.get_family() + '\n'
	    return family

	def gedcom_individual(self, id):
		for e in g.element_list():
			if e.individual():
				if e.pointer() == id:
					individual = e.get_individual()
					t = e.get_individual()
		return individual

	def show_about(self, *args):
		dialog = gtk.AboutDialog()
		dialog.set_name('MGedcom')
		dialog.set_logo_icon_name('system')
		dialog.set_comments('Simple PyGTK GEDCOM Navigator')
		dialog.set_copyright('(C) 2009 Darren Enns')
		dialog.set_authors(AUTHORS)
		dialog.set_version(VERSION)
		dialog.set_website('http://darethehair.googlepages.com')
		dialog.connect('response', lambda d, r: d.destroy())
		dialog.show()

	def on_show_note(self, window, message, choice):
		if hildon_flag == True:
			dialog = hildon.Note ("confirmation", (window, message, gtk.STOCK_DIALOG_INFO) )
			dialog.set_button_text(choice)
			dialog.run()
			dialog.destroy()
		else:
			dialog = gtk.MessageDialog(
			parent         = None,
			flags          = gtk.DIALOG_DESTROY_WITH_PARENT,
			type           = gtk.MESSAGE_INFO,
			buttons        = gtk.BUTTONS_OK,
			message_format = message)
			dialog.set_title("GEDCOM Statistics")
			dialog.connect('response', lambda dialog, response: dialog.destroy())
			dialog.show()

		return

	def on_key_press_raw_gedcom(self, widget, event, window, *args):
		global font_size
		global window_in_fullscreen
		global raw_gedcom_treeview

		if event.keyval == gtk.keysyms.F6:
			# The "Full screen" hardware key has been pressed
			if window_in_fullscreen:
				#print "going unfullscreen..."
				window_in_fullscreen = False
				window.unfullscreen ()
			else:
				#print "going fullscreen..."
				window.fullscreen ()
				window_in_fullscreen = True
			#print "Fullscreen mode now set to:", window_in_fullscreen

		if event.keyval == gtk.keysyms.F7:
			# The "Zoom In" hardware key has been pressed
			font_size = font_size + 1
			self.set_font_size_raw_gedcom()

		if event.keyval == gtk.keysyms.F8:
			# The "Zoom Out" hardware key has been pressed
			font_size = font_size - 1
			self.set_font_size_raw_gedcom()

		if event.keyval == gtk.keysyms.Escape:
			window.destroy()

	def on_key_press_nice_gedcom(self, widget, event, window, *args):
		global font_size
		global window_in_fullscreen

		if event.keyval == gtk.keysyms.F6:
			# The "Full screen" hardware key has been pressed
			if window_in_fullscreen:
				#print "going unfullscreen..."
				window_in_fullscreen = False
				window.unfullscreen ()
			else:
				#print "going fullscreen..."
				window.fullscreen ()
				window_in_fullscreen = True
			#print "Fullscreen mode now set to:", window_in_fullscreen

		if event.keyval == gtk.keysyms.F7:
			# The "Zoom In" hardware key has been pressed
			font_size = font_size + 1
			self.set_font_size_nice_gedcom()

		if event.keyval == gtk.keysyms.F8:
			# The "Zoom Out" hardware key has been pressed
			font_size = font_size - 1
			self.set_font_size_nice_gedcom()

		if event.keyval == gtk.keysyms.Escape:
			window.destroy()

def on_window_state_change(widget, event, window, *args):
        global window_in_fullscreen
        if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
                window_in_fullscreen = True

        else:
                window_in_fullscreen = False

        return

def on_key_press_basic(widget, event, window, *args):
	global font_size
        global window_in_fullscreen

        if event.keyval == gtk.keysyms.F6:
                # The "Full screen" hardware key has been pressed
                if window_in_fullscreen:
                        #print "going unfullscreen..."
                        window_in_fullscreen = False
                        window.unfullscreen ()
                else:
                        #print "going fullscreen..."
                        window.fullscreen ()
                        window_in_fullscreen = True
                #print "Fullscreen mode now set to:", window_in_fullscreen

        if event.keyval == gtk.keysyms.F7:
                # The "Zoom In" hardware key has been pressed
                font_size = font_size - 1
		self.refresh_view(widget)

        if event.keyval == gtk.keysyms.F8:
                # The "Zoom Out" hardware key has been pressed
                font_size = font_size + 1
		self.refresh_view()

        #if event.keyval == gtk.keysyms.Escape:
                # The "Escape" hardware key has been pressed
                #print "Escape key pressed..."

        #if event.keyval == gtk.keysyms.Return:
                # The "Return" hardware key has been pressed
                #print "Return key pressed..."

        if event.keyval == gtk.keysyms.Escape:
                window.destroy()

        return

class main_window:
        def __init__(self):
                if hildon_flag == 1:
                        self.main_window = hildon.Window()
                else:
                        self.main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)

                self.main_window.connect("destroy", gtk.main_quit)
                self.main_window.connect("window-state-event", on_window_state_change, self.main_window)
                #self.main_window.connect("key-press-event", on_key_press_basic, self.main_window)

                self.window_in_fullscreen = False

                self.main_window.set_title('MGedcom ' + VERSION)
                self.main_window.set_size_request(800,480)

                path = os.path.dirname(os.path.abspath(sys.argv[0]))
                image_file = os.path.join(path, "mgedcom.jpg")
                image = gtk.Image()
                image.set_from_file(image_file)
                image.show()

                button = gtk.Button()
                self.main_window.add(button)
                button.connect("clicked", starter, self.main_window, button)
                button.set_image(image)
                button.show()

		if not os.path.exists("~/.mgedcom"):
			os.system('mkdir -p ~/.mgedcom')
		
                self.main_window.show()

                if hildon_flag == True:
               		self.main_window.fullscreen()

                self.main_window.show_all()

	def main(self):
    		gtk.main()
		return

if __name__ == "__main__":
        main = main_window()
        main.main()

