from Widget import Widget
from Pixmap import Pixmap, TEMPORARY_PIXMAP, text_extents

from theme import theme


def _find_first_of(text, chars, pos):

    min_idx = len(text)
    for c in chars:
        idx = text.find(c, pos)
        if (idx != -1):
            min_idx = min(min_idx, idx)
    #end for
    
    return min_idx


class TextDisplay(Widget):

    def __init__(self):
    
        self.__line_height = 0
        self.__font = None
        
        self.__text_lines = []
        self.__total_height = 0
        
        self.__invalidated_range = (0, 0)
        
        # display position in fractions of a text line
        self.__position = 0.0
    
        self.__scrollbar_pbuf = None
        self.__scrollbar_pmap = None
        
    
        Widget.__init__(self)
        self.set_font(theme.font_mb_plain)
        
        
    def set_size(self, w, h):
    
        Widget.set_size(self, w, h)
        self.set_font(self.__font)
        self.set_scrollbar(self.__scrollbar_pbuf)
        self.__format_text()
        

    def set_scrollbar(self, pbuf):
        """
        Sets a pixbuf to use for displaying a scrollbar.
        Pass 'None' in order to remove the scrollbar again.
        
        The scrollbar is not interactive.
        
        @param pbuf: the pixbuf for the scrollbar
        """
    
        self.__scrollbar_pbuf = pbuf
        if (not pbuf):
            self.__scrollbar_pmap = None
        else:
            nil, h = self.get_size()
            w = pbuf.get_width()
            w = max(2, w)
            h = max(2, h)
            self.__scrollbar_pmap = Pixmap(None, w, h)            
            self.__scrollbar_pmap.draw_pixbuf(pbuf, 0, 0, w, h, scale = True)

        
    def set_font(self, font):
    
        w, h = text_extents("Yy", font)
        self.__line_height = h
        self.__font = font
        
        w, h = self.get_size()
        self.__total_height = self.__line_height * len(self.__text_lines)

        
        
    def render_this(self):
    
        x, y = self.get_screen_pos()
        w, h = self.get_size()
        screen = self.get_screen()
        
        TEMPORARY_PIXMAP.copy_buffer(screen, x, y, 0, 0, w, h)
        #TEMPORARY_PIXMAP.fill_area(0, 0, w, h, "#000000")
        
        self._render_text(TEMPORARY_PIXMAP)
        if (self.__scrollbar_pmap):
            self._render_scrollbar(TEMPORARY_PIXMAP)
            
        screen.copy_buffer(TEMPORARY_PIXMAP, 0, 0, x, y, w, h)
              
        
    def load_text(self, text):
    
        self.__text = text
        self.__format_text()
      
        
    def __format_text(self):
        """
        Formats the text for displaying on screen.
        """
    
        w, h = self.get_size()
        if (w == 0): return
        
        self.__text_lines = []
        current_line = ""
        x = 0
        pos = 0
        text = self.__text
        while (True):
            idx = _find_first_of(text, " -\n", pos)
            if (idx == len(text)):
                self.__text_lines.append(current_line)
                break

            part = text[pos:idx + 1]

            tw, th = text_extents(part, self.__font)
            if (x + tw > w):
                self.__text_lines.append(current_line)
                print w, x, tw, text_extents(current_line, self.__font), current_line
                current_line = part
                x = tw
            else:
                current_line += part
                x += tw
                
            if (part[-1] == "\n"):
                self.__text_lines.append(current_line)
                current_line = ""
                x = 0
                
            #print part, x, pos
            pos += len(part)
        #end while
        
        self.__total_height = self.__line_height * len(self.__text_lines)
        
        
        
    def move(self, dx, dy):

        x, y = self.get_screen_pos()    
        w, h = self.get_size()
        screen = self.get_screen()

        # copy and move        
        TEMPORARY_PIXMAP.copy_buffer(screen, x, y, 0, 0 - dy, w, h)

        if (dy > 0):
            pixels_bottom = self.__position_to_pixels(self.__position) + h
            new_first = int(self.__pixels_to_position(pixels_bottom))
            new_last = int(self.__pixels_to_position(pixels_bottom + dy))
        else:
            pixels_top = self.__position_to_pixels(self.__position)
            new_first = int(self.__pixels_to_position(pixels_top + dy))
            new_last = int(self.__pixels_to_position(pixels_top))

        pixels = self.__position_to_pixels(self.__position)
        pixels += dy
        pixels = max(0, min(self.__total_height - h, pixels))
        self.__position = self.__pixels_to_position(pixels)
        offset = pixels

        # render new lines
        for lineno in range(new_first, new_last + 1):
            if (lineno >= len(self.__text_lines)): break
            text = self.__text_lines[lineno]
            text_y = self.__position_to_pixels(lineno) - offset
            TEMPORARY_PIXMAP.fill_area(0, text_y, w, self.__line_height, "#000000")
            TEMPORARY_PIXMAP.draw_text(text, self.__font, 0, text_y,
                                       "#ffffff")
        #end for
        
        screen.copy_buffer(TEMPORARY_PIXMAP, 0, 0, x, y, w, h)

        """
        pixels = self.__position_to_pixels(self.__position)
        pixels += dy
        pixels = max(0, min(self.__total_height - h, pixels))
        
            
        new_lines = self.__text_lines[new_first:new_last + 1]
        print new_lines
            
        self.__position = self.__pixels_to_position(pixels)
        
        self.render()
        """


    def __position_to_pixels(self, pos):
    
        pixels = int(self.__line_height * pos)
        return pixels
        
        
    def __pixels_to_position(self, pixels):
    
        pos = pixels / float(self.__line_height)
        return pos



    def _render_text(self, screen):
    
        x, y = 0, 0
        w, h = self.get_size()
               
        lineno = int(self.__position)
        offset = int((self.__position - lineno) * self.__line_height)
        
        y = y - offset
        a, b = self.__invalidated_range
        while (y < h + self.__line_height and lineno < len(self.__text_lines)):
            if (a <= lineno <= b):
                text = self.__text_lines[lineno]
                screen.fill_area(x, y, w, self.__line_height, "#000000")
                screen.draw_text(text, self.__font, x, y, "#ffffff")
            #end if
            y += self.__line_height
            lineno += 1
        #end while


    def _render_scrollbar(self, screen):
        """
        Renders the scrollbar onto the buffer.
        """

        x, y = 0, 0
        w, h = self.get_size()
        offset = self.__position_to_pixels(self.__position)
        total = self.__total_height

        if (self.__total_height > 0):
            percent = offset / float(total)
            slider_size = (h / float(total)) * h
        else:
            percent = 0
            slider_size = h


        y1 = int(h * percent)
        y2 = int(y1 + slider_size)

        slider_width, nil = self.__scrollbar_pmap.get_size()
        slider_width /= 2

        screen.copy_pixmap(self.__scrollbar_pmap,
                           0, 0,
                           x + w - slider_width, y,
                           slider_width, h)
        screen.copy_pixmap(self.__scrollbar_pmap,
                           slider_width, 0, x + w - slider_width, y + y1,
                           slider_width, y2 - y1 + 1)
