#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import datetime
import uuid
import sqlite3
import urllib
import commands
import gobject
gobject.threads_init()

import threading
import string
import time
import socket
import pango

from mutils import * 
from msyncerror import *
from mevent import *

import gdata
import gdata.calendar.service
import gdata.service
import atom.service
import gdata.calendar

try:
        import pygtk
        pygtk.require("2.0")
except:
        pass
try:
        import gtk
        import gtk.glade
except:
        sys.exit(1)

try:
  import hildon
  HILDON_SUPPORT = True
except:
  HILDON_SUPPORT = False

class _IdleObject(gobject.GObject):
    """
    Override gobject.GObject to always emit signals in the main thread
    by emmitting on an idle handler
    """
    def __init__(self):
        gobject.GObject.__init__(self)

    def emit(self, *args):
        print "emit"
        gobject.idle_add(gobject.GObject.emit,self,*args)

class _Thread(threading.Thread, _IdleObject):
    """
    Cancellable thread which uses gobject signals to return information
    to the GUI.
    """
    __gsignals__ =  { 
            "completed": (
                gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, []),               
            "error": (
                gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [
                gobject.TYPE_STRING]),
            "progress": (
                gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [
                gobject.TYPE_FLOAT])
            }

    def __init__(self, *args):
        threading.Thread.__init__(self)
        _IdleObject.__init__(self)
        self.cancelled = False
        self.data = args[0]
        self.name = args[1]
        self.setName("%s" % self.name)

    def cancel(self):
        """
        Threads in python are not cancellable, so we implement our own
        cancellation logic
        """
        self.cancelled = True

    def importEvent(self,local_event,google_event,cal_id):
      debug('importEvent cal_id:'+str(cal_id))
      for a_when in google_event.when:
        local_event.start_datetime = dateFromGoogle(a_when.start_time,format=4)
        local_event.end_datetime = dateFromGoogle(a_when.end_time,format=5)

        if GOOGLE_REMINDER==False:
          for reminder in a_when.reminder:
            local_event.alarm=True
            local_event.alarm_value = reminder.minutes

      local_event.description = google_event.title.text
      local_event.googleid = google_event.id.text
#      local_event.googleid = google_event.id.text.split('/').pop()
      local_event.cal_id = urllib.unquote(cal_id)
      local_event.lastup = dateFromGoogle(google_event.updated.text)
      local_event.lastup = local_event.lastup + datetime.timedelta(seconds = 1)
      if google_event.recurrence == None:
        debug('recurrence=None')
        local_event.repeat = False
      else:
          debug('recurrence=True')     
          debug(google_event.recurrence.text)             
          local_event.repeat=True
          rstring = google_event.recurrence.text
          rstring = rstring.split('\n')
          if len(rstring[2]) != 0 :
            for line in rstring:
                if 'DTSTART' in line:
                  value = line.split(':')[1]
                  if 'T' in value:
                    local_event.start_datetime = dateFromGoogle(value,1)
                  else:
                    local_event.start_datetime = dateFromGoogle(value,2)
                    local_event.start_datetime = e.start_datetime.replace(hour=0,minute=0)
                elif 'DTEND' in line:
                  value = line.split(':')[1]
                  if 'T' in value:
                    local_event.end_datetime = dateFromGoogle(value,1)
                  else:
                    local_event.end_datetime = dateFromGoogle(value,2)
                    local_event.end_datetime = local_event.end_datetime.replace(hour=23,minute=59)
                    diff = datetime.timedelta(days=1)
                    local_event.end_datetime = local_event.end_datetime - diff
                if "RRULE" in line:
                  debug('line 320:'+line)
                  line = line.replace('RRULE:','')
                  lines = line.split(';')
                  local_event.repeat_number = 1
                  local_event.repeat_until = datetime.datetime(9999,9,9)
                  for value in lines:
                    if "FREQ=" in value:
                      value = value.replace('FREQ=','')
                      local_event.setFrequencyFromGoogle(value)
                    elif "UNTIL=" in value:
                      value = value.replace('UNTIL=','')
                      if 'T' in value:
                        local_event.repeat_until = dateFromGoogle(value,1)
                      else:
                        local_event.repeat_until = dateFromGoogle(value,2)
                    if "INTERVAL=" in value:
                      value = value.replace('INTERVAL=','')
                      local_event.repeat_number = int(value)
                    if "BYDAY=" in value:
                      value = value.replace('BYDAY=','')
                      local_event.repeat_byday = value
      local_event.saveToDB(self)
      return local_event

    def doLogin(self):

      cal_client = gdata.calendar.service.CalendarService()
      self.dbcur.execute('SELECT id,content FROM prefs')       
      for prefs in self.dbcur.fetchall():
        if prefs[0]=='email':
          cal_client.email = prefs[1]
        if prefs[0]=='password':
          cal_client.password = prefs[1]
        if prefs[0]=='last_update':
          self.last_update = datetime.datetime.strptime(prefs[1],DB_FORMAT)
      self.future_update = datetime.datetime.now()  
      cal_client.source = 'mCalendar ' + VERSION
      cal_client.ProgrammaticLogin()  
      return cal_client

    def run(self):
        debug ("Running %s" % str(self))

        #errors = mSyncError()

        self.last_update = datetime.date(1970,01,01)
        try:
          if HILDON_SUPPORT:
            db_path='/home/user/.mPIM/mcalendar.db'
          else:
            db_path='mcalendar.db'
          self.db = sqlite3.connect(db_path)
          self.dbcur = self.db.cursor()
          self.db2 = sqlite3.connect(db_path)
          self.dbcur2 = self.db2.cursor()

#          try:

          cal_client = self.doLogin()
          self.emit("progress", 10)

          #Delete Google Event
          debug('Delete google event deleted locally')
          self.dbcur.execute('SELECT googleid,uuid,description FROM events WHERE description="DELETED"')       
          for an_event in self.dbcur.fetchall():
              anid = an_event[0]

              try:
                deleted_event = cal_client.GetCalendarEventEntry(anid)   
                if deleted_event.GetEditLink()!=None:
                  cal_client.DeleteEvent(deleted_event.GetEditLink().href)
                self.dbcur2.execute('DELETE FROM events WHERE uuid=?',[an_event[1]])       
                self.db2.commit()
              except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
                import traceback
                trace = str(traceback.print_exc())
                #errors.append(str(error),trace,an_event[2])
                self.emit("error", str(error) + "\n" + trace+ "\n" + an_event[2])
                cal_client = self.doLogin()

          self.emit("progress", 20)
#          except:
#            errors.append(e)

          #send local update
          self.dbcur.execute('SELECT uuid,lastup FROM events,cal WHERE ((events.cal_id=cal.id AND (cal.access_level=="owner" OR cal.access_level=="contributor")) OR cal_id="default" OR cal_id="") AND googleid!="" AND lastup>"'+self.last_update.strftime(DB_FORMAT)+'"')       
          for an_event in self.dbcur.fetchall():
            e = Event(an_event[0],self)
            debug('uuid to update on google : %s' % (an_event[0]))

            try:
              event = cal_client.GetCalendarEventEntry(e.googleid)
              event.title = atom.Title(text=e.description)
              if len(event.author)==0:
                event.author.append(atom.Author(name=atom.Name(text='mCalendar')))

              if e.repeat==True:
                recurrence_data = ('DTSTART;TZID=Etc/GMT:'+dateToGoogle(e.start_datetime,1)+'\r\n'     
                     + 'DTEND;TZID=Etc/GMT:'+dateToGoogle(e.end_datetime,1)+'\r\n'
                     + 'RRULE:FREQ='+e.googleFrequency()+';INTERVAL='+str(e.repeat_number))

                if (dateToGoogle(e.repeat_until,2)!='99990909'):
                  recurrence_data  = recurrence_data +';UNTIL='+dateToGoogle(e.repeat_until,2)

                if (e.repeat_byday != "") and (e.repeat_byday != None):
                  recurrence_data  = recurrence_data + ";BYDAY=" +e.repeat_byday
                recurrence_data  = recurrence_data +'\r\n' 
                debug(recurrence_data)
                event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
              if len(event.when)==0:
                event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))
              else:
                event.when[0] = gdata.calendar.When(start_time=dateToGoogle(e.start_datetime) , end_time=dateToGoogle(e.end_datetime) )

              event.updated.text = dateToGoogle(e.lastup)
              debug(2)
              debug(event.GetEditLink())
              debug(event.title.text)
              edit_link = event.GetEditLink()
              if edit_link != None:
                event = cal_client.UpdateEvent(edit_link.href, event)
              e.googleid = event.id.text
              e.saveToDB(self)
            except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
              import traceback
              trace = str(traceback.print_exc())
              #errors.append(str(error),trace,e.description)
              self.emit("error", str(error) + "\n" + trace+ "\n" +e.description)
              cal_client = self.doLogin()

          self.emit("progress", 40)

          #Create Update Event

          #Get all calendar
          try:
            feed = cal_client.GetCalendarListFeed()
            self.dbcur.execute('DELETE FROM cal ;')
            self.db.commit()
            for cal in feed.entry:
              theid = cal.id.text.split('/').pop() 
              theid = urllib.unquote(theid)
              self.dbcur.execute('INSERT INTO cal (id , access_level, color, last_update) VALUES(?,?,?,?);',[theid,cal.access_level.text,cal.color.value,cal.updated.text])
              self.db.commit()

          except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
            import traceback
            trace = str(traceback.print_exc())
#            errors.append(str(error),trace,'Retrieving calendar list')
            self.emit("error", str(error) + "\n" + trace+ "\n" +'Retrieving calendar list')            
            cal_client = self.doLogin()

          #DEBUG
#          self.dbcur.execute('SELECT id,access_level FROM cal')       
#          for cal in self.dbcur.fetchall():
#            print cal[0]

          self.dbcur.execute('SELECT id,access_level FROM cal')       
          for cal in self.dbcur.fetchall():
            start_index = 1
            end_reached = False
            while(end_reached == False):
              debug('Get All Google Events on : ')
#                  try:
#                    an_event.id.text = string.replace(an_event.id.text,'composite','full')
#                    self.dbcur.execute('SELECT uuid,lastup FROM events WHERE googleid LIKE "%'+an_event.id.text.split("/").pop()+'"')       
              try:
                query = gdata.calendar.service.CalendarEventQuery(cal[0], 'private', 'composite', None, {"ctz":"utc"})
                query.updated_min = dateToGoogle(self.last_update)
                query.max_results = 1
                query.start_index = str(start_index)
                debug(dateToGoogle(self.last_update))
                debug('cal_client.CalendarEventQuery(query) ...')
                feed = cal_client.CalendarQuery(query)
                #e.description = "2 event skipped :" + str(start_index) + " :" + str(start_index+1)
                self.emit("progress", 60)
                if len(feed.entry)<1:
                  end_reached = True
                  debug('End reached')

                for i, an_event in enumerate(feed.entry):
                  try:

                    an_event.id.text = string.replace(an_event.id.text,'composite','full')
                    self.dbcur.execute('SELECT uuid,lastup FROM events WHERE googleid LIKE "%'+an_event.id.text.split("/").pop()+'"')  

                    uuid = ''
                    debug(5)
                    for event in self.dbcur.fetchall():
                      uuid = event[0]
                      updated = event[1]

                    debug('status:')
                    debug(an_event.event_status.value)
                    if an_event.event_status.value=='CANCELED':
                      debug('Delete local event deleted on google : %s' % (an_event.id.text))
                      self.dbcur.execute('DELETE FROM events WHERE googleid="'+an_event.id.text+'"')       
                      self.db.commit()
                    else:
                      e = Event(uuid,self)
                      if uuid == '':
                        e = self.importEvent(e,an_event,cal[0]) 
                        #new event
                      else:
                        #check update
                        google_update = dateFromGoogle(an_event.updated.text)
                        google_update =  google_update + datetime.timedelta(seconds = 1)
                        debug('dates : ...')
                        debug(google_update)
                        debug(e.lastup)
                        if google_update==e.lastup:
                          debug('Events match %s' % (uuid))
                          e.googleid = an_event.id.text
                          e.saveToDB()

                        elif google_update<e.lastup:
                          #self.emit("error", 'WARNING')  
                          debug('Need to update google %s' % (uuid))
                          debug('Google utc update  date : %s' %(str(an_event.updated.text)))
                          debug('Google timezone update  date : %s' %(str(google_update)))
                          debug('Local update date : %s' %(str(e.lastup)))
                        else:
                          e = self.importEvent(e,an_event,cal[0]) 

                  except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
                    import traceback
                    trace = str(traceback.print_exc())
#                    errors.append(str(error),trace,error.description)
                    self.emit("error", str(error) + "\n" + trace+ "\n" +e.description)

                    cal_client = self.doLogin()
                start_index = start_index + 1
              except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
                import traceback
                start_index = start_index + 1
                trace = str(traceback.print_exc())
#                errors.append(str(error),trace,'')
                self.emit("error", str(error) + "\n" + trace)
                cal_client = self.doLogin()

          #send new
          debug('send new event')
          self.emit("progress", 80)
          self.dbcur.execute('SELECT uuid FROM events WHERE googleid=""')       
          for an_event in self.dbcur.fetchall():
            try:
              e = Event(an_event[0],self)
              debug('new uuid to send : %s' % (an_event[0]))
              event = gdata.calendar.CalendarEventEntry()
              event.author.append(atom.Author(name=atom.Name(text='mCalendar')))
              event.title = atom.Title(text=e.description)
              if e.repeat==True:
                recurrence_data = ('DTSTART;TZID=Etc/GMT:'+dateToGoogle(e.start_datetime,1)+'\r\n'     
                     + 'DTEND;TZID=Etc/GMT:'+dateToGoogle(e.end_datetime,1)+'\r\n'
                     + 'RRULE:FREQ='+e.googleFrequency()+';INTERVAL='+str(e.repeat_number))

                if (dateToGoogle(e.repeat_until,2)!='99990909'):
                  recurrence_data  = recurrence_data +    ';UNTIL='+dateToGoogle(e.repeat_until,2)

                if (e.repeat_byday != "") and (e.repeat_byday != None):
                  recurrence_data  = recurrence_data + ";BYDAY=" +e.repeat_byday
                recurrence_data = recurrence_data + '\r\n'
                debug(recurrence_data)
                event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
                event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))              
              else:
                event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))
              new_event = cal_client.InsertEvent(event,'/calendar/feeds/default/private/full')
              e.googleid = new_event.id.text
              e.cal_id = urllib.unquote(new_event.id.text.split('/')[5])
              print 'new event cal_id :'+str(e.cal_id)
              e.saveToDB(self)
            except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
              import traceback
              trace = str(traceback.print_exc())
              self.emit("error", str(error) + "\n" + trace+ "\n" +e.description)
              cal_client = self.doLogin()

          self.emit("progress", 90)
          debug('progress 90')

        
        except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,e:
          import traceback
          t = str(traceback.print_exc())
          self.emit("error", str(e))

        self.emit("progress", 100)
        self.emit("completed")
        debug('completed')

class ThreadManager:
    """
    Manages many FooThreads. This involves starting and stopping
    said threads, and respecting a maximum num of concurrent threads limit
    """
    def __init__(self, maxConcurrentThreads):
        self.maxConcurrentThreads = maxConcurrentThreads
        self.Threads = {}
        self.pendingThreadArgs = []

    def _register_thread_completed(self, thread, *args):
        """
        Decrements the count of concurrent threads and starts any 
        pending threads if there is space
        """
        del(self.Threads[args])
        running = len(self.Threads) - len(self.pendingThreadArgs)

        debug( "%s completed. %s running, %s pending" % (
                            thread, running, len(self.pendingThreadArgs)))

        if running < self.maxConcurrentThreads:
            try:
                args = self.pendingThreadArgs.pop()
                debug("Starting pending %s" % self.Threads[args])
                self.Threads[args].start()
            except IndexError: pass

    def make_thread(self, completedCb, progressCb,errorCb, userData,  *args):
        """
        Makes a thread with args. The thread will be started when there is
        a free slot
        """
        running = len(self.Threads) - len(self.pendingThreadArgs)

        if args not in self.Threads:
            thread = _Thread(*args)
            thread.connect("completed", completedCb, userData)
            thread.connect("completed", self._register_thread_completed, *args)
            thread.connect("progress", progressCb, userData)
            thread.connect("error", errorCb, userData)
            self.Threads[args] = thread

            if running < self.maxConcurrentThreads:
                self.Threads[args].start()
            else:
                self.pendingThreadArgs.append(args)

    def stop_all_threads(self, block=False):
        """
        Stops all threads. If block is True then actually wait for the thread
        to finish (may block the UI) 
        """
        for thread in self.Threads.values():
            thread.cancel()
            if block:
                if thread.isAlive():
                    thread.join()
