#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import datetime
import uuid
import sqlite3
import commands
import gobject
gobject.threads_init()

import threading
import string
import time
import socket
import pango

from mutils import * 
from msyncerror import * 
from msync import * 

try:
  import hildon
  HILDON_SUPPORT = True
except:
  HILDON_SUPPORT = False

try:
        import pygtk
        pygtk.require("2.0")
except:
        pass
try:
        import gtk
        import gtk.glade
except:
        sys.exit(1)

class mAlert:

  def __init__(self,message="Unknown error"):
    dialog = gtk.MessageDialog(gtk.Window(),
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_ERROR,
                    gtk.BUTTONS_OK,
                    message)
    rc = dialog.run ()
    dialog.destroy ()

class mPrefs:

        def __init__(self,widget):
                self.widget = widget
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.wTree = gtk.glade.XML(self.gladefile, "Prefs")       
#                if HILDON_SUPPORT:
#                  self.window = hildon.Window()
#                  self.window.set_border_width(0)
#                else:
#                  self.window = gtk.Window()
                self.window = self.wTree.get_widget("Prefs")
#                self.vbox = self.wTree.get_widget("vbox9")
#                self.vbox.reparent(self.window)
#                self.window.set_title(self.prefs_win.get_title())
                self.window.connect("destroy", self.cancel)
                self.widget.app.add_window(self.window)

                #Create our dictionay and connect it
                dic = {
                       "on_bOK_clicked" : self.validate,
                       "on_bCancel_clicked" : self.cancel}
                self.wTree.signal_autoconnect(dic)

                self.bEmail = self.wTree.get_widget("bEmail")
                self.bPassword = self.wTree.get_widget("bPassword")
                self.bPassword.set_invisible_char('*')
                self.bPassword.set_visibility(False)
                self.bLastUpdate = self.wTree.get_widget("bLastUpdate")
                self.fDate = self.wTree.get_widget("fDate")
                self.fTime = self.wTree.get_widget("fTime")
                self.fDay_view = self.wTree.get_widget("fDay_view")
                self.fWeek_view = self.wTree.get_widget("fWeek_view")
                self.fMonth_view = self.wTree.get_widget("fMonth_view")
                self.fAllDay_view = self.wTree.get_widget("fAllDay_view")
                self.fAllWeek_view = self.wTree.get_widget("fAllWeek_view")
                self.fAllMonth_view = self.wTree.get_widget("fAllMonth_view")
                self.wStart_time = self.wTree.get_widget("wStart_time")
                self.wEnd_time = self.wTree.get_widget("wEnd_time")
                self.bp_override = self.wTree.get_widget("bp_override")
                self.bp_autosync = self.wTree.get_widget("bp_autosync")
                self.bp_popupalarm = self.wTree.get_widget("bp_popupalarm")
                self.bp_display_day= self.wTree.get_widget("bp_display_day")
                self.bp_use_google_color = self.wTree.get_widget("bp_use_google_color")

                self.widget.dbcur.execute('SELECT id,content FROM prefs')       
                for prefs in self.widget.dbcur.fetchall():
                  if prefs[0]=='email':
                    self.bEmail.set_text(prefs[1])
                  if prefs[0]=='password':
                    self.bPassword.set_text(prefs[1])
                  if prefs[0]=='last_update':
                    self.bLastUpdate.set_text(prefs[1])
                  if prefs[0]=='date_format':
                    self.fDate.set_text(prefs[1])
                  if prefs[0]=='time_format':
                    self.fTime.set_text(prefs[1])
                  if prefs[0]=='day_view':
                    self.fDay_view.set_text(prefs[1])
                  if prefs[0]=='week_view':
                    self.fWeek_view.set_text(prefs[1])
                  if prefs[0]=='month_view':
                    self.fMonth_view.set_text(prefs[1])
                  if prefs[0]=='wstart_time':
                    self.wStart_time.set_text(prefs[1])
                  if prefs[0]=='wend_time':
                    self.wEnd_time.set_text(prefs[1])
                  if prefs[0]=='allmonth_view':
                    self.fAllMonth_view.set_text(prefs[1])
                  if prefs[0]=='allweek_view':
                    self.fAllWeek_view.set_text(prefs[1])
                  if prefs[0]=='allday_view':
                    self.fAllDay_view.set_text(prefs[1])
                  if prefs[0]=='override_theme':
                    self.bp_override.set_active(prefs[1]=='True')
                  if prefs[0]=='auto_sync':
                    self.bp_autosync.set_active(prefs[1]=='True')
                  if prefs[0]=='popup_alarm':
                    self.bp_popupalarm.set_active(prefs[1]=='True')
                  if prefs[0]=='use_google_color':
                    self.bp_use_google_color.set_active(prefs[1]=='True')
                  if prefs[0]=='display_day':
                    self.bp_display_day.set_active(prefs[1]=='True')

                if OVERRIDE_THEME==True:
                  children_color_bg(self.window)

                self.window.show_all()

        def cancel(self,widget):
                self.window.hide()

        def validate(self,widget):

                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.bEmail.get_text()+'" where id = "email"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.bLastUpdate.get_text()+'" where id = "last_update"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.bPassword.get_text()+'" where id = "password"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fDate.get_text()+'" where id = "date_format"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fTime.get_text()+'" where id = "time_format"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fDay_view.get_text()+'" where id = "day_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fWeek_view.get_text()+'" where id = "week_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fMonth_view.get_text()+'" where id = "month_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.wStart_time.get_text()+'" where id = "wstart_time"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.wEnd_time.get_text()+'" where id = "wend_time"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fAllDay_view.get_text()+'" where id = "allday_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fAllWeek_view.get_text()+'" where id = "allweek_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fAllMonth_view.get_text()+'" where id = "allmonth_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+str(self.bp_override.get_active())+'" where id = "override_theme"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+str(self.bp_popupalarm.get_active())+'" where id = "popup_alarm"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+str(self.bp_autosync.get_active())+'" where id = "auto_sync"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+str(self.bp_use_google_color.get_active())+'" where id = "use_google_color"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+str(self.bp_display_day.get_active())+'" where id = "display_day"')
                self.widget.db.commit()
                self.widget.loadPrefs()
                self.window.hide()
                self.widget.updateList()

class mCalendar:
        """This is the mCalendar Application"""
        def createTable(self):
          try:
            self.dbcur.execute('CREATE TABLE events (uuid TEXT PRIMARY KEY, start DATETIME, end DATETIME, description TEXT, repeat INTEGER, repeatvalue INTEGER, frequency TEXT,until DATETIME, lastup DATETIME, googleid TEXT, byday TEXT, alarm INTEGER, alarm_value INTEGER, alarm_id INTEGER, cal_id TEXT)')
            self.db.commit()
            self.dbcur.execute('CREATE TABLE prefs (id TEXT PRIMARY KEY,content TEXT);')
            self.db.commit()
            self.dbcur.execute('CREATE TABLE cal (id TEXT PRIMARY KEY,access_level TEXT, color TEXT, last_update TEXT);')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("last_update","2008-01-01 00:00");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("password","password");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("email","email");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("day_view","<b>%H:%M</b>");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("week_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("month_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("date_format","%x");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("time_format","%X");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wstart_time","09:00");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wend_time","18:00");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allday_view",?);',[ALLDAY_VIEW_FORMAT])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allweek_view",?);',[ALLWEEK_VIEW_FORMAT])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allmonth_view",?);',[ALLMONTH_VIEW_FORMAT])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("VERSION",?);',[VERSION])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("override_theme",?);',['True'])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("auto_sync",?);',['False'])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("use_google_color",?);',['True'])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("popup_alarm",?);',['False'])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("auto_sync_id",?);',[''])
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("display_day",?);',['True'])
            self.db.commit()

          except StandardError,e:
            debug(e)
            try:
              self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("VERSION",?);',[VERSION])
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD byday TEXT')    
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD alarm INTEGER')    
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD alarm_value INTEGER')    
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD alarm_id INTEGER')    
              self.db.commit()
              self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("popup_alarm",?);',['False'])
              self.db.commit()
              self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("auto_sync",?);',['False'])
              self.db.commit()
              self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("use_google_color",?);',['True'])
              self.db.commit()
              self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("auto_sync_id",?);',[''])
              self.db.commit()
              self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("display_day",?);',['True'])
              self.db.commit()

            except StandardError,e:
              debug(e)

        def __init__(self,app,background=False):
                self.background=background
                try:
                  if HILDON_SUPPORT:
                    db_path='/home/user/.mPIM/mcalendar.db'
                  else:
                    db_path='mcalendar.db'
                  self.db = sqlite3.connect(db_path)
                  self.dbcur = self.db.cursor()
                except StandardError,e:
                  debug(e)
                  commands.getoutput("mkdir /home/user/.mPIM/")
                  if HILDON_SUPPORT:
                    db_path='/home/user/.mPIM/mcalendar.db'
                  else:
                     db_path='mcalendar.db'
                  self.db = sqlite3.connect(db_path)
                  self.dbcur = self.db.cursor()

                try:
                  self.dbcur.execute('SELECT content FROM prefs WHERE id = "VERSION";')
                  v = self.dbcur.fetchall()

                  if len(v)==0:
                    self.createTable()

                  else:            
                    for line in v:     
                      for version in line:
                        if version < '0.3.6':
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allday_view",?);',[ALLDAY_VIEW_FORMAT])
                          self.db.commit()
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allweek_view",?);',[ALLWEEK_VIEW_FORMAT])
                          self.db.commit()
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allmonth_view",?);',[ALLMONTH_VIEW_FORMAT])
                          self.db.commit()
                        if version < '0.4.0':
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("override_theme",?);',['True'])
                          self.db.commit()
                        if version < '0.4.1':
                          self.dbcur.execute('ALTER TABLE events ADD cal_id TEXT')
                          self.db.commit()
                          self.dbcur.execute('CREATE TABLE cal (id TEXT PRIMARY KEY,access_level TEXT, color TEXT, last_update TEXT);')
                          self.db.commit()
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("popup_alarm",?);',['False'])
                          self.db.commit()
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("auto_sync",?);',['False'])
                          self.db.commit()
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("use_google_color",?);',['True'])
                          self.db.commit()
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("auto_sync_id",?);',[''])
                          self.db.commit()
                          self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("display_day",?);',['True'])
                          self.db.commit()

                except StandardError,e:
                  debug(e)
                  self.createTable()    

                self.dbcur.execute('UPDATE prefs SET content=? WHERE id="VERSION"',[VERSION])    
                self.db.commit()

                #Current_view :
                #    0 = Today
                #    1 = Week
                #    2 = Month
                self.current_view=0
                self.view_datetime = datetime.datetime.now()

#                self.alternate_color = False

                #Set the Glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.wTree = gtk.glade.XML(self.gladefile, "CalendarView")
                self.window = self.wTree.get_widget("CalendarView")
                self.window.set_title('mCalendar')
#                if HILDON_SUPPORT:
                if app==None:
                  self.app = hildon.Program()    
                else:
                  self.app = app
                gtk.set_application_name('')  
                self.window.set_name('mCalendar') 
#                  self.window = hildon.Window()
#                  self.window.hide()
#                else:
#                  self.window = gtk.Window()
                self.window.connect("key-press-event", self.on_key_press)
                self.window.connect("window-state-event", self.on_window_state_change)  
                self.window_in_fullscreen = False #The window isn't in full screen mode initially.
                

#                self.window.set_icon(gtk.gdk.pixbuf_new_from_file('/usr/share/pixmaps/mcalendar26.png'))
                #set a win background
#                pixbuf = gtk.gdk.pixbuf_new_from_file('background_pattern.png')
#                pixmap, mask = pixbuf.render_pixmap_and_mask()
#                width, height = pixmap.get_size()
#                del pixbuf
#                self.window.set_app_paintable(gtk.TRUE)
#                self.window.resize(width, height)
#                self.window.realize()
#                self.window.window.set_back_pixmap(pixmap, gtk.FALSE)
#                del pixmap 
#
                self.loadPrefs()
#                hildon.hildon_helper_set_thumb_scrollbar(True,True)

                self.vbox = self.wTree.get_widget("vbox8")
#                if HILDON_SUPPORT:
                hildon.hildon_helper_set_thumb_scrollbar(self.wTree.get_widget("scrolledwindow3"),True)
#                self.vbox.reparent(self.window)
#                self.window.set_title(self.calendarview_win.get_title())
                self.window.connect("destroy", self.Quit)
                if HILDON_SUPPORT:
                  self.app.add_window(self.window)
                  if (background == False):
                    self.window.show_all()
                    
#                self.window.set_icon_from_file('/usr/share/pixmaps/mcalendar26.png')

                #Create our dictionay and connect it
                dic = {
                       "on_bNew_clicked" : self.AddEvent,
                       "on_bNext_clicked" : self.nextButton,
                       "on_bPrevious_clicked" : self.previousButton,
                       "on_bFreetime_clicked" : self.bFreetime,
                       "on_bToday_clicked" : self.bToday,
                       "on_bWeek_clicked" : self.bWeek,
                       "on_bMonth_clicked" : self.bMonth,
                       "on_lCurrentDate_clicked" : self.bSetCurrentDate,
                       "on_tDisplay_row_activated" : self.EditEvent}
                self.wTree.signal_autoconnect(dic)

                #connect data
                self.list = self.wTree.get_widget("tDisplay")
                self.data = EventsDisplay(self.list)

                #get gui objects
                self.bToday = self.wTree.get_widget("bToday")
                self.bWeek = self.wTree.get_widget("bWeek")
                self.bMonth = self.wTree.get_widget("bMonth")

#                self.vbox.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
#                self.bToday.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))

                self.lCurrentDate = self.wTree.get_widget("lCurrentDate")
#                self.lCurrentTime = self.wTree.get_widget("lCurrentTime")

                #set gui data
                self.updateCurrentDatetime()
#                self.timer = gobject.timeout_add(30000, self.updateCurrentDatetime)
                self.updateCurrentDayButton()                
                self.updateViewDateButton()

                self.pendingModel = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT)
                self.completeModel = gtk.ListStore(gobject.TYPE_STRING)
                self._make_view(self.pendingModel, "Pending Threads", True, self.vbox)

                if OVERRIDE_THEME==True:
                  children_color_bg(self.window)

                self.updateList()
                self.create_menu()

                if (background==False):
                  self.window.show_all()
                self.progress_view.hide()

        def get_bg_color(self):
          return "#FFFFFF"
          if self.alternate_color == False:
            self.alternate_color = True
            return "#FFFFFF"
          else:
            self.alternate_color = False
            return "#E5F2FF"

        def get_fg_color(self,cal_id):
          global USE_GOOGLE_COLOR

          if USE_GOOGLE_COLOR == False:
            return "#000000"
          else:
            self.dbcur.execute("SELECT color FROM cal where id='"+cal_id+"';")       
            for cal in self.dbcur.fetchall():
              return cal[0]
            return "#000000"

        def appendToStore(self):
          self.event_list.sort()
          last_date = None
          for date,event in self.event_list:
            if ((date.date()!=last_date) and (self.current_view!=3) and (self.current_view!=0)) and (DISPLAY_DAY==True):
              last_date = date.date()
              self.data.store.append(("","",date.strftime("%A %x"),"noteditable","","","#000000","#E5FFE5",pango.STYLE_ITALIC))

            event = (event[0],event[1],event[2],event[3],event[4],event[5],event[6], event[7],pango.STYLE_NORMAL)
            self.data.store.append(event)

        def appendToView(self,start_datetime,start_format,end_datetime,end_format,description,uuid,d1="",d2="",fg="#000000",bg="#FFFFFF"):

          if ((start_datetime.hour==0) and (start_datetime.minute==0)) and ((end_datetime.hour==23) and (end_datetime.minute==59)):
            if start_format == WEEK_VIEW_FORMAT: 
              start_format = ALLWEEK_VIEW_FORMAT
            elif start_format == MONTH_VIEW_FORMAT: 
              start_format = ALLMONTH_VIEW_FORMAT
            else:
              start_format = ALLDAY_VIEW_FORMAT
            end_format = ''

#            if self.last_date_list != start_datetime.date():
#              self.last_date_list = start_datetime.date()
#              self.data.store.append(("","",start_datetime.strftime("%x"),"noteditable","","","#FFFFFF","#CC0000"))

          if (start_datetime.date()==end_datetime.date()) or (self.current_view == 0):
            if (start_format==DAY_VIEW_FORMAT) and (end_format==DAY_VIEW_FORMAT):
              ds = start_datetime.strftime(start_format)+'\n'+end_datetime.strftime(end_format)
              de = ''
            else:
              ds = start_datetime.strftime(start_format)+'\n'+end_datetime.strftime(end_format)
              de = end_datetime.strftime(end_format)   
            self.event_list.append((start_datetime,(ds,de,description,uuid,d1,d2,fg,bg)))                
          else:
            for d in range( (end_datetime - start_datetime).days+1):
              diff = datetime.timedelta(days=d)
              if (start_format==DAY_VIEW_FORMAT) and (end_format==DAY_VIEW_FORMAT):
                ds = (start_datetime + diff).strftime(start_format)+'\n'+end_datetime.strftime(end_format)
                de = ''
              else:
                ds = (start_datetime + diff).strftime(start_format)
                de = end_datetime.strftime(end_format)   

              if ((self.current_view==1) and (start_datetime.strftime("%W")==((start_datetime+diff).strftime("%W")))) or ((self.current_view==2) and (start_datetime.strftime("%M")==((start_datetime+diff).strftime("%M")))):             
                self.event_list.append((start_datetime+diff,(ds,de,description,uuid,d1,d2,fg,bg)))

        def appendToView2(self,start_datetime,start_format,end_datetime,end_format,description,uuid,d1="",d2="",fg="#000000",bg="#FFFFFF"):
          debug('---')
          debug(description)
          debug(start_datetime)
          debug(start_datetime)
          debug(fg)
          debug(bg)
          debug('uuid : '+str(uuid))

          if ((start_datetime.hour==0) and (start_datetime.minute==0)) and ((end_datetime.hour==23) and (end_datetime.minute==59)):
            if start_format == WEEK_VIEW_FORMAT: 
              start_format = ALLWEEK_VIEW_FORMAT
            elif start_format == MONTH_VIEW_FORMAT: 
              start_format = ALLMONTH_VIEW_FORMAT
            else:
              start_format = ALLDAY_VIEW_FORMAT
            end_format = ''

          if (start_format==DAY_VIEW_FORMAT) and (end_format==DAY_VIEW_FORMAT):
            ds = start_datetime.strftime(start_format)+'\n'+end_datetime.strftime(end_format)
            de = ''
          else:
            ds = start_datetime.strftime(start_format)
            de = end_datetime.strftime(end_format)          
            if self.last_date_list != start_datetime.date():
              self.last_date_list = start_datetime.date()
              self.data.store.append(("","",start_datetime.strftime("%x"),"noteditable","","","#FFFFFF","#CC0000"))

          self.data.store.append((ds,de,description,uuid,d1,d2,fg,bg))                

        def setDefaultPrefs(self):
          self.dbcur.execute('SELECT id from Prefs where id="date_format"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("date_format","%x");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="day_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("day_view","<b>%H:%M</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="week_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("week_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="month_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("month_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="allday_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allday_view","<b>All Day</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="allweek_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allweek_view","<b>%a %d\nAll Day</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="allmonth_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("allmonth_view","<b>%a %d\nAll Day</b>");')
            self.db.commit()

          self.dbcur.execute('SELECT id from Prefs where id="time_format"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("time_format","%X");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="wstart_time"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wstart_time","09:00");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="wend_time"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wend_time","18:00");')
            self.db.commit()

        def loadPrefs(self):
          self.setDefaultPrefs()

          global DATE_FORMAT
          DATE_FORMAT = "%x"
          global TIME_FORMAT
          TIME_FORMAT = "%X"
          global DAY_VIEW_FORMAT
          DAY_VIEW_FORMAT = "<b>%H:%M</b>"
          global WEEK_VIEW_FORMAT
          WEEK_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
          global MONTH_VIEW_FORMAT
          MONTH_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
          global FIRST_DAY_WEEK
          FIRST_DAY_WEEK = 0
          global DAY_START_HOUR
          DAY_START_HOUR = 8
          global DAY_START_MINUTE
          DAY_START_MINUTE = 0
          global DAY_END_HOUR
          DAY_END_HOUR = 18
          global DAY_END_MINUTE
          DAY_END_MINUTE = 0
          global ALLDAY_VIEW_FORMAT
          ALLDAY_VIEW_FORMAT = "<b>All day</b>"
          global ALLWEEK_VIEW_FORMAT
          ALLWEEK_VIEW_FORMAT = "<b>%a %d\nAll day</b>"
          global ALLMONTH_VIEW_FORMAT
          ALLMONTH_VIEW_FORMAT = "<b>%a %d\nAll day</b>"
          global OVERRIDE_THEME
          OVERRIDE_THEME = True
          global GOOGLE_REMINDER
          GOOGLE_REMINDER = False
          global USE_GOOGLE_COLOR
          USE_GOOGLE_COLOR = True
          global DISPLAY_DAY
          DISPLAY_DAY = True

          auto_sync = False
          auto_sync_id = '' 

          self.dbcur.execute('SELECT id,content from Prefs')
          for prefs in self.dbcur.fetchall():
            if prefs[0]=='date_format':
              DATE_FORMAT = str(prefs[1])
            elif prefs[0]=='time_format':
              TIME_FORMAT = str(prefs[1])
            elif prefs[0]=='day_view':
              DAY_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='week_view':
              WEEK_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='month_view':
              MONTH_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='allmonth_view':
              ALLMONTH_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='allday_view':
              ALLDAY_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='allweek_view':
              ALLWEEK_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='wstart_time':
              DAY_START_HOUR = int(str(prefs[1])[0:2])
              DAY_START_MINUTE = int(str(prefs[1])[3:5])
              debug((prefs[1])[0:2])
              debug(DAY_START_HOUR)
              debug(DAY_START_MINUTE)
            elif prefs[0]=='wend_time':
              DAY_END_HOUR = int(str(prefs[1])[0:2])
              DAY_END_MINUTE = int(str(prefs[1])[3:5])
            elif prefs[0]=='override_theme':
              OVERRIDE_THEME = prefs[1]=='True'
            elif prefs[0]=='popup_alarm':
              GOOGLE_REMINDER = prefs[1]=='True'
            elif prefs[0]=='auto_sync':
              auto_sync = prefs[1]=='True'
            elif prefs[0]=='auto_sync_id':
              auto_sync_id = prefs[1]
              print 'auto_sync_id exist :' + auto_sync_id
            elif prefs[0]=='use_google_color':
              USE_GOOGLE_COLOR = prefs[1]=='True'
            elif prefs[0]=='display_day':
              DISPLAY_DAY = prefs[1]=='True'

          self.set_auto_sync(auto_sync,auto_sync_id)

        def set_auto_sync(self,auto_sync,auto_sync_id):
          import osso.alarmd
          if (auto_sync_id != '') and (auto_sync==False):
            osso.alarmd.get_alarm(int(auto_sync_id)).cancel_alarm()
            self.dbcur.execute('UPDATE prefs SET content="''" WHERE id ="auto_sync_id";')
            self.db.commit()

          if (auto_sync_id == '') and (auto_sync==True):
            debug('auto_sync == True')
            diff = datetime.timedelta(minutes=1)
            timer = datetime.datetime.now() + diff
            i = osso.alarmd.add_alarm(time.mktime(timer.timetuple()),flags=385,exec_name='python /usr/lib/mcalendar/mcalendar_main.py -s',recurrence=360,recurrence_count=-1)
            #TODO
            #Set a more spaced time
            #Set release path
            print 'auto sync id pref:'+str(i) 
            self.dbcur.execute('UPDATE prefs SET content="'+str(i)+'" WHERE id ="auto_sync_id";')
            self.db.commit()

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            self.previousButton(self)
          elif event.keyval == gtk.keysyms.F7:
            self.nextButton(self)

        def Quit(self,widget):
                self.db.close()
                gtk.main_quit()
                exit()

        def AddEvent(self, widget):
                edit = EventEditor("",self)
                edit.show()

        def EditEvent(self, widget,a,b):
          selection = self.list.get_selection()
          # Get the selection iter
          model, selection_iter = selection.get_selected()

          if (selection_iter):
            suuid = self.data.store.get_value(selection_iter, 3)
            if suuid != 'noteditable':
              start = self.data.store.get_value(selection_iter, 4)
              end = self.data.store.get_value(selection_iter, 5)
              edit = EventEditor(suuid,self,start,end)
              edit.show()

        def updateCurrentDatetime(self):
          self.current_datetime = datetime.datetime.now()
          debug('current datetime updated')
          return True

        def updateCurrentDayButton(self):
          self.bToday.set_label(self.current_datetime.strftime('%A %d'))
          self.bMonth.set_label(self.current_datetime.strftime('%B'))
          self.bWeek.set_label(self.current_datetime.strftime('Week %W'))

        def updateViewDateButton(self):
          if (self.current_view == 0) or (self.current_view == 3):
            self.lCurrentDate.set_label(self.view_datetime.strftime('%A %d %B %Y'))
          elif self.current_view == 1:
            self.lCurrentDate.set_label(self.view_datetime.strftime('Week %W'))
          elif self.current_view == 2:
            self.lCurrentDate.set_label(self.view_datetime.strftime('%B %Y'))

        def nextButton(self,widget):
          if (self.current_view == 0) or (self.current_view == 3):
            diff = datetime.timedelta(days=1)
            self.view_datetime = self.view_datetime + diff
          elif self.current_view == 1:
            diff = datetime.timedelta(weeks=1)
            self.view_datetime = self.view_datetime + diff
          elif self.current_view == 2:
            self.view_datetime = addMonth(self.view_datetime,1)

          self.updateViewDateButton()
          self.updateList()

        def previousButton(self,widget):
          if (self.current_view == 0) or (self.current_view == 3):
            diff = datetime.timedelta(days=1)
            self.view_datetime = self.view_datetime - diff
          elif self.current_view == 1:
            diff = datetime.timedelta(weeks=1)
            self.view_datetime = self.view_datetime - diff
          elif self.current_view == 2:
            self.view_datetime = supMonth(self.view_datetime,1)
          self.updateViewDateButton()
          self.updateList()

        def datePicker(self,date):   
            debug(date)
            if date.year==9999:
              date = datetime.datetime.now()
            d = date.day
            m = date.month
            y = date.year
            debug(y)
            if HILDON_SUPPORT:
              D = hildon.CalendarPopup(hildon.Window(),y,m,d)
              if(D.run()==gtk.RESPONSE_OK):
                y,m,d = D.get_date()
              else:
                y = 9999
                m = 9
                d = 9
              D.destroy()
            return datetime.datetime.combine(datetime.date(y,m,d),date.time())

        def bSetCurrentDate(self,widget):
          date = self.datePicker(self.view_datetime)
          if date.date()!=datetime.date(9999,9,9):
            self.view_datetime = date
            self.current_view = 0
            self.updateViewDateButton()
            self.updateList()

        def bToday(self,widget):
          self.current_view = 0
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def bFreetime(self,widget):
          self.current_view = 3
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def bWeek(self,widget):
          self.current_view = 1
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def bMonth(self,widget):
          self.current_view = 2
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def updateList(self):
            debug("UpdateList")
            self.data.store.clear()
            self.event_list = []
            self.alternate_color = False
#            self.last_date_list = None
            #test

            if self.current_view==0:
              where = ' WHERE ((start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'"'
              where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'")'
              #reccuring
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND strftime("%m",start)='+str(self.view_datetime.month)+' AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'

            elif self.current_view==1:
              firstWeekDay,lastWeekDay = getWeekDetails(self.view_datetime)

              where = ' WHERE (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'"'
              where = where + ' AND end>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'"'
              #reccuring
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)<=7.0 ) '
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))<=7.0 ) '
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND (('+str((lastWeekDay.year*12)+lastWeekDay.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND (('+str((lastWeekDay.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'

            elif self.current_view==2:
              where = ' WHERE (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'"'
              where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'"'
              #reccuring
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-01 00:00")+'")-(julianday(start))) % repeatvalue)<31.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-01 00:00")+'")-(julianday(start))) % (repeatvalue*7))<31.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'
            elif self.current_view==3:
              where = ' WHERE ((start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'"'
              where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'")'
              #reccuring
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND strftime("%m",start)='+str(self.view_datetime.month)+' AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'

            else:
              where = ""

            if self.current_view == 3:
              notfreetime = []

            self.dbcur.execute('SELECT  start, end, description,uuid,repeat,repeatvalue,frequency,until,byday,cal_id,googleid FROM events  '+where + '  AND description<>"DELETED" ORDER by start')       
            for event in self.dbcur.fetchall():
              repeat = event[4]
              repeatvalue = int(event[5])
              frequency = event[6]
              byday = event[8]
              until = datetime.datetime.strptime(event[7],DB_FORMAT)
              start_datetime = datetime.datetime.strptime(event[0],DB_FORMAT)
              end_datetime = datetime.datetime.strptime(event[1],DB_FORMAT)
              debug('byday : %s' % byday)  
              debug('googleid : %s' % event[10])
              if self.current_view==0:
                if (not repeat) or (repeat and (self.view_datetime.weekday() in googleToDays(byday))):
                  self.appendToView(start_datetime,DAY_VIEW_FORMAT,end_datetime,DAY_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())                
              elif self.current_view==1:
                if not repeat:
                  self.appendToView(start_datetime,WEEK_VIEW_FORMAT,end_datetime,WEEK_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                else:
                  if frequency=="Day(s)":
                    diff = datetime.timedelta(days=repeatvalue)
                    debug('repeatvalue : %s' % str(repeatvalue))
                    debug('byday : %s' % byday)
                    d = start_datetime
                    de = end_datetime
                    while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
                      if (d.strftime("%W")==self.view_datetime.strftime("%W")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.appendToView(d,WEEK_VIEW_FORMAT,de,WEEK_VIEW_FORMAT,event[2],event[3],self.get_fg_color(event[9]),self.get_bg_color())
                      d = d+diff     
                      de = de + diff  
                      debug(d) 
                  elif frequency=="Week(s)":
                    debug('byday : %s' % byday)
                    diff = datetime.timedelta(days=repeatvalue*7)
                    d = start_datetime
                    de = end_datetime
                    while ((d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1])) and (self.view_datetime.weekday() in googleToDays(byday)) :
                      if (d.strftime("%W")==self.view_datetime.strftime("%W")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.appendToView(d,WEEK_VIEW_FORMAT,de,WEEK_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                      d = d+diff
                      de = de + diff
                  elif frequency=="Month(s)":
                    d = start_datetime
                    de = end_datetime
                    while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
                      if (d.strftime("%W")==self.view_datetime.strftime("%W")):
                        self.appendToView(d,WEEK_VIEW_FORMAT,de,WEEK_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                      d = addMonth(d,repeatvalue) 
                      de = addMonth(d,repeatvalue)
                  elif frequency=="Year(s)":
                    d = start_datetime
                    de = end_datetime
                    while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
                      if ((d.strftime("%Y")==self.view_datetime.strftime("%Y")) and (d.strftime("%W")==self.view_datetime.strftime("%W"))) :
                        self.appendToView(d,WEEK_VIEW_FORMAT,de,WEEK_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                      d = addMonth(d,repeatvalue*12) 
                      de = addMonth(de,repeatvalue*12)

              elif self.current_view==2:
                if not repeat:
                  self.appendToView(start_datetime,MONTH_VIEW_FORMAT,end_datetime,MONTH_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                else:
                  if frequency=="Day(s)":
                    diff = datetime.timedelta(days=repeatvalue)
                    d = start_datetime
                    de = end_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if (d.strftime("%m")==self.view_datetime.strftime("%m")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.appendToView(d,MONTH_VIEW_FORMAT,de,MONTH_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                      d = d+diff         
                      de = de + diff
                  elif frequency=="Week(s)":
                    diff = datetime.timedelta(days=repeatvalue*7)
                    d = start_datetime
                    de = end_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if (d.strftime("%m")==self.view_datetime.strftime("%m")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.data.store.append(eventToList(d,MONTH_VIEW_FORMAT,de,MONTH_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color()))
                      d = d+diff            
                      de = de + diff
                  elif frequency=="Month(s)":
                    debug('test')
                    d = start_datetime
                    de = end_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if (d.strftime("%m")==self.view_datetime.strftime("%m")) :
                        self.appendToView(d,MONTH_VIEW_FORMAT,de,MONTH_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                      d = addMonth(d,repeatvalue)        
                      de = addMonth(d,repeatvalue)        
                  elif frequency=="Year(s)":
                    debug('test')
                    d = start_datetime
                    de = end_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if ((d.strftime("%Y")==self.view_datetime.strftime("%Y")) and (d.strftime("%m")==self.view_datetime.strftime("%m"))):
                        self.appendToView(d,MONTH_VIEW_FORMAT,de,MONTH_VIEW_FORMAT,event[2],event[3],"","",self.get_fg_color(event[9]),self.get_bg_color())
                      d = addMonth(d,repeatvalue*12)  
                      de = addMonth(de,repeatvalue*12)  
              elif self.current_view==3:     
                if self.view_datetime.weekday() in googleToDays(byday):
                 notfreetime.append((start_datetime,end_datetime))

            if self.current_view == 3:
              freetime_start = startDay(self.view_datetime)
              freetime_end = endDay(self.view_datetime)
              for start_datetime,end_datetime in notfreetime:
                if freetime_end > start_datetime:
                  freetime_end = start_datetime

              if freetime_end > freetime_start:
                self.appendToView(freetime_start,DAY_VIEW_FORMAT,freetime_end,DAY_VIEW_FORMAT,'Free Time','',startDay(self.view_datetime).strftime(DB_FORMAT),freetime_end.strftime(DB_FORMAT),'','')

              first = True
              for start_datetime,end_datetime in notfreetime:
                if first==False:
                  freetime_end = start_datetime
                  if freetime_end > freetime_start:
                    self.appendToView(freetime_start.strftime(DAY_VIEW_FORMAT)+'\n'+freetime_end.strftime(DAY_VIEW_FORMAT),'','Free Time','',freetime_start.strftime(DB_FORMAT),freetime_end.strftime(DB_FORMAT))
                  freetime_start = end_datetime
                else:
                  first = False
                  freetime_start = end_datetime

              if freetime_start.strftime(DB_FORMAT) < endDay(self.view_datetime).strftime(DB_FORMAT) and (len(notfreetime)>0):
                self.appendToView(freetime_start.strftime(DAY_VIEW_FORMAT)+'\n'+ endDay(self.view_datetime).strftime(DAY_VIEW_FORMAT),'','Free Time','',freetime_start.strftime(DB_FORMAT),endDay(self.view_datetime).strftime(DB_FORMAT))

            self.appendToStore()

        def callPrefs(self,widget):
          mPrefs(self)
          self.loadPrefs()
          self.updateList()

        def create_menu(self):
          self.menubar = gtk.Menu ()
          if HILDON_SUPPORT:
            self.window.set_menu(self.menubar)

          item = gtk.MenuItem ('Synchro')
          item.connect ("activate", self.synchro)
          item.show ()
          self.menubar.append (item)

          item = gtk.MenuItem ('Preferences')
          item.connect ("activate", self.callPrefs)
          item.show ()
          self.menubar.append (item)

          item = gtk.MenuItem ('_Help')
          item.show ()
          self.menubar.append (item)

          menu = gtk.Menu ()
          menu.show ()
          item.set_submenu (menu)
          item = gtk.ImageMenuItem (gtk.STOCK_ABOUT)
          item.connect ("activate", self.onAbout)
          item.show ()
          menu.append (item)

        def onAbout(self, widget):
          dialog = gtk.AboutDialog()
          dialog.set_name("mCalendar")
          dialog.set_version(VERSION)
          dialog.set_logo_icon_name("mcalendar")
#          dialog.set_icon("/usr/share/pixmaps/mcalendar64.png")
          dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
          dialog.set_copyright("By Benoit HERVIER (aka Khertan)")
          dialog.set_website("http://khertan.net/")
          dialog.connect ("response", lambda d, r: d.destroy())
          dialog.show()

        def synchro(self,widget):
          import os

          if (os.path.exists("/tmp/mcalendar_sync.pid")==False):
            self.manager = ThreadManager(1)
            self.future_update = datetime.datetime.now()
            if OVERRIDE_THEME==True:
              children_color_bg(self.vbox)
            self.vbox.show_all()
            self.errors = mSyncError()

            name = "Google Calendar Sync"
            data = 100
            rowref = self.pendingModel.insert(0,(name,0)) 

            self.sync_pid  = open("/tmp/mcalendar_sync.pid","wb")
            self.sync_pid.write(str(os.getpid()))
            self.sync_pid.close()

            #THE ACTUAL THREAD BIT
            self.manager.make_thread(
                            self.thread_finished,
                            self.thread_progress,
                            self.thread_error,
                            rowref,data,name)
          else:
            #last_modif = os.stat("/tmp/mcalendar_sync.pid")[9]
            #todo
            diff = datetime.timedelta(minutes=30)
            print datetime.datetime.now()+diff
            print datetime.datetime.fromtimestamp(os.stat("/tmp/mcalendar_sync.pid")[9])
            if (datetime.datetime.fromtimestamp(os.stat("/tmp/mcalendar_sync.pid")[9])) <= (datetime.datetime.now()+diff):
              if (len(self.pendingModel)==0):
                for sync_thread in self.pendingModel:
                  self.pendingModel.remove(sync_thread)
                os.remove("/tmp/mcalendar_sync.pid")
                self.synchro(self)
              else:
                self.sync_pid  = open("/tmp/mcalendar_sync.pid","r")
                pid = self.sync_pid.read(-1)
                self.sync_pid.close()
                commands.getoutput("kill -9 "+pid)
                os.remove("/tmp/mcalendar_sync.pid")
                self.synchro(self)
            else:
              self.errors.append('A synchronization is already in progress')
              if (self.background == False):
                self.errors.show()

        def thread_finished(self, thread, rowref):
          import os
          self.pendingModel.remove(rowref)
          print 'finished'
          print str(len(self.pendingModel))
          if len(self.pendingModel)==0:
            self.progress_view.hide()
            if self.errors.isNotEmpty()==True:
              if self.background == False:
                self.errors.show()
            else:
              print "update  last_update"
              self.dbcur.execute('UPDATE prefs SET content="'+self.future_update.strftime(DB_FORMAT)+'" WHERE id ="last_update";')
              self.db.commit()

            if self.background==False:
              self.updateList()
          self.completeModel.insert(0,(thread.name,))
          os.remove("/tmp/mcalendar_sync.pid")

          if self.background == True:
            gtk.main_quit()
            exit()

        def thread_progress(self, thread, progress, rowref):
          print progress
          self.pendingModel.set_value(rowref,1,int(progress))

        def thread_error(self, thread, error, rowref):
#          mAlert(error)
          print error
          self.errors.append(error)

        def _make_view(self, model, title, showProgress, vbox):
          self.progress_view = gtk.TreeView(model)
          self.progress_view.set_size_request(-1,20)
          self.progress_view.append_column(gtk.TreeViewColumn(title, gtk.CellRendererText(), text=0))
          if showProgress:
            self.progress_view.append_column(gtk.TreeViewColumn("Progress", gtk.CellRendererProgress(), value=1))
          self.progress_view.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
          self.progress_view.modify_base(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
          vbox.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))

          vbox.pack_start(self.progress_view)

if __name__ == "__main__":

        argv = sys.argv
        argv.pop(0)

        if len(argv)>0:
          for arg in argv:
            if arg=="-s":
              mcal = mCalendar(app,background=True)
              mcal.synchro(mcal)
              gtk.main()
#              gtk.exit()

        else:
          gtk.settings_get_default().set_long_property("gtk-button-images",1,"")
          mCal = mCalendar(None)
          gtk.main()
