/*****************************************************************************
 *** Mauku - Micro-blogging client for Maemo devices
 ***
 *** Copyright (c) 2009 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef MICROFEEDMISC_H
#define MICROFEEDMISC_H

#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>

#define microfeed_memory_allocate(t) ((t*)microfeed_memory_allocate_bytes(sizeof(t)))
void* microfeed_memory_allocate_bytes(size_t size);
#define microfeed_memory_allocate_with_strings(t,...) ((t*)microfeed_memory_allocate_with_strings_impl(sizeof(t),__VA_ARGS__))
/* #define microfeed_memory_free(p) free(p) */
void microfeed_memory_free(void* p);

char* microfeed_util_string_concatenate(const char* s, ...);
char* microfeed_util_string_percent_encoding_escape(const char* s);
char* microfeed_util_string_percent_encoding_unescape(const char* s);
char* microfeed_util_string_base64_encode(const char* s, size_t length);
size_t microfeed_util_string_starts_with(const char* s, const char* prefix);

#endif
