/*****************************************************************************
 *** Mauku - Micro-blogging client for Maemo devices
 ***
 *** Copyright (c) 2009 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef MICROFEEDHTTP_H
#define MICROFEEDHTTP_H

#include <time.h>
#include <json.h>

typedef struct json_object JsonObject;

typedef struct _MicrofeedHttp MicrofeedHttp;

typedef int (*MicrofeedHttpOAuthAuthorizeCallback)(MicrofeedHttp* http, const char* url, void* user_data);
typedef void (*MicrofeedHttpOAuthAccessCallback)(MicrofeedHttp* http, const char* access_token, const char* access_token_secret, void* user_data);

typedef enum _MicrofeedOAuthSignatureMethod {
	MICROFEED_HTTP_OAUTH_SIGNATURE_METHOD_HMAC_SHA1
} MicrofeedHttpOAuthSignatureMethod ;

void microfeed_http_init(int multithreaded);
void microfeed_http_cleanup();
MicrofeedHttp* microfeed_http_new();
void microfeed_http_free(MicrofeedHttp* http);

void microfeed_http_free_string(MicrofeedHttp* http, char* ptr);
const void* microfeed_http_get_data(MicrofeedHttp* http, const char* url, size_t* size_return);
JsonObject* microfeed_http_get_json_object(MicrofeedHttp* http, const char* url);
time_t microfeed_get_reply_start_time(MicrofeedHttp* http);
time_t microfeed_http_get_server_time(MicrofeedHttp* http);
char* microfeed_http_post_data(MicrofeedHttp* http, const char* url, size_t* len, const char* post_data);
time_t microfeed_http_parse_date(MicrofeedHttp* http, char* datestring);
JsonObject* microfeed_http_post_json_object(MicrofeedHttp* http, const char* url, const char* post_data);
int microfeed_http_set_cookie_file(MicrofeedHttp* http, const char* filename);
int microfeed_http_set_basic_authentication(MicrofeedHttp* http, const char* userpass);
int microfeed_http_set_oauth_authentication(MicrofeedHttp* http, const char* request_token_url, const char* user_authorization_url, const char* access_token_url, const char* consumer_key, const char* consumer_secret, MicrofeedHttpOAuthAuthorizeCallback authorize_callback, MicrofeedHttpOAuthAccessCallback access_callback, void* user_data);
void microfeed_http_unset_oauth_authentication(MicrofeedHttp* http);
void microfeed_http_set_oauth_access_token(MicrofeedHttp* http, const char* access_token, const char* access_token_secret);
void microfeed_http_set_oauth_signature_method(MicrofeedHttp* http, MicrofeedHttpOAuthSignatureMethod signature_method);

char* microfeed_http_url_encode(MicrofeedHttp* http, const char* s);
char* microfeed_http_escape_markup(MicrofeedHttp* http, const char* s);

#endif
