
#include "config.h"

#if LIBTINYMAIL && LIBTINYMAIL_MAEMO

#include "mauku.h"
#include "folderobserver.h"

enum {
	SIGNAL_FOLDER_UPDATED,
	SIGNAL_COUNT
};

static guint signals[SIGNAL_COUNT];

static void mauku_tny_folder_observer_update(TnyFolderObserver* folder_observer, TnyFolderChange* change) {
	g_signal_emit(folder_observer, signals[SIGNAL_FOLDER_UPDATED], 0, change);
}

static void mauku_tny_folder_observer_class_init(MaukuTnyFolderObserverClass* klass) {
	GObjectClass *object_class;

	object_class = (GObjectClass*)klass;
	signals[SIGNAL_FOLDER_UPDATED] = g_signal_new("folder-updated", MAUKU_TYPE_TNY_FOLDER_OBSERVER, 0, 0,
	                                              NULL, NULL,
	                                              g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1,
						      TNY_TYPE_FOLDER_CHANGE | G_SIGNAL_TYPE_STATIC_SCOPE);
}

static void mauku_tny_folder_observer_init(gpointer _klass, gpointer data) {
	TnyFolderObserverIface *klass = (TnyFolderObserverIface *)_klass;

	klass->update = mauku_tny_folder_observer_update;
}

GType mauku_tny_folder_observer_get_type(void) {
	static GType type = 0;
	static const GTypeInfo info = {
		sizeof(MaukuTnyFolderObserverClass),
		NULL,   /* base_init */
		NULL,   /* base_finalize */
		(GClassInitFunc)mauku_tny_folder_observer_class_init,
		NULL,   /* class_finalize */
		NULL,   /* class_data */
		sizeof(MaukuTnyFolderObserver),
		0,      /* n_preallocs */
		NULL /* instance_init */
	};
		static const GInterfaceInfo folder_observer_info = {
		(GInterfaceInitFunc)mauku_tny_folder_observer_init,
		NULL,         /* interface_finalize */
		NULL          /* interface_data */
	};
	
	if (!type) {
		type = g_type_register_static(G_TYPE_OBJECT, "MaukuTnyFolderStore", &info, 0);
		g_type_add_interface_static(type, TNY_TYPE_FOLDER_OBSERVER, &folder_observer_info);
	}
	
	return type;
}

MaukuTnyFolderObserver* mauku_tny_folder_observer_new(void) {
	MaukuTnyFolderObserver* folder_observer;
	
	folder_observer = g_object_new(MAUKU_TYPE_TNY_FOLDER_OBSERVER, NULL);

	return folder_observer;
}

#endif
