
#include "config.h"

#if LIBTINYMAIL && LIBTINYMAIL_MAEMO

#include "mauku.h"
#include "accountstore.h"

#include <tny-device.h>
#include <tny-session-camel.h>
#include <tny-camel-imap-store-account.h>
#include <tny-camel-pop-store-account.h>
#include <tny-noop-lockable.h>

typedef struct {
	TnySessionCamel* session;
	TnyAccount* store_account;
	TnyAccount* transport_account;
	TnyDevice* device;
	guint notify_id;
} MaukuTnyAccountStorePrivate;

#define MAUKU_TNY_ACCOUNT_STORE_GET_PRIVATE(x) (G_TYPE_INSTANCE_GET_PRIVATE((x), MAUKU_TYPE_TNY_ACCOUNT_STORE, MaukuTnyAccountStorePrivate))

static gboolean mauku_tny_account_store_alert(TnyAccountStore* account_store, TnyAccount* account,
                                              TnyAlertType type, gboolean question, GError* error) {
	printf("ALERT: %s\n", error->message);

	return TRUE;
}

static TnyAccount* mauku_tny_account_store_find_account(TnyAccountStore* account_store, const gchar* url_string) {

	return NULL;
}

gchar* get_store_account_password(TnyAccount* account, const gchar* prompt, gboolean* cancel) {
	gchar* s;
	
	if (!(s = gconf_client_get_string(gconf, MAUKU_GCONF_KEY_EMAIL_PASSWORD, NULL))) {
		*cancel = TRUE;
	}
	
	return s;
}

void forget_store_account_password(TnyAccount* account) {
	gconf_client_set_string(gconf, MAUKU_GCONF_KEY_EMAIL_PASSWORD, "", NULL);
}

static void mauku_tny_account_store_get_accounts(TnyAccountStore* account_store, TnyList* list, TnyGetAccountsRequestType types) {
	MaukuTnyAccountStorePrivate* private = MAUKU_TNY_ACCOUNT_STORE_GET_PRIVATE(account_store);
	gchar* s;
	gint i;

	if (types == TNY_ACCOUNT_STORE_BOTH || types == TNY_ACCOUNT_STORE_STORE_ACCOUNTS) {
		if (!private->store_account) {
			if ((s = gconf_client_get_string(gconf, MAUKU_GCONF_KEY_EMAIL_PROTO, NULL))) {
				if (!strcmp(s, "imap")) {
					private->store_account = TNY_ACCOUNT(tny_camel_imap_store_account_new());
				} else if (!strcmp(s, "pop")) {
					private->store_account = TNY_ACCOUNT(tny_camel_pop_store_account_new());
				}
			}
			if (private->store_account) {
				tny_account_set_proto(private->store_account, s);
				tny_account_set_id(private->store_account, "mauku_store_account");
				tny_camel_account_set_session(TNY_CAMEL_ACCOUNT(private->store_account), private->session);
				g_free(s);

				if ((s = gconf_client_get_string(gconf, MAUKU_GCONF_KEY_EMAIL_HOST, NULL))) {
					tny_account_set_hostname(private->store_account, s);
				}
				if ((i = gconf_client_get_int(gconf, MAUKU_GCONF_KEY_EMAIL_PORT, NULL))) {
					tny_account_set_port(private->store_account, i);
				}
				if ((s = gconf_client_get_string(gconf, MAUKU_GCONF_KEY_EMAIL_NAME, NULL))) {
					tny_account_set_user(private->store_account, s);
				}
				tny_account_set_pass_func(private->store_account, get_store_account_password);
				tny_account_set_forget_pass_func(private->store_account, forget_store_account_password);
				tny_camel_account_add_option(TNY_CAMEL_ACCOUNT (private->store_account),
				                             tny_pair_new ("use_ssl", "wrapped"));
			}
			tny_session_camel_set_initialized(private->session);
		}
		if (private->store_account) {
			tny_list_prepend (list, (GObject*)private->store_account);
		}
	} 
	if (types == TNY_ACCOUNT_STORE_BOTH || types == TNY_ACCOUNT_STORE_TRANSPORT_ACCOUNTS) {
		if (!private->transport_account) {

		}
		if (private->transport_account) {
			tny_list_prepend (list, (GObject*)private->transport_account);
		}
	}
}

static const gchar* mauku_tny_account_store_get_cache_dir(TnyAccountStore* account_store) {
	static gchar* cache_dir = NULL;
	
	if (!cache_dir) {
		cache_dir = g_strdup_printf("%s/.mauku/email", (getenv("HOME") ? getenv("HOME") : "/home/user"));
	}
	
	return cache_dir;
}
static TnyDevice* mauku_tny_account_store_get_device(TnyAccountStore* account_store) {
	MaukuTnyAccountStorePrivate* private;
	
	private = MAUKU_TNY_ACCOUNT_STORE_GET_PRIVATE(account_store);
	g_object_ref(private->device);
	
	return private->device;

}
static void account_changed(GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer user_data) {
	MaukuTnyAccountStore* account_store;
	MaukuTnyAccountStorePrivate* private;

	account_store = MAUKU_TNY_ACCOUNT_STORE(user_data);
	private = MAUKU_TNY_ACCOUNT_STORE_GET_PRIVATE(account_store);

	if (private->store_account) {
		g_object_unref(private->store_account);
		private->store_account = NULL;
	}
	if (private->transport_account) {
		g_object_unref(private->transport_account);
		private->transport_account = NULL;
	}
}

static void mauku_tny_account_store_instance_init (GTypeInstance* instance, gpointer klass) {
	MaukuTnyAccountStore* account_store;
	MaukuTnyAccountStorePrivate* private;

	account_store = (MaukuTnyAccountStore*)instance;
	private = MAUKU_TNY_ACCOUNT_STORE_GET_PRIVATE(account_store);

	private->store_account = private->transport_account = NULL;

	private->notify_id = gconf_client_notify_add (gconf, MAUKU_GCONF_DIR_EMAIL, account_changed, account_store, NULL, NULL);
	private->device = TNY_DEVICE(tny_maemo_conic_device_new());

	return;
}

static void tny_maemo_account_store_finalize(GObject* object) {
	MaukuTnyAccountStore* account_store;
	MaukuTnyAccountStorePrivate* private;
	GObjectClass* parent_class;

	account_store = MAUKU_TNY_ACCOUNT_STORE(object);
	private = MAUKU_TNY_ACCOUNT_STORE_GET_PRIVATE(account_store);

	gconf_client_notify_remove (gconf, private->notify_id);

	if (private->store_account) {
		g_object_unref(private->store_account);
		private->store_account = NULL;
	}
	if (private->transport_account) {
		g_object_unref(private->transport_account);
		private->transport_account = NULL;
	}
	
	parent_class = g_type_class_peek_parent(g_type_class_peek(MAUKU_TYPE_TNY_ACCOUNT_STORE)); 
	parent_class->finalize(object);
}

static void mauku_tny_account_store_class_init(MaukuTnyAccountStoreClass* klass) {
	GObjectClass *object_class;

	object_class = (GObjectClass*)klass;
	object_class->finalize = tny_maemo_account_store_finalize;
	g_type_class_add_private (object_class, sizeof (MaukuTnyAccountStorePrivate));
}

static void mauku_tny_account_store_init(gpointer _klass, gpointer data) {
	TnyAccountStoreIface *klass = (TnyAccountStoreIface *)_klass;

	klass->get_accounts = mauku_tny_account_store_get_accounts;
	klass->get_cache_dir = mauku_tny_account_store_get_cache_dir;
	klass->get_device = mauku_tny_account_store_get_device;
	klass->alert = mauku_tny_account_store_alert;
	klass->find_account = mauku_tny_account_store_find_account;
}

GType mauku_tny_account_store_get_type(void) {
	static GType type = 0;
	static const GTypeInfo info = {
		sizeof(MaukuTnyAccountStoreClass),
		NULL,   /* base_init */
		NULL,   /* base_finalize */
		(GClassInitFunc)mauku_tny_account_store_class_init,
		NULL,   /* class_finalize */
		NULL,   /* class_data */
		sizeof(MaukuTnyAccountStore),
		0,      /* n_preallocs */
		mauku_tny_account_store_instance_init
	};
		static const GInterfaceInfo account_store_info = {
		(GInterfaceInitFunc)mauku_tny_account_store_init,
		NULL,         /* interface_finalize */
		NULL          /* interface_data */
	};
	
	if (!type) {
		type = g_type_register_static(G_TYPE_OBJECT, "MaukuTnyAccountStore", &info, 0);
		g_type_add_interface_static(type, TNY_TYPE_ACCOUNT_STORE, &account_store_info);
	}
	
	return type;
}

MaukuTnyAccountStore* mauku_tny_account_store_new(void) {
	MaukuTnyAccountStore* account_store;
	MaukuTnyAccountStorePrivate* private;
	
	account_store = g_object_new(MAUKU_TYPE_TNY_ACCOUNT_STORE, NULL);
	private = MAUKU_TNY_ACCOUNT_STORE_GET_PRIVATE(account_store);
	private->session = tny_session_camel_new(TNY_ACCOUNT_STORE(account_store));
	tny_session_camel_set_ui_locker(private->session, tny_noop_lockable_new());

	return account_store;
}

#endif
