/*****************************************************************************
 *** Mauku - Jaiku client for Maemo devices 
 ***
 *** Twitter backend
 ***
 *** Copyright (c) 2007-2008 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef INCLUDED_TWITTER_H
#define INCLUDED_TWITTER_H

#include <glib.h>
#include "http.h"
#include "ui.h"

typedef enum {
	TWITTER_ITEM_TYPE_TWEET = 0,
	TWITTER_ITEM_TYPE_RECEIVED_DM,
	TWITTER_ITEM_TYPE_SENT_DM,
} TwitterMessageType;

extern ViewItemSource twitter_item_source;

gboolean twitter_handle_marked_item(ViewAddingSession* session, Http* http, gchar* unique_id, gchar* url);
gboolean twitter_send(const gchar* text);
void twitter_update_contacts_view(View* view);
void twitter_update_explore_view(View* view);
void twitter_update_generic_view(View* view);


#endif
