/*****************************************************************************
 *** Mauku - Jaiku client for Maemo devices 
 ***
 *** Copyright (c) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#include "config.h"
 
#include "mauku.h"

#include <sys/types.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <unistd.h>

#define FLITE_PATH "/usr/bin/flite"

static gpointer do_service_thread(gpointer args); 

static GStaticMutex mutex = G_STATIC_MUTEX_INIT;
static GThread* thread = NULL;
GList* speeches = NULL;

void text_to_speech_service_init() {
}

void text_to_speech_service_cleanup() {
}

gboolean text_to_speech_service_is_available() {
	return g_file_test(FLITE_PATH, G_FILE_TEST_IS_EXECUTABLE);
}

void text_to_speech_service_speak(const gchar* text) {
	if (g_file_test(FLITE_PATH, G_FILE_TEST_IS_EXECUTABLE)) {
		g_static_mutex_lock(&mutex);

		speeches = g_list_append(speeches, g_strdup(text));
		if (!thread) {
			thread = g_thread_create(do_service_thread, NULL, FALSE, NULL);
		}

		g_static_mutex_unlock(&mutex);
	}
}

static gpointer do_service_thread(gpointer args) {
	gchar* text;
	pid_t pid;
	gint len;
	gint i, j;
	int pipe_fds[2];
	char buffer[1024];
	
	g_static_mutex_lock(&mutex);
	
	while (g_list_first(speeches)) {
		text = g_list_first(speeches)->data;
		pipe(pipe_fds);
		if (!(pid = fork())) {
			dup2(pipe_fds[1], STDOUT_FILENO);
			close(pipe_fds[1]);
			close(pipe_fds[0]);
			execl(FLITE_PATH, FLITE_PATH, "-v", "-t", text, NULL);
			exit(0);
		}
		close(pipe_fds[1]);
		speeches = g_list_remove(speeches, text);
		g_free(text);

		g_static_mutex_unlock(&mutex);

		waitpid(pid, &i, 0);
		if ((len = read(pipe_fds[0], buffer, 1023)) > 0) {
			for (j = 0; j < len && buffer[j] != '('; j++) {
			}
			if (j < len) {
				for (i = j + 1; i < len && buffer[i] != '.'; i++) {
				}
				if (i < len) {
					buffer[i] = 0;
					len = atoi(buffer + j);

					sleep(len + 2);
				}
			}
		}

		g_static_mutex_lock(&mutex);
	}
	thread = NULL;
	
	g_static_mutex_unlock(&mutex);

	return NULL;
}
