/*****************************************************************************
 *** Mauku - Jaiku client for Maemo devices 
 ***
 *** Copyright (c) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef INCLUDED_JAIKU_H
#define INCLUDED_JAIKU_H

#include <glib.h>
#include "http.h"
#include "ui.h"

extern ViewItemSource jaiku_item_source;

/* Static functions in jaiku.c*/
gboolean jaiku_handle_marked_item(ViewAddingSession* session, Http* http, gchar* unique_id, gchar* url);
void jaiku_start_login();
gboolean jaiku_send_comment(const gchar* url, const gchar* text);
gboolean jaiku_send_jaiku(const gchar* channel, const gchar* text, gint icon_id);
void jaiku_update_contacts_view(View* view);
void jaiku_update_explore_view(View* view);
void jaiku_update_overview(View* view);
void jaiku_update_your_jaikus_view(View* view);

/* Static function in jaikuupdate.c */

void jaiku_start_update(View* view);

/* Static functions in jaikulocation.c */

void jaiku_change_location();
void jaiku_set_location(const gchar* location);
void jaiku_update_location(Http* http);

#endif
