/*****************************************************************************
 *** Mauku - Jaiku client for Maemo devices 
 ***
 *** Copyright (c) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#include "config.h"

#include "mauku.h"

ImageCache* image_cache_new() {
	ImageCache* image_cache;
	
	image_cache = g_malloc(sizeof(ImageCache));
	image_cache->images = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_object_unref);
	image_cache->images_mutex = g_mutex_new();
	
	return image_cache;
}

void image_cache_destroy(ImageCache* image_cache) {
	if (image_cache) {
		g_mutex_lock(image_cache->images_mutex);
		g_hash_table_destroy(image_cache->images);
		g_mutex_unlock(image_cache->images_mutex);
		g_mutex_free(image_cache->images_mutex);
		g_free(image_cache);
	}	
}

GdkPixbuf* image_cache_load_image(ImageCache* image_cache, Http* http, gchar* url) {
	GdkPixbuf* pixbuf = NULL;
	char* reply;
	size_t len;
	GdkPixbufLoader* loader;
	
	g_mutex_lock(image_cache->images_mutex);
	if (!(pixbuf = g_hash_table_lookup(image_cache->images, url))) {
		if ((reply = http_get_data(http, url, &len))) {
			loader = gdk_pixbuf_loader_new();
			if (gdk_pixbuf_loader_write(loader, reply, len, NULL) &&
			    gdk_pixbuf_loader_close(loader, NULL) &&
			    (pixbuf = gdk_pixbuf_loader_get_pixbuf(loader))) {
				g_object_ref(pixbuf);
				g_hash_table_insert(image_cache->images, g_strdup(url), pixbuf);
			}
			g_object_unref(loader);
		}	
	}
	g_mutex_unlock(image_cache->images_mutex);
	
	return pixbuf;
}
