/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*

Install the libmiaouw-dev package first. Compile this program with

gcc -o miaouwscrolling $(pkg-config --cflags --libs miaouw gtk+-2.0 hildon-libs libosso) miaouwscrolling.c

in Maemo 3.x environment or

gcc -o miaouwscrolling $(pkg-config --cflags --libs miaouw gtk+-2.0 hildon-1 libosso) miaouwscrolling.c

in Maemo 4.x environment.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include <libosso.h>
#include <stdlib.h>
#if defined HILDON && HILDON == 0
#include <hildon-widgets/hildon-program.h>
#else
#include <hildon/hildon.h>
#endif

#include <miaouw/miaouw.h>

#define ROWS 30
#define COLS 15

void clicked(GtkButton* button, gpointer user_data) {
	g_printf("Button clicked\n");
}

int main(int argc, char** argv) {
	osso_context_t* osso_context;
	HildonProgram* program;
	GtkWidget* window;
	GtkWidget* box;
	GtkWidget* label;
	GtkWidget* event_box;
	GtkWidget* scrolled_window;
	GtkWidget* table;
	GtkWidget* widget;
	gint row, col;
	gchar buffer[1024];

	gtk_init(&argc, &argv);
	osso_context = osso_initialize("miaouwscrolling", "0.0.1", TRUE, NULL);

	program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name("Miaouw");
	
	/* You can set the window title when creating a MiaouwWindow. */
	window = miaouw_window_new_with_title("Scrolling");
	hildon_program_add_window(program, HILDON_WINDOW(window));
	g_signal_connect(G_OBJECT(window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

	box = gtk_vbox_new(FALSE, FALSE);
	event_box = gtk_event_box_new();
	label = gtk_label_new("Touchpad");

	/* The MiaouwScrolledWindow acts just like the original Gtk ScrolledWindow. */
	scrolled_window = miaouw_scrolled_window_new(NULL, NULL);
	table = gtk_table_new(ROWS, COLS, TRUE);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), table);

	miaouw_scrolled_window_activate_scrolling(MIAOUW_SCROLLED_WINDOW(scrolled_window), event_box);

	/* Remember to add XXX! */
	gtk_widget_set_size_request(scrolled_window, 640, 300);
	gtk_container_add(GTK_CONTAINER(window), box);
	gtk_container_add(GTK_CONTAINER(box), scrolled_window);
	gtk_container_add(GTK_CONTAINER(event_box), label);
	gtk_container_add(GTK_CONTAINER(box), event_box);
	
	/* The easiest way to support D-pad is to attach scroll adjustments to it with the MiaouwWindow. */
	miaouw_window_set_vadjustment(MIAOUW_WINDOW(window),
	                              gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrolled_window)));
	miaouw_window_set_hadjustment(MIAOUW_WINDOW(window),
	                              gtk_scrolled_window_get_hadjustment(GTK_SCROLLED_WINDOW(scrolled_window)));
	
	srand(time(NULL));
	for (row = 0; row < ROWS; row++) {
		for (col = 0; col < COLS; col++) {
			snprintf(buffer, 1024, "[%d %d]", col, row);
			if (rand() < RAND_MAX / 10) {
				widget = gtk_button_new_with_label(buffer);
				g_signal_connect(widget, "clicked", G_CALLBACK(clicked), NULL);
				miaouw_scrolled_window_activate_scrolling(MIAOUW_SCROLLED_WINDOW(scrolled_window), widget);
			} else if (rand() < RAND_MAX / 10) {
				widget = gtk_button_new_with_label("Only clicks");
				g_signal_connect(widget, "clicked", G_CALLBACK(clicked), NULL);
			} else if (rand() < RAND_MAX / 10) {
				widget = gtk_entry_new();
			} else {
				widget = gtk_label_new(buffer);
				/* The MiaouwWindow can be used to directly change text widgets' font size. */
				g_signal_connect_swapped(window, "change-font-size", 
				                         G_CALLBACK(gtk_widget_modify_font), widget);
			}
			gtk_table_attach(GTK_TABLE(table), widget, col, col + 1, row, row + 1,
			                 GTK_EXPAND|GTK_SHRINK|GTK_FILL, GTK_EXPAND|GTK_SHRINK|GTK_FILL,
					 8, 8);
		}
	}
		
	gtk_widget_show_all(window);


	gtk_main();

	return 0;
}
