/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*

Install the libmiaouw-dev package first. Compile this program with

gcc -o miaouwcapturing $(pkg-config --cflags --libs miaouw gtk+-2.0 hildon-libs libosso) miaouwcapturing.c

in Maemo 3.x environment or

gcc -o miaouwcapturing $(pkg-config --cflags --libs miaouw gtk+-2.0 hildon-1 libosso) miaouwcapturing.c

in Maemo 4.x environment.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include <libosso.h>
#include <stdlib.h>
#if defined HILDON && HILDON == 0
#include <hildon-widgets/hildon-program.h>
#else
#include <hildon/hildon.h>
#endif

#include <miaouw/miaouw.h>

#define ROWS 30
#define COLS 15

gboolean handle_event(GtkWidget* widget, GdkEvent* event, gpointer user_data) {
	g_printf("%s (%p: %d)\n", user_data, event->any.window, event->any.type);

	return FALSE;
}

int main(int argc, char** argv) {
	osso_context_t* osso_context;
	HildonProgram* program;
	GtkWidget* window;
	GtkWidget* box;
	GtkWidget* event_box;
	GtkWidget* label;
	GtkWidget* button;

	gtk_init(&argc, &argv);
	osso_context = osso_initialize("miaouwcapturing", "0.0.1", TRUE, NULL);

	program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name("Miaouw");
	
	/* You can set the window title when creating a MiaouwWindow. */
	window = miaouw_window_new_with_title("Capturing");
	hildon_program_add_window(program, HILDON_WINDOW(window));
	g_signal_connect(G_OBJECT(window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

	box = miaouw_box_new_vertical(FALSE);
	event_box = miaouw_event_box_new_with_window();
	label = gtk_label_new("Label");
	button = gtk_button_new_with_label("Button");
	
	gtk_container_add(GTK_CONTAINER(window), event_box);
	gtk_container_add(GTK_CONTAINER(event_box), box);
	gtk_container_add(GTK_CONTAINER(box), label);
	gtk_container_add(GTK_CONTAINER(box), button);

	gtk_widget_set_events(event_box, gtk_widget_get_events(event_box) | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_POINTER_MOTION_MASK);

	g_signal_connect(event_box, "captured-button-press", G_CALLBACK(handle_event), "event_box: captured-button-press");
	g_signal_connect(event_box, "captured-button-release", G_CALLBACK(handle_event), "event_box: captured-button-release");
	g_signal_connect(event_box, "captured-motion-notify", G_CALLBACK(handle_event), "event_box: captured-motion-notify");
	g_signal_connect(event_box, "button-press-event", G_CALLBACK(handle_event), "event_box: button-press-event");
	g_signal_connect(event_box, "button-release-event", G_CALLBACK(handle_event), "event_box: button-release-event");
	g_signal_connect(event_box, "motion-notify-event", G_CALLBACK(handle_event), "event_box: motion-notify-event");

	g_signal_connect(button, "button-press-event", G_CALLBACK(handle_event), "button: button-press-event");
	g_signal_connect(button, "button-release-event", G_CALLBACK(handle_event), "button: button-release-event");
	g_signal_connect(button, "motion-notify-event", G_CALLBACK(handle_event), "button: motion-notify-event");

	gtk_widget_show_all(window);


	gtk_main();

	return 0;
}
