/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MIAOUW_WINDOW_H
#define MIAOUW_WINDOW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#if defined HILDON && HILDON == 0
#include <hildon-widgets/hildon-program.h>
#else
#include <hildon/hildon-program.h>
#endif

typedef struct _MiaouwWindow MiaouwWindow;
typedef struct _MiaouwWindowClass MiaouwWindowClass;
typedef struct _MiaouwWindowPrivate MiaouwWindowPrivate;

struct _MiaouwWindow {
  HildonWindow parent;

  /* private */
  MiaouwWindowPrivate* priv;
};

struct _MiaouwWindowClass {
  HildonWindowClass parent;
  /* class members */
};

GType miaouw_window_get_type (void);

#define MIAOUW_TYPE_WINDOW (miaouw_window_get_type())
#define MIAOUW_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), MIAOUW_TYPE_WINDOW, MiaouwWindow))
#define MIAOUW_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MIAOUW_TYPE_WINDOW, MiaouwWindowClass))
#define MIAOUW_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), MIAOUW_TYPE_SCROLLED_WINDOW))
#define MIAOUW_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MIAOUW_TYPE_WINDOW))
#define MIAOUW_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), MIAOUW_TYPE_WINDOW, MiaouwWindowClass))

GtkWidget* miaouw_window_new();
GtkWidget* miaouw_window_new_with_title(const gchar* title);

void miaouw_window_activate_urgency_hint(MiaouwWindow* window);
guint miaouw_window_get_font_size(const MiaouwWindow* window);
gboolean miaouw_window_is_fullscreen(const MiaouwWindow* window);
void miaouw_window_set_font_size(MiaouwWindow* window, const guint font_size);
void miaouw_window_set_hadjustment(MiaouwWindow* window, GtkAdjustment* hadjustment);
void miaouw_window_set_led_pattern_name(gchar* name);
void miaouw_window_set_vadjustment(MiaouwWindow* window, GtkAdjustment* vadjustment);

#endif
