/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MIAOUW_SCROLLED_WINDOW_H
#define MIAOUW_SCROLLED_WINDOW_H

#include <gtk/gtk.h>
#include <gtk/gtkscrolledwindow.h>

typedef struct _MiaouwScrolledWindow MiaouwScrolledWindow;
typedef struct _MiaouwScrolledWindowClass MiaouwScrolledWindowClass;
typedef struct _MiaouwScrolledWindowPrivate MiaouwScrolledWindowPrivate;

struct _MiaouwScrolledWindow {
  GtkScrolledWindow parent;

  /* private */
  MiaouwScrolledWindowPrivate* priv;
};

struct _MiaouwScrolledWindowClass {
  GtkScrolledWindowClass parent;
  /* class members */
};

GType miaouw_scrolled_window_get_type (void);

#define MIAOUW_TYPE_SCROLLED_WINDOW (miaouw_scrolled_window_get_type())
#define MIAOUW_SCROLLED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), MIAOUW_TYPE_SCROLLED_WINDOW, MiaouwScrolledWindow))
#define MIAOUW_SCROLLED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MIAOUW_TYPE_SCROLLED_WINDOW, MiaouwScrolledWindowClass))
#define MIAOUW_IS_SCROLLED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), MIAOUW_TYPE_SCROLLED_WINDOW))
#define MIAOUW_IS_SCROLLED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MIAOUW_TYPE_SCROLLED_WINDOW))
#define MIAOUW_SCROLLED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), MIAOUW_TYPE_SCROLLED_WINDOW, MiaouwScrolledWindowClass))

GtkWidget* miaouw_scrolled_window_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment);

void miaouw_scrolled_window_activate_scrolling(MiaouwScrolledWindow* scrolled_window, GtkWidget* widget);
gboolean miaouw_scrolled_window_is_drag_scrolled(MiaouwScrolledWindow* scrolled_window);
void miaouw_scrolled_window_set_drag_scrolling(MiaouwScrolledWindow* scrolled_window, gboolean panning);
void miaouw_scrolled_window_set_scrolling_hints(MiaouwScrolledWindow* scrolled_window, gboolean enabled);

#endif
