/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2008 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MIAOUW_GESTURE_EVENT_BOX_H
#define MIAOUW_GESTURE_EVENT_BOX_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>

typedef enum {
	MIAOUW_GESTURE_FAILED = -1,
	MIAOUW_GESTURE_NONE = 0,
	MIAOUW_GESTURE_LEFT,
	MIAOUW_GESTURE_RIGHT,
	MIAOUW_GESTURE_UP,
	MIAOUW_GESTURE_DOWN
} MiaouwGestureType;

typedef struct _MiaouwGestureEventBox MiaouwGestureEventBox;
typedef struct _MiaouwGestureEventBoxClass MiaouwGestureEventBoxClass;
typedef struct _MiaouwGestureEventBoxPrivate MiaouwGestureEventBoxPrivate;

typedef struct _MiaouwGestureEvent MiaouwGestureEvent;

struct _MiaouwGestureEventBox {
	GtkEventBox parent;

	/* private */
	MiaouwGestureEventBoxPrivate* priv;
};

struct _MiaouwGestureEventBoxClass {
	GtkEventBoxClass parent;

	/* class members */
	gint threshold;
};


GType miaouw_gesture_event_box_get_type (void);

#define MIAOUW_TYPE_GESTURE_EVENT_BOX (miaouw_gesture_event_box_get_type())
#define MIAOUW_GESTURE_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), MIAOUW_TYPE_GESTURE_EVENT_BOX, MiaouwGestureEventBox))
#define MIAOUW_GESTURE_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MIAOUW_TYPE_GESTURE_EVENT_BOX, MiaouwGestureEventBoxClass))
#define MIAOUW_IS_GESTURE_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), MIAOUW_TYPE_SCROLLED_GESTURE_EVENT_BOX))
#define MIAOUW_IS_GESTURE_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MIAOUW_TYPE_GESTURE_EVENT_BOX))
#define MIAOUW_GESTURE_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), MIAOUW_TYPE_GESTURE_EVENT_BOX, MiaouwGestureEventBoxClass))

GtkWidget* miaouw_gesture_event_box_new();

/* ******************** MiaouwGestureEvent ******************** */

struct _MiaouwGestureEvent {
	MiaouwGestureType gesture;
	MiaouwGestureType previous_gesture;
	gint x;
	gint y;
	gint start_x;
	gint start_y;
	gint previous_start_x;
	gint previous_start_y;
};

MiaouwGestureEvent* miaouw_gesture_event_copy(const MiaouwGestureEvent* gesture_event);
void miaouw_gesture_event_free(MiaouwGestureEvent* gesture_event);
GType miaouw_gesture_event_get_type(void);

#define MIAOUW_TYPE_GESTURE_EVENT (miaouw_gesture_event_get_type())

#endif
