/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MIAOUW_BOX_H
#define MIAOUW_BOX_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>

typedef struct _MiaouwBox MiaouwBox;
typedef struct _MiaouwBoxClass MiaouwBoxClass;
typedef struct _MiaouwBoxPrivate MiaouwBoxPrivate;

struct _MiaouwBox {
	GtkContainer parent;

	/* private */
	MiaouwBoxPrivate* priv;
};

struct _MiaouwBoxClass {
	GtkContainerClass parent;
	/* class members */
};

GType miaouw_box_get_type (void);

#define MIAOUW_TYPE_BOX (miaouw_box_get_type())
#define MIAOUW_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), MIAOUW_TYPE_BOX, MiaouwBox))
#define MIAOUW_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MIAOUW_TYPE_BOX, MiaouwBoxClass))
#define MIAOUW_IS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), MIAOUW_TYPE_BOX))
#define MIAOUW_IS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MIAOUW_TYPE_BOX))
#define MIAOUW_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), MIAOUW_TYPE_BOX, MiaouwBoxClass))

GtkWidget* miaouw_box_new_horizontal();
GtkWidget* miaouw_box_new_vertical();

void miaouw_box_add_after(MiaouwBox* box, GtkWidget* child, GtkWidget* existing_child);
void miaouw_box_add_before(MiaouwBox* box, GtkWidget* child, GtkWidget* existing_child);

#endif
