/*
  kwarto board
*/

#include "colors.inc"    
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"

#include "tile.inc"

background { color White }

light_source { <20, 30, -50> color White }

camera {
  location <0, 0, -4.25>
//  location <0, -4, -0.2>
  look_at <0, 0, 0>
  right x*1
}

#declare Wood =
    texture { pigment { P_WoodGrain1A color_map { M_Wood10A }}}
    texture { pigment { P_WoodGrain1B color_map { M_Wood10B }}}

#declare board = difference {
  union {
     box { <-2, -2, -0.1>, <2, 2, 0.1> }

     cylinder { <0,0,-2>, <0,0,2>, 0.1 rotate <90,0,0> translate <-2,0,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.1 rotate <90,0,0> translate < 2,0,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.1 rotate <0,90,0> translate <0,-2,0> }
     cylinder { <0,0,-2>, <0,0,2>, 0.1 rotate <0,90,0> translate <0, 2,0> }

     sphere { <-2,-2,0>, 0.1 }
     sphere { < 2,-2,0>, 0.1 }
     sphere { <-2, 2,0>, 0.1 }
     sphere { < 2, 2,0>, 0.1 }
  }
  torus { 2.0 0.025 translate <0,-0.1,0> rotate <90,0,0> }

#declare step = 0.7;
#declare NrY = 0;
#while (NrY < 4)
  #declare NrX = 0;
  #while (NrX < 4)
    torus { 0.2 0.025 translate <(1.5-NrX)*step,-0.1,(1.5-NrY)*step> rotate <90,0,0> }
    #declare NrX = NrX + 1;
  #end
  #declare NrY = NrY + 1;
#end
}

object {
    board

//    texture { Wood translate <0.1,0.1,0.1> rotate <110, 3, 3> scale 4}
//    finish { specular 0.5  roughness 0.0025 }

    texture { T_Stone17 translate <0.1,0.1,0.1> rotate <110, 3, 3> scale 2}
    finish { specular 0.35 roughness 0.005 }
} 
