#include "statusbar.h"

static void message(statusbar_t *statusbar, const char *msg) {
  static guint mid = 0;
  if(mid)
    gtk_statusbar_pop(GTK_STATUSBAR(statusbar->widget),statusbar->cid);

  mid = gtk_statusbar_push(GTK_STATUSBAR(statusbar->widget),
			   statusbar->cid, msg);
}

void statusbar_message_state(statusbar_t *statusbar) {
  const char *state_msg[] = {
    "Game not running",
    "CPU selects ...",
    "Please place the tile",
    "Please select a tile",
    "CPU places ..."
  };
   
  g_assert(statusbar->game->state >= 0);
  g_assert(statusbar->game->state < sizeof(state_msg)/sizeof(char*));

  message(statusbar, state_msg[statusbar->game->state]);
}

static gboolean
cb_statusbar_message_state(GtkWidget *widget, gpointer data) {  
  statusbar_message_state((statusbar_t*)data);
  return TRUE;
}

GtkWidget *statusbar_create(statusbar_t *statusbar, 
			    game_state_t *game, HildonWindow *window) {
  statusbar->game = game;
  statusbar->window = window;
  statusbar->widget = gtk_statusbar_new();
  statusbar->cid = gtk_statusbar_get_context_id(
			GTK_STATUSBAR(statusbar->widget), "Msg");

  g_signal_new("statusbar_message_state", GTK_TYPE_WINDOW, 
	       (GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
	       0,  // class offset
	       NULL, NULL,  // accu
	       g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0 );
  
  g_signal_connect(G_OBJECT(statusbar->window), "statusbar_message_state",
  		   G_CALLBACK(cb_statusbar_message_state), statusbar);

  statusbar_message_state(statusbar);

  return statusbar->widget;
}
