#ifndef STACK_H
#define STACK_H

#include <hildon/hildon-program.h>
#include "game.h"
#include "selected.h"
#include "tileset.h"

#define STACK_WIDTH  4
#define STACK_HEIGHT 4

/* this structure contains everything to handle the tile stack gui */
typedef struct {
  HildonWindow *window;
  GtkWidget *item[16];
  tileset_t *tileset;
  game_state_t *game;
  selected_t *selected;
} stack_t;

extern GtkWidget *stack_create_gui(stack_t *stack, tileset_t *tileset, 
				   game_state_t *game, HildonWindow *window,
				   selected_t *selected);
extern void stack2selected(stack_t *stack, int item);
extern void stack_update(stack_t *stack);


#endif // STACK_H
