/*
 * selected.c
 */

#include <gtk/gtk.h>

#include "selected.h"

GtkWidget *selected_create_gui(selected_t *selected, tileset_t *tileset,
			       game_state_t *game) {
  GtkWidget *frame;
  GdkPixbuf *pixbuf;

  frame = gtk_frame_new(" Selected ");

  /* selected->tile has already been set by gconf_load */
  pixbuf = gtk_image_get_pixbuf(tileset->empty);

  selected->tileset = tileset;
  selected->game = game;
  gtk_container_add(GTK_CONTAINER(frame), 
		    (selected->item = gtk_image_new_from_pixbuf(pixbuf)));

  return frame;
}

void selected_remove(selected_t *selected) {
  /* remove "selected" */
  GtkWidget *parent = selected->item->parent;
  gtk_widget_destroy(selected->item);
  
  /* ... and replace with tile */
  GdkPixbuf *pixbuf = gtk_image_get_pixbuf(selected->tileset->empty);
  
  gtk_container_add(GTK_CONTAINER(parent), 
	    (selected->item = gtk_image_new_from_pixbuf(pixbuf)));

  gtk_widget_show_all(GTK_WIDGET(selected->item));

  selected->tile = LOC_EMPTY;
}

void selected_add(selected_t *selected, int item) {

  /* remove empty tile from "selected" ... */
  GtkWidget *parent = selected->item->parent;
  gtk_widget_destroy(selected->item);

  /* ... and replace with tile */
  GdkPixbuf *pixbuf = gtk_image_get_pixbuf(selected->tileset->tile[item]);

  gtk_container_add(GTK_CONTAINER(parent), 
	  (selected->item = gtk_image_new_from_pixbuf(pixbuf)));

  gtk_widget_show_all(GTK_WIDGET(selected->item));

  selected->tile = item;
}
