#ifndef APPDATA_H
#define APPDATA_H

#include <hildon/hildon-program.h>
#include <gconf/gconf-client.h>
#include <libosso.h>

#include "tileset.h"
#include "selected.h"
#include "stack.h"
#include "statusbar.h"

/* this structure contains everything to handle the appdata gui */
typedef struct {
  /* application global stuff */
  HildonProgram *program;
  HildonWindow *window;
  GConfClient *gconf_client;

  /* part specific stuff */
  game_state_t *game;
  tileset_t *tileset;
  selected_t *selected;
  stack_t *stack;
  statusbar_t *statusbar;
} appdata_t;

#endif //APPDATA_H
