#include "test.h"

int main() {
    {
        TEST_INFO (Test string assignement shares string);
        String s ("foo");
        String t = s;
        TEST_VERIFY (t == "foo" );
        TEST_VERIFY ((const char *)s == (const char *)t );
    }
    {
        TEST_INFO (Test String::append);
        String s ("foo");
        s.append (" bar", 4);
        TEST_VERIFY (s == "foo bar" );
        s.append ("some dummy text", 0);
        TEST_VERIFY (s == "foo bar" );
    }
    {
        TEST_INFO (Test String::stripWhiteSpace);
        TEST_VERIFY (String ("").isEmpty () );
        TEST_VERIFY (String ("   foo   bar  ").stripWhiteSpace () == "foo   bar" );
        TEST_VERIFY (String ("foo   bar").stripWhiteSpace () == "foo   bar" );
        TEST_VERIFY (String ("f     ").stripWhiteSpace () == "f" );
        TEST_VERIFY (String (" f    ").stripWhiteSpace () == "f" );
        TEST_VERIFY (String ("     r").stripWhiteSpace () == "r" );
        TEST_VERIFY (String ("    r ").stripWhiteSpace () == "r" );
        TEST_VERIFY (String ("   f   r  ").stripWhiteSpace () == "f   r" );
    }
    return 0;
}
