#!/usr/bin/env python2.5
#
# This file is part of isearch-edit, a tool to create and edit
# files for the maemo internet search applet
#
# (c) 2007-2008 Thomas Schmidt <tschmidt@debian.org>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This code is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with isearch-edit. If not, see <http://www.gnu.org/licenses/>.
#

import xml.dom.minidom, xml.dom.ext

from xml.dom.minidom import Node, getDOMImplementation

class Mis:
    def __init__(self,
                name        = None,
                action      = None,
                inputs      = [],
                userinput   = None,
                icon        = None,
                filename    = None,
                edited      = False
        ):

        self.name       = name
        self.action     = action
        self.inputs     = inputs
        self.userinput  = userinput
        self.icon       = icon
        self.filename   = filename
        self.edited     = edited

    def __str__(self):
        return "instance of class Mis <name: %s, action: %s, inputs: %s, userinput: %s, icon: %s, filename: %s, edited: %s" % (
                    self.name, self.action, self.inputs, self.userinput, self.icon, self.filename, self.edited
                )

def file_to_mis(filename):
    name        = None
    action      = None
    inputs      = []
    userinput   = None
    icon        = None

    try:
        misxml  = xml.dom.minidom.parse(filename)

        for node in misxml.getElementsByTagName("search"):
            name        = node.getAttribute("name")
            icon        = node.getAttribute("icon")
            action      = node.getAttribute("action")
            userinput   = node.getAttribute("user-input")

            L = node.getElementsByTagName("input")
            for node2 in L:
              inputname   = node2.getAttribute("name")
              inputvalue  = node2.getAttribute("value")
              inputs.append((inputname, inputvalue))
    except IOError, msg:
        print "IOError occurred: %s" % msg

    return Mis(name=name, action=action, inputs=inputs, userinput=userinput, icon=icon, filename=filename)

def mis_to_url(mis):
    url = mis.action + '?' + mis.userinput + '=%s'

    for input in mis.inputs:
      inputname   = input[0]
      inputvalue  = input[1]
      url += "&" + inputname + "=" + inputvalue

    return url

def url_to_mis(url):
    action      = None
    inputs      = []
    userinput   = None

    temp    = url.split('?')
    action  = temp[0]

    arguments   = temp[1]
    parameters  = arguments.split('&')

    for input in parameters:
        input_tmp   = input.split('=')
        inputname   = input_tmp[0]
        inputvalue  = input_tmp[1]

        if inputvalue.find('%s') != -1:
            userinput = inputname
        else:
            inputs.append((inputname, inputvalue))

    return Mis(action=action, inputs=inputs, userinput=userinput)

def mis_to_xml(mis):
    impl    = xml.dom.minidom.getDOMImplementation()
    misxml  = impl.createDocument(None, "search", None)

    top_element = misxml.documentElement

    if mis.name:
      top_element.setAttribute("name", mis.name)
    if mis.icon:
      top_element.setAttribute("icon", mis.icon)
    if mis.action:
      top_element.setAttribute("action", mis.action)
    if mis.userinput:
      top_element.setAttribute("user-input", mis.userinput)

    for input in mis.inputs:
      name  = input[0]
      value = input[1]
      child = misxml.createElement("input")

      child.setAttribute("name", name)
      child.setAttribute("value", value)
      top_element.appendChild(child)

    return misxml.toprettyxml()

def main():
    import os
    mis    = Mis(name="Test", action="http://www.blabla.de", inputs=[("abc", "bla"), ("test", "0")], userinput="q", icon="/dev/null")
    misxml = mis_to_xml(mis)
    #print misxml

    file = open(filename, 'w').write(misxml)

    #url = mis_to_url(mis)
    #print "url: %s" % url

    #mis2 = url_to_mis(url)
    #print "mis2: %s" % mis2

    #filename    = "/usr/share/mis/google-search.xml"
    #new_mis     = file_to_mis(filename)
    #print "new mis: %s" % new_mis

    #misdir = "/usr/share/mis"

    #for filename in os.listdir(misdir):
    #    mis   = file_to_mis(os.path.join(misdir, filename))
    #    url   = mis_to_url(mis)
    #    print "mis: %s\turl: %s" % (mis.name, url)

    return 0

if __name__ == "__main__":
    import sys
    sys.exit(main())

# vim: set expandtab tabstop=2 shiftwidth=4 autoindent smartindent foldmethod=indent:
