
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <hildonmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "calendar-popup.h"
#include "color-button.h"
#include "controlbar.h"
#include "date-editor.h"
#include "font-selection-dialog.h"
#include "get-password-dialog.h"
#include "hvolumebar.h"
#include "login-dialog.h"
#include "note.h"
#include "number-editor.h"
#include "range-editor.h"
#include "seekbar.h"
#include "set-password-dialog.h"
#include "sort-dialog.h"
#include "time-editor.h"
#include "time-picker.h"
#include "volumebar.h"
#include "vvolumebar.h"
#include "weekday-picker.h"
#include "wizard-dialog.h"
#include "window.h"
#include "caption.h"
#include "find-toolbar.h"
#include "program.h"
#include "banner.h"
#include "code-dialog.h"
#include "color-chooser-dialog.h"
#include "color-chooser.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType hildon_banner_get_type(void);
GType hildon_calendar_popup_get_type(void);
GType hildon_caption_get_type(void);
GType hildon_code_dialog_get_type(void);
GType hildon_color_button_get_type(void);
GType hildon_color_chooser_get_type(void);
GType hildon_color_chooser_dialog_get_type(void);
GType hildon_controlbar_get_type(void);
GType hildon_date_editor_get_type(void);
GType hildon_find_toolbar_get_type(void);
GType hildon_font_selection_dialog_get_type(void);
GType hildon_get_password_dialog_get_type(void);
GType hildon_hvolumebar_get_type(void);
GType hildon_login_dialog_get_type(void);
GType hildon_note_get_type(void);
GType hildon_number_editor_get_type(void);
GType hildon_program_get_type(void);
GType hildon_range_editor_get_type(void);
GType hildon_seekbar_get_type(void);
GType hildon_set_password_dialog_get_type(void);
GType hildon_sort_dialog_get_type(void);
GType hildon_time_editor_get_type(void);
GType hildon_time_picker_get_type(void);
GType hildon_vvolumebar_get_type(void);
GType hildon_volumebar_get_type(void);
GType hildon_weekday_picker_get_type(void);
GType hildon_window_get_type(void);
GType hildon_wizard_dialog_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Hildon {  class Banner_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class CalendarPopup_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Caption_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class CodeDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class ColorButton_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class ColorChooser_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class ColorChooserDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Controlbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class DateEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FindToolbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FontSelectionDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class GetPasswordDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class HVolumebar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class LoginDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Note_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class NumberEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Program_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class RangeEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Seekbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class SetPasswordDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class SortDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TimeEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TimePicker_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class VVolumebar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Volumebar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class WeekdayPicker_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Window_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class WizardDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Hildon { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(hildon_banner_get_type(), &Hildon::Banner_Class::wrap_new);
  Glib::wrap_register(hildon_calendar_popup_get_type(), &Hildon::CalendarPopup_Class::wrap_new);
  Glib::wrap_register(hildon_caption_get_type(), &Hildon::Caption_Class::wrap_new);
  Glib::wrap_register(hildon_code_dialog_get_type(), &Hildon::CodeDialog_Class::wrap_new);
  Glib::wrap_register(hildon_color_button_get_type(), &Hildon::ColorButton_Class::wrap_new);
  Glib::wrap_register(hildon_color_chooser_get_type(), &Hildon::ColorChooser_Class::wrap_new);
  Glib::wrap_register(hildon_color_chooser_dialog_get_type(), &Hildon::ColorChooserDialog_Class::wrap_new);
  Glib::wrap_register(hildon_controlbar_get_type(), &Hildon::Controlbar_Class::wrap_new);
  Glib::wrap_register(hildon_date_editor_get_type(), &Hildon::DateEditor_Class::wrap_new);
  Glib::wrap_register(hildon_find_toolbar_get_type(), &Hildon::FindToolbar_Class::wrap_new);
  Glib::wrap_register(hildon_font_selection_dialog_get_type(), &Hildon::FontSelectionDialog_Class::wrap_new);
  Glib::wrap_register(hildon_get_password_dialog_get_type(), &Hildon::GetPasswordDialog_Class::wrap_new);
  Glib::wrap_register(hildon_hvolumebar_get_type(), &Hildon::HVolumebar_Class::wrap_new);
  Glib::wrap_register(hildon_login_dialog_get_type(), &Hildon::LoginDialog_Class::wrap_new);
  Glib::wrap_register(hildon_note_get_type(), &Hildon::Note_Class::wrap_new);
  Glib::wrap_register(hildon_number_editor_get_type(), &Hildon::NumberEditor_Class::wrap_new);
  Glib::wrap_register(hildon_program_get_type(), &Hildon::Program_Class::wrap_new);
  Glib::wrap_register(hildon_range_editor_get_type(), &Hildon::RangeEditor_Class::wrap_new);
  Glib::wrap_register(hildon_seekbar_get_type(), &Hildon::Seekbar_Class::wrap_new);
  Glib::wrap_register(hildon_set_password_dialog_get_type(), &Hildon::SetPasswordDialog_Class::wrap_new);
  Glib::wrap_register(hildon_sort_dialog_get_type(), &Hildon::SortDialog_Class::wrap_new);
  Glib::wrap_register(hildon_time_editor_get_type(), &Hildon::TimeEditor_Class::wrap_new);
  Glib::wrap_register(hildon_time_picker_get_type(), &Hildon::TimePicker_Class::wrap_new);
  Glib::wrap_register(hildon_vvolumebar_get_type(), &Hildon::VVolumebar_Class::wrap_new);
  Glib::wrap_register(hildon_volumebar_get_type(), &Hildon::Volumebar_Class::wrap_new);
  Glib::wrap_register(hildon_weekday_picker_get_type(), &Hildon::WeekdayPicker_Class::wrap_new);
  Glib::wrap_register(hildon_window_get_type(), &Hildon::Window_Class::wrap_new);
  Glib::wrap_register(hildon_wizard_dialog_get_type(), &Hildon::WizardDialog_Class::wrap_new);

  // Register the gtkmm gtypes:
  Hildon::Banner::get_type();
  Hildon::CalendarPopup::get_type();
  Hildon::Caption::get_type();
  Hildon::CodeDialog::get_type();
  Hildon::ColorButton::get_type();
  Hildon::ColorChooser::get_type();
  Hildon::ColorChooserDialog::get_type();
  Hildon::Controlbar::get_type();
  Hildon::DateEditor::get_type();
  Hildon::FindToolbar::get_type();
  Hildon::FontSelectionDialog::get_type();
  Hildon::GetPasswordDialog::get_type();
  Hildon::HVolumebar::get_type();
  Hildon::LoginDialog::get_type();
  Hildon::Note::get_type();
  Hildon::NumberEditor::get_type();
  Hildon::Program::get_type();
  Hildon::RangeEditor::get_type();
  Hildon::Seekbar::get_type();
  Hildon::SetPasswordDialog::get_type();
  Hildon::SortDialog::get_type();
  Hildon::TimeEditor::get_type();
  Hildon::TimePicker::get_type();
  Hildon::VVolumebar::get_type();
  Hildon::Volumebar::get_type();
  Hildon::WeekdayPicker::get_type();
  Hildon::Window::get_type();
  Hildon::WizardDialog::get_type();

} // wrap_init()

} //Hildon


