// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_RANGE_EDITOR_H
#define _HILDONMM_RANGE_EDITOR_H


#include <glibmm.h>

/* $Id: number-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* range-editor.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonRangeEditor HildonRangeEditor;
typedef struct _HildonRangeEditorClass HildonRangeEditorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class RangeEditor_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::RangeEditor allows the user to enter a pair of integers, such as the lower
 * and higher bounds of a range. A minimum and maximum can also be set for the bounds.
 *
 * @ingroup HildonWidgets
 */

class RangeEditor : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef RangeEditor CppObjectType;
  typedef RangeEditor_Class CppClassType;
  typedef HildonRangeEditor BaseObjectType;
  typedef HildonRangeEditorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~RangeEditor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class RangeEditor_Class;
  static CppClassType rangeeditor_class_;

  // noncopyable
  RangeEditor(const RangeEditor&);
  RangeEditor& operator=(const RangeEditor&);

protected:
  explicit RangeEditor(const Glib::ConstructParams& construct_params);
  explicit RangeEditor(HildonRangeEditor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonRangeEditor*       gobj()       { return reinterpret_cast<HildonRangeEditor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonRangeEditor* gobj() const { return reinterpret_cast<HildonRangeEditor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  RangeEditor();
  
  explicit RangeEditor(const Glib::ustring& separator);

  
  /** Sets a range to the editor. (The current value)
   * 
   * Sets the range of the @a HildonRangeEditor  widget.
   * @param start Range's start value.
   * @param end Range's end value.
   */
  void set_range(int start, int end);
  
  /** Gets the range of the @a HildonRangeEditor  widget.
   * @param start Ranges start value.
   * @param end Ranges end value.
   */
  void get_range(int& start, int& end) const;
  
  /** Sets the range of the @a HildonRangeEditor  widget.
   * @param start Minimum acceptable value (default: no limit).
   * @param end Maximum acceptable value (default: no limit).
   */
  void set_limits(int start, int end);

  
  void set_lower(int value);
  
  void set_higher(int value);
  
  int get_lower() const;
  
  int get_higher() const;
  
  void set_min (int value);
  
  void set_max (int value);
  
  int get_min() const;
  
  int get_max() const;
  
  void set_separator(const Glib::ustring& separator);
  
  Glib::ustring get_separator() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum value in a range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_min() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum value in a range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_min() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum value in a range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum value in a range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value in the entry presenting lower end of selected range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_lower() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value in the entry presenting lower end of selected range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_lower() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value in the entry presenting higher end of selected range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_higher() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current value in the entry presenting higher end of selected range.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_higher() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Separator string to separate entries.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_separator() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Separator string to separate entries.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_separator() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::RangeEditor
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::RangeEditor* wrap(HildonRangeEditor* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_RANGE_EDITOR_H */

