// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_COLOR_CHOOSER_H
#define _HILDONMM_COLOR_CHOOSER_H


#include <glibmm.h>

/* $Id: color-chooser-dialog.hg,v 1.10 2006/22/9 10:52:44 murrayc Exp $ */

/* color-chooser-dialog.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonColorChooser HildonColorChooser;
typedef struct _HildonColorChooserClass HildonColorChooserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class ColorChooser_Class; } // namespace Hildon
namespace Hildon
{

/** A widget used to select a color from an HSV colorspace.
 * 
 * @ingroup HildonWidgets
 */

class ColorChooser : public Gtk::Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ColorChooser CppObjectType;
  typedef ColorChooser_Class CppClassType;
  typedef HildonColorChooser BaseObjectType;
  typedef HildonColorChooserClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ColorChooser();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ColorChooser_Class;
  static CppClassType colorchooser_class_;

  // noncopyable
  ColorChooser(const ColorChooser&);
  ColorChooser& operator=(const ColorChooser&);

protected:
  explicit ColorChooser(const Glib::ConstructParams& construct_params);
  explicit ColorChooser(HildonColorChooser* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonColorChooser*       gobj()       { return reinterpret_cast<HildonColorChooser*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonColorChooser* gobj() const { return reinterpret_cast<HildonColorChooser*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_color_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

	
public:
  ColorChooser();

  
  /** Sets the color selected in the widget.
   * Will move the crosshair pointer to indicate the passed color.
   * @param color A color to be set.
   */
  void set_color (const Gdk::Color& color);
  
  /** Retrives the currently selected color in the chooser.
   * @param color A color structure to fill with the currently selected color.
   */

  Gdk::Color get_color() const;
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
   /**
   * @par Prototype:
   * <tt>void %color_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_color_changed();
;


};

} //namespace Hildon


namespace Glib
{
  /** @relates Hildon::ColorChooser
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::ColorChooser* wrap(HildonColorChooser* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_COLOR_CHOOSER_H */

