// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_COLOR_BUTTON_H
#define _HILDONMM_COLOR_BUTTON_H


#include <glibmm.h>

/* $Id: add-home-dialog.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* color-button.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/button.h>
#include <hildonmm/color-chooser-dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonColorButton HildonColorButton;
typedef struct _HildonColorButtonClass HildonColorButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class ColorButton_Class; } // namespace Hildon
namespace Hildon
{

/** @defgroup HildonButtons Buttons
 */

/** Hildon::ColorButton is a widget to open a Hildon::ColorSelector dialog. 
 * The selected color is shown in the button and is a property of the button.
 *
 * @ingroup HildonButtons
 * @ingroup HildonWidgets
 */

class ColorButton : public Gtk::Button
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ColorButton CppObjectType;
  typedef ColorButton_Class CppClassType;
  typedef HildonColorButton BaseObjectType;
  typedef HildonColorButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ColorButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ColorButton_Class;
  static CppClassType colorbutton_class_;

  // noncopyable
  ColorButton(const ColorButton&);
  ColorButton& operator=(const ColorButton&);

protected:
  explicit ColorButton(const Glib::ConstructParams& construct_params);
  explicit ColorButton(HildonColorButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonColorButton*       gobj()       { return reinterpret_cast<HildonColorButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonColorButton* gobj() const { return reinterpret_cast<HildonColorButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  ColorButton();
  

  explicit ColorButton(const Gdk::Color& color);
  
  Gdk::Color get_color() const;
  

  /** Sets the color selected by the button.
   * @param color A color to be set.
   */
  void set_color(const Gdk::Color& color);
  
  /** This function checks if the color button has the color 
   * selection dialog currently popped-up.
   * @return <tt>true</tt> if the dialog is popped-up (visible to user).
   */
  bool get_popup_shown() const;
  
  /** If the color selection dialog is currently popped-up (visible)
   * it will be popped-down (hidden).
   */
  void popdown();

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If the color selection dialog is popped up.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_popup_shown() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /* no_default_handler is used to avoid ABI break */
  
   /**
   * @par Prototype:
   * <tt>void %setup_dialog(ColorChooserDialog* dialog)</tt>
   */

  Glib::SignalProxy1< void,ColorChooserDialog* > signal_setup_dialog();


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::ColorButton
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::ColorButton* wrap(HildonColorButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_COLOR_BUTTON_H */

