// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_BANNER_H
#define _HILDONMM_BANNER_H


#include <glibmm.h>

/* $Id: banner.hg,v 1.10 2006/22/9 10:52:44 murrayc Exp $ */

/* banner.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/window.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/label.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonBanner HildonBanner;
typedef struct _HildonBannerClass HildonBannerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Banner_Class; } // namespace Hildon
namespace Hildon
{

/** @defgroup HildonWidgets Widgets
 */

/** The Hildon::Banners are used in many places in the Maemo applications. 
 * They show a small information banner in the top right corner of the application view 
 * for a few seconds and then disappear automatically. They are used for all kinds of 
 * notifications, such as "File Saved", "Unable to make connection" or "Choose one option only".
 * 
 * There are multiple static methods to choose, depending on the information you want to show. 
 * The banner can show the user plain text, a custom icon, or a progress bar. 
 *
 * @ingroup HildonWidgets
 */

class Banner : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Banner CppObjectType;
  typedef Banner_Class CppClassType;
  typedef HildonBanner BaseObjectType;
  typedef HildonBannerClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Banner();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Banner_Class;
  static CppClassType banner_class_;

  // noncopyable
  Banner(const Banner&);
  Banner& operator=(const Banner&);

protected:
  explicit Banner(const Glib::ConstructParams& construct_params);
  explicit Banner(HildonBanner* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonBanner*       gobj()       { return reinterpret_cast<HildonBanner*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonBanner* gobj() const { return reinterpret_cast<HildonBanner*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
protected:
  Banner();
	
public:
  
  /** This function creates and displays an information banner that
   * automatically goes away after certain time period. For each window
   * in your application there can only be one timed banner, so if you
   * spawn a new banner before the earlier one has timed out, the
   * previous one will be replaced.
   * @param widget The Gtk::Widget that is the owner of the banner.
   * @param icon_name The name of icon to use. Can be <tt>0</tt> for default icon.
   * @param text Text to display.
   * @return The newly created banner.
   */

  static void show_information(Gtk::Widget& widget, const Glib::ustring& icon_name, const Glib::ustring& text);

  /** This function creates and displays an information banner that
   * automatically goes away after a certain time period. For each window
   * in your application there can only be one timed banner, so if you
   * spawn a new banner before the earlier one has timed out, the
   * previous one will be replaced.
   *
   * @param widget The widget that wants to display a banner.
   * @param text The name of the icon to use.
   */
  static void show_information(Gtk::Widget& widget, const Glib::ustring& text);

  
  /** This function creates and displays an information banner that
   * automatically goes away after certain time period. For each window
   * in your application there can only be one timed banner, so if you
   * spawn a new banner before the earlier one has timed out, the
   * previous one will be replaced.
   * @param widget The Gtk::Widget that wants to display banner.
   * @param icon_name The name of icon to use. Can be <tt>0</tt> for default icon.
   * @param markup A markup string to display (see Pango markup format).
   * @return The newly created banner.
   */

  static void show_information_with_markup(Gtk::Widget& widget, const Glib::ustring& icon_name, const Glib::ustring& markup);

  /** This function creates and displays an information banner that
   * automatically goes away after a certain time period. For each window
   * in your application there can only be one timed banner, so if you
   * spawn a new banner before the earlier one has timed out, the
   * previous one will be replaced.
   *
   * @param widget The widget that wants to display a banner.
   * @param markup A markup string to display (see <a href="http://developer.gnome.org/doc/API/2.0/pango/PangoMarkupFormat.html">Pango markup format</a>)
   */
  static void show_information_with_markup(Gtk::Widget& widget, const Glib::ustring& markup);	
		
  
  /** Shows an animated progress notification. It's recommended not to try
   * to show more than one progress notification at a time, since
   * they will appear on top of each other. You can use progress
   * notifications with timed banners. In this case the banners are
   * located so that you can somehow see both.
   * 
   * Please note that banners are destroyed automatically once the
   * window they are attached to is closed. The pointer that you
   * receive with this function do not contain additional references,
   * so it can become invalid without warning (this is true for
   * all toplevel windows in gtk). To make sure that the banner do not disapear
   * automatically, you can separately ref the return value (this
   * doesn't prevent the banner from disappearing, but the object it just
   * not finalized). In this case you have to delete it manually.
   * @param widget The Gtk::Widget that wants to display banner.
   * @param animation_name The progress animation to use. You usually can just
   * pass <tt>0</tt> for the default animation.
   * @param text The text to display.
   * @return A Hildon::Banner widget. You must delete it
   * once you are ready with the banner.
   * 
   * Since: 0.12.2.
   */

  static Banner* show_animation(Gtk::Widget& widget, const Glib::ustring& animation_name, const Glib::ustring& text);

  /** Shows an animated progress notification. It's recommended not to try
   * to show more than one progress notification at a time, since
   * they will appear on top of each other. You can use progress
   * notifications with timed banners. In this case the banners are
   * located so that you can somehow see both.
   *
   * Please note that banners are destroyed automatically once the
   * window they are attached to is closed. The pointer that you
   * receive with this function does not contain additional references,
   * so it can become invalid without warning (this is true for
   * all toplevel windows in gtk).
   *
   * @param widget The widget that wants to display a banner.
   * @param text: the text to display.
   * @result A Hildon::Banner widget. You must call delete once you are finished with the banner.
   */
  static Banner* show_animation(Gtk::Widget& widget, const Glib::ustring& text);

  
  /** Shows progress notification. See #show_animation
   * for more information.
   * @param widget The Gtk::Widget that wants to display banner.
   * @param bar Progressbar to use. You usually can just pass <tt>0</tt>, unless
   * you want somehow customized progress bar.
   * @param text Text to display.
   * @return A Hildon::Banner widget. You must delete it when you do not need it any more.
   * 
   * Since: 0.12.2.
   */

  static Banner* show_progress(Gtk::Widget& widget, Gtk::ProgressBar& bar, const Glib::ustring& text);

  /** Shows progress notification. See show_animation() for more information.
   *
   * @param widget The widget that wants to display a banner.
   * @param text The text to display.
   * @result A Hildon::Banner widget. You must call delete once you are finished with the banner.
   */
  static Banner* show_progress(Gtk::Widget& widget, const Glib::ustring& text);
	
  
  /** Sets the text that is displayed in the banner.
   * @param text A new text to display in banner.
   */
  void set_text(const Glib::ustring& text);
  
  /** Sets the text with markup that is displayed in the banner.
   * @param markup A new text with Pango markup to display in the banner.
   */
  void set_markup(const Glib::ustring& markup);

  
  /** The fraction is the completion of progressbar, 
   * the scale is from 0.0 to 1.0.
   * Sets the amount of fraction the progressbar has.
   * 
   * Since: 0.12.2
   * @param fraction Double.
   */
  void set_fraction(double fraction);

  
  /** Sets the icon to be used in the banner.
   * @param icon_name The name of icon to use. Can be <tt>0</tt> for default icon.
   */
  void set_icon(const Glib::ustring& icon_name);
  
  /** Sets the icon from its filename to be used in the banner.
   * @param icon_file The filename of icon to use. Can be <tt>0</tt> for default icon.
   */
  void set_icon_from_file(const std::string& icon_file);
  
  /** Sets the timeout on the banner. After the given amount of miliseconds
   * has elapsed the banner will go away. Note that settings this only makes
   * sense on the banners that are timed and that have not been yet displayed
   * on the screen.
   * @param timeout Timeout to set in miliseconds.
   */
  void set_timeout(guint timeout);


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The window for which the banner will be singleton.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Window*> property_parent_window() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not the notification goes away automatically after the specified time has passed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_timed() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The time before making the banner banner go away.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::Banner
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::Banner* wrap(HildonBanner* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_BANNER_H */

