// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_SEEKBAR_H
#define _HILDONMM_SEEKBAR_H


#include <glibmm.h>

/* $Id: add-home-dialog.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* control-bar.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/scale.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonSeekbar HildonSeekbar;
typedef struct _HildonSeekbarClass HildonSeekbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Seekbar_Class; } // namespace Hildon
namespace Hildon
{

/** Hildon::Seekbar allows seeking in media with a range widget.  It
 * supports the setting or getting of the length (total time) of the media,
 * the position within it and the fraction (maximum position in a
 * stream/the amount currently downloaded).  The position is clamped
 * between zero and the total time, or zero and the fraction in case of
 * a stream.
 *
 * @ingroup HildonWidgets
 */

class Seekbar : public Gtk::Scale
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Seekbar CppObjectType;
  typedef Seekbar_Class CppClassType;
  typedef HildonSeekbar BaseObjectType;
  typedef HildonSeekbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Seekbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Seekbar_Class;
  static CppClassType seekbar_class_;

  // noncopyable
  Seekbar(const Seekbar&);
  Seekbar& operator=(const Seekbar&);

protected:
  explicit Seekbar(const Glib::ConstructParams& construct_params);
  explicit Seekbar(HildonSeekbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonSeekbar*       gobj()       { return reinterpret_cast<HildonSeekbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonSeekbar* gobj() const { return reinterpret_cast<HildonSeekbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Seekbar();
  

  /** 
   * @return Total playing time of media in seconds.
   */
  int get_total_time() const;
  
  /** Set total playing time of media in seconds.
   * @param time Integer greater than zero.
   */
  void set_total_time(int time);
  
  /** Get current position in stream in seconds.
   * @return Current position in stream in seconds.
   */
  int get_position() const;
  
  /** Set current position in stream in seconds.
   * @param time Time within range of &gt;= 0 && &lt; G_MAXINT.
   */
  void set_position(int time);
  
  /** Set current fraction value of the range.
   * It should be between the minimal and maximal values of the range in seekbar.
   * @param fraction The new position of the progress indicator.
   */
  void set_fraction(guint fraction);
  
  /** Get current fraction value of the rage.
   * @return Current fraction.
   */
  guint get_fraction() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Total playing time of this media file.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_total_time() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Total playing time of this media file.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_total_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current position in this media file.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current position in this media file.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** current fraction related to theprogress indicator.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_fraction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** current fraction related to theprogress indicator.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_fraction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::Seekbar
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::Seekbar* wrap(HildonSeekbar* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_SEEKBAR_H */

