// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_GET_PASSWORD_DIALOG_H
#define _HILDONMM_GET_PASSWORD_DIALOG_H


#include <glibmm.h>

/* $Id: file-details-dialog.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* get-password-dialog.h
 *
 * Copyright 2005-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonGetPasswordDialog HildonGetPasswordDialog;
typedef struct _HildonGetPasswordDialogClass HildonGetPasswordDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class GetPasswordDialog_Class; } // namespace Hildon
namespace Hildon
{

/** A widget used to get a password.
 *
 * Hildon::GetPasswordDialog prompts the user for a password, with 
 * an optional configurable label, for instance for showing the domain. 
 * The maximum length of the password can be set.
 *
 * @ingroup HildonDialogs
 */

class GetPasswordDialog : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef GetPasswordDialog CppObjectType;
  typedef GetPasswordDialog_Class CppClassType;
  typedef HildonGetPasswordDialog BaseObjectType;
  typedef HildonGetPasswordDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~GetPasswordDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class GetPasswordDialog_Class;
  static CppClassType getpassworddialog_class_;

  // noncopyable
  GetPasswordDialog(const GetPasswordDialog&);
  GetPasswordDialog& operator=(const GetPasswordDialog&);

protected:
  explicit GetPasswordDialog(const Glib::ConstructParams& construct_params);
  explicit GetPasswordDialog(HildonGetPasswordDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonGetPasswordDialog*       gobj()       { return reinterpret_cast<HildonGetPasswordDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonGetPasswordDialog* gobj() const { return reinterpret_cast<HildonGetPasswordDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  GetPasswordDialog(Gtk::Window& parent, bool get_old_password_title = true);
  explicit GetPasswordDialog(bool get_old_password_title = true);
  GetPasswordDialog(Gtk::Window& parent, const Glib::ustring& password, bool get_old_password_title = true);
  GetPasswordDialog(const Glib::ustring& password, bool get_old_password_title = true);
  

  /** Sets the optional descriptive text displayed at the top of the dialog.
   * @param message A custom message or some other descriptive text to be set.
   */
  void set_message(const Glib::ustring& message);
  
  /** Sets the password entry field's neigbouring label.
   * @param new_caption The text to be set as the caption label.
   */
  void set_caption(const Glib::ustring& new_caption);
  
  /** sets the maximum number of characters allowed as the password
   * @param max_characters The maximum number of characters the password dialog
   * accepts.
   */
  void set_max_characters(int max_characters);
  
  /** Gets the currently entered password. The string should not be freed.
   * @return Current password entered by the user.
   */
  Glib::ustring get_password() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set optional message.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_message() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set optional message.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_message() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Password field.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_password() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Password field.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_password() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set entry to accept only numeric values.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_numbers_only() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set entry to accept only numeric values.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_numbers_only() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to be set as the caption label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_caption_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to be set as the caption label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_caption_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The maximum number of characters the password dialog accepts.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_characters() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The maximum number of characters the password dialog accepts.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_characters() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if dialog is a get old password dialog
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_get_old() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::GetPasswordDialog
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::GetPasswordDialog* wrap(HildonGetPasswordDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_GET_PASSWORD_DIALOG_H */

