// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_FMMM_FILE_SYSTEM_MODEL_H
#define _HILDON_FMMM_FILE_SYSTEM_MODEL_H


#include <glibmm.h>

/* $Id: date-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* grid.h
 *
 * Copyright 2006-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treeiter.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treedragsource.h>
#include <glibmm/object.h>
// We couldn't include it in treemodel.h, but doing it here makes it easier for people.
#include <gtkmm/treepath.h>

#include <gtkmm/widget.h>
#include <hildon/hildon-file-system-common.h>

#include <hildon/hildon-file-system-model.h> //TODO: Remove this when bug #182 is fixed.


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class FileSystemModel_Class; } // namespace Hildon
namespace Hildon
{


//This is not a very reusable API because it is tightly-bound to the HildonFileSelection.
//However, the HildonFileSystemModel does suggest that HildonFileDetailsDialog can be used in applications,
//and that dialog needs this.

/** A tree model that contains file system data.
 *
 * @ingroup HildonFileSystem
 */

class FileSystemModel 
: public Glib::Object,
  public Gtk::TreeModel,
  public Gtk::TreeDragSource
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FileSystemModel CppObjectType;
  typedef FileSystemModel_Class CppClassType;
  typedef HildonFileSystemModel BaseObjectType;
  typedef HildonFileSystemModelClass BaseClassType;

private:  friend class FileSystemModel_Class;
  static CppClassType filesystemmodel_class_;

private:
  // noncopyable
  FileSystemModel(const FileSystemModel&);
  FileSystemModel& operator=(const FileSystemModel&);

protected:
  explicit FileSystemModel(const Glib::ConstructParams& construct_params);
  explicit FileSystemModel(HildonFileSystemModel* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FileSystemModel();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  HildonFileSystemModel*       gobj()       { return reinterpret_cast<HildonFileSystemModel*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const HildonFileSystemModel* gobj() const { return reinterpret_cast<HildonFileSystemModel*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  HildonFileSystemModel* gobj_copy();

private:

  
protected:
  //There is no hildon_file_system_model_new() function but the documentation for HildonFileSystemModel says that we must provide a ref_widget to g_object_new().
  explicit FileSystemModel(Gtk::Widget& ref_widget);

public:
  
  static Glib::RefPtr<FileSystemModel> create(Gtk::Widget& ref_widget);


   //TODO: Remove this when bug #182 is fixed.

  /** Searches the model for the given local path and returns an iterator pointing to it.
   * Note that the path must already exist in the model.
   *
   * @param path a file path to load.t.
   * @param recursive if false, only immediate children of the parent are searched. If true, this searches the entire subtree.
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not found.
   */
  Gtk::TreeModel::iterator search_local_path(const std::string& path, bool recursive = true) const;

  /** Searches the model for the given local path and returns an iterator pointing to it.
   * Note that the path must already exist in the model.
   *
   * @param path a file path to load.
   * @param start_iter An iterator indicating the starting point.
   * @param recursive if false, only immediate children of the parent are searched. If true, this searches the entire subtree.
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not found.
   */
  Gtk::TreeModel::iterator search_local_path(const std::string& path, const Gtk::TreeModel::iterator& start_iter, bool recursive = true) const;
  

  /** Searches the model for the given URI and returns an iterator pointing to it.
   * Note that the path must already exist in the model.
   *
   * @param uri a URI to load.
   * @param recursive if false, only immediate children of the parent are searched. If true, this searches the entire subtree.
   *
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not found.
   */
  Gtk::TreeModel::iterator search_uri(const Glib::ustring& uri, bool recursive = true) const;

  /** Searches the model for the given URI and returns an iterator pointing to it.
   * Note that the path must already exist in the model.
   *
   * @param uri a URI to load.
   * @param start_iter An iterator indicating the starting point.
   * @param recursive if false, only immediate children of the parent are searched. If true, this searches the entire subtree.
   *
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not found.
   */
  Gtk::TreeModel::iterator search_uri(const Glib::ustring& uri, const Gtk::TreeModel::iterator& start_iter, bool recursive = true) const;
  

  /** Searches the model for given path and returns an iterator pointing to it.
   * Note that the path must already exist in the model.
   *
   * @param path A file path to load.
   * @param recursive if false, only immediate children of the parent are searched. If true, this searches the entire subtree.
   *
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not found.
   */
  Gtk::TreeModel::iterator search_path(const std::string& path, bool recursive = true) const;

  /** Searches the model for given path and returns an iterator pointing to it.
   * Note that the path must already exist in the model.
   *
   * @param path A file path to load.
   * @param start_iter An iterator indicating the starting point.
   * @param recursive if false, only immediate children of the parent are searched. If true, this searches the entire subtree.
   *
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not found.
   */
  Gtk::TreeModel::iterator search_path(const std::string& path, const Gtk::TreeModel::iterator& start_iter, bool recursive = true) const;
  

  /** Loads a local path.
   *
   * @param path A path to load.
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not loaded.
   */
  Gtk::TreeModel::iterator load_local_path(const std::string& path);
  

  /** Loads a URI.
   *
   * @param uri A URI to load.
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not loaded.
   */
  Gtk::TreeModel::iterator load_uri(const Glib::ustring& uri);
  

  /** This method locates the given path from the data model. New branches are
   * loaded if the given path doesn't exist in memory. This method is otherwise similar to
   * search_path().
   *
   * @param path A file path to load.
   * @result A valid iterator to the desired file, or an invalid iterator if the file was not loaded.
   */
  Gtk::TreeModel::iterator load_path(const std::string& path);
  

  /** Creates a new unique name under @a parent . The returned name can be used
   * when creating a new file. If there are no name collisions, stub name
   * will be the final name. If a file with that name already exists, then
   * a number is appended to stub. This function is mainly used by dialog
   * implementations. It's probably not needed in application development.
   * @param parent A parent iterator.
   * @param stub_name A boby of the new name.
   * @param extension Extension of the new name.
   * @return A New unique name. Can be empty if the directory is not yet loaded.
   */
  Glib::ustring new_item(const Gtk::TreeModel::iterator& parent, const Glib::ustring& stub_name, const Glib::ustring& extension);

  
  /** This function checks if the given URI already exists in the model.
   * if not, then a copy of it is returned unmodified. If the URI already
   * exists then a number is added in a form file://file(2).html.
   * @param uri An URI to be autonamed.
   * @param error A GError to hold possible error information.
   * @return Either the same uri given as parameter or a modified
   * uri that contains proper index number. Can be empty in case
   * an error occured.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring autoname_uri(const Glib::ustring& uri) const;
#else
  Glib::ustring autoname_uri(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


//This method changes the model. The iterator is not meant to be an output parameter.
//We have renamed it from iter_available to set_iter_available() to make that clearer.
  
  /** This function sets some paths available/not available. Locations
   * that are not available are usually shown dimmed in the gui. This
   * function can be used if program needs for some reason to disable some
   * locations. By default all paths are available.
   * @param iter A Gtk::TreeIter to location to modify.
   * @param available New availability state.
   */
  void set_iter_available(const Gtk::TreeModel::iterator& iter, bool available);

  
  /** Cancels all changes made by #set_iter_available.
   * Selection is back to it's default state.
   */
  void reset_available();

   // deprecated


   /**
   * @par Prototype:
   * <tt>void %finished_loading(const Gtk::TreeModel::iterator& iter)</tt>
   */

  Glib::SignalProxy1< void,const Gtk::TreeModel::iterator& > signal_finished_loading();

  
   /**
   * @par Prototype:
   * <tt>void %device_disconnected(const Gtk::TreeModel::iterator& iter)</tt>
   */

  Glib::SignalProxy1< void,const Gtk::TreeModel::iterator& > signal_device_disconnected();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set GtkFileSystem backend to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_backend() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //GtkFileSystem is private API: _WRAP_PROPERTY("backend-object", GtkFileSystem*)
  //_WRAP_PROPERTY("thumbnail-callback", pointer) //Horrible function pointer thing. Let's not wrap this. murrayc.
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Any widget on the screen. Needed if you want icons.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Widget*> property_ref_widget() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Any widget on the screen. Needed if you want icons.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Widget*> property_ref_widget() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Specify an alternative root directory. Note thatgateway and MMCs appear ONLY if you leavethis to default setting.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_root_dir() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When multiple root directories is enabled
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_multi_root() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_finished_loading(const Gtk::TreeModel::iterator& iter);
  virtual void on_device_disconnected(const Gtk::TreeModel::iterator& iter);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::FileSystemModel
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Hildon::FileSystemModel> wrap(HildonFileSystemModel* object, bool take_copy = false);
}


#endif /* _HILDON_FMMM_FILE_SYSTEM_MODEL_H */

