// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_FMMM_FILE_CHOOSER_DIALOG_H
#define _HILDON_FMMM_FILE_CHOOSER_DIALOG_H


#include <glibmm.h>

/* $Id: date-editor.hg,v 1.10 2005/02/15 10:52:44 murrayc Exp $ */

/* grid.h
 *
 * Copyright 2006-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>
#include <gtkmm/filechooser.h>
#include <hildon-fmmm/file-selection.h>
#include <hildon-fmmm/file-system-model.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonFileChooserDialog HildonFileChooserDialog;
typedef struct _HildonFileChooserDialogClass HildonFileChooserDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class FileChooserDialog_Class; } // namespace Hildon
namespace Hildon
{

/** @defgroup HildonDialogs Dialogs
 */

/** @defgroup HildonFileSystem FileSystem
 */

/** The Hildon::FileChooserDialog is a dialog used to save and open user files. 
 * Since it is based on the Gtk::FileChooser, the API is similar to the one used in GTK+/gtkmm.
 * For instance, you can use get_filename() from the Gtk::FileChooser base class.
 *
 * The Hildon::FileChooserDialog is usually opened by the signal handler of the Open or Save menu entries or 
 * toolbar buttons.
 *
 * @ingroup HildonDialogs
 * @ingroup HildonFileSystem
 */

class FileChooserDialog 
  : public Gtk::Dialog,
    public Gtk::FileChooser
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileChooserDialog CppObjectType;
  typedef FileChooserDialog_Class CppClassType;
  typedef HildonFileChooserDialog BaseObjectType;
  typedef HildonFileChooserDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FileChooserDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FileChooserDialog_Class;
  static CppClassType filechooserdialog_class_;

  // noncopyable
  FileChooserDialog(const FileChooserDialog&);
  FileChooserDialog& operator=(const FileChooserDialog&);

protected:
  explicit FileChooserDialog(const Glib::ConstructParams& construct_params);
  explicit FileChooserDialog(HildonFileChooserDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonFileChooserDialog*       gobj()       { return reinterpret_cast<HildonFileChooserDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonFileChooserDialog* gobj() const { return reinterpret_cast<HildonFileChooserDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  explicit FileChooserDialog(Gtk::FileChooserAction action);
  explicit FileChooserDialog(Gtk::Window& parent, Gtk::FileChooserAction action);
  

  //TODO:
  /* GtkWidget *hildon_file_chooser_dialog_new_with_properties(GtkWindow *
                                                          parent,
                                                          const Glib::ustring& 
                                                          first_property,
                                                          ...);
  */

  
  void focus_to_input();

  
  /** Sets a safe folder that is used as a fallback in a case
   * that automatic location change fails.
   * @param local_path A path to safe folder.
   */
  void set_safe_folder(const Glib::ustring& local_path);
  
  /** See #set_safe_folder.
   * @param uri An uri to safe folder.
   */
  void set_safe_folder_uri(const Glib::ustring& uri);
  
  /** Gets safe folder location as local path.
   * @return A local path.
   */
  Glib::ustring get_safe_folder() const;
  
  /** Gets safe folder location as uri.
   * @return An uri.
   */
  Glib::ustring get_safe_folder_uri() const;

  
  void set_show_upnp(bool value);
  
  bool get_show_upnp() const;

  
  void add_extra(Gtk::Widget& widget);

   
  Gtk::Widget* add_extensions_combo(const Glib::StringArrayHandle& extensions, const Glib::StringArrayHandle& ext_names);

  
  std::string get_extension() const;

  //This extra conversion is necessary because the C API (currently) uses a non-const char* parameter:
   

  void set_extension(const std::string& extension);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** String to use when selected folder is empty.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_empty_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** String to use when selected folder is empty.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_empty_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Tell the file chooser to use existing model instead of creating a new one.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileSystemModel> > property_file_system_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the folder button should be visible (if it's possible).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_folder_button() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the folder button should be visible (if it's possible).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_folder_button() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the location information should be visible (if it's possible).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_location() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the location information should be visible (if it's possible).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_location() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text set to name entry should be automatically appended by a counter when the given name already exists.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_autonaming() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text set to name entry should be automatically appended by a counter when the given name already exists.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_autonaming() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** String to use in leftmost (=open) button.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_open_button_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** String to use in leftmost (=open) button.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_open_button_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text to be displayed in items field when saving multiple files.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_save_multiple() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Text to be displayed in items field when saving multiple files.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_save_multiple() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of an individual file/folder name when entered by user. Note that the actual limit can be smaller
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_name_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of an individual file/folder name when entered by user. Note that the actual limit can be smaller
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_name_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of the whole path of an individual file/folder name when entered by user. Use -1 for no limit or 0 to look the value from MAX_FILENAME_LENGTH environment variable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_full_path_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of the whole path of an individual file/folder name when entered by user. Use -1 for no limit or 0 to look the value from MAX_FILENAME_LENGTH environment variable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_full_path_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //Include file-chooser-selection.h to get this enum, if we need to build with properties enabled,
  //though this is probably meant as semi-private API:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** View mode used for hildon file selection widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<FileSelectionMode> property_selection_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** View mode used for hildon file selection widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<FileSelectionMode> property_selection_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** @relates Hildon::FileChooserDialog
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Hildon::FileChooserDialog* wrap(HildonFileChooserDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_FMMM_FILE_CHOOSER_DIALOG_H */

