/*
 * testtext.c
 *
 * Shows a problem with a set of textviews inside a notebook
 */

#include <string.h>
#include <gtk/gtk.h>

#define TEXTS  10

const char text[] = 
"The text in this box is not displayed at full size. You need to "
"click into it once to see the last line!\n"
"ljkf wfg wgf kvjjfvnjsdfv jsflhv sjf jsffvshjf dsjfkl sdfghdjg\n"
"ojhsfg jkslg hjsgjkh gdjkgsdkjgh djkdfsjkghsd gskdjlhg dskjlg\n"
"jfhjslkg sdjkfgh dsgkljh gdfkljg hdf gkdhgsg klhsdgkljgh kjh lk\n"
"This is the last line, the text ends here!";

GtkWidget *window;

GtkWidget *problem_widget(void) {

  /* put everything inside a scrolled view */
  GtkWidget *scrolled_window = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), 
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  GtkWidget *vbox = gtk_vbox_new(FALSE, 0);

  int cnt = 0;
  
  /* add all logs to the vbox */
  while(cnt++ < TEXTS) {
    gtk_box_pack_start_defaults(GTK_BOX(vbox), gtk_hseparator_new());
   
    GtkTextBuffer *buffer = gtk_text_buffer_new(NULL);
    gtk_text_buffer_set_text(buffer, text, strlen(text));
    GtkWidget *textview = gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview), GTK_WRAP_WORD);
    
    gtk_box_pack_start_defaults(GTK_BOX(vbox), textview);
  }
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), 
					vbox);

  return scrolled_window;
}

GtkWidget *p;

GtkWidget *notebook(void) {
  GtkWidget *notebook =  gtk_notebook_new();
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
	   gtk_label_new("Label!"), gtk_label_new("Just a label here"));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
	   p = problem_widget(), gtk_label_new("Problem here!"));

  return notebook;
}
 
int main(int argc, char *argv[]) {
  gtk_init (&argc, &argv);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size(GTK_WINDOW(window), 500, 300);

  gtk_container_add(GTK_CONTAINER(window), notebook());

  g_signal_connect(G_OBJECT(window), "destroy", 
		   G_CALLBACK(gtk_main_quit), NULL);


  gtk_widget_show_all(GTK_WIDGET(window));
  gtk_widget_realize(p);
  gtk_main();

  return 0;
}
