/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007, 2008 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _UI_H_
#define _UI_H_

#define _GNU_SOURCE

#include <config.h>

#if PLAINGTK == 0
# if HILDON == 1
#  include <hildon/hildon-program.h>
#  include <hildon/hildon-banner.h>
#  include <hildon/hildon-note.h>
#  include <hildon/hildon-number-editor.h>
#  include <hildon/hildon-date-editor.h>
#  include <hildon-fm-2/hildon/hildon-file-chooser-dialog.h>
#  include <hildon-fm-2/hildon/hildon-file-system-model.h>
#  include <hildon/hildon-help.h>
# else
#  include <hildon-widgets/hildon-program.h>
#  include <hildon-widgets/hildon-banner.h>
#  include <hildon-widgets/hildon-input-mode-hint.h>
#  include <hildon-widgets/hildon-number-editor.h>
#  include <hildon-widgets/hildon-date-editor.h>
#  include <hildon-widgets/hildon-file-chooser-dialog.h>
#  include <hildon-widgets/hildon-file-system-model.h>
#  include <osso-helplib.h>
# endif
# include <libosso.h>
#endif
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gconf/gconf-client.h>

#include <gtkextra/gtkplot.h>
#include <gtkextra/gtkplotdata.h>
#include <gtkextra/gtkplotbar.h>
#include <gtkextra/gtkplotcanvas.h>
#include <gtkextra/gtkplotcanvastext.h>
#include <gtkextra/gtkplotcanvasline.h>
#include <gtkextra/gtkplotcanvasplot.h>
#include <gtkextra/gtkplotprint.h>

#include <libintl.h>
#include <locale.h>

#include <stdlib.h>
#define _GNU_SOURCE
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <time.h>

#include "fuelpad.h"
#include "util.h"

#define _(String) gettext(String)
#define gettext_noop(String) String

/* Import window */
#define IMPORTCOLS 9

/* Add record dialog */
#define ENTRYDATEMAX 20
#define ENTRYKMMAX 8
#define ENTRYTRIPMAX 8
#define ENTRYFILLMAX 8
#define ENTRYPRICEMAX 8
#define ENTRYNOTESMAX 50
#define ENTRYSERVICEMAX 8
#define ENTRYOILMAX 8
#define ENTRYTIRESMAX 8

/* Maximum lengths of some buffers */
#define CARMAXLEN 30
#define NICKMAXLEN 30
#define DFFORMATLEN 7
#define LISTITEMMAX 50
#define TIMELENMAX 12
#define TOTALKMMAXLEN 8
#define BUFMAX 10
#define YEARBUFLEN 20

#define HELP_ID_PREFIX "help_fuelpad_"
#define HELP_ID_INTRO HELP_ID_PREFIX"intro"
#define HELP_ID_SETTINGS HELP_ID_PREFIX"settings"
#define HELP_ID_ADDCAR HELP_ID_PREFIX"addcardialog"
#define HELP_ID_ADDDRIVER HELP_ID_PREFIX"adddriverdialog"
#define HELP_ID_ADDRECORD HELP_ID_PREFIX"addrecorddialog"
#define HELP_ID_REPORT HELP_ID_PREFIX"yearly"
#define HELP_ID_ALARM HELP_ID_PREFIX"reminders"
#define HELP_ID_EDITEVENT HELP_ID_PREFIX"editevent"
#define HELP_ID_ADDEVENT HELP_ID_PREFIX"addevent"
#define HELP_ID_ADDREMINDER HELP_ID_PREFIX"addreminder"
#define HELP_ID_EDITREMINDER HELP_ID_PREFIX"editreminder"
#define HELP_ID_STATISTICS HELP_ID_PREFIX"monthly"
#define HELP_ID_DATABASE HELP_ID_PREFIX"database"
#define HELP_ID_MAINWIN HELP_ID_PREFIX"mainwindow"
#define HELP_ID_FILTER HELP_ID_PREFIX"filter"

#define YSCALE(y) ((y)*(400.0/700.0*GTK_PLOT_A4_W/GTK_PLOT_A4_H))

#define DIALOG_MIN_HEIGHT1 200
#define DIALOG_MIN_HEIGHT2 150
#define DIALOG_MIN_WIDTH1 720

enum
{
  COL_DAY = 0,
  COL_KM,
  COL_TRIP,
  COL_FILL,
  COL_CONSUM,
  COL_PRICE,
  COL_PRICEPERTRIP,
  COL_PRICEPERLITRE,
  COL_SERVICE,
  COL_OIL,
  COL_TIRES,
/*   COL_INSURANCE, */
/*   COL_OTHER, */
  COL_CO2EMISSION,
  COL_NOTES,
  COL_ID,
  COL_VISIBLE,
  NUM_COLS
};

enum unit {SI, US, IMPERIAL};

/* for tree view data function */
typedef struct {
  int col;
  char format[DFFORMATLEN];
} data_func_t;

/* Unit combo type */
enum {
  UNITCOMBO=0,
  LENGTHCOMBO,
  VOLUMECOMBO,
  CONSUMECOMBO,
  MASSCOMBO
};

/* Paper */
enum papertype {
  A4PAPER,
  LETTERPAPER
};

enum fontscale {
  XSMALL=1,
  SMALL,
  MEDIUM,
  LARGE
};

typedef struct _AppData AppData;

struct _AppData
{
#if PLAINGTK == 0
  HildonProgram *program;     /* handle to application */
  HildonWindow *mainwindow;   /* handle to main window */
  HildonWindow *statwindow;   /* handle to statistics window */
  HildonWindow *reportwindow; /* handle to report window */
  HildonWindow *alarmwindow;  /* handle to alarm window */
  osso_context_t *osso;       /* handle to osso */
#else
  GtkWidget *mainwindow;
  GtkWidget *statwindow;
  GtkWidget *reportwindow;
  GtkWidget *alarmwindow;
#endif
};

typedef struct _AppUIData AppUIData;
struct _AppUIData
{
  /* Handle to app's data */
  AppData *app;

  /* Fullscreen for different windows */
  gboolean mainfullscreen;
  gboolean statfullscreen;
  gboolean reportfullscreen;
  gboolean alarmfullscreen;

  /* Main window */
  GtkWidget *mainvbox;
  GtkWidget *view;
  GtkWidget *carlabel;
  GtkWidget *driverlabel;
  GtkWidget *servicelabel;
  GtkWidget *oillabel;
  GtkWidget *tireslabel;
  GtkWidget *totalkmlabel;
  GtkWidget *mpglabel;
  GtkWidget *avgconsumlabel;
  GtkWidget *totcostlabel;
  GtkWidget *datascrollwin;
  GtkWidget *main_menu_item_fullscreen;
  GtkWidget *stat_menu_item_fullscreen;
  GtkWidget *report_menu_item_fullscreen;
  GtkWidget *alarm_menu_item_fullscreen;

  /* Main menu */
  GtkWidget *main_menu;
  GtkWidget *mm_menu_db;
  GtkWidget *mm_menu_record;
  GtkWidget *mm_menu_stat;
  GtkWidget *mm_menu_view;
  GtkWidget *mm_menu_toolbar;
  GtkWidget *mm_menu_fontsize;
  GtkWidget *mm_item_db;
  GtkWidget *mm_item_record;
  GtkWidget *mm_item_view;
  GtkWidget *mm_item_settings;
  GtkWidget *mm_item_stat;
  GtkWidget *mm_item_alarm;
  GtkWidget *mm_item_help;
  GtkWidget *mm_item_about;
  GtkWidget *mm_item_exit;

  /* Database menu (in main menu) */
  GtkWidget *mm_item_open;
  GtkWidget *mm_item_close;
  GtkWidget *mm_item_import;
  GtkWidget *mm_item_export;

  /* Record menu (in main menu) */
  GtkWidget *mm_item_new;
  GtkWidget *mm_item_edit;
  GtkWidget *mm_item_delete;

  /* Statistics menu (in main menu) */
  GtkWidget *mm_item_monthly;
  GtkWidget *mm_item_report;

  /* View menu (in main menu) */
  GtkWidget *mm_item_columnselect;
  GtkWidget *mm_item_filter;
  GtkWidget *mm_item_toolbar;
  GtkWidget *mm_item_fontsize;

  /* Toolbars menu (in View menu) */
  GtkWidget *mm_item_toolbar_main;
  GtkWidget *mm_item_toolbar_secondary;

  /* Font size menu (in View menu) */
  GtkWidget *mm_item_fontsize_x_small;
  GtkWidget *mm_item_fontsize_small;
  GtkWidget *mm_item_fontsize_medium;
  GtkWidget *mm_item_fontsize_large;

#if PLAINGTK == 1
  GtkWidget *mm_menubar;
  GtkWidget *mm_item_file;
#endif

  /* Settings dialog */
  GtkWidget *drivercombo;
  GtkWidget *carcombo;
  GtkWidget *datecombo;
  GtkWidget *unitcombo;
  GtkWidget *lengthcombo;
  GtkWidget *volumecombo;
  GtkWidget *consumecombo;
  GtkWidget *masscombo;
  GtkWidget *entrycurrency;
  GtkWidget *entrywarnkm;
  GtkWidget *labelentrywarn;
  GtkWidget *warntimecombo;

  /* Main toolbar */
  GtkWidget *main_toolbar;
  GtkToolItem *mtb_add;
  GtkToolItem *mtb_edit;
  GtkToolItem *mtb_up;
  GtkToolItem *mtb_down;
  GtkToolItem *mtb_delete;
  GtkToolItem *mtb_reminder;
  GtkToolItem *mtb_close;

  /* Secondary toolbar */
  GtkWidget *secondary_toolbar;
  GtkToolItem *stb_car;
  GtkToolItem *stb_carapply;
  GtkToolItem *stb_totalkm;
  GtkToolItem *stb_avgconsum;
  GtkToolItem *stb_totcost;
  GtkWidget *stb_carcombo;
  GtkWidget *stb_totalkmlabel;
  GtkWidget *stb_avgconsumlabel;
  GtkWidget *stb_totcostlabel;

  /* Add driver dialog */
  GtkWidget *entryname;
  GtkWidget *entrynick;

  /* Add car dialog */
  GtkWidget *entrymark;
  GtkWidget *entrymodel;
  GtkWidget *entryyear;
  GtkWidget *entryregister;
  GtkWidget *combofueltype;
  GtkWidget *entrycarnotes;

  /* Add record dialog */
  GtkWidget *entrydate;
  GtkWidget *entrykm;
  GtkWidget *entrytrip;
  GtkWidget *entryfill;
  GtkWidget *entryprice;
  GtkWidget *entrynotes;
  GtkWidget *entryservice;
  GtkWidget *entryoil;
  GtkWidget *entrytires;

  /* Select columns dialog*/
  GtkWidget *columncheck[NUM_COLS];

  /* Filter records dialog */
  GtkWidget *addbutton[NUM_COLS];
  GtkWidget *andorcombo[NUM_COLS];
  GtkWidget *filterminentry[NUM_COLS];
  GtkWidget *filtermaxentry[NUM_COLS];
  GtkWidget *filterentry;

  /* Report window */
  GtkWidget *reportcanvas;
  GtkWidget *reportscrollwin;
  GtkWidget *yearcombo;
  GtkWidget *papercombo;

  /* Import window */
  GtkWidget *colspin[IMPORTCOLS];
  GtkWidget *flspinner;
  GtkWidget *localecombo;
  GtkWidget *dateformatentry;

  /* Statistics window */
  GtkWidget *statscrollwin;
  GtkWidget *canvas;
  GtkWidget **plots;
  GtkWidget *active_plot;
  GtkPlotArray *months;
  GtkPlotCanvasChild *maintitle;

  /* Statistics window menu */
  GtkWidget *sm_item_monthly;
  GtkWidget *sm_item_monthlytrip;
  GtkWidget *sm_item_monthlypriceperlitre;
  GtkWidget *sm_item_consumdistr;

  /* Alarm window */
  GtkWidget *alarmview;
  GtkWidget *alarmscrollwin;
  GtkWidget *alarmcarcombo;
  GtkWidget *entryalarmdesc;
  GtkWidget *entryalarmdistance;
  GtkWidget *entryalarminterval;
  GtkWidget *entryalarmlongdesc;
  GtkWidget *entryeventdate;
  GtkWidget *entryeventkm;
  GtkWidget *entryeventservice;
  GtkWidget *entryeventoil;
  GtkWidget *entryeventtires;
  GtkWidget *entryeventnotes;
  GtkWidget *eventview;

  /* Alarm secondary toolbar */
  GtkToolItem *stb_alarmdesc;
  GtkWidget *stb_alarmdesclabel;
  GtkToolItem *stb_alarmkm;
  GtkWidget *stb_alarmkmlabel;
  GtkToolItem *stb_alarmtime;
  GtkWidget *stb_alarmtimelabel;

};

/* Units */
struct _unit {
  enum unit mainunit;
  enum unit lengthunit;
  enum unit volumeunit;
  enum unit consumeunit;
  enum unit massunit;
  gboolean individualunit;
  GString *currency;
  gint dateformat;
};

typedef struct _unit unit_t;

/* Function declarations */
void ui_init(int   argc, char *argv[]);
void ui_main_loop(void);
void ui_create_mainwin(void);
void ui_show_animation(GtkWidget **banner, const char *s);
void ui_show_banner(const char *s);
void ui_remove_banner(GtkWidget *banner);
gchar * interface_file_chooser (gchar *header, 
				GtkFileChooserAction action, 
				const gchar *ext,
				gchar *help_id);
GtkWidget *create_driver_combo(void);
GtkWidget *create_car_combo(void);
GtkWidget *create_unit_combo(gint whichunit, AppUIData *pui);
double SIlength2user(double length);
double user2SIlength(double length);
double SIvolume2user(double length);
double user2SIvolume(double length);
double SIconsumption2user(double consum);
double user2SIconsumption(double consum);
double SIppl2user(double ppl);
double SImass2user(double mass);
double SIemission2user(double emission);
void update_record_model(AppUIData *pui);
void update_totalkm(AppUIData *pui);
void update_reminder_toolbutton(AppUIData *pui, gboolean warn);
void update_car_changed(AppUIData *pui);
void help_activated(GtkWidget *win, gchar *help_id);
void get_store_and_iter(GtkTreeModel *model, GtkWidget *view, GtkTreeIter *iter, GtkListStore **store, GtkTreeIter *storeiter);

#if PLAINGTK == 0
void help_dialog_help_enable(GtkDialog *dialog, const gchar *topic, osso_context_t *osso);
#endif

#endif
