/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * makepack.c
 *
 * Utilita na vytvoreni baliku.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pack.h"

#ifdef HAVE_ZLIB
#include <zlib.h>
#endif

#define BUF_SIZE        (1024 * 1024)

int main(int argc, char **argv)
{
  FILE *fo, *fi;
  int i1, i2, size;
  pack_head head;
  char *bufi, *bufo;
  char *ch;
  char name[64];
#ifdef HAVE_ZLIB
  z_stream z;
#endif

  if (argc < 3) {
    printf("Usage: makepack input_file(s) ... output_file\n");
#ifdef HAVE_ZLIB
    printf("(all files containing a dot in their name will be compressed)\n");
#endif
    return 1;
  }
  bufi = malloc(BUF_SIZE);
  bufo = malloc(BUF_SIZE);
  if (!bufi || !bufo) {
    printf("Memory allocation failed.\n");
    return 1;
  }
  printf("Creating pack file %s...\n", argv[argc - 1]);
  fo = fopen(argv[argc - 1], "wb");
  if (!fo) {
    printf("Cannot open output file %s.\n", argv[argc - 1]);
    return 1;
  }
  /* zapiseme hlavicky na zacatku souboru */
  /* prvni je uvodni hlavicka */
  memset(&head, 0, sizeof(head));
  strcpy(head.name, PACK_ID);
  head.len = argc - 2;
  if (fwrite(&head, sizeof(head), 1, fo) != 1) {
    printf("Error writing %s.\n", argv[argc - 1]);
    return 1;
  }
  /* pak vynechame misto pro hlavicky souboru - hlavicka se zopakuje
   * tolikrat, kolik je souboru */
  memset(&head, 0, sizeof(head));
  for (i1 = 1; i1 < argc - 1; i1++) {
    if (fwrite(&head, sizeof(head), 1, fo) != 1) {
      printf("Error writing %s.\n", argv[argc - 1]);
      return 1;
    }
  }
  /* ted budeme postupne zapisovat soubory */
  for (i1 = 1; i1 < argc - 1; i1++) {
    memset(&head, 0, sizeof(head));
    strncpy(name, argv[i1], 63);
    name[63] = '\0';
    ch = strrchr(name, '/');
    if (ch)
      for (i2 = 0; *ch; i2++, ch++) name[i2] = ch[1];
    strncpy(head.name, name, PACK_HEAD_NAME_LEN - 1);
    /* o ukoncovaci nulu se starat nemusime, protoze jsme pred chvili
     * vynulovali cely zaznam */
    head.start = ftell(fo);
    printf("  %s: ", argv[i1]);
    fi = fopen(argv[i1], "rb");
    if (!fi) {
      printf("Cannot open.\n");
      return 1;
    }
    fseek(fi, 0, SEEK_END);
    head.len = ftell(fi);
    rewind(fi);
#ifdef HAVE_ZLIB
    if (strchr(name, '.')) {
      /* jmeno souboru obsahuje tecku, takze budeme komprimovat */
      printf("(compressing... ");
      /* inicializace komprese */
      z.zalloc = Z_NULL;
      z.zfree = Z_NULL;
      z.opaque = Z_NULL;
      if (deflateInit(&z, Z_DEFAULT_COMPRESSION) != Z_OK) {
        printf("deflateInit: %s)\n", z.msg);
        return 1;
      }
      z.avail_out = BUF_SIZE;           /* nastaveni vystupniho bufferu */
      z.next_out = bufo;
      /* komprimacni smycka */
      while (1) {
        /* nacteni vstupu */
        size = fread(bufi, 1, BUF_SIZE, fi);
        if (!size) {
          /* vsechno nacteno => ukoncime komprimaci */
          while (1) {
            size = deflate(&z, Z_FINISH);
            if (size < 0) {             /* komprimace */
              printf("deflate: %s)\n", z.msg);
              return 1;
            }
            if (size == Z_STREAM_END) break;    /* vsechno poslano do bufferu */
            /* dosel vystupni buffer => musime zapsat data */
            if (fwrite(bufo, 1, BUF_SIZE, fo) != BUF_SIZE) {
              printf("Error writing %s.\n", argv[argc - 1]);
              return 1;
            }
            z.avail_out = BUF_SIZE;       /* znovunastaveni vystupniho bufferu */
            z.next_out = bufo;
          }
          if (fwrite(bufo, 1, BUF_SIZE - z.avail_out, fo) != (BUF_SIZE - z.avail_out)) {
            printf("Error writing %s.\n", argv[argc - 1]);
            return 1;
          }
          break;
        }
        z.next_in = bufi;               /* nastaveni vstupniho bufferu */
        z.avail_in = size;
        while (1) {
          if (deflate(&z, Z_NO_FLUSH) < 0) {    /* komprimace */
            printf("deflate: %s)\n", z.msg);
            return 1;
          }
          if (z.avail_out) break;       /* dosel vstupni buffer? */
          /* dosel vystupni buffer => musime zapsat data */
          if (fwrite(bufo, 1, BUF_SIZE, fo) != BUF_SIZE) {
            printf("Error writing %s.\n", argv[argc - 1]);
            return 1;
          }
          z.avail_out = BUF_SIZE;       /* znovunastaveni vystupniho bufferu */
          z.next_out = bufo;
        }
      }
      head.compressed = z.total_out;
      printf("%d%%) ", (head.compressed * 100) / head.len);
      /* konec komprese */
      deflateEnd(&z);
      fclose(fi);
    }
    else
#endif
    {
      /* bez komprese */
      while (1) {
        size = fread(bufi, 1, BUF_SIZE, fi);
        if (!size) break;
        if (fwrite(bufi, 1, size, fo) != size) {
          printf("Error writing %s.\n", argv[argc - 1]);
          return 1;
        }
      }
      fclose(fi);
    }
    /* zapis hlavicky */
    fseek(fo, i1 * sizeof(head), SEEK_SET);
    if (fwrite(&head, sizeof(head), 1, fo) != 1) {
      printf("Error writing %s.\n", argv[argc - 1]);
      return 1;
    }
    fseek(fo, 0, SEEK_END);
    printf("ok.\n");
  }
  fclose(fo);
  printf("Done.\n");
  return 0;
}
