/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * bmp2img.c
 *
 * Utilita pro konverzi obrazku z BMP do neceho prijatelnejsiho. Umi pouze
 * 24bitove BMP a neprovadi zadnou kontrolu.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


int main(int argc, char **argv)
{
  FILE *fi, *fo;
  char name[64], *ch;
  int size, w, h, scanline;
  char *bufi;
  int i1, i2;

  if (argc < 2) {
    printf("Usage: bmp2img input_file(s) ...\n");
    printf("(output files will have the same name, but a .img extension\n");
    printf("and will be saved to the current directory)\n");
    return 1;
  }
  for (i1 = 1; i1 < argc; i1++) {
    printf("%s ", argv[i1]);
    fi = fopen(argv[i1], "rb");
    if (!fi) {
      printf("- cannot open.\n");
      return 1;
    }
    /* vytvorime jmeno: */
    strncpy(name, argv[i1], 59);
    name[59] = '\0';
    /* odrizneme cestu na zacatku */
    ch = strrchr(name, '/');
    if (ch)
      for (i2 = 0; *ch; i2++, ch++) name[i2] = ch[1];
    /* nahradime priponu */
    ch = strrchr(name, '.');
    if (!ch) strcat(name, ".img");
    else strcpy(ch, ".img");
    /* zkonvertujeme soubor: */
    printf("=> %s: ", name);
    fseek(fi, 0, SEEK_END);
    size = ftell(fi);
    rewind(fi);
    bufi = malloc(size);
    if (!bufi) {
      printf("Cannot allocate memory.\n");
      return 1;
    }
    if (fread(bufi, 1, size, fi) != size) {
      printf("Read error.\n");
      return 1;
    }
    fclose(fi);
    fo = fopen(name, "wb");
    if (!fo) {
      printf("Cannot create file.\n");
      return 1;
    }
    /* zapiseme vysku a sirku obrazku */
    w = *((int *)(bufi + 18));
    h = *((int *)(bufi + 22));
    scanline = (w * 3 + 3) & ~3;
    if (fwrite(&w, 4, 1, fo) != 1 || fwrite(&h, 4, 1, fo) != 1) {
      printf("Write error.\n");
      return 1;
    }
    /* zapiseme obrazek tak, aby nebyl hlavou dolu */
    ch = bufi + 54 + (h - 1) * scanline;
    for (i2 = 0; i2 < h; i2++) {
      if (fwrite(ch, 1, w * 3, fo) != w * 3) {
        printf("Write error.\n");
        return 1;
      }
      ch -= scanline;
    }
    fclose(fo);
    free(bufi);
    printf("ok.\n");
  }
  printf("Done.\n");
  return 0;
}
