/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * readdata.h
 *
 * Funkce na cteni dat (z baliku nebo z disku).
 *
 */

#ifndef _READDATA_H
#define _READDATA_H
#include "common.h"

/* Struktura souboru v baliku (resp. informaci o nem). */
typedef struct {
  unsigned start, len, compressed;      /* (viz pack.h) */
} pack_file;

#define PWD_LEN         12              /* delka hesla (pocet znaku hesla) */


/* Inicializace baliku. */
void init_pack();

void reinit_pack(void);

/* "Otevreni" souboru v baliku (tj. zjisteni informaci o nem). */
void pack_fopen(pack_file *f, char *name);

/* Nacteni souboru v baliku (soubor musel byt predtim "otevren" funkci
 * pack_fopen()). */
void pack_fread(pack_file *f, void *buf);

/* Nacteni celeho souboru z baliku (vcetne alokace pameti). Pokud neni len
 * rovno NULL, je do nej ulozena delka dat. */
void *pack_fget(char *name, int *len);

/* Vrati pocet kol v jednotlivych sadach (1 = jeden hrac, jednoducha kola;
 * 2 = jeden hrac, obtizna kola; 3 = dva hraci; 0 = dema). */
int cnt_level(int levelset);

/* Nacte kolo (z baliku). lev_bagger smi byt NULL (pak se ignoruje). */
void load_level(int levelset_no, int level_no, uchar *lev_def, uchar *lev_bagger);

/* Nacte externi kolo (tj. ze souboru). */
void load_extern_level(const char *name, uchar *lev_def, uchar *lev_bagger);

/* ulozi heslo prislusneho kola do pwd (pwd musi byt alokovano) */
void get_level_password(int levelset_no, int level_no, char *pwd);

/* najde kolo prislusne zadanemu heslu - vrati cislo kola nebo -1 v pripade
 * neuspechu */
int find_level_password(int levelset_no, char *pwd);

#endif
