/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * params.c
 *
 * Funkce pro parsing prikazoveho radku a nahrani/ulozeni konfigurace.
 *
 */

#include <string.h>
#include "common.h"
#include "keys.h"
#include "params.h"

/* Promenne param_xxx */
int param_editor = 0;           /* spustit editor - neimplementovano */
int param_userlevel = 0;        /* uzivatelske kolo */
int param_lang = LANG_EN;       /* language */
int lang_forced = 0;

char *userlevel;                /* nazev souboru s uzivatelskym kolem */

char *exedir;                   /* cesta, kde je ulozen spusteny program */


/* Set language; can be called only until various other systems (packfile,
 * SDL, etc.) are initialized. */
static void set_lang(int lang)
{
	if (lang != LANG_EN && lang != LANG_CZ)
		return;
	param_lang = lang;
	reinit_ls();
	reinit_keys();
}

/* Proparsuje parametry predane na prikazovem radku a nastavi prislusne
 * promenne param_xxx. */
void parse_parameters(int argc, char **argv)
{
  char *ch;

  /* nejdriv ulozime cestu k executable */
  exedir = emalloc(strlen(argv[0]) + 2);
  strcpy(exedir, argv[0]);
#ifdef win32
  ch = strrchr(exedir, '\\');
#else
  ch = strrchr(exedir, '/');
#endif
  if (ch) ch[1] = '\0';
  else exedir[0] = '\0';
  /* pak proparsujeme parametry */
  for (argc--, argv++; argc > 0; argc--, argv++) {
    if (!strcmp(*argv, "-editor")) param_editor = 1;
    else if (!strcmp(*argv, "-map")) {
      param_userlevel = 1;
      if (--argc < 1)
        error(ls(STR_PARAMS_MAP_NO_FILE));
      userlevel = *++argv;
    }
    else if (!strcmp(*argv, "cz")) {
      set_lang(LANG_CZ);
      lang_forced = 1;
    }
    else if (!strcmp(*argv, "en")) {
      set_lang(LANG_EN);
      lang_forced = 1;
    }
    else error(ls(STR_PARAMS_UNKNOWN_PARAM), *argv);
  }
}


/* klavesy pro ovladani */
/* poradi je:
 * hrac 1 vlevo, hrac 1 vpravo, hrac 1 nahoru, hrac 1 dolu,
 * hrac 2 vlevo, hrac 2 vpravo, hrac 2 nahoru, hrac 2 dolu,
 * zrychleni
 */
SDLKey keyscfg[9] = {
  SDLK_LEFT, SDLK_RIGHT, SDLK_UP, SDLK_DOWN,
#ifdef maemo
  SDLK_j, SDLK_l, SDLK_i, SDLK_k,
#else
  SDLK_a, SDLK_d, SDLK_w, SDLK_s,
#endif
#ifdef win32
  SDLK_RCTRL     /* v pripade ovladace windib je problem s rozpoznavanim shiftu */
#else
#ifdef maemo
  SDLK_F4
#else
  SDLK_RSHIFT
#endif
#endif
};

/* cesta k domovskemu adresari */
char homedir[64];

/* jmeno souboru, do nehoz se uklada konfigurace */
char cfgfilename[] =
#ifdef win32
  "fred.cfg";
#else
  ".fredcfg";
#endif
/* hlavicka konfiguracniho souboru */
char cfghead[] = "Fred Config File\x0a";
#define CFGHEAD_SIZE            sizeof(cfghead)


/* Nacte konfiguraci klaves z ~/.fredcfg */
void load_config()
{
  char filename[80];
  FILE *f;
  char head[CFGHEAD_SIZE];
  SDLKey keys[9];
  char tmp;

  /* load_config() se vola jako prvni, takze naplnime retezec homedir */
#ifdef win32
  strncpy(homedir, exedir, 62);
  homedir[62] = '\0';
#else
  strncpy(homedir, getenv("HOME"), 62);
  homedir[62] = '\0';
  if (homedir[strlen(homedir) - 1] != '/') strcat(homedir, "/");
#endif
  /* vytvoreni nazvu souboru */
  strcpy(filename, homedir);
  strcat(filename, cfgfilename);
  f = fopen(filename, "rb");
  if (f) {
    if (!fread(head, CFGHEAD_SIZE, 1, f) ||
        memcmp(head, cfghead, CFGHEAD_SIZE)) {
      fclose(f);
      return;
    }
    if (fread(keys, sizeof(keyscfg), 1, f)) {
      memcpy(keyscfg, keys, sizeof(keyscfg));
      if (fread(&tmp, 1, 1, f) && !lang_forced)
	  set_lang(tmp);
    }
    fclose(f);
  }
}

  
/* Ulozi konfiguraci klaves do ~/.fredcfg */
void save_config()
{
  char filename[80];
  FILE *f;
  char tmp = param_lang;

  strcpy(filename, homedir);
  strcat(filename, cfgfilename);
  f = fopen(filename, "wb");
  if (f) {
    if (fwrite(cfghead, CFGHEAD_SIZE, 1, f) &&
      fwrite(keyscfg, sizeof(keyscfg), 1, f) &&
      fwrite(&tmp, 1, 1, f))
      ;
    fclose(f);
  }
}
