/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * level.h
 *
 * Funkce pro praci s koly.
 *
 */

#ifndef _LEVEL_H
#define _LEVEL_H
#include "common.h"

/* x-ova a y-ova velikost definice kola */
#define XSIZE_LEVELDEF          40
#define YSIZE_LEVELDEF          22

/* pocet baggeru a velikost jedne polozky definujici bagger v definici
 * kola */
#define CNT_BAGGER              16
#define SIZEDEF_BAGGER          3

extern uchar *leveldef;                 /* definice kola */
extern uchar *levelbagger;              /* definice baggeru v kole */
                                        /* (nulta polozka urcuje Fredy) */


/* x-ova a y-ova velikost pole urcujiciho aktualni stav kola */
#define XSIZE_LEVELSTAT         (XSIZE_LEVELDEF * 8)
#define YSIZE_LEVELSTAT         (YSIZE_LEVELDEF * 8)

extern uchar *levelstat;                /* aktualni stav kola */


/* konstanty typu objektu v definici kola */
#define OBJ_BRICK       1
#define OBJ_UP          2
#define OBJ_RUN         3
#define OBJ_BOULD       5
#define OBJ_FRED1       7
#define OBJ_FRED2       4
#define OBJ_BAGG        6


/* maximalni velikost pole obsahujiciho stavy pohyblivych veci v kole */
#define MAXSIZE_THINGSTAT       440

/* typ stavu jedne pohyblive veci v kole */
typedef struct {
  int x, y;             /* pozice [x, y] */
  unsigned c;           /* citac zpracovani veci */
} thing_stat;

extern thing_stat *thingstat;           /* stavy pohyblivych veci v kole */
extern int thingcnt;                    /* aktualni velikost pole thingstat */


extern int actuallevelset, actuallevel; /* aktualni (prave probihajici) sada a kolo */
extern int actualmaxlevel;              /* pocet kol v aktualni sade */

extern int demoactive;                  /* priznak, ze je aktivni demo */
extern int levelfinished;               /* priznak, ze je konec kola */
extern int levelrestart;                /* priznak, ze se ma hrat kolo zase od zacatku */
extern int gamerestart;                 /* priznak, ze se ma vratit do hlavniho menu */

/* faze animace objektu: */
extern int phaserun;
extern int phasefred[];
  /* animacni faze baggera a faze aktivity/neaktivity baggera (bagger se
   * pohybuje 2x pomaleji nez hrac) */
extern int phasebagg, phaseactbagg;
extern int fredup[];                    /* priznak, ze Fred stoupa */

extern int gamespeed;                   /* stupen rychlosti hry */

/* konstanty stupnu rychlosti hry */
#define GAMESPEED_MAX           1       /* maximalni rychlost hry */
#define GAMESPEED_DEMO          5       /* rychlost dema */
#define GAMESPEED_BASIC         5       /* zakladni (pocatecni) rychlost hry */
#define GAMESPEED_MIN           8       /* minimalni rychlost hry */


/* Inicializace datovych struktur pro kola. */
void init_levels();

/* Inicializace a vykresleni kola. Je-li afterload != 0, znamena to, ze kolo
 * bylo prave loadnuto a bude inicializovano trochu jinak. */
void draw_level(int afterload);

/* Provedeni jednoho kroku hry. */
void step_level();

#endif
