/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * graphics.h
 *
 * Funkce pro praci s grafikou (pomoci SDL).
 *
 */

#ifndef _GRAPHICS_H
#define _GRAPHICS_H
#include "SDL.h"

extern SDL_Surface *screen;     /* surface obrazovky */

#define CNT_IMGBRICK    9       /* pocet typu cihel */
#define CNT_IMGBOULD    3       /* pocet typu balvanu */

/* surfacy obrazku (spritu): */
extern SDL_Surface
  *(imgfred[]),                 /* Fred (hrac 1 & hrac 2) */
  *(imgfredr[]),                /* Fred - reverzni */
  *(imgbagg[]),                 /* Bagger */
  *(imgbaggr[]),                /* Bagger - reverzni */
  *(imgrun[]),                  /* spoustec baggera */
  *(imgup[]),                   /* vytah */
  *imgupact,                    /* indikator stani na vytahu */
  *(imgbrick[]),                /* cihla */
  *(imgbould[]),                /* balvan */
  *imgfont,                     /* font */
  *imgtitle,                    /* logo "Fred" */
  *(imgmainmenu[]),             /* hlavni menu */
  *imgctrlsmenu,                /* menu pro nastaveni ovladani */
  *(imggamemenu[]),             /* menu v prubehu hry */
  *(imggamespeed[]),            /* box pro nastaveni rychlosti */
  *imgpasswd,                   /* napis "Heslo:" */
  /* miniverze obrazku (pro nahledy pri save/load): */
  *(imgmfred[]),
  *(imgmfredr[]),
  *imgmbagg,
  *imgmbaggr,
  *imgmrun,
  *imgmup,
  *(imgmbrick[]),
  *(imgmbould[]);

#define Y_FONT          32      /* vyska jednoho pismene ve fontu */

/* Inicializace vseho potrebneho pro SDL a natazeni spritu */
void init_sdl();

void reinit_imgs(void);

/* Natazeni spritu do surfacu - vraci surface. Jako vstup je nazev spritu
 * (tak, jak je ulozen v baliku). */
SDL_Surface *load_img(const char *name);

/* Natazeni serie spritu (se jmeny *#, kde # je cislo) do pole surfacu. */
void load_serieimg(const char *name, SDL_Surface **img, int cnt);

/* Zapise dany sprite na obrazovku na dane souradnice (ale nevola
 * SDL_UpdateRect(), tedy neprekresluje obrazovku). */
void draw_img(SDL_Surface *img, Sint16 x, Sint16 y);

/* Prekresli sprite na obrazovce - tj. na puvodnim miste vykresli cerny
 * obdelnik, a pote vykresli novy sprite. */
void redraw_img(SDL_Surface *img, Sint16 newx, Sint16 newy, Sint16 oldx, Sint16 oldy);

/* Zapise cast daneho spritu na obrazovku. Cast ma sirku spritu a udany
 * svisly ofset a vysku. */
void draw_part_img(SDL_Surface *img, Sint16 ofs_y, Uint16 h, Sint16 x, Sint16 y);

/* Zapise na obrazovku na dane souradnice obdelnik v dane velikosti a barve
 * (zadane pres RGB slozky). */
void draw_bar(Sint16 x, Sint16 y, Uint16 w, Uint16 h, Uint8 r, Uint8 g, Uint8 b);

/* Vykresli nevyplneny obdelnik v zadane barve. */
void draw_rect(Sint16 x, Sint16 y, Uint16 w, Uint16 h, Uint8 r, Uint8 g, Uint8 b);

/* Prekresli obrazovku. */
void redraw();

/* Varianta funkce draw_img(), ktera navic uklada zmeneny obdelnik pro
 * pozdejsi rychlejsi prekresleni. */
void drawf_img(SDL_Surface *img, Sint16 x, Sint16 y);

/* Varianta funkce redraw_img() umoznujici pouze vodorovne prekresleni,
 * ktera uklada zmeneny obdelnik. */
void redrawfhoriz_img(SDL_Surface *img, Sint16 newx, Sint16 newy, Sint16 oldx);

/* Varianta funkce redraw_img() umoznujici pouze svisle prekresleni,
 * ktera uklada zmeneny obdelnik. */
void redrawfvert_img(SDL_Surface *img, Sint16 newx, Sint16 newy, Sint16 oldy);

/* Varianta funkce draw_bar(), ktera pouziva jen cernou barvu a uklada
 * zmeneny obdelnik. */
void drawf_blackbar(Sint16 x, Sint16 y, Uint16 w, Uint16 h);

/* Varianta funkce draw_rect(), ktera uklada zmeneny obdelnik. */
void drawf_rect(Sint16 x, Sint16 y, Uint16 w, Uint16 h, Uint8 r, Uint8 g, Uint8 b);

/* Varianta funkce redraw(), ktera prekresluje jen zmenene obdelniky. */
void redrawf();

/* Vypis textu. */
void draw_text(int x, int y, char *text);

#endif
