/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "SDL.h"
#include <stdio.h>
#include <string.h>
#include "params.h"
#include "readdata.h"
#include "graphics.h"
#include "keys.h"
#include "level.h"
#include "boxes.h"
#include "demo.h"
#include "save.h"
#include "maemo.h"

#ifdef DEMOSAVE
#include "demosave.h"
#endif


/* Ukonceni vseho potrebneho */
void shutdown()
{
  /* ulozeni konfigurace */
  save_config();
}


/* Inicializace vseho potrebneho */
void init()
{
  init_maemo();
  /* natazeni konfigurace */
  load_config();
  /* inicializace baliku */
  init_pack();
  /* inicializace SDL */
  init_sdl();
  /* inicializace levelu */
  init_levels();
  /* inicializace savu */
  init_save();
#ifdef DEMOSAVE
  /* inicializace nahravace dem */
  init_demosave();
#endif
  /* registrace padaci funkce */
  atexit(shutdown);
}


/* main */
int main(int argc, char **argv)
{
  /* parsing parametru na prikazovem radku */
  parse_parameters(argc, argv);
  /* inicializace */
  init();

  init_main_menu();
  while (1) {                   /* (smycka hlavniho menu) */
    if (!param_userlevel) {
      gamespeed = GAMESPEED_DEMO;
      main_menu();
      actuallevel = 0;
      actualmaxlevel = cnt_level(actuallevelset);
    }

    gamespeed = GAMESPEED_BASIC;
    gamerestart = 0;
    init_game_menu();

    while (1) {                 /* (smycka kol) */
      /* presuneme se do dalsiho kola (pokud neni uzivatelske kolo) */
      if (!param_userlevel)
        if (++actuallevel > actualmaxlevel) break;
      
      /* spustime kolo */
      do {                      /* (smycka jednoho kola) */
        if (param_userlevel)  
          load_extern_level(userlevel, leveldef, levelbagger);
        else load_level(actuallevelset, actuallevel, leveldef, levelbagger);
        draw_level(0);
        /* hlavni herni smycka */
        do {                    /* (hlavni herni smycka) */
          step_level();
          if (keyboard[SDLK_ESCAPE] || keyboard[SDLK_F10]) {
            /* stisknuti Escape nebo F10 znamena menu */
#ifdef DEMOSAVE
            /* ukonceni nahravace dem i programu */
            shutdown_demosave();
            return 0;
#endif
            game_menu();
          }
        } while (!levelfinished && !levelrestart && !gamerestart);
      } while (!levelfinished && !gamerestart);

      /* pokud bylo uzivatelske kolo, ukoncime hru; pokud chceme konec sady,
      * vratime se do hlavniho menu */
      if (param_userlevel || gamerestart) break;
    } /* while (smycka kol) */
    if (param_userlevel) break;
  } /* while (smycka hlavniho menu) */

  return 0;
}

