/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * demo.c
 *
 * Funkce pro prehravani dem.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "readdata.h"
#include "demo.h"

int cntdemo;                    /* pocet dostupnych dem */
static uchar *demodata;         /* data dema */
static int demolength;          /* delka dema (zbyvajici) */
static uchar *demopos;          /* pozice v demu */
static int rleleft;             /* zbyvajici RLE */
static uchar lastrlebyte;       /* posledni hodnota bytu */


/* Inicializace prehravace dem. */
void init_demo()
{
  cntdemo = cnt_level(0);       /* zjisti pocet dostupnych dem */
  demodata = NULL;
}


/* Inicializace demokola (nacteni prubehu kola). Provadi i pripadne uvolneni
 * demokola predchoziho. */
void init_demolevel(int number)
{
  pack_file f;
  char name[64];

  shutdown_demolevel();
  sprintf(name, "demo%03d", number);
  pack_fopen(&f, name);
  demodata = emalloc(f.len);
  pack_fread(&f, demodata);
  /* prvni 2 byty udavaji delku */
  demolength = 0;
  memcpy(&demolength, demodata, 2);
  demopos = demodata + 2;
  rleleft = 0;
}


/* Uklizeni demokola. */
void shutdown_demolevel()
{
  if (demodata) {
    free(demodata);
    demodata = NULL;
  }
}


/* Vraceni jedne klavesy z dema. Pokud uz zadna dalsi klavesa neni k
 * dispozici, vrati -1. */
int demo_getkey()
{
  if (demolength <= 0) return -1;
  if (rleleft > 0) rleleft--;
  else {
    lastrlebyte = *demopos++;
    if (lastrlebyte & 128) {
      rleleft = (lastrlebyte & 127) - 1;
      lastrlebyte = *demopos++;
    }
  }
  demolength--;
  return lastrlebyte;
}
