/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * boxes.h
 *
 * Ovladaci prvky (boxy) - menu, atd. ("GUI")
 *
 */

#ifndef _BOXES_H
#define _BOXES_H


/* Okno se zpravou. */
void msg_box(char *text);

/* Zadavac textu.
 * x, y urcuji levy horni roh. maxlen je maximalni delka. nullchar je znak,
 * ktery se bude psat na miste, kde neni zadny znak. dest je buffer, odkud
 * se vezme vychozi retezec a kam se ulozi nacteny retezec. onlychars je
 * priznak, ze jdou zadat jen pismena, cursor je priznak, ze je viditelny
 * kurzor.
 * Vrati 0, pokud cteni nebylo uspesne (uzivatel zmackl Esc) - i v tom
 * pripade je v dest to, co uzivatel zadal; vrati 1, pokud je vse ok. */
int input_text(int x, int y, int maxlen, char nullchar, char *dest, int onlychars, int cursor);

/* Inicializace menu (vynulovani aktualni pozice). */
void init_game_menu();

/* Menu. */
void game_menu();

/* Inicializace hlavniho menu (vynulovani aktualni pozice). */
void init_main_menu();

/* Hlavni menu (spolu s demem). */
void main_menu();

/* Vstupni box pro heslo. */
void game_password();

/* Vykresleni ramecku. */
void draw_frame(int x, int y, int w, int h);

#endif
