/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * boxes.c
 *
 * Ovladaci prvky (boxy) - menu, atd. ("GUI")
 *
 */

#include <string.h>
#include <ctype.h>
#include "graphics.h"
#include "keys.h"
#include "level.h"
#include "params.h"
#include "readdata.h"
#include "demo.h"
#include "save.h"
#include "boxes.h"

/* Konstanty */
#define MAINMENU_X              480     /* pozice hlavniho menu */
#define MAINMENU_Y              166
#define MAINMENU_YSIZE          35      /* vyska jedne polozky hlavniho menu */
#define MAINMENU_GAP            14      /* dira mezi 3. a 4. polozkou hlavniho menu */

#define TITLE_X                 260     /* pozice titulku (u hlavniho menu) */
#define TITLE_Y                 0

#define CTRLSMENU_X             148     /* pozice menu s nastavenim ovladani */
#define CTRLSMENU_Y             12
#define CTRLSMENU_BOXXSIZE      476     /* velikost okna */
#define CTRLSMENU_BOXYSIZE      376
#define CTRLSMENU_KEYX          (CTRLSMENU_X + 250)     /* pozice nazvu klaves */
#define CTRLSMENU_KEYY          (CTRLSMENU_Y + 74)
#define CTRLSMENU_YSIZE         32      /* vyska jedne polozky menu */
#define CTRLSMENU_ITEMX         262     /* pozice obdelniku kolem vybrane polozky */
#define CTRLSMENU_ITEMY         87
#define CTRLSMENU_XSIZE         338     /* sirka obdelniku kolem vybrane polozky */
#define CTRLSMENU_LAST          75      /* o kolik je vetsi obdelnik u posledni polozky */

#define GAMEMENU_YSIZE          32      /* vyska jedne polozky gamemenu */
#define GAMEMENU_YOFS           16      /* svisly ofset prvni polozky gamemenu */
#define GAMEMENU_CNT            6       /* pocet polozek gamemenu */

#define MENUSPEED_XOFS          18      /* vodorovny ofset ukazovatka */
#define MENUSPEED_YOFS          50      /* svisly ofset ukazovatka */
#define MENUSPEED_STEP          30      /* velikost kroku ukazovatka */


int mainmenuitem;                       /* aktivni polozka hlavniho menu */
int gamemenuitem;                       /* aktivni polozka gamemenu */


/* Vykresleni ramecku. */
void draw_frame(int x, int y, int w, int h)
{
  draw_bar(x + 1, y, w - 3, 2, 0xff, 0x55, 0x55);
  draw_bar(x, y + 1, 2, h - 3, 0xff, 0x55, 0x55);
  draw_bar(x + w - 2, y, 2, h - 1, 0xaa, 0x00, 0x00);
  draw_bar(x, y + h - 2, w - 1, 2, 0xaa, 0x00, 0x00);
  draw_bar(x + w - 2, y, 1, 1, 0xff, 0x55, 0x55);
  draw_bar(x, y + h - 2, 1, 1, 0xff, 0x55, 0x55);
  draw_bar(x + 2, y + 2, w - 4, h - 4, 0, 0, 0);
}


/* Okno se zpravou. */
void msg_box(char *text)
{
  int size;

  size = (strlen(text) + 4) * imgfont->w;
  draw_frame((640 - size) / 2, (400 - 2 * Y_FONT) / 2, size, 2 * Y_FONT);
  draw_text((640 - size) / 2 + 2 * imgfont->w, (400 - 2 * Y_FONT) / 2 + Y_FONT / 2, text);
  redraw();
  wait_for_key();
}


/* Pomocna funkce pro input_text() - vezme retezec src, zkopiruje ho do dest
 * a doplni ho danym znakem do maximalni delky; navic doplni i kurzor
 * (neni-li roven 0). Vrati dest. */
char *fill_up_chars(char *dest, char *src, int maxlen, char nullchar, char cursor)
{
  int i1;

  if (cursor) maxlen++;
  strcpy(dest, src);
  i1 = strlen(dest);
  if (i1 >= maxlen) return dest;
  if (cursor) dest[i1++] = cursor;
  for (; i1 < maxlen; i1++) dest[i1] = nullchar;
  dest[i1] = '\0';
  return dest;
}


/* Zadavac textu.
 * x, y urcuji levy horni roh. maxlen je maximalni delka. nullchar je znak,
 * ktery se bude psat na miste, kde neni zadny znak. dest je buffer, odkud
 * se vezme vychozi retezec a kam se ulozi nacteny retezec. onlychars je
 * priznak, ze jdou zadat jen pismena, cursor je priznak, ze je viditelny
 * kurzor.
 * Vrati 0, pokud cteni nebylo uspesne (uzivatel zmackl Esc) - i v tom
 * pripade je v dest to, co uzivatel zadal; vrati 1, pokud je vse ok. */
int input_text(int x, int y, int maxlen, char nullchar, char *dest, int onlychars, int cursor)
#ifndef maemo
{
  char buffer[128];
  char ch;
  char *last;

  /* do last ulozime ukazatel na ukoncovaci \0 v dest (a pak ho budeme
   * prubezne udrzovat) */
  for (last = dest; *last; last++) ;
  while (1) {
    draw_text(x, y, fill_up_chars(buffer, dest, maxlen, nullchar, (cursor ? '_' : 0)));
    redraw();
    do {
      wait_for_key();
      ch = key_translate();
    } while (!ch);
    switch (ch) {
      case '\b':  /* backspace */
        if (*dest) *--last = '\0';
        break;
      case '\n': /* enter */
        return 1;
      case '\x1b': /* escape */
        return 0;
      default:
        if (last - dest < maxlen) {
          if (onlychars) {
            ch = toupper(ch);
            if (ch < 'A' || ch > 'Z') ch = 0;
          }
          if (ch) {
            *last++ = ch;
            *last = '\0';
          }
        }
        break;
    }
  }
}
#else
{
  char buffer[128];
  char ch;
  char *last;
  int spec, pos = 0;

  (void)nullchar; (void)cursor; /* shut up, gcc */
  for (last = dest; *last; last++) pos++;
  while (1) {
    draw_text(x, y, fill_up_chars(buffer, dest, maxlen, ' ', ' '));
    draw_bar(x + pos * 18, y + Y_FONT - 3, 18, 2, 0xff, 0xff, 0xff);
    redraw();
    do {
      wait_for_key();
      ch = '\0';
      spec = 1;
      switch (lastkey) {
      case SDLK_LEFT:
        if (last - dest == pos) pos = (pos ? pos - 1 : 0);
        else ch = '\b';
        break;
      case SDLK_RIGHT:
        if (last - dest > pos) pos++;
        break;
      case SDLK_UP:
        if (last - dest > pos) {
	  if (++dest[pos] > 'Z')
	    dest[pos] = 'A';
	}
	else ch = 'A';
	break;
      case SDLK_DOWN:
        if (last - dest > pos) {
	  if (--dest[pos] < 'A')
	    dest[pos] = 'Z';
	}
	else ch = 'Z';
	break;
      default:
        spec = 0;
        ch = key_translate();
        break;
      }
      switch (ch) {
        case '\0': break;
        case '\b':  /* backspace */
          if (*dest) {
            *--last = '\0';
            if (!spec) pos = last - dest;
	  }
          break;
        case '\n': /* enter */
          return 1;
        case '\x1b': /* escape */
          return 0;
        default:
          if (last - dest < maxlen) {
            if (onlychars) {
              ch = toupper(ch);
              if (ch < 'A' || ch > 'Z') ch = 0;
            }
            if (ch) {
              *last++ = ch;
              *last = '\0';
              if (!spec) pos = last - dest;
            }
          }
          break;
      }
    } while (!ch && !spec);
  }
}
#endif


/* Nastavovac rychlosti. */
void game_setspeed()
{
  int x, y;
  SDLKey key;

  /* spocitani polohy menu na obrazovce */
  x = (640 - imggamespeed[0]->w) / 2;
  y = (400 - imggamespeed[0]->h) / 2;
  while (1) {
    drawf_img(imggamespeed[0], x, y);
    draw_img(imggamespeed[1], x + MENUSPEED_XOFS + (GAMESPEED_MIN - gamespeed) * MENUSPEED_STEP,
        y + MENUSPEED_YOFS);
      /* zde neni potreba drawf_..., protoze zakreslovana oblast prekryva tu,
       * ktera byla nakreslena vyse */
    redrawf();
    /* pockame si na stisk klavesy */
    key = wait_for_key();
    switch (key) {
      case SDLK_LEFT:
        if (gamespeed < GAMESPEED_MIN) gamespeed++;
        break;
      case SDLK_RIGHT:
        if (gamespeed > GAMESPEED_MAX) gamespeed--;
        break;
      case SDLK_HOME:
        gamespeed = GAMESPEED_MIN;
        break;
      case SDLK_END:
        gamespeed = GAMESPEED_MAX;
        break;
      case SDLK_RETURN: case SDLK_ESCAPE:
        return;
      default:
        if (key >= '1' && key <= '0' + GAMESPEED_MIN)
          gamespeed = GAMESPEED_MIN - (key - '0') + 1;
        break;
    }
  }
}


/* Inicializace menu (vynulovani aktualni pozice). */
void init_game_menu()
{
  gamemenuitem = 0;
}


/* Menu. */
void game_menu()
{
  SDL_Surface *store;
  SDLKey key;
  int x, y;
  int select;
  
  /* ulozeni obrazovky */
  store = SDL_CreateRGBSurface(SDL_SWSURFACE, 640, 400, 16, 0, 0, 0, 0);
  if (!store)
    error(ls(STR_BOXES_ERR_STORE_BUFFER));
  SDL_BlitSurface(screen, NULL, store, NULL);
  /* spocitani polohy menu na obrazovce */
  x = (640 - imggamemenu[0]->w) / 2;
  y = (400 - imggamemenu[0]->h) / 2;
  select = 0;
  while (1) {
    drawf_img(imggamemenu[0], x, y);
    draw_part_img(imggamemenu[1], GAMEMENU_YOFS + gamemenuitem * GAMEMENU_YSIZE,
        GAMEMENU_YSIZE, x, y + GAMEMENU_YOFS + gamemenuitem * GAMEMENU_YSIZE);
      /* zde neni potreba drawf_..., protoze zakreslovana oblast prekryva tu,
       * ktera byla nakreslena vyse */
    redrawf();
    /* pokud byla vybrana polozka, vyskocime */
    if (select) break;
    /* pockame si na stisk klavesy */
    key = wait_for_key();
    switch (key) {
      case SDLK_UP:
        if (--gamemenuitem < 0) gamemenuitem = GAMEMENU_CNT - 1;
        break;
      case SDLK_DOWN:
        if (++gamemenuitem >= GAMEMENU_CNT) gamemenuitem = 0;
        break;
      case SDLK_RETURN:
        select = 1;
        break;
      case SDLK_ESCAPE:
        select = -1;
        break;
      case SDLK_z: case SDLK_y:
        gamemenuitem = 0;
        select = 1;
        break;
      case SDLK_l:
        gamemenuitem = 1;
        select = 1;
        break;
      case SDLK_s:
        gamemenuitem = 2;
        select = 1;
        break;
      case SDLK_r:
        gamemenuitem = 3;
        select = 1;
        break;
      case SDLK_h:
        gamemenuitem = 4;
        select = 1;
        break;
      case SDLK_k:
        gamemenuitem = 5;
        select = 1;
        break;
      default:                  /* aby GCC nervalo */
        break;
    }
  }

  /* vyhodnoceni vyberu polozky */
  if (select > 0) {
    /* byla vybrana polozka */
    switch (gamemenuitem) {
      case 0:   /* znovu */
        levelrestart = 1;
        break;
      case 1:   /* load */
        select = -1;
        if (!param_userlevel) 
          if (game_load()) select = -2;
        break;
      case 2:   /* save */
        if (!param_userlevel) game_save();
        select = -1;
        break;
      case 3:   /* rychlost */
        game_setspeed();
        select = -1;
        break;
      case 4:   /* heslo */
        if (!param_userlevel) game_password();
        select = -1;
        break;
      case 5:   /* konec */
        gamerestart = 1;
        break;
    }
  }
  if (select < 0) {
    /* Esc */
    delay_before_key();
      /* kdybychom tu necekali, byla by okamzite klavesa Esc vzata v hlavni
       * herni smycce a bylo znovu aktivovano menu - takhle dame uzivateli
       * sanci klavesu vcas pustit */
  }
  /* obnova obrazovky */
  if (select == -1) {
    SDL_BlitSurface(store, NULL, screen, NULL);
    redraw();
  }
  SDL_FreeSurface(store);
}


/* Nastaveni ovladani. */
void controls_menu()
{
  SDL_Surface *store;
  SDLKey key;
  int i1;
  int olditem, item;
  
  /* ulozeni obrazovky */
  store = SDL_CreateRGBSurface(SDL_SWSURFACE, 640, 400, 16, 0, 0, 0, 0);
  if (!store)
    error(ls(STR_BOXES_ERR_STORE_BUFFER));
  SDL_BlitSurface(screen, NULL, store, NULL);
  /* vykresleni menu */
  draw_frame(CTRLSMENU_X, CTRLSMENU_Y, CTRLSMENU_BOXXSIZE, CTRLSMENU_BOXYSIZE);
  draw_img(imgctrlsmenu, CTRLSMENU_X + 2, CTRLSMENU_Y + 2);
  for (i1 = 0; i1 < 9; i1++)
    draw_text(CTRLSMENU_KEYX, CTRLSMENU_KEYY + i1 * CTRLSMENU_YSIZE, key_name(keyscfg[i1]));
  redraw();
  item = 0;
  olditem = -1;         /* zadna predchozi polozka jeste neni */
  while (item >= 0) {
    /* smazeme stary obdelnik */
    if (olditem >= 0) {
      if (olditem < 8)
        drawf_rect(CTRLSMENU_ITEMX, CTRLSMENU_ITEMY + olditem * CTRLSMENU_YSIZE,
            CTRLSMENU_XSIZE, CTRLSMENU_YSIZE, 0, 0, 0);
      else drawf_rect(CTRLSMENU_ITEMX - CTRLSMENU_LAST, CTRLSMENU_ITEMY + 8 * CTRLSMENU_YSIZE,
          CTRLSMENU_XSIZE + CTRLSMENU_LAST, CTRLSMENU_YSIZE, 0, 0, 0);
    }
    /* vykreslime novy obdelnik */
    if (item < 8)
      drawf_rect(CTRLSMENU_ITEMX, CTRLSMENU_ITEMY + item * CTRLSMENU_YSIZE,
          CTRLSMENU_XSIZE, CTRLSMENU_YSIZE, 0xff, 0x55, 0x55);
    else drawf_rect(CTRLSMENU_ITEMX - CTRLSMENU_LAST, CTRLSMENU_ITEMY + 8 * CTRLSMENU_YSIZE,
        CTRLSMENU_XSIZE + CTRLSMENU_LAST, CTRLSMENU_YSIZE, 0xff, 0x55, 0x55);
    olditem = item;
    redrawf();
    while (olditem == item) {
      key = wait_for_key();
      switch (key) {
        case SDLK_UP:
          if (--item < 0) item = 8;
          break;
        case SDLK_DOWN:
          if (++item > 8) item = 0;
          break;
        case SDLK_RETURN:
          /* zmena klavesy */
          drawf_blackbar(CTRLSMENU_KEYX, CTRLSMENU_KEYY + item * CTRLSMENU_YSIZE + 2,
              CTRLSMENU_XSIZE - (CTRLSMENU_KEYX - CTRLSMENU_ITEMX) - 1, CTRLSMENU_YSIZE - 2);
          redrawf();
          while (1) {
            key = wait_for_key();
            if (key == SDLK_ESCAPE) {
              /* ESC na maemu znamena smazani klavesy, na ostatnich
               * platformach to, ze se nic menit nebude */
#ifdef maemo
              keyscfg[item] = 0;
#endif
              break;
            }
            /* jinak se podivame, jestli uz tato klavesa neni pouzita pro
             * neco jineho */
            for (i1 = 0; i1 < 9; i1++)
              if (i1 != item && keyscfg[i1] == key) {
                /* ano, je */
                key = 0;
                break;
              }
            if (key) {
              /* byla zvolena klavesa */
              keyscfg[item] = key;
              break;
            }
          }
          /* vypsani nazvu klavesy - neni treba volat draw(), nebot se pise
           * do oblasti, kolem ktere bude za chvili nakreslen ramecek
           * (cerny), a tim dojde i k vykresleni oblasti uvnitr ramecku */
          draw_text(CTRLSMENU_KEYX, CTRLSMENU_KEYY + item * CTRLSMENU_YSIZE,
              key_name(keyscfg[item]));
          /* posun o jednu polozku dolu */
          if (++item > 8) item = 0;
          break;
        case SDLK_ESCAPE:
          item = -1;
          break;
        default:
          break;
      }
    }
  }
  /* obnova obrazovky */
  SDL_BlitSurface(store, NULL, screen, NULL);
  redraw();
  SDL_FreeSurface(store);
}


/* Inicializace hlavniho menu (vynulovani aktualni pozice). */
void init_main_menu()
{
  mainmenuitem = 0;
}


/* Hlavni menu (spolu s demem). */
void main_menu()
{
  int actualize, finish;
  int y;

  demoactive = 1;
  actuallevelset = 0;           /* sada demokol */
  actuallevel = 0;

  draw_bar(0, 0, 640, 400, 0, 0, 0);
  draw_img(imgtitle, TITLE_X, TITLE_Y);
  redraw();
  finish = 0;
  actualize = 1;
  levelfinished = 1;
  while (!finish) {
    if (actualize) {
      /* pokud se zmenil stav menu, prekreslime ho */
      actualize = 0;
      drawf_img(imgmainmenu[0], MAINMENU_X, MAINMENU_Y);
      y = mainmenuitem * MAINMENU_YSIZE;
      if (mainmenuitem >= 3) y += MAINMENU_GAP;
      draw_part_img(imgmainmenu[1], y, MAINMENU_YSIZE, MAINMENU_X, MAINMENU_Y + y);
      /* redrawf() bude zavolana uvnitr step_level() */
    }
    if (levelfinished) {
      /* mame zacit nove demokolo */
      levelfinished = 0;
      if (++actuallevel > cntdemo) actuallevel = 1;
      init_demolevel(actuallevel);
      load_level(0, actuallevel, leveldef, levelbagger);
      draw_level(0);
    }

    lastkey = 0;
    /* jeden krok hry (v tomto pripade dema) */
    step_level();

    switch (lastkey) {
      case SDLK_UP:
        if (--mainmenuitem < 0) mainmenuitem = 4;
        actualize = 1;
        break;
      case SDLK_DOWN:
        if (++mainmenuitem >= 5) mainmenuitem = 0;
        actualize = 1;
        break;
      case SDLK_RETURN:
        if (mainmenuitem == 3)          /* nastaveni ovladani */
          controls_menu();
        else finish = 1;
        break;
#ifdef maemo
      case SDLK_F7:
      case SDLK_F8:
#endif
      case SDLK_l:
	if (param_lang == LANG_EN) param_lang = LANG_CZ;
	else param_lang = LANG_EN;
	reinit_ls();
	reinit_keys();
	reinit_pack();
	reinit_imgs();
	actualize = 1;
	break;
      default:                          /* aby GCC nervalo */
        break;
    }
  }
  shutdown_demolevel();

  /* nastavime zvolenou sadu kol */
  switch (mainmenuitem) {
    case 0: case 1: case 2:             /* vyber sady kol */
      actuallevelset = mainmenuitem + 1;
      break;
    case 4:                             /* konec hry */
      exit(0);
  }
  demoactive = 0;
}


/* Vstupni box pro heslo. */
void game_password()
{
  char pwd[PWD_LEN];
  int no;

  draw_frame(141, 140, 356, 68);
  draw_img(imgpasswd, 159, 162);
  pwd[0] = '\0';
  input_text(257, 158, PWD_LEN, '-', pwd, 1, 0);
  no = find_level_password(actuallevelset, pwd);
  if (no > 0) {
    actuallevel = no;
    levelrestart = 1;
  }
  else msg_box(ls(STR_BOXES_INVALID_PASSWD));
}
